//
//  SwitchDataProvider.m
//
//

#import "SwitchDataProvider.h"

@implementation SwitchDataProvider {
	NSDictionary * _contents;
}

- (void)valueDidChange:(UISwitch *)control {
	[self updateContents];
	[self notifyObservers];
}

- (void)updateContents {
	//NSLog(@"SWITCH ON: %d", self.control.on);
	_contents = @{
				  @"on": [NSNumber numberWithBool:_control.on],
				  @"notOn": [NSNumber numberWithBool:!_control.on],
				  };
}

- (id)contents {
	return _contents;
}


@end

@implementation UISwitch (DataProvider)

- (void)setDataProvider:(SwitchDataProvider *)provider {
	//NSLog(@"SWITCH ON: %d", self.on);
	[self addTarget:provider action:@selector(valueDidChange:) forControlEvents:UIControlEventValueChanged];
	[provider updateContents];
}

@end
