//
//  TextViewDelegate.m
//

#import "TextViewDelegate.h"

@implementation TextViewDelegate {
	BOOL _isEditingTextView;
}

- (void)notifyObserversForChange {
	[self notifyObserversForKeyPath:@"contents.text"];
}

- (BOOL)textView:(UITextView *)textView shouldChangeTextInRange:(NSRange)range replacementText:(NSString *)string {
	dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(0.1 * NSEC_PER_SEC)), dispatch_get_main_queue(), ^{
		[self notifyObserversForChange];
	});
	return YES;
}

- (id)valueForKeyPath:(NSString *)keyPath {
	if ([keyPath isEqualToString:@"contents.text"]) {
		return _control.text;
	}
	return [super valueForKeyPath:keyPath];
}

- (void)setValue:(id)value forKeyPath:(NSString *)keyPath {
	if ([keyPath isEqualToString:@"contents.text"]) {
		_control.text = value;
	}
	return [super setValue:value forKeyPath:keyPath];
}

@end


@implementation UITextView (DataProvider)

- (void)setDataProvider:(TextViewDelegate *)dataProvider {
	self.delegate = dataProvider;
}

- (TextViewDelegate *)dataProvider {
	return (TextViewDelegate *)self.delegate;
}

@end
