
registerType('info.appdoo-mac', (function () { function TextualListDataSource() {} var __super = setSupertypeFromDomain(TextualListDataSource, 'BasicDataSource', 'appdoo');

	Object.defineProperty(TextualListDataSource.prototype, "readableDescription", {
		get: function () {
			return LocalizedString('Provides lines of text as a data source');
		}});
	

TextualListDataSource.prototype.createForContext = function TextualListDataSource_createForContext(context, options) {
		var inst = __super.prototype.createForContext.call(this, context);
		inst.location = 'local';
		if (options && options.droppedOnView) {
			this.createUITableViewForSuperview(options.droppedOnView, inst);
		}
		return inst;};
	
	
TextualListDataSource.prototype.setTextData = function TextualListDataSource__setTextData(str) {
		this.contents = str.split('\n');};
	

	Object.defineProperty(TextualListDataSource.prototype, "data", {
		set: function (v) {
			this.setTextData(v);
		}});
	

	Object.defineProperty(TextualListDataSource.prototype, "rootData", {
		get: function () {
			return this.contents||[];
		}});
	
	
	Object.defineProperty(TextualListDataSource.prototype, "rootDataKeyPath", {
		value: ''});
	

	Object.defineProperty(TextualListDataSource.prototype, "itemArrayKeyPath", {
		value: ''});
	
	
	Object.defineProperty(TextualListDataSource.prototype, "canBeKeyPathFiltered", {
		value: false});
	

	Object.defineProperty(TextualListDataSource.prototype, "providesRootData", {
		value: true});
	

	Object.defineProperty(TextualListDataSource.prototype, "iconURL", {
		get: function () {
			return 'Resources/TextualListDataSource48.png';
		}});
	
	
	Object.defineProperty(TextualListDataSource.prototype, "outlineIconURL", {
		get: function () {
			return 'Resources/TextualListDataSource.png';
		}});
	
	
	Object.defineProperty(TextualListDataSource.prototype, "readableType", {
		get: function () { return TRANSLATE({'de':"Textliste",'en':'Textual List'}); }});
	

	Object.defineProperty(TextualListDataSource.prototype, "isPlugin", {
		value: true});
	
		
	Object.defineProperty(TextualListDataSource.prototype, "fileExtensionsForImport", {
		value: ['txt']});
	
	
	
TextualListDataSource.prototype.determineFirstItemKey = function TextualListDataSource__determineFirstItemKey(item) {
		return '';};
	








TextualListDataSource.prototype.nameForKeyPath = function TextualListDataSource_nameForKeyPath(keyPath) {
		if (keyPath === '') return LocalizedString('Values');
		return __super.prototype.nameForKeyPath.call(this, keyPath);};
	

TextualListDataSource.prototype.expectedTypeForProperty = function TextualListDataSource_expectedTypeForProperty(key) {
	if (key === "readableDescription") return "";
	if (key === "data") return "";
	if (key === "rootData") return "";
	if (key === "rootDataKeyPath") return "";
	if (key === "itemArrayKeyPath") return "";
	if (key === "canBeKeyPathFiltered") return "";
	if (key === "providesRootData") return "";
	if (key === "iconURL") return "";
	if (key === "outlineIconURL") return "";
	if (key === "readableType") return "";
	if (key === "isPlugin") return "";
	if (key === "fileExtensionsForImport") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return TextualListDataSource; }()));