
registerType('info.appdoo-mac', (function () { function Timer() {} var __super = setSupertypeFromDomain(Timer, 'BasicEditableObject', 'appdoo');

		Object.defineProperty(Timer.prototype, "bindableProperties", {
			get: function () {
				return [['interval', this.readableNameForProperty('interval')]];
			}});
		
Timer.prototype.readableNameForProperty = function Timer__readableNameForProperty(propertyName) {
		if (propertyName == 'interval') return LocalizedString('Interval');};
	

	Object.defineProperty(Timer.prototype, "outlineIconURL", {
		value: 'Resources/Timer.png'});
	

	Object.defineProperty(Timer.prototype, "iconURL", {
		value: 'Resources/Timer48.png'});
	

	Object.defineProperty(Timer.prototype, "isPlugin", {
		value: true});
	

Timer.prototype.init = function Timer_init() {
		__super.prototype.init.call(this);
		
		return this;};
	
	
Timer.prototype.destroy = function Timer_destroy() {
		this.stopTimer();
		__super.prototype.destroy.call(this);};
	

	Object.defineProperty(Timer.prototype, "readableType", {
		get: function () {
			return TRANSLATE({
				de: 'Timer',
				en: 'Timer',
			});
		}});
	
	
	Object.defineProperty(Timer.prototype, "readableDescription", {
		get: function () {
			return LocalizedString('Performs an action delayed or repeatedly at an interval');
		}});
	
	
	Object.defineProperty(Timer.prototype, "interval", {
	outlet: true, 
	enumerable: true, get:function () { return this._interval; }, set:function (v) {if (!Object.hasOwnProperty(this, "_interval")) Object.defineProperty(this, "_interval", { writable: true, configurable: true }); this._interval = v; }});
	

Timer.prototype.createForContext = function Timer_createForContext(context) {

		return createComponentFromDomain(
			this.constructor.name,
			this.__domain,
			context,
			{
				interval: 1,
				shouldStartImmediately: true
			}
		);
		};
	

	Object.defineProperty(Timer.prototype, "inspectorProperties", {
		get: function () {
		
			return [
				{
					type: 'group',
					title: this.readableType,
					id: 'view',
					items: [

						{ name: LocalizedString('Name'), keyPath: 'e_name', dataKeyPath: 'name', type: 'text', positionLeft: true, placeholder:LocalizedString('Optional') },
						
						{ name: LocalizedString('Interval'), keyPath: 'interval', type: 'number', suffix: LocalizedString('sec'), step: 0.1, onlyPositive: true },

						{ type: 'boolean', name: LocalizedString('Repeat'), keyPath: 'shouldRepeat' },
						{ type: 'boolean', name: LocalizedString('Start Immediately'), keyPath: 'shouldStartImmediately' },
						
						{ type: 'space' },


						{ type: 'action', currentActionType: this.actionType, currentActionObjectID: this.e_actionObjectID }
					]
				}
			];
		}});
	


	Object.defineProperty(Timer.prototype, "shouldRepeat", {
	outlet: true, 
	enumerable: true, get:function () { return this._shouldRepeat; }, set:function (v) {if (!Object.hasOwnProperty(this, "_shouldRepeat")) Object.defineProperty(this, "_shouldRepeat", { writable: true, configurable: true }); this._shouldRepeat = v; }});
	


	Object.defineProperty(Timer.prototype, "shouldStartImmediately", {
	outlet: true, 
	enumerable: true, get:function () { return this._shouldStartImmediately; }, set:function (v) {if (!Object.hasOwnProperty(this, "_shouldStartImmediately")) Object.defineProperty(this, "_shouldStartImmediately", { writable: true, configurable: true }); this._shouldStartImmediately = v; }});
	

Timer.prototype.transformData = function Timer_transformData(data, transformer) {
		var result = __super.prototype.transformData.call(this, data, transformer);
		
		transformer.setFloatProperty(result, 'interval', data.interval);
		transformer.setBooleanProperty(result, 'shouldRepeat', data.shouldRepeat);
		transformer.setBooleanProperty(result, 'shouldStartImmediately', data.shouldStartImmediately);
		


		if (transformer.isXIBGenerator) {
			if (data.actionInfo) {
				var procedure = transformer.createProcedureFromData(null, data.actionInfo);
				if (procedure) {
					var actionID = transformer.registerInlineObject(procedure);
					
					transformer.addConnectionFrom__to__type__info__(data.$id, transformer.currentViewControllerId, 'customAction', {
								selector: transformer.selectorNameForProcedureID(actionID),
								destination: transformer.currentViewControllerXID,
								eventType: "fire",
								id: transformer.createStoryboardID()
						}, result);
				}
			}
		}
		else {
			if (data.actionInfo) {
				result.$initialMethodCalls.push({
						name: 'addTarget:action:forEvents:',
						arguments: [
							transformer.generateActionObject(null, data.actionInfo), 
							{ $type:'SEL', name:'action:' },
							"fire"
						]});
			}
		}
		
		return result;};
	
	
	Object.defineProperty(Timer.prototype, "timer", {
	synthesized: true, get:function () { return this._timer; }, set:function (v) {if (!Object.hasOwnProperty(this, "_timer")) Object.defineProperty(this, "_timer", { writable: true, configurable: true }); this._timer = v; }});
	
	
Timer.prototype.startTimer = function Timer_startTimer() {
		if (this.timer) this.stopTimer();
		if (!this.interval) return;
		this.timer = setInterval(function () {
			this.action();
		}.bind(this), this.interval*1000);};
	
	
Timer.prototype.stopTimer = function Timer_stopTimer() {
		clearInterval(this.timer);
		this.timer = null;};
	

Timer.prototype.action = function Timer_action() {
		_context.editor.simulateAction(this.actionType, this.actionInfo, true);};
	
	



	Object.defineProperty(Timer.prototype, "performableActions", {
		get: function () {
			var performableActions =  {};
			
			performableActions['start'] = { name: LocalizedString('start') };

			performableActions['stop'] = { name: LocalizedString('stop') };
			
			return performableActions;
		}});
	

Timer.prototype.initPropertiesFromData = function Timer_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("interval")) this.interval = data.interval;
if (data.hasOwnProperty("shouldRepeat")) this.shouldRepeat = data.shouldRepeat;
if (data.hasOwnProperty("shouldStartImmediately")) this.shouldStartImmediately = data.shouldStartImmediately;
};

Timer.prototype.decodeData = function Timer_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

Timer.prototype.encode = function Timer_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

Timer.prototype.encodeCloned = function Timer_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

Timer.prototype.expectedTypeForProperty = function Timer_expectedTypeForProperty(key) {
	if (key === "bindableProperties") return "";
	if (key === "outlineIconURL") return "";
	if (key === "iconURL") return "";
	if (key === "isPlugin") return "";
	if (key === "readableType") return "";
	if (key === "readableDescription") return "";
	if (key === "interval") return "Number";
	if (key === "inspectorProperties") return "";
	if (key === "shouldRepeat") return "Boolean";
	if (key === "shouldStartImmediately") return "Boolean";
	if (key === "timer") return "";
	if (key === "performableActions") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return Timer; }()));