//
//  UINavigationBar_BarTintSystem6.m
//
//

#define SYSTEM_VERSION_LESS_THAN(v)                 ([[[UIDevice currentDevice] systemVersion] compare:v options:NSNumericSearch] == NSOrderedAscending)


// Accepts #000000 strings
//UIColor * colorFromHexString(NSString * hexString);
static UIColor * colorFromHexString(NSString * hexString) {
	if (!hexString || hexString.length < 6) return [UIColor clearColor];
    unsigned rgbValue = 0;
    NSScanner *scanner = [NSScanner scannerWithString:hexString];
	if ([hexString characterAtIndex:0] == '#') [scanner setScanLocation:1]; // bypass '#' character
    [scanner scanHexInt:&rgbValue];
	if (hexString.length >= 8) {
		double red = ((rgbValue & 0xFF000000) >> 24)/255.0;
		double green = ((rgbValue & 0xFF0000) >> 16)/255.0;
		double blue = ((rgbValue & 0xFF00) >> 8)/255.0;
		double alpha = (rgbValue & 0xFF)/255.0;
		return [UIColor colorWithRed:red green:green blue:blue alpha:alpha];
	}

	return [UIColor colorWithRed:((rgbValue & 0xFF0000) >> 16)/255.0 green:((rgbValue & 0xFF00) >> 8)/255.0 blue:(rgbValue & 0xFF)/255.0 alpha:1.0];
}



@implementation UINavigationBar (BarTintSystem6)

- (void)setBarTintSystem6:(NSString *)hexString {
	if (SYSTEM_VERSION_LESS_THAN(@"7.0"))
		self.tintColor = colorFromHexString(hexString);
}

@end

@implementation UITabBar (BarTintSystem6)

- (void)setBarTintSystem6:(NSString *)hexString {
	if (SYSTEM_VERSION_LESS_THAN(@"7.0")) {
		//UIColor * tintColor = colorFromHexString(hexString);
		//self.tintColor = tintColor;
		self.tintColor = nil;
	}
}

@end