
registerType('appdoo.iOS', (function () { function UICollectionView() {} var __super = setSupertypeFromDomain(UICollectionView, 'CollectionView', 'Core.UI');

UICollectionView.prototype.init = function UICollectionView_init() {
		__super.prototype.init.call(this);
		this.updateSegue();
		if (this.modalTransitionStyle === undefined)
			this.modalTransitionStyle = '-1';
		return this;	};
	

UICollectionView.prototype.superviewDidChangeTintColor = function UICollectionView__superviewDidChangeTintColor(color) {
		if (Array.isArray(this.subviews)) this.subviews.every(function (subview) {
			if (subview.superviewDidChangeTintColor)
				subview.superviewDidChangeTintColor(color);return true; }, this);
		};
	

	Object.defineProperty(UICollectionView.prototype, "backgroundColor", {
	outlet: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_backgroundColor")) Object.defineProperty(this, "_backgroundColor", { writable: true, configurable: true });
			this._backgroundColor = v;
			this.style({ backgroundColor: v||'' });
		}, get:function () { return this._backgroundColor; }});
	

	Object.defineProperty(UICollectionView.prototype, "nameIsEditable", {
		get: function () {
			return true;
		}});
	

UICollectionView.prototype.createForSuperview = function UICollectionView_createForSuperview(superview) {

		var makeFullSize = (superview.subviews.length === 0);

		var size = makeFullSize ? superview.sizeCopy :
			{ width: Math.min(320, superview.size.width), height: 100 };
	
		var isSystem7 = superview.context.simulatedSystemVersion >= 7;

		var options = {
			size: size,
			autoresizingMask: makeFullSize ? 18 : 36,
              "margin": 0,
              "spacing": 10,
              flowLayoutMinimumLineSpacing: 10,
              flowLayoutMinimumInteritemSpacing: 10,
              "flowLayoutScrollDirection": "vertical",
              "isExpandedInEditorOutline": true,
			backgroundColor: 'rgb(240,240,240)',
			cellPrototype: this.createDefaultCellPrototypeForContextWithSize(superview.context, size),
			usesDataSource: false,
			insetTop: makeFullSize ? _context.editor.contentFrameController.defaultTopScrollInset : 0,
			insetBottom: makeFullSize ? _context.editor.contentFrameController.defaultBottomScrollInset : 0,
		};
	
		var collectionView = createComponentFromDomain(this.constructor.name,
			this.__domain, superview.context, options);
			
		collectionView.e_numberOfStaticSections = 1;
			
		return collectionView;};
	

	Object.defineProperty(UICollectionView.prototype, "defaultCellPrototype", {
		get: function () {
			return this.createDefaultCellPrototypeForContextWithSize(this.context, this.size);
		}});
	

	Object.defineProperty(UICollectionView.prototype, "staticCellPrototype", {
		get: function () {
			return this.createDefaultCellPrototypeForContextWithSize(this.context, this.size, true);
		}});
	
	
UICollectionView.prototype.createDefaultCellPrototypeForContextWithSize = function UICollectionView__createDefaultCellPrototypeForContextWithSize(context, size, noLabel) {

		var isSystem7 = context.simulatedSystemVersion >= 7;

		var cellData = {
              "$type": "CollectionViewCellContentView",
				backgroundColor: 'rgb(255,255,255)',
              "$domain": "appdoo.iOS",
              "size": {
                "height": 100,
                "width": 100
              },
              "isExpandedInEditorOutline": true,
              "subviews": [
                  
              ],
            };
           
		if (!noLabel) {
			cellData.subviews.push({
							"$type": "UILabel",
							"$domain": "appdoo.iOS",
							"autoresizingMask": 2,
							"text": LocalizedString("Text"),
							"layoutMode": "autoFitHeight",
							"size": {
								"width": isSystem7 ? 70 : 80,
								"height": isSystem7 ? 25 : 26
							},
							"position": {
								"left": isSystem7 ? 15 : 10,
								"top": isSystem7 ? 10 : 9
							},
							"fontFamily": "System",
							"fontName": "_DEFAULT_BOLD_",
							"fontSize": 13
						});
			}
						
		
		return cellData;};
	
	
	Object.defineProperty(UICollectionView.prototype, "numberOfColumns", {
	outlet: true, 
	enumerable: true, get:function () { return this._numberOfColumns; }, set:function (v) {if (!Object.hasOwnProperty(this, "_numberOfColumns")) Object.defineProperty(this, "_numberOfColumns", { writable: true, configurable: true }); this._numberOfColumns = v; }});
	

	Object.defineProperty(UICollectionView.prototype, "readableValue", {
	configurable: true, 
		get: function () {
			if (this.name) return this.name;
			if (this.dataSource)
				return this.dataSource.readableValue+' ('+LocalizedString('Collection View')+')';
			return LocalizedString('Collection View');
		}});
	

	Object.defineProperty(UICollectionView.prototype, "iconURL", {
		get: function () {
			return _context.pathForResource('UICollectionView48.png')
		}});
	
	
	Object.defineProperty(UICollectionView.prototype, "outlineIconURL", {
	configurable: true, 
		get: function () {
			return this.context.pathForResource('UICollectionView.png');
		}});
	

UICollectionView.prototype.reloadDataLazy = function UICollectionView__reloadDataLazy() {
		__super.prototype.reloadDataLazy.call(this);
		this.addEditorButtonsToCells(this.subviews);};
	

UICollectionView.prototype.insertData = function UICollectionView__insertData() {

		if (this.usesDataSource) {
			__super.prototype.insertData.call(this);
		}
		else
			this.insertStaticContent();
		
		var cellFunc = function (cell) {
			cell.style({ overflow: 'hidden' });
			this.convertLayoutRelationsInDynamicCell(cell);
			_context.editor.resolveLayoutInView(cell);
		}.bind(this);

		if (Array.isArray(this.subviews)) this.subviews.every(function (subview) {
			if (subview.isSectionView) {
				if (Array.isArray(subview.subviews)) subview.subviews.every(function (cell) {
					cellFunc(cell);return true; }, this);
				
			}
			else {
				cellFunc(subview);
			}return true; }, this);
		};
	

UICollectionView.prototype.insertStaticContent = function UICollectionView__insertStaticContent() {
		var i = 0, max = this.numberOfStaticSections;
		if (Array.isArray(this.staticSections)) this.staticSections.every(function (section) {
			if (++i > max) return false;
			this.insertStaticCell(section.view);return true; }, this);
		};
	

UICollectionView.prototype.loadDataSource = function UICollectionView__loadDataSource() {

		if (this.dataSource) {
			this.dataSourceWillChange(this.dataSource.$id, this._dataSourceId);
		}
		this.dataSource = this.context.getLivingDataSourceWithId(this._dataSourceId);

		this.reloadData();
		this.readableValueDidChange();};
	

UICollectionView.prototype.dataSourceWillChange = function UICollectionView__dataSourceWillChange(oldDataSourceID, newDataSourceID) {

		this.updateBindingsInViews([this.cellPrototypeView], oldDataSourceID, newDataSourceID);
		this.updatePrototypesForEditor(_context.editor);};
	

	Object.defineProperty(UICollectionView.prototype, "modalTransitionStyle", {
	outlet: true, 
	enumerable: true, get:function () { return this._modalTransitionStyle; }, set:function (v) {if (!Object.hasOwnProperty(this, "_modalTransitionStyle")) Object.defineProperty(this, "_modalTransitionStyle", { writable: true, configurable: true }); this._modalTransitionStyle = v; }});
	

	Object.defineProperty(UICollectionView.prototype, "inspectorProperties", {
		get: function () {
		
			return [
				{
					type: 'group',
					title: LocalizedString('Collection View'),
					id: 'UICollectionViewAppearance',
					items: [

						{ name: this.readableNameForProperty('name'), keyPath: 'e_name', dataKeyPath: 'name', type: 'text', positionLeft: true, placeholder:LocalizedString('Optional') },
						{ name: LocalizedString('Cells'), keyPath: 'staticSections.0.e_numberOfStaticCells', type: 'number', onlyPositive: true, disabled: this.e_usesDataSource },

						{  name: LocalizedString('Use Data Source'), keyPath: 'e_usesDataSource', type: 'boolean', positionLeft: true },

						
						{ name: '', keyPath: 'e_dataSourceID', type: 'object', labelOnTop: true, objectType:'dataSource', placeholder:LocalizedString('There are no data sources available in this screen.'), numberOfVisibleItems:3.5, hidden: !this.e_usesDataSource, showsSelectButton:true },
						{ type: 'button', caption: LocalizedString('New Data Source'), actionKeyPath: 'showNewDataSourcePanel', buttonWidth: 105, align: 'left', hidden: !this.e_usesDataSource, buttonStyle: 'flat', marginTop: -3, positionLeft:true },
						
						{ name: LocalizedString("Use a Navigation Target"), type: "boolean", keyPath: "e_navigatesToDetailScene", "positionLeft": true, hidden: !this.e_usesDataSource },
						
						{ name: '', keyPath: 'e_detailSceneID', type: 'scene', labelOnTop: true, allowsEmptySelection:false, numberOfVisibleItems:1, hidden: !this.e_usesDataSource||!this.e_navigatesToDetailScene },

						this.modalTransitionStyleProperty,
						
						{ type: 'space' },
						{ type: 'space' },
					]
				},

				{
					type: 'group',
					title: LocalizedString('Layout'),
					id: 'UICollectionViewLayout',
					items: [


						{ name: LocalizedString('Scroll Direction'), keyPath: 'e_flowLayoutScrollDirection', labelOnTop: true, type: 'select', options: [
							['vertical',LocalizedString('vertically'), [
								{ name: LocalizedString('Margin'), keyPath: 'e_margin', labelOnTop: true, type: 'number', range: [0, 1000], undefinedValue: '0', suffix: '' },
								{ name: LocalizedString('Cell Spacing'), keyPath: 'e_spacing', labelOnTop: true, type: 'number', range: [0, 1000], undefinedValue: '0', toolTip: LocalizedString('Minimum Spacing Between Cells') },
							]],
							['horizontally',LocalizedString('horizontally'), [
								{ name: LocalizedString('Margin'), keyPath: 'e_margin', labelOnTop: true, type: 'number', range: [0, 1000], undefinedValue: '0', suffix: '' },
								{ name: LocalizedString('Cell Spacing'), keyPath: 'e_spacing', labelOnTop: true, type: 'number', range: [0, 1000], undefinedValue: '0', toolTip: LocalizedString('Minimum Spacing Between Cells') },
								{ name: LocalizedString('scroll with paging'), keyPath: 'pagingEnabled', type: 'boolean', positionLeft: true },
								{ type: 'space' },
							]]
						],
						undefinedValue: 'vertical',
						},
						
						
						{ type: 'space' },

						{ name: LocalizedString('Background Color'), keyPath: 'backgroundColor', type: 'color', undefinedValue: 'rgba(255,255,255, 1)' , positionLeft: true},
						{ type: 'space' },
					]
				},
				  this.scrollViewInsetsInspectorProperties,
				{
					type: 'group',
					title: LocalizedString('Advanced'),
					id: this.constructor.name+'Advanced',
					items: [
		
							{ type: 'boolean', keyPath: 'hidden', name: LocalizedString('Hidden'), positionLeft: true },
		
					]
				},
			];
		}});
	
	
UICollectionView.prototype.editCellAtIndexPathWithEditor = function UICollectionView__editCellAtIndexPathWithEditor(indexPath, editor) {
		var cell = this.cellForIndexPath(indexPath);
		return this.editCellWithEditor(cell, editor);};
	


UICollectionView.prototype.editorWillEditPrototypeCell = function UICollectionView_editorWillEditPrototypeCell(editor, subview) {
		if (subview == this.cellPrototypeView) {

			if (!subview.indexPath) subview.indexPath = {section:0,item:0};
			this.prepareCellWithDataForIndexPath(subview, subview.indexPath, true);

			editor.pushDataContextForDataSourceItem(this.dataSource, subview.indexPath);
		}};
	

UICollectionView.prototype.editorDidEditPrototypeCell = function UICollectionView_editorDidEditPrototypeCell(editor, subview) {
		if (subview == this.cellPrototypeView) {
			subview.superview = this;
			var ip = subview.indexPath;
			
			_context.editor.changeCellPrototypeForItemsView('cellPrototype', subview.encode(), this, false);

			editor.popDataContextForDataSourceItem(this.dataSource, ip);

		}};
	

	
	Object.defineProperty(UICollectionView.prototype, "cellPrototypeView", {
	synthesized: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_cellPrototypeView")) Object.defineProperty(this, "_cellPrototypeView", { writable: true, configurable: true });

			this._cellPrototypeView = v;
			this._cellPrototypeView.isPrototype = true;

			v.superview = this;

			if (!v.position) {
				var firstCell = this.cellForIndexPath({ item: 0 });
				if (firstCell) v.position = {
					left: firstCell.position.left,
					top: firstCell.position.top
				};
			}
		}, get:function () { return this._cellPrototypeView; }});
	
	
	
UICollectionView.prototype.isDynamicCell = function UICollectionView_isDynamicCell(view) {
		return this.usesDataSource;};
	

UICollectionView.prototype.cellForIndexPath = function UICollectionView_cellForIndexPath(indexPath) {
		if (!this.usesDataSource) return this.staticSections[indexPath.section].staticCells[indexPath.item];
		return this.subviews[0].subviews[indexPath.item];};
	


UICollectionView.prototype.prepareCellWithDataForIndexPath = function UICollectionView__prepareCellWithDataForIndexPath(cell, indexPath, keepOriginalIDs) {
		__super.prototype.prepareCellWithDataForIndexPath.call(this, cell, indexPath, keepOriginalIDs);
		
		cell.DOMNode.addEventListener('mousedown', function (e) {
			if (_context.editor.isActionClick(e))
				this.selectCell(cell);
		}.bind(this));

		cell.DOMNode.className = 'canClickInActionMode';
};
	
	
UICollectionView.prototype.selectCell = function UICollectionView_selectCell(cell) {

		if (this.detailSceneID||cell.detailSceneID) {
		
			var indexPath = cell.indexPath,
				itemsView = this,
				inputData = itemsView.usesDataSource ? itemsView.dataSource.dataForIndexPath(indexPath) : null,
				detailSceneID = cell.detailSceneID || itemsView.detailSceneID;
			
			_context.editor.navigateToSceneWithID(detailSceneID, inputData, itemsView.dataSource, indexPath);
			
		}
		};
	
	
UICollectionView.prototype.collectionView_transformDataForXIB = function UICollectionView_collectionView_transformDataForXIB(data, transformer) {
		
		
		
		var selectedItemIndex1Binding, selectedItemIndex0Binding;
		if (data.bindings) {
			selectedItemIndex1Binding = this.bindingForKey.call(data, 'selectedItemIndex1');
			selectedItemIndex0Binding = this.bindingForKey.call(data, 'selectedItemIndex');

			var index;
			index = data.bindings.indexOf(selectedItemIndex1Binding);
			if (index !== -1) data.bindings.splice(index, 1);
			index = data.bindings.indexOf(selectedItemIndex0Binding);
			if (index !== -1) data.bindings.splice(index, 1);
		}


		var result = transformer.transformView(data, true);
		result.clipsSubviews = "YES";
		
		if (data.pagingEnabled) result.pagingEnabled = "YES";
		
		var margin = data.margin || 0,
			spacing = data.spacing || 0,
			scrollDirection = data.flowLayoutScrollDirection || "vertical";
		
		result.collectionViewFlowLayout = {
			key: 'collectionViewLayout',
			minimumLineSpacing: spacing,
			minimumInteritemSpacing: spacing,
			id: transformer.createStoryboardID(),
			'size headerReferenceSize': {
				key: 'headerReferenceSize',
				width: 0,
				height: 0
			},
			'size footerReferenceSize': {
				key: 'footerReferenceSize',
				width: 0,
				height: 0
			},
			inset: {
				key: 'sectionInset',
				minX: margin,
				minY: margin,
				maxX: margin,
				maxY: margin
			},
			scrollDirection: scrollDirection
		};
		

		if (data.usesDataSource) {
			this.transformPrototypeCells(data, result, transformer);
		}
		else {
			this.transformStaticContent(data, result, transformer);
		}
		

		
		
		if (data.insetTop || data.insetBottom) {
			result.inset = { key:"contentInset", minX:0, minY:data.insetTop||0, maxX:0, maxY:data.insetBottom||0 };
		}
		
		
		if (data.dataProvider) {
			transformer.demandPlugin('info.appdoo-mac.UICollectionViewSelectedItem');
			
			var delegate = createComponentFromDomain('CollectionViewDelegate', 'info.appdoo-mac', _context.projectContext, {
				collectionViewStoryboardID: result.id
			});
			delegate.$id = data.$id+'Delegate';

			if (selectedItemIndex1Binding) {
				delegate.addBinding(selectedItemIndex1Binding);
			}

			transformer.demandPlugin('info.appdoo-mac.CollectionViewDataProvider');
			
			var dataProvider = _context.projectContext.decodeObjectTree(data.dataProvider);
			dataProvider.$id = data.$id+'DataProvider';
			delegate.dataProvider = dataProvider;
			transformer.registerInlineObject(dataProvider);

			if (!result.connections) result.connections = {};
			
			result.connections['outlet delegate'] = {
					property: "delegate",
					destination: transformer.storyboardIDForComposeObject(delegate),
					id: transformer.createStoryboardID()
				};

			transformer.registerInlineObject(delegate);


		}
		
				
		return result;
};
	
	
UICollectionView.prototype.transformPrototypeCells = function UICollectionView__transformPrototypeCells(data, result, transformer) {
		
		var dataSource = data.dataSource;
		if (dataSource === undefined)
			dataSource = transformer._getInstanceDataById(data.dataSourceId);
		
		var dataSourceCodeID = transformer.codeIDForDataSource(dataSource);
		var cellClass = transformer.context.createUID('Cell');
		
		var cell = {
			id: transformer.createStoryboardID(),
			autoresizingMask: { key: "autoresizingMask" },
			reuseIdentifier: 'Cell',
			customClass: cellClass,
			connections: {},
			clipsSubviews: 'YES',
		};

	
		transformer.willTransformCellWithIdentifier(cell, cellClass, data, data.cellPrototype);

		
		
		transformer.productGenerator.addIncludeHeaderForThing(transformer.currentViewControllerClassId+'.h', data.cellPrototype);
		transformer.addOutletForDataAndId(transformer.currentViewControllerData, transformer.storyboardIDForObjectID(transformer.currentViewControllerId), 'viewController', transformer.currentViewControllerClassId);

		var cellView = transformer.transformView(data.cellPrototype);

		transformer.didTransformCell();

		cell['color backgroundColor'] = cellView['color backgroundColor'];
		delete cellView['color backgroundColor'];

		cellView.rect.x = 0;
		cellView.rect.y = 0;
		cellView.key = 'contentView';

		cell.rect = clone(cellView.rect);
		cell.view = cellView;

		result.cells = {
			collectionViewCell: cell
		};
		
		result.dataMode = 'prototypes';

		

		transformer.object__addOutlet__from__to__(result, 'dataSource', data.$id, data.dataSourceId);

		
		
		if (data.detailSceneID) {
		
			var detailScene = _context.projectContext.sceneWithID(data.detailSceneID);
			if (detailScene) {
				if (data.modalTransitionStyle === '-1') {
					cell.connections['segue'] = {
						destination: transformer.storyboardIDForComposeObject(detailScene.viewController),
						kind: 'push',
						id: transformer.createStoryboardID()
					};
				}
				else {
					cell.connections['segue'] = {
						destination: transformer.storyboardIDForObjectID(detailScene.viewController.$id+'NavigationController'),
						kind: 'modal',
						modalTransitionStyle: transformer.transformModalTransitionStyle(data.modalTransitionStyle),
						id: transformer.createStoryboardID()
					};
				}
			}
		
		}
		
		result.collectionViewFlowLayout['size itemSize'] = {
				key: 'itemSize',
				width: cellView.rect.width,
				height: cellView.rect.height
			};
};
	

UICollectionView.prototype.transformStaticContent = function UICollectionView__transformStaticContent(data, result, transformer) {

		result.dataMode = 'prototypes';
		result.cells = {};
		
		var sectionCtr = 0;
		if (Array.isArray(data.staticSections)) data.staticSections.every(function (sectionData) {
			sectionCtr++; if (sectionCtr > data.numberOfStaticSections) return false;

			
			var cellCtr = 0;
			if (Array.isArray(sectionData.staticCells)) sectionData.staticCells.every(function (cellViewData) {
				cellCtr++; if (cellCtr > sectionData.numberOfStaticCells) return false;

				var cellID = transformer.createStoryboardID();

				transformer.willTransformCellWithIdentifier(cellViewData, null, {}, null);
				var cellView = transformer.transformView(cellViewData);
				transformer.didTransformCell();

				cellView.key = "contentView";
				if (!cellView.opaque)
					cellView.opaque = "NO";
				cellView.clipsSubviews = "YES";
				cellView.multipleTouchEnabled = "YES";
				cellView.contentMode = "center";
				cellView.rect.x = 0; cellView.rect.y = 0;

				var cell = {
					id: cellID,
					contentMode: 'center',
					selectionStyle: 'blue',
					rect: cellView.rect,
					opaque: 'NO',
					view: cellView,
					size: { key: "customSize", width: cellViewData.frame.size.width, height: cellViewData.frame.size.height },
					reuseIdentifier: 'Cell '+cellCtr
				};
				
				if (cellViewData.navigatesToDetailScene) {
					cell.accessoryType = "disclosureIndicator";
					var detailScene = _context.projectContext.sceneWithID(cellViewData.detailSceneID);
					if (detailScene) {
						var destinationID = transformer.storyboardIDForComposeObject(detailScene.viewController);
						cell.connections = {};
						cell.connections['segue'] = {
							destination: destinationID,
							kind: 'push',
							id: transformer.createStoryboardID()
						};
					}
				}

				if (cellView['color backgroundColor']) {
					cell['color backgroundColor'] = cellView['color backgroundColor'];
					delete cellView['color backgroundColor'];
				} else {
					cell['color backgroundColor'] = transformer.transformCSSColor('rgba(0,0,0,0)');
				}
				
				result.cells['collectionViewCell '+cell.id] = cell;return true; }, this);
			
			return true; }, this);
		
		
		result.collectionViewFlowLayout['size itemSize'] = {
				key: 'itemSize',
				width: 50,
				height: 50
			};


		var cellSizesString = "";

		var sectionCtr = 0;
		if (Array.isArray(data.staticSections)) data.staticSections.every(function (sectionData) {
			sectionCtr++; if (sectionCtr > data.numberOfStaticSections) return false;
			var cellCtr = 0;
			if (Array.isArray(sectionData.staticCells)) sectionData.staticCells.every(function (cellViewData) {
				cellCtr++; if (cellCtr > sectionData.numberOfStaticCells) return false;
				if (cellSizesString) cellSizesString += '	';
				cellSizesString += '{'+cellViewData.frame.size.width+', '+cellViewData.frame.size.height+'}';return true; }, this);
			return true; }, this);
		
		

		var ds = createComponentFromDomain('StaticCollectionViewDataSource', 'info.appdoo-mac', _context.projectContext, {
			cellSizesString: cellSizesString
		});
		
		transformer.registerInlineObject(ds);
		
		result.connections = {
			'outlet dataSource': {
				property: "dataSource",
				destination: transformer.storyboardIDForObjectID(ds.identify()),
				id: transformer.createStoryboardID()
			},
			'outlet delegate': {
				property: "delegate",
				destination: transformer.storyboardIDForObjectID(ds.identify()),
				id: transformer.createStoryboardID()
			}
		};
		
};
	

	Object.defineProperty(UICollectionView.prototype, "positionIsEditable", {
	configurable: true, 
		value: true});
	

	Object.defineProperty(UICollectionView.prototype, "sizeIsEditable", {
	configurable: true, 
		value: true});
	

	Object.defineProperty(UICollectionView.prototype, "canHaveLayoutRelations", {
		value: true});
	

	Object.defineProperty(UICollectionView.prototype, "notAvailableInDynamicCells", {
		value: true});
	


UICollectionView.prototype.createStaticSection = function UICollectionView__createStaticSection() {
		var section = createComponentFromDomain("UICollectionViewSection", "appdoo.iOS", this.context, {
			itemsView: this,
			isExpandedInEditorOutline: true,
			numberOfStaticCells: 0})
		;
		return section;};
	

UICollectionView.prototype.acceptsMemberWithUTI = function UICollectionView_acceptsMemberWithUTI(UTI) {
		if (this.usesDataSource) return false;
		if (UTI === 'appdoo.iOS.CollectionViewCellContentView') return true;
		return false;};
	

UICollectionView.prototype.encodeCloned = function UICollectionView_encodeCloned() {
		var data = __super.prototype.encodeCloned.call(this);
		delete data.cellPrototype;
		data.cellPrototype = this.cellPrototypeView.encodeCloned();
		return data;};
	

	Object.defineProperty(UICollectionView.prototype, "bindableProperties", {
		get: function () {
			var result = clone(__super.prototype.bindableProperties);
			result.splice(1, 0,
				['selectedItemIndex', this.readableNameForProperty('selectedItemIndex')],
				['selectedItemIndex1', this.readableNameForProperty('selectedItemIndex1')]
			);
			return result;
		}});
	


UICollectionView.prototype.readableNameForProperty = function UICollectionView__readableNameForProperty(propertyName) {
		switch (propertyName) {
			case 'selectedItemIndex1': return LocalizedString('Selected Cell')+' (1-index)';
			case 'selectedItemIndex': return LocalizedString('Selected Cell')+' (0-index)';
			case 'name': return LocalizedString('Name');
		}
		return __super.prototype.readableNameForProperty.call(this, propertyName);};
	
	
	var UICollectionViewScrollDirectionVertical = 0,
		UICollectionViewScrollDirectionHorizontal = 1;
	
UICollectionView.prototype.transformData = function UICollectionView_transformData(data, transformer) {
		if (transformer.isXIBGenerator) return this.collectionView_transformDataForXIB(data, transformer);
		else return this.collectionView_transformDataForPreview(data, transformer);};
	

UICollectionView.prototype.collectionView_transformDataForPreview = function UICollectionView_collectionView_transformDataForPreview(data, transformer) {
	
		if (!data.frame) data.frame = { size: data.size, origin: {x:data.position.left,y:data.position.top}};
		
		var result = getPrototype('appdoo.iOS.UIView').transformData(data, transformer, { useDefaultInitializer: true });
		
		result.$type = 'UICollectionView';
		result.contentInset = transformer.transformEdgeInsets(0,0,0,0);

		if (!result.backgroundColor) result.backgroundColor = transformer.transformCSSColor('rgba(0,0,0,0)');
		
		if (data.pagingEnabled)
			result.pagingEnabled = transformer.transformBoolean(data.pagingEnabled);
		
		var margin = data.margin || 0;
		var spacing = data.spacing || 0;
		var flowLayoutMinimumInteritemSpacing = spacing;
		var flowLayoutMinimumLineSpacing = spacing;
		var sectionInset = transformer.transformEdgeInsets(margin, margin, margin, margin);
		var itemSize;

		if (data.usesDataSource && data.cellPrototype && data.cellPrototype.frame)
			itemSize = transformer.transformCGSize(data.cellPrototype.frame.size.width, data.cellPrototype.frame.size.height);
		else
			itemSize = transformer.transformCGSize(100, 100);
		
		var layout = {
			$type: 'UICollectionViewFlowLayout',
			$domain: 'com.apple',
			itemSize: itemSize,
			minimumInteritemSpacing: transformer.transformFloat(flowLayoutMinimumInteritemSpacing),
			minimumLineSpacing: transformer.transformFloat(flowLayoutMinimumLineSpacing),
			scrollDirection: (data.flowLayoutScrollDirection === 'vertical' ? UICollectionViewScrollDirectionVertical : UICollectionViewScrollDirectionHorizontal),
			sectionInset: sectionInset
		};
		
		result.$initializer = { name: 'initWithFrame:collectionViewLayout:', arguments: [result.frame, layout] };
		delete result.frame;


		result.contentInset = transformer.transformEdgeInsets(data.insetTop||0,0,data.insetBottom||0,0);

		if (data.usesDataSource) {

			result.$connections.push({ key: "dataSource", destination: data.dataSourceId });
		
			var cellPrototypeData = clone(data.cellPrototype);
			if (cellPrototypeData.frame) cellPrototypeData.frame.origin = { x: 0, y: 0 };
			
			var cellPrototype = getPrototype('appdoo.iOS.UIView').transformData(cellPrototypeData, transformer, true);
			
			
			cellPrototype.$prototype = true; 

			var cellPrototypeView = _context.decodeObjectTree(data.cellPrototype);
			
			result.$connections.push({ key: "cellGenerator", destinationObject: {
				$type: 'PrototypeCellGenerator',
				$domain: 'appdoo',
				$needsContextReference: true,
				contentViewPrototypeInfo: cellPrototype,
				cellInfo: {
					$type: 'SimpleCollectionViewCell',
					$domain: 'info.appdoo-mac',
					$prototype: true,
					layoutRelationsInfos: getType('appdoo.Editor.LayoutResolver').prototype.layoutRelationsInViewForAppdooPreview(cellPrototypeView, transformer),
				},
				bindingsInfo: bindingsInfoForView(data.cellPrototype, this),
			} });
			
			cellPrototypeView.destroy();
			
			var delegate = {
				$type: 'SimpleCollectionViewDelegate',
				$domain: 'appdoo',
				$id: data.$id+'Delegate',
				$needsViewControllerReference: true,
				detailSceneID: transformer.transformString(data.detailSceneID),
				cellFrame: cellPrototype.frame,
			};
			if (transformer.previewAppVersion >= 2) {
				delegate.modalTransitionStyle = transformer.transformModalTransitionStyle(data.modalTransitionStyle);
			}
			
			transformer.currentObjects.push(delegate);
			result.$connections.push({ key: "delegate", destination: delegate.$id });

		}
		else {

			result.dataSource = getPrototype('appdoo.iOS.StaticCellsDataSource').transformData({
					$type: 'StaticCellsDataSource',
					$domain: 'appdoo.iOS',
					$id: data.$id+'DataSource',
					headerView: data.listHeaderView,
					footerView: data.listFooterView,
					staticSections: data.staticSections
				}, transformer);
				
			result.delegate = { $type: '$Reference', destination: data.$id+'DataSource' };
		
		}
		
		return result;	};
	

UICollectionView.prototype.transformChangeForAppdooPreview = function UICollectionView_transformChangeForAppdooPreview(change, transformer, result) {
		return getPrototype('appdoo.iOS.UIView').transformChangeForAppdooPreview.call(this, change, transformer, result);};
	
	
	
	
	Object.defineProperty(UICollectionView.prototype, "transform", {
	outlet: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_transform")) Object.defineProperty(this, "_transform", { writable: true, configurable: true }); if (!v) v = ''; this._transform = v; if (this.DOMNode) this.DOMNode.style.webkitTransform = v; }, get:function () { return this._transform; }});
	
	
	
	Object.defineProperty(UICollectionView.prototype, "alpha", {
	outlet: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_alpha")) Object.defineProperty(this, "_alpha", { writable: true, configurable: true }); if (isNaN(v)) v = 1; this._alpha = v; if (this.DOMNode) this.DOMNode.style.opacity = v; }, get:function () { return this._alpha; }});
	

	Object.defineProperty(UICollectionView.prototype, "alpha100", {
		set: function (v) { this.alpha = v/100||0; }, 
		get: function () { return this.alpha*100; }});
	

UICollectionView.prototype.prepareForEditor = function UICollectionView_prepareForEditor(editor) {
		__super.prototype.prepareForEditor.call(this, editor);
		getPrototype('info.appdoo-mac.CollectionViewDataProvider').addDataProviderToObject(this);};
	

	Object.defineProperty(UICollectionView.prototype, "dataProvider", {
	outlet: true, 
	enumerable: true, get:function () { return this._dataProvider; }, set:function (v) {if (!Object.hasOwnProperty(this, "_dataProvider")) Object.defineProperty(this, "_dataProvider", { writable: true, configurable: true }); this._dataProvider = v; }});
	

	Object.defineProperty(UICollectionView.prototype, "selectedItemIndex", {
	outlet: true, 
		get: function () {
			
			return 0; 
		}, set:function (v) {if (!Object.hasOwnProperty(this, "_selectedItemIndex")) Object.defineProperty(this, "_selectedItemIndex", { writable: true, configurable: true }); this._selectedItemIndex = v; }});
	

UICollectionView.prototype.initPropertiesFromData = function UICollectionView_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("backgroundColor")) this.backgroundColor = data.backgroundColor;
if (data.hasOwnProperty("numberOfColumns")) this.numberOfColumns = data.numberOfColumns;
if (data.hasOwnProperty("modalTransitionStyle")) this.modalTransitionStyle = data.modalTransitionStyle;
if (data.hasOwnProperty("transform")) this.transform = data.transform;
if (data.hasOwnProperty("alpha")) this.alpha = data.alpha;
if (data.hasOwnProperty("dataProvider")) this.dataProvider = data.dataProvider;
if (data.hasOwnProperty("selectedItemIndex")) this.selectedItemIndex = data.selectedItemIndex;
};

UICollectionView.prototype.decodeData = function UICollectionView_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
if (data.hasOwnProperty("dataProvider")) decoded.dataProvider = this.context.decodeObjectTree(data.dataProvider);
return decoded; };

UICollectionView.prototype.encode = function UICollectionView_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
if (this._dataProvider && this._dataProvider.encode) {encoded.dataProvider = this.dataProvider.encode();
}return encoded; };

UICollectionView.prototype.expectedTypeForProperty = function UICollectionView_expectedTypeForProperty(key) {
	if (key === "backgroundColor") return "String";
	if (key === "nameIsEditable") return "";
	if (key === "defaultCellPrototype") return "";
	if (key === "staticCellPrototype") return "";
	if (key === "numberOfColumns") return "";
	if (key === "readableValue") return "";
	if (key === "iconURL") return "";
	if (key === "outlineIconURL") return "";
	if (key === "modalTransitionStyle") return "Number";
	if (key === "inspectorProperties") return "";
	if (key === "cellPrototypeView") return "";
	if (key === "positionIsEditable") return "";
	if (key === "sizeIsEditable") return "";
	if (key === "canHaveLayoutRelations") return "";
	if (key === "notAvailableInDynamicCells") return "";
	if (key === "bindableProperties") return "";
	if (key === "transform") return "String";
	if (key === "alpha") return "Number";
	if (key === "alpha100") return "Number";
	if (key === "dataProvider") return "CollectionViewDataProvider";
	if (key === "selectedItemIndex") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return UICollectionView; }()));
registerType('info.appdoo-mac', (function () { function CollectionViewDataProvider() {} var __super = setSupertypeFromDomain(CollectionViewDataProvider, 'DataProvider', 'info.appdoo-mac');

	Object.defineProperty(CollectionViewDataProvider.prototype, "propertiesForBindings", {
		value: ['selectedItemIndex']});
	
	
	Object.defineProperty(CollectionViewDataProvider.prototype, "selectedItemIndex", {
		get: function () {
			return 0;
		}});
	
	
	
	Object.defineProperty(CollectionViewDataProvider.prototype, "mutable", {
		value: true});
	

CollectionViewDataProvider.prototype.transformData = function CollectionViewDataProvider_transformData(data, transformer) {
		var result = __super.prototype.transformData.call(this, data, transformer);
		transformer.setReferenceProperty(result, 'control', data.$id, data.objectID);
		return result;};
	
	
CollectionViewDataProvider.prototype.expectedTypeForProperty = function CollectionViewDataProvider_expectedTypeForProperty(key) {
	if (key === "propertiesForBindings") return "";
	if (key === "selectedItemIndex") return "";
	if (key === "mutable") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return CollectionViewDataProvider; }()));
registerType('appdoo.iOS', (function () { function CollectionViewCellContentView() {} var __super = setSupertypeFromDomain(CollectionViewCellContentView, 'CellContentView', 'appdoo.iOS');

	
	
CollectionViewCellContentView.prototype.dataForIndexPath = function CollectionViewCellContentView_dataForIndexPath(ip) {
		return {"foo":"bar", "selected": true};};
	

	Object.defineProperty(CollectionViewCellContentView.prototype, "outlineIconURL", {
	configurable: true, 
		get: function () {
			return this.context.pathForResource('UICollectionViewCell.png');
		}});
	

	Object.defineProperty(CollectionViewCellContentView.prototype, "readableType", {
	configurable: true, 
		get: function () {
			if (this.isPrototype) return LocalizedString('Cell Prototype');
			return LocalizedString('Cell');
		}});
	

	Object.defineProperty(CollectionViewCellContentView.prototype, "widthIsEditable", {
		value: true});
	

	Object.defineProperty(CollectionViewCellContentView.prototype, "heightIsEditable", {
		value: true});
	

	Object.defineProperty(CollectionViewCellContentView.prototype, "sizeIsEditable", {
		value: true});
	

	Object.defineProperty(CollectionViewCellContentView.prototype, "nameIsEditable", {
		value: true});
	

	Object.defineProperty(CollectionViewCellContentView.prototype, "viewMayScroll", {
		value: false});
	

	Object.defineProperty(CollectionViewCellContentView.prototype, "isPrototype", {
	outlet: true, 
	enumerable: true, get:function () { return this._isPrototype; }, set:function (v) {if (!Object.hasOwnProperty(this, "_isPrototype")) Object.defineProperty(this, "_isPrototype", { writable: true, configurable: true }); this._isPrototype = v; }});
	

	Object.defineProperty(CollectionViewCellContentView.prototype, "section", {
	synthesized: true, get:function () { return this._section; }, set:function (v) {if (!Object.hasOwnProperty(this, "_section")) Object.defineProperty(this, "_section", { writable: true, configurable: true }); this._section = v; }});
	

	Object.defineProperty(CollectionViewCellContentView.prototype, "isStaticCell", {
		get: function () {
			return !this.isPrototype;
		}});
	

CollectionViewCellContentView.prototype.deleteForEditor = function CollectionViewCellContentView__deleteForEditor(editor) {
		var r = __super.prototype.deleteForEditor.call(this, editor);
		if (r === false) return false;

		if (this.isStaticCell) {
			if (this.section) this.section.removeCell(this);
		}
	};
	


CollectionViewCellContentView.prototype.initPropertiesFromData = function CollectionViewCellContentView_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("isPrototype")) this.isPrototype = data.isPrototype;
};

CollectionViewCellContentView.prototype.decodeData = function CollectionViewCellContentView_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

CollectionViewCellContentView.prototype.encode = function CollectionViewCellContentView_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

CollectionViewCellContentView.prototype.encodeCloned = function CollectionViewCellContentView_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

CollectionViewCellContentView.prototype.expectedTypeForProperty = function CollectionViewCellContentView_expectedTypeForProperty(key) {
	if (key === "outlineIconURL") return "";
	if (key === "readableType") return "";
	if (key === "widthIsEditable") return "";
	if (key === "heightIsEditable") return "";
	if (key === "sizeIsEditable") return "";
	if (key === "nameIsEditable") return "";
	if (key === "viewMayScroll") return "";
	if (key === "isPrototype") return "Boolean";
	if (key === "section") return "";
	if (key === "isStaticCell") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return CollectionViewCellContentView; }()));
registerType('appdoo.iOS', (function () { function UICollectionViewSection() {} var __super = setSupertypeFromDomain(UICollectionViewSection, 'UIItemsViewSection', 'appdoo.iOS');

UICollectionViewSection.prototype.populateView = function UICollectionViewSection__populateView() {
	
		this.view.removeAllSubviews(true);

		var i = 0, max = this.numberOfStaticCells;
		var rowView;
		if (Array.isArray(this.staticCells)) this.staticCells.every(function (cell) {
			if (++i > max) return false;
			cell.section = this;
			this.view.addSubview(cell);
			cell.indexPath = { section: 0, item: i-1 };return true; }, this);
		
		};
	
	
	function maxPositionPropertyInCells(positionProperty, cells) {
		var max = 0;
		if (Array.isArray(cells)) cells.every(function (cell) {
			max = Math.max(cell.position[positionProperty], max);return true; }, this);
		
		return max;
	}

	function findLowestBottomInCells(cells) {
		return maxPositionPropertyInCells('bottom', cells);
	}

	function findRightestRightInCells(cells) {
		return maxPositionPropertyInCells('right', cells);
	}
	
UICollectionViewSection.prototype.arrangeSubviews = function UICollectionViewSection__arrangeSubviews() {
	
		var allCells = this.staticCells;

		this.itemsView.layoutCells(allCells);

		var margin = (this.itemsView.margin || 0);
		var scrollInsetBottom =  (this.itemsView.e_insetBottom || 0);
		if (this.itemsView.flowLayoutScrollDirection === 'vertical') {
			this.view.size.height = findLowestBottomInCells(allCells)+margin+scrollInsetBottom;
			this.view.size.width = this.itemsView.size.width;
		} else {
			this.view.size.width = findRightestRightInCells(allCells)+margin;
			this.view.size.height = this.itemsView.size.height;
		}
	};
	

UICollectionViewSection.prototype.acceptsMemberWithUTI = function UICollectionViewSection_acceptsMemberWithUTI(uti) {
		if (this.usesDataSource) return false;
		if (uti === 'appdoo.iOS.CollectionViewCellContentView') return true;
		return false;};
	

UICollectionViewSection.prototype.expectedTypeForProperty = function UICollectionViewSection_expectedTypeForProperty(key) {
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return UICollectionViewSection; }()));
registerType('info.appdoo-mac', (function () { function StaticCollectionViewDataSource() {} var __super = setSupertypeFromDomain(StaticCollectionViewDataSource, 'BasicObject', 'Core');

	Object.defineProperty(StaticCollectionViewDataSource.prototype, "needsNoObjCOutlet", {
		value: true});
	

	Object.defineProperty(StaticCollectionViewDataSource.prototype, "cellSizesString", {
	outlet: true, 
	enumerable: true, get:function () { return this._cellSizesString; }, set:function (v) {if (!Object.hasOwnProperty(this, "_cellSizesString")) Object.defineProperty(this, "_cellSizesString", { writable: true, configurable: true }); this._cellSizesString = v; }});
	
	
StaticCollectionViewDataSource.prototype.transformData = function StaticCollectionViewDataSource_transformData(data, transformer) {
		if (!transformer.isXIBGenerator) return {};
		var result = { customClass: 'StaticCollectionViewDataSource' };
		
		result.userDefinedRuntimeAttributes = {
			userDefinedRuntimeAttribute: {
				type: "string",
				keyPath: "cellSizesString",
				value: data.cellSizesString
			}
		};
		
		return result; };
	

StaticCollectionViewDataSource.prototype.initPropertiesFromData = function StaticCollectionViewDataSource_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("cellSizesString")) this.cellSizesString = data.cellSizesString;
};

StaticCollectionViewDataSource.prototype.decodeData = function StaticCollectionViewDataSource_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

StaticCollectionViewDataSource.prototype.encode = function StaticCollectionViewDataSource_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

StaticCollectionViewDataSource.prototype.encodeCloned = function StaticCollectionViewDataSource_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

StaticCollectionViewDataSource.prototype.expectedTypeForProperty = function StaticCollectionViewDataSource_expectedTypeForProperty(key) {
	if (key === "needsNoObjCOutlet") return "";
	if (key === "cellSizesString") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return StaticCollectionViewDataSource; }()));
registerType('info.appdoo-mac', (function () { function CollectionViewDelegate() {} var __super = setSupertypeFromDomain(CollectionViewDelegate, 'BasicObject', 'Core');

	Object.defineProperty(CollectionViewDelegate.prototype, "selectedItemIndex1", {
	synthesized: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_selectedItemIndex1")) Object.defineProperty(this, "_selectedItemIndex1", { writable: true, configurable: true });
			this._selectedItemIndex1 = v;
		}, get:function () { return this._selectedItemIndex1; }});
	
	
	Object.defineProperty(CollectionViewDelegate.prototype, "dataProvider", {
	synthesized: true, 
	enumerable: true, get:function () { return this._dataProvider; }, set:function (v) {if (!Object.hasOwnProperty(this, "_dataProvider")) Object.defineProperty(this, "_dataProvider", { writable: true, configurable: true }); this._dataProvider = v; }});
	

CollectionViewDelegate.prototype.propertyIsObservable = function CollectionViewDelegate_propertyIsObservable(propertyName) {
		switch (propertyName) {
			case 'selectedItemIndex1': return true;
		}
		return false;};
	


	Object.defineProperty(CollectionViewDelegate.prototype, "needsNoObjCOutlet", {
		value: false});
	
	
	Object.defineProperty(CollectionViewDelegate.prototype, "collectionViewStoryboardID", {
	outlet: true, 
	enumerable: true, get:function () { return this._collectionViewStoryboardID; }, set:function (v) {if (!Object.hasOwnProperty(this, "_collectionViewStoryboardID")) Object.defineProperty(this, "_collectionViewStoryboardID", { writable: true, configurable: true }); this._collectionViewStoryboardID = v; }});
	

CollectionViewDelegate.prototype.transformData = function CollectionViewDelegate_transformData(data, transformer) {
		if (!transformer.isXIBGenerator) return {};
	
		var result = { customClass: 'CollectionViewDelegate' };
		
		result.connections = {
			'outlet collectionView': {
				property: "collectionView",
				destination: data.collectionViewStoryboardID,
				id: transformer.createStoryboardID()
			},
		};
		
		if (data.dataProvider) {
			result.connections['outlet dataProvider'] = {
				property: "dataProvider",
				destination: transformer.storyboardIDForComposeObject(data.dataProvider),
				id: transformer.createStoryboardID()
			};
		}
		
		return result; };
	
	
CollectionViewDelegate.prototype.initPropertiesFromData = function CollectionViewDelegate_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("collectionViewStoryboardID")) this.collectionViewStoryboardID = data.collectionViewStoryboardID;
};

CollectionViewDelegate.prototype.decodeData = function CollectionViewDelegate_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

CollectionViewDelegate.prototype.encode = function CollectionViewDelegate_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

CollectionViewDelegate.prototype.encodeCloned = function CollectionViewDelegate_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

CollectionViewDelegate.prototype.expectedTypeForProperty = function CollectionViewDelegate_expectedTypeForProperty(key) {
	if (key === "selectedItemIndex1") return "Number";
	if (key === "dataProvider") return "CollectionViewDataProvider";
	if (key === "needsNoObjCOutlet") return "";
	if (key === "collectionViewStoryboardID") return "String";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return CollectionViewDelegate; }()));
