//
//  UISegmentedControl+TitleTextAttributesString.m
//  

#import "UISegmentedControl+TitleTextAttributesString.h"

@implementation UISegmentedControl (TitleTextAttributesString)

- (void)setTitleTextAttributesString:(NSString *)string {
	NSDictionary * attributesInfo = [NSJSONSerialization JSONObjectWithData:[string dataUsingEncoding:NSUTF8StringEncoding] options:0 error:nil];
	NSMutableDictionary * attributes = @{}.mutableCopy;
	for (NSString * key in attributesInfo) {
		if ([key isEqualToString:@"fontName"]) {
			NSString * fontName = attributesInfo[key];
			CGFloat fontSize = [attributesInfo[@"fontSize"] floatValue];
			UIFont * font = nil;
			if ([fontName isEqualToString:@"_DEFAULT_"]) {
				[UIFont systemFontOfSize:fontSize];
			}
			else if ([fontName isEqualToString:@"_DEFAULT_BOLD_"]) {
				[UIFont boldSystemFontOfSize:fontSize];
			}
			else if ([fontName isEqualToString:@"_DEFAULT_ITALIC_"]) {
				[UIFont italicSystemFontOfSize:fontSize];
			}
			else {
				font = [UIFont fontWithName:fontName size:fontSize];
			}
			if (font) attributes[(id)NSFontAttributeName] = font;
		} else if ([key isEqualToString:@"fontSize"]) {
			CGFloat fontSize = [attributesInfo[@"fontSize"] floatValue];
			attributes[(id)NSFontAttributeName] = [UIFont systemFontOfSize:fontSize];
		}
		if ([key isEqualToString:@"fontSize"]) continue;
	}
	[self setTitleTextAttributes:attributes forState:UIControlStateNormal];
}

@end
