//
//  UITabBarItem+UnselectedImageSystem7.m
//
//

#define SYSTEM_VERSION_LESS_THAN(v)                 ([[[UIDevice currentDevice] systemVersion] compare:v options:NSNumericSearch] == NSOrderedAscending)

#import "UITabBarItem+UnselectedImageSystem7.h"

@implementation UITabBarItem (UnselectedImageSystem7)

- (void)setUnselectedImageName:(NSString *)imageName {
	if (SYSTEM_VERSION_LESS_THAN(@"7.0")) {
		return;
	}
	
	self.selectedImage = self.image;
	self.image = [UIImage imageNamed:imageName];
	
}

- (instancetype)initWithTitle:(NSString *)title unselectedImage:(UIImage *)image selectedImage:(UIImage *)selectedImage {
	if (SYSTEM_VERSION_LESS_THAN(@"7.0")) {
		return [self initWithTitle:title image:selectedImage tag:0];
	}
	return [self initWithTitle:title image:image selectedImage:selectedImage];
}


@end
