//
//  UIViewFontNameAndSizeProperty.m
//
//

static void setFontNameAndSizeInObject(NSString * nameAndSize, id object) {
	NSArray * components = [nameAndSize componentsSeparatedByString:@"\n"];
	UIFont * font = [UIFont fontWithName:components[0] size:[components[1] intValue]];
	[object setValue:font forKey:@"font"];
}

@implementation UIView (FontNameAndSize)

- (void)setFontNameAndSize:(NSString *)nameAndSize {
	setFontNameAndSizeInObject(nameAndSize, self);
}

@end
