
registerType('info.appdoo-mac', (function () { function appdooPublisherDataSource() {} var __super = setSupertypeFromDomain(appdooPublisherDataSource, 'JSONDataSource', 'info.appdoo-mac');

	Object.defineProperty(appdooPublisherDataSource.prototype, "requiresPreviewBuildVersion", {
		value: 12});
	

	Object.defineProperty(appdooPublisherDataSource.prototype, "apiURL", {
		get: function () {
			
			return 'https://appdoo.info/publisher/api/1';
		}});
	
	
	Object.defineProperty(appdooPublisherDataSource.prototype, "publisherURL", {
		get: function () {
			
			return 'https://appdo.info/publisher/';
		}});
	

	Object.defineProperty(appdooPublisherDataSource.prototype, "publisherResourceID", {
	outlet: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_publisherResourceID")) Object.defineProperty(this, "_publisherResourceID", { writable: true, configurable: true });
			var isUpdating = (this._publisherResourceID !== undefined);
			this._publisherResourceID = v;
			setTimeout(function () {
				this.URLRequest.URL = this.apiURL+'/resource/'+v;
				
				if (!this.isLoading) this.load();
			}.bind(this), 1);
		}, get:function () { return this._publisherResourceID; }});
	


appdooPublisherDataSource.prototype.createForContext = function appdooPublisherDataSource_createForContext(context, options) {
		var inst = __super.prototype.createForContext.call(this, context);
		inst.location = 'remote';
		setTimeout(function () {
			if (options && options.droppedOnView) {
				
				if (inst.isGroup)
					this.createUITableViewForSuperview(options.droppedOnView, inst);
			}
		}.bind(this), 1);
		return inst;};
	

	Object.defineProperty(appdooPublisherDataSource.prototype, "readableType", {
		get: function () {
			if (this.isGroup) {
				return LocalizedString("Publisher Dataset Group");
			}

				return LocalizedString("Publisher Dataset");


		}});
	

	Object.defineProperty(appdooPublisherDataSource.prototype, "readableDescription", {
		get: function () {
			return LocalizedString("Provides an appdoo Publisher Data Source");
		}});
	
	
	Object.defineProperty(appdooPublisherDataSource.prototype, "outlineIconURL", {
		get: function () {
			
			if (this.isGroup)
				return 'Resources/appdooPublisherDataSourceE.png';

			if (this.isSingle)
				return 'Resources/appdooPublisherDataSourceC.png';

			return 'Resources/appdooPublisherDataSourceUnknown.png';
		}});
	

	Object.defineProperty(appdooPublisherDataSource.prototype, "iconURL", {
		get: function () {
			if (this.isGroup)
				return 'Resources/appdooPublisherDataSourceE48.png';

			if (this.isSingle)
				return 'Resources/appdooPublisherDataSourceC48.png';

			return 'Resources/appdooPublisherDataSourceUnknown48.png';
		}});
	

	
	Object.defineProperty(appdooPublisherDataSource.prototype, "isGroup", {
	enumerable: true, 
		get: function () {
			return this.metadata && this.metadata.datasetType === 'group';
		}});
	

	Object.defineProperty(appdooPublisherDataSource.prototype, "isSingle", {
		get: function () {
			return this.metadata && this.metadata.datasetType === 'single';
		}});
	

	Object.defineProperty(appdooPublisherDataSource.prototype, "inspectorProperties", {
		get: function () {

			var groups = [

				{
					type: 'group',
					title: this.readableValue,
					id: this.constructor.name,
					items: [

						
						
						{ type: 'button', positionLeft: true, caption: LocalizedString('Edit…'), buttonStyle: 'flat', buttonWidth:TRANSLATE({en:80,de:104}), actionKeyPath:'editData' },
						
						

					]
				},
		
			];

			if (this.isGroup && this.publisherSettings && this.publisherSettings.pushNotificationsEnabled) groups.push({
					type: 'group',
					title: TRANSLATE({de:'Push-Benachrichtigungen',en:'Push Notifications'}),
					id: this.constructor.name+'PushNotifications',
					items: [
						{ type: 'select', keyPath: 'pushNotificationEventHandler.type', name: TRANSLATE({de:'Beim Eintreffen einer Benachrichtigung',en:'When a Notification Arrives'}), labelOnTop: true, numberOfVisibleItems:1, options: [
							['',TRANSLATE({de:'nichts tun',en:'Do Nothing'})],
							['scene',TRANSLATE({de:'Datensatz auf Screen zeigen',en:'Show Dataset on Screen'}), [
								{ type: 'scene', name: LocalizedString('Screen'), keyPath: 'pushNotificationEventHandler.sceneID' }
							]],
							
						], marginTop:-3 }
					]
				});
			
			return groups;

		}});
	
	
	Object.defineProperty(appdooPublisherDataSource.prototype, "bindableProperties", {});
	
	Object.defineProperty(appdooPublisherDataSource.prototype, "pushNotificationEventHandler", {
		get: function () { return this.getPushNotificationEventHandler(); }});
	
	
	Object.defineProperty(appdooPublisherDataSource.prototype, "publisherSettings", {
		get: function () {
			return getPrototype('info.appdoo-mac.appdooPublisherSettings').sharedInstance;
		}});
	
	
appdooPublisherDataSource.prototype.getPushNotificationEventHandler = function appdooPublisherDataSource__getPushNotificationEventHandler() {
		var publisherSettings = this.publisherSettings;
		if (!publisherSettings) return {};
		return publisherSettings.pushNotificationEventHandlerForResourceID(this.publisherResourceID);};
	

appdooPublisherDataSource.prototype.editData = function appdooPublisherDataSource_editData(editor, sender) {
		this.context.nativeProxy.sendMessage('openURL', this.publisherURL+'editresource/'+encodeURIComponent(this.publisherResourceID));};
	
	
appdooPublisherDataSource.prototype.readableNameForProperty = function appdooPublisherDataSource_readableNameForProperty(p) {
		switch (p) {
			case 'publisherResourceID':				return LocalizedString('Resource-ID');
		}
		return __super.prototype.readableNameForProperty.call(this, p);};
	

appdooPublisherDataSource.prototype.setJSONData = function appdooPublisherDataSource__setJSONData(json) {

		
		try {
			var contents = JSON.parse(json);
			this.lastCheckWasValid = true;
		}
		catch (err) {
			console.warn('The JSON is invalid.', {JSON:json}, err);
			var contents = {};
			this.lastCheckWasValid = false;
		}
		
		this.unsortedContents = contents.contents;
		var metadata = clone(contents);
		delete metadata.contents;
		this.metadata = metadata;
		this.e_name = contents.name;
		this.everythingDidLoad();};
	
	
	Object.defineProperty(appdooPublisherDataSource.prototype, "unsortedContents", {
	synthesized: true, get:function () { return this._unsortedContents; }, set:function (v) {if (!Object.hasOwnProperty(this, "_unsortedContents")) Object.defineProperty(this, "_unsortedContents", { writable: true, configurable: true }); this._unsortedContents = v; }});
	
	






	
appdooPublisherDataSource.prototype.everythingDidLoad = function appdooPublisherDataSource__everythingDidLoad() {
		this.contents = this.unsortedContents;
    	this.notifyObservers();
    	this.outlineIconURLDidChange();
    	if (_context.editor.treeController.nodeIsSelected(this.node))
	    	_context.editor.refreshInspector();};
	
	
	Object.defineProperty(appdooPublisherDataSource.prototype, "nameIsEditable", {
		value: false});
	

	
	Object.defineProperty(appdooPublisherDataSource.prototype, "socket", {
	synthesized: true, get:function () { return this._socket; }, set:function (v) {if (!Object.hasOwnProperty(this, "_socket")) Object.defineProperty(this, "_socket", { writable: true, configurable: true }); this._socket = v; }});
	

appdooPublisherDataSource.prototype.load = function appdooPublisherDataSource_load(callback) {

		if (!this.publisherResourceID) {
			if (callback) callback();
			return;
		}

		
		

		this.unsortedContents = null;
		__super.prototype.load.call(this, callback, true);















};
	

	Object.defineProperty(appdooPublisherDataSource.prototype, "metadata", {
	outlet: true, 
	enumerable: true, get:function () { return this._metadata; }, set:function (v) {if (!Object.hasOwnProperty(this, "_metadata")) Object.defineProperty(this, "_metadata", { writable: true, configurable: true }); this._metadata = v; }});
	
	









appdooPublisherDataSource.prototype.transformData = function appdooPublisherDataSource_transformData(data, transformer) {
		transformer.demandPlugin('info.appdoo-mac.appdooPublisher');
		transformer.demandPlugin('info.appdoo-mac.JSONDataSource');
		transformer.demandPlugin('info.appdoo-mac.DataSourceBase');
		transformer.demandPlugin('info.appdoo-mac.NSStringPunycodeAdditions');
		
		data = clone(data);
		delete data.URLRequest;
		var result = __super.prototype.transformData.call(this, data, transformer);
		transformer.setStringProperty(result, 'publisherResourceID', data.publisherResourceID);
		transformer.setBooleanProperty(result, 'isGroup', data.isGroup);

		return result;};
	
	
	
	Object.defineProperty(appdooPublisherDataSource.prototype, "pluginIdentifier", {
		value: 'info.appdoo-mac.appdooPublisher'});
	

appdooPublisherDataSource.prototype.determineFirstItemKey = function appdooPublisherDataSource__determineFirstItemKey(item) {
		
		if (!this.metadata) return;
		if (this.metadata.titleField) return this.metadata.titleField;
		if (this.metadata.fields) return this.metadata.fields[0];};
	
	
appdooPublisherDataSource.prototype.dataForItemInSectionAtIndex = function appdooPublisherDataSource_dataForItemInSectionAtIndex(section, index) {
		if (!this.itemArray) return {};
		var entry = this.itemArray[index] || {};
		if (this.isGroup) {
			entry.$appdoo$isRead = false;
			entry.$appdoo$originalDataSourceRef = '***REF*'+this.$id;
			
			
		}
		return entry;};
	
























	Object.defineProperty(appdooPublisherDataSource.prototype, "performableActions", {
		get: function () {
			var a = Object.getOwnPropertyDescriptor(__super.prototype, "performableActions").get.call(this);
			a['markAllEntriesUnread'] = { name: LocalizedString('Mark All Entries Unread') };
			a['markAllEntriesRead'] = { name: LocalizedString('Mark All Entries Read') };
			if (this.isGroup) {
				a['markEntryRead:<#dataSourceContents#>'] = { name: LocalizedString('Mark Entry Read:'), parameters: [{ type:'dataSourceContents', name:LocalizedString('Entry'), key:'dataSourceContents', canChooseNothing:true, includeDynamicContext:true, numberOfVisibleItems: 1 }] };
			}
			return a;
		}});
	

appdooPublisherDataSource.prototype.nameForKeyPath = function appdooPublisherDataSource_nameForKeyPath(keyPath) {
		if (keyPath.indexOf('$appdoo$isRead') !== -1)
			return TRANSLATE({de:'gelesen (Feed-Eintrag)',en:'is read (feed entry)'});
		if (keyPath.indexOf('$appdoo$originalDataSourceRef') !== -1) {
			return this.readableValue+' (Alias)';
			return LocalizedString('Data Source (Alias)');
		}
		if (keyPath.indexOf('$appdoo$identifier') !== -1) {
			return TRANSLATE({de:'Eintrag-ID',en:'Entry ID'});
		}
		return __super.prototype.nameForKeyPath.call(this, keyPath);};
	
	
	Object.defineProperty(appdooPublisherDataSource.prototype, "singleItemName", {
		get: function () {
			
			return this.readableValue+' '+LocalizedString('Entry');
		}});
	

appdooPublisherDataSource.prototype.suggestedDataTypeForKeyPath = function appdooPublisherDataSource_suggestedDataTypeForKeyPath(keyPath, value) {
		
		
		if (!keyPath) return 'items';
		if (keyPath === '$appdoo$originalDataSourceRef') return 'reference';
		if (this.metadata) {
			
			
			if (keyPath === this.metadata.titleField) return 'title';
			if (this.metadata.types)
				return this.metadata.types[keyPath] || 'text';
		}
		return;};
	

appdooPublisherDataSource.prototype.initPropertiesFromData = function appdooPublisherDataSource_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("publisherResourceID")) this.publisherResourceID = data.publisherResourceID;
if (data.hasOwnProperty("metadata")) this.metadata = data.metadata;
};

appdooPublisherDataSource.prototype.decodeData = function appdooPublisherDataSource_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

appdooPublisherDataSource.prototype.encode = function appdooPublisherDataSource_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

appdooPublisherDataSource.prototype.encodeCloned = function appdooPublisherDataSource_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

appdooPublisherDataSource.prototype.expectedTypeForProperty = function appdooPublisherDataSource_expectedTypeForProperty(key) {
	if (key === "requiresPreviewBuildVersion") return "";
	if (key === "apiURL") return "";
	if (key === "publisherURL") return "";
	if (key === "publisherResourceID") return "String";
	if (key === "readableType") return "String";
	if (key === "readableDescription") return "String";
	if (key === "outlineIconURL") return "";
	if (key === "iconURL") return "";
	if (key === "isGroup") return "";
	if (key === "isSingle") return "";
	if (key === "inspectorProperties") return "";
	if (key === "bindableProperties") return "";
	if (key === "pushNotificationEventHandler") return "";
	if (key === "publisherSettings") return "";
	if (key === "unsortedContents") return "";
	if (key === "nameIsEditable") return "";
	if (key === "socket") return "WebSocket";
	if (key === "metadata") return "Object";
	if (key === "pluginIdentifier") return "";
	if (key === "performableActions") return "";
	if (key === "singleItemName") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return appdooPublisherDataSource; }()));