
registerType('info.appdoo-mac', (function () { function appdooPublisherSettings() {} var __super = setSupertypeFromDomain(appdooPublisherSettings, 'BasicEditableObject', 'appdoo');

	Object.defineProperty(appdooPublisherSettings.prototype, "requiresPreviewBuildVersion", {
		value: 12});
	

	Object.defineProperty(appdooPublisherSettings.prototype, "pluginIdentifier", {
		value: 'info.appdoo-mac.appdooPublisher'});
	

	var sharedInstance;
	
	Object.defineProperty(appdooPublisherSettings.prototype, "sharedInstance", {
		get: function () { return sharedInstance; }});
	

appdooPublisherSettings.prototype.init = function appdooPublisherSettings_init() {
		
		__super.prototype.init.call(this);
		sharedInstance = this;
		return this;};
	
	
appdooPublisherSettings.prototype.prepareForEditor = function appdooPublisherSettings_prepareForEditor(editor) {
		if (!this.username && !this.isSignedOut) this.connectAccount();
		this.loadDatasetList();
		};
	


appdooPublisherSettings.prototype.createForContext = function appdooPublisherSettings_createForContext(context) {
		if (sharedInstance) {
			_context.editor.selectSingleObject(sharedInstance);
			return null;
		}
		var instance = __super.prototype.createForContext.call(this, context);
		instance.pushNotificationsEnabled = true;
		instance.deviceStatisticsEnabled = true;
		return instance;};
	
	
appdooPublisherSettings.prototype.deleteForEditor = function appdooPublisherSettings_deleteForEditor(editor) {
		
		sharedInstance = null;};
	

	Object.defineProperty(appdooPublisherSettings.prototype, "readableType", {
		get: function () {
			return TRANSLATE({'en':'appdoo Publisher','de':'appdoo Publisher'});
		}});
	

	Object.defineProperty(appdooPublisherSettings.prototype, "readableDescription", {
		get: function () {
			return TRANSLATE({en:'Cloud service for push notifications and hosted data',de:'Webdienst für Benachrichtigungen und Feeds'});
		}});
	

	Object.defineProperty(appdooPublisherSettings.prototype, "outlineIconURL", {
		value: 'Resources/appdooPublisherSettings.png'});
	

	Object.defineProperty(appdooPublisherSettings.prototype, "iconURL", {
		value: 'Resources/appdooPublisherSettings48.png'});
	
	
appdooPublisherSettings.prototype.instancesCanBeLocal = function appdooPublisherSettings_instancesCanBeLocal() {
		return false;};
		

appdooPublisherSettings.prototype.instancesCanBeGlobal = function appdooPublisherSettings_instancesCanBeGlobal() {
		return true;};
	
	
	Object.defineProperty(appdooPublisherSettings.prototype, "isConnected", {
		get: function () {
			return !!this.username;
		}});
	
	
	Object.defineProperty(appdooPublisherSettings.prototype, "statusText", {
		get: function () {
			if (this.isConnected)
				
			return this.username;
			return TRANSLATE({de:'Nicht angemeldet',en:'Not Signed In'});
		}});
	

	Object.defineProperty(appdooPublisherSettings.prototype, "inspectorProperties", {
		get: function () {
			var self = this;

			var accountButtonWidth = getPrototype('appdoo.iOS.UILabel').widthForTextWithAttributes(this.username, {
				fontFamily: 'Lucida Grande',
				fontSize: 11,
				width: 320,
				lineHeight: '1em'
			})+15;
			
			var logo = 						{ type: 'info', html: '<center><img src="Resources/appdooPublisherLogo@2x.png" height=48 style="position: relative;top:8px;left:-8px;" /></center>', positionLeft: true, height: 65 };
			
			if (!this.isConnected) {
			  var signInButtonWidth = TRANSLATE({en:70,de:72});

			  return	 [

				{
					type: 'group',
					title: '',
					id: this.constructor.name,
					items: [
						
						{ type: 'info', html: '<center><img src="Resources/appdooPublisherLogo@2x.png" width=161 height=58 style="position: relative;top:12px;left:-5px;" /></center>', positionLeft: true, height: 75 },
						{ type: 'space' },

						{ type: 'info', html: TRANSLATE({
							en:'Use appdoo Publisher to store your app\'s data in the cloud and send push notifications.',
							de:'Verwenden Sie appdoo Publisher, um Daten in der Cloud speichern und Push-Benachrichtigungen zu senden.'
							}), positionLeft: true, style: {position:'relative',left:'27px',fontSize:'13px',color:'#555'}, height: 70 },
						
						{ type: 'button', caption: LocalizedString('Sign In'), buttonWidth: signInButtonWidth, positionLeft: true, actionKeyPath: 'connectAccount', hidden: this.isConnected, buttonStyle: 'flat',
							noLinebreak: true
						 },
						{ type: 'button', caption: TRANSLATE({'de':'Konto erstellen','en':'Create Account'}), buttonWidth: TRANSLATE({en:115,de:101}), positionLeft: true, actionKeyPath: 'createAccount', hidden: this.isConnected, buttonStyle: 'flat', noLinebreak: false,
							
							left: signInButtonWidth+35
							},
					]
				}
			  ];

			
			} else {

			  return	 [

				{
					type: 'group',
					title: '',
					id: this.constructor.name,
					items: [
					
						
						
						logo,
						
						{ type: 'info', html: TRANSLATE({'en':'Publisher Account','de':'Publisher-Konto'}), positionLeft: true, style: {color:'#000'}, height: 10, noLinebreak: 0 },
						{ type: 'button', buttonStyle: 'flat', actionKeyPath: 'manageAccount', caption: this.username, buttonWidth: accountButtonWidth, align: 'left', positionLeft: true, noLinebreak: 0 },


						
						
						
						
					
						
























						{ type: 'info', html: TRANSLATE({'en':'Datasets','de':'Datensätze'}), positionLeft: true, style: {color:'#555',fontSize: '12px',},  height: 10, noLinebreak: 0 },

						{ type: 'promisedObjects', keyPath: 'datasetList', numberOfVisibleItems: 6.5, positionLeft: true, isFirstInGroup:true, 
							placeholderText: TRANSLATE({en:'Click on "Manage Datasets…" to create or add a dataset.',de:'Keine Datensätze'}),
							
						},
						
						{ type: 'button', caption: TRANSLATE({'de':'Datensätze verwalten …','en':'Manage Datasets…'}), buttonStyle: 'flat', buttonWidth: TRANSLATE({'en':120,'de':140}), align: 'right', positionLeft: 0, marginTop: -10, noLinebreak: true, actionKeyPath: 'manageDatasets' },
						
						{ type: 'button', buttonImageSrc: 'Resources/ReloadMini.png', buttonStyle: 'flat', buttonWidth: 22, align: 'left', positionLeft: true, marginTop: 0, actionKeyPath: 'reloadDatasets' },
						
						
						
						

						{ type: 'space' },

						{ type: 'space' },
						{ type: 'boolean', name: TRANSLATE({de:'Pushbenachrichtigungen',en:'Push Notifications'}), positionLeft: true, marginTop: 0, keyPath:'pushNotificationsEnabled', label: TRANSLATE({de:'Funktionen',en:'Features'}) },
						
						{ type: 'boolean', name: TRANSLATE({de:'Geräte-Statistiken',en:'Device Statistics'}), positionLeft: 0, marginTop: 0, keyPath:'deviceStatisticsEnabled' },

						{ type: 'space' },


					]
				},
		
			];
		  }

		}});
	


	Object.defineProperty(appdooPublisherSettings.prototype, "pushNotificationsEnabled", {
	outlet: true, 
	enumerable: true, get:function () { return this._pushNotificationsEnabled; }, set:function (v) {if (!Object.hasOwnProperty(this, "_pushNotificationsEnabled")) Object.defineProperty(this, "_pushNotificationsEnabled", { writable: true, configurable: true }); this._pushNotificationsEnabled = v; }});
	

	Object.defineProperty(appdooPublisherSettings.prototype, "deviceStatisticsEnabled", {
	outlet: true, 
	enumerable: true, get:function () { return this._deviceStatisticsEnabled; }, set:function (v) {if (!Object.hasOwnProperty(this, "_deviceStatisticsEnabled")) Object.defineProperty(this, "_deviceStatisticsEnabled", { writable: true, configurable: true }); this._deviceStatisticsEnabled = v; }});
	
	
	Object.defineProperty(appdooPublisherSettings.prototype, "apiURL", {
		get: function () {
			
			return 'https://appdoo.info/publisher/api/1';
		}});
	
	
	Object.defineProperty(appdooPublisherSettings.prototype, "developerID", {
	outlet: true, 
	enumerable: true, get:function () { return this._developerID; }, set:function (v) {if (!Object.hasOwnProperty(this, "_developerID")) Object.defineProperty(this, "_developerID", { writable: true, configurable: true }); this._developerID = v; }});
	


	
appdooPublisherSettings.prototype.connectAccount = function appdooPublisherSettings_connectAccount(sender, previousErrorMessage) {
		var showSignInDialog = sender !== undefined;
		if (typeof previousErrorMessage !== 'string') previousErrorMessage = '';
		
		
		
		var json = this.context.nativeProxy.sendMessage('usernameForAppdooPublisherAccount', showSignInDialog, previousErrorMessage);
		if (!json) return;
		
		var onSuccess = function (info, response) {
			this.isSignedOut = false;
			this.username = info.username;
	    	if (_context.editor.treeController.nodeIsSelected(this.node))
				_context.editor.refreshInspector();
			this.loadDatasetList();
			if (response) {
				this.developerID = response.developerID;
				
			}
		}.bind(this);
		
		try {
			var info = JSON.parse(json);
			
			if (info.password === undefined)
				return onSuccess(info);
			
			
			var url = this.apiURL+'/signin?lang='+encodeURIComponent(window.language)+'&username='+encodeURIComponent(info.username)+'&password='+encodeURIComponent(info.password)+'&mid='+encodeURIComponent(info.mid);
			
			var xmlHttp = new XMLHttpRequest();
			xmlHttp.open('GET', url, true);
			xmlHttp.onreadystatechange = function () {
				if (xmlHttp.readyState == 4) {
					try {
						var response = JSON.parse(xmlHttp.responseText);
						
						
						if (response.error)
							return this.handleFailedSignIn(response.error);
						
						onSuccess(info, response);

					} catch (err) {
						if (_context.isDebugging)
							alert(xmlHttp.responseText);
						else
							this.handleFailedSignIn();
					}
				}
			}.bind(this);
			xmlHttp.send(null);
		} catch (err) {
		}
};
	
	
appdooPublisherSettings.prototype.handleFailedSignIn = function appdooPublisherSettings__handleFailedSignIn(errorMessage) {
		if (!errorMessage) errorMessage = TRANSLATE({de:'Die Anmeldung ist fehlgeschlagen. Bitte versuchen Sie es in Kürze noch einmal.',en:'Failed to sign in. Please try again in a few seconds.'});
		setTimeout(function () {
			this.connectAccount(this, errorMessage);
		}.bind(this), 1000);};
	

	Object.defineProperty(appdooPublisherSettings.prototype, "isSignedOut", {
	outlet: true, 
	enumerable: true, get:function () { return this._isSignedOut; }, set:function (v) {if (!Object.hasOwnProperty(this, "_isSignedOut")) Object.defineProperty(this, "_isSignedOut", { writable: true, configurable: true }); this._isSignedOut = v; }});
	

appdooPublisherSettings.prototype.manageAccount = function appdooPublisherSettings_manageAccount() {
		var result = this.context.nativeProxy.sendMessage('confirmWithOptions', JSON.stringify({
			message: LocalizedString('Signed in as') + ' ' + this.username,
			details: LocalizedString('Do you want to sign out or view the settings for this account?'),
			button1: LocalizedString('Settings…'),
			button2: LocalizedString('Sign Out'),
			button3: LocalizedString('Cancel'),
			
		}));
		if (result === 2) return; 
		if (result === true) { 
			this.context.nativeProxy.sendMessage('openURL', 'https://appdoo.info/publisher/account/');
			return; 
		}
		if (result === false) { 
			this.username = null;
			this.datasetList = null;
			this.isSignedOut = true;
	    	if (_context.editor.treeController.nodeIsSelected(this.node))
				_context.editor.refreshInspector();
			return; 
		}};
	
	
appdooPublisherSettings.prototype.createAccount = function appdooPublisherSettings_createAccount() {
		this.context.nativeProxy.sendMessage('openURL', 'https://appdoo.info/publisher/register/');};
	
	
appdooPublisherSettings.prototype.manageDatasets = function appdooPublisherSettings_manageDatasets() {
		this.context.nativeProxy.sendMessage('openURL', 'https://appdoo.info/publisher/datasets/');};
	
	

	Object.defineProperty(appdooPublisherSettings.prototype, "username", {
	outlet: true, 
	enumerable: true, get:function () { return this._username; }, set:function (v) {if (!Object.hasOwnProperty(this, "_username")) Object.defineProperty(this, "_username", { writable: true, configurable: true }); this._username = v; }});
	


appdooPublisherSettings.prototype.transformData = function appdooPublisherSettings_transformData(data, transformer) {

		
	
		transformer.demandPlugin('info.appdoo-mac.appdooPublisher');
		transformer.demandPlugin('info.appdoo-mac.SceneInputDataSource');
		transformer.demandPlugin('info.appdoo-mac.JSONDataSource');

		var result = __super.prototype.transformData.call(this, data, transformer);

		transformer.setBooleanProperty(result, 'pushNotificationsEnabled', data.pushNotificationsEnabled);
		transformer.setBooleanProperty(result, 'deviceStatisticsEnabled', data.pushNotificationsEnabled);
		transformer.setStringProperty(result, 'developerID', data.developerID);

		if (data.pushNotificationsEnabled) {
			
			var appDelegateCode = {
				'application:didFinishLaunchingWithOptions:':'\t[appdooPublisherPNS applicationDidFinishLaunchingWithOptions:launchOptions];',
				
				
				'application:didRegisterForRemoteNotificationsWithDeviceToken:':'\t[appdooPublisherPNS applicationDidRegisterForRemoteNotificationsWithDeviceToken:deviceToken];',
				'application:didReceiveRemoteNotification:':'\t[appdooPublisherPNS handlePush:userInfo];',
				'application:didFailToRegisterForRemoteNotificationsWithError:':'#ifdef DEBUG\n\t[[UIAlertController alertWithTitle:@"An error occured when registering for remote notifications." message:error.localizedDescription] show];\n#endif',
			};
			for (var key in appDelegateCode) {
				transformer.registerAppDelegateCode(key, appDelegateCode[key]);
			}
			
			transformer.setStringProperty(result, 'pushNotificationEventHandlersJSON', JSON.stringify(data.pushNotificationEventHandlers));
		}

		return result;};
	
	
	Object.defineProperty(appdooPublisherSettings.prototype, "datasetList", {
	outlet: true, 
	enumerable: true, get:function () { return this._datasetList; }, set:function (v) {if (!Object.hasOwnProperty(this, "_datasetList")) Object.defineProperty(this, "_datasetList", { writable: true, configurable: true }); this._datasetList = v; }});
	
	
	Object.defineProperty(appdooPublisherSettings.prototype, "isLoading", {
	synthesized: true, get:function () { return this._isLoading; }, set:function (v) {if (!Object.hasOwnProperty(this, "_isLoading")) Object.defineProperty(this, "_isLoading", { writable: true, configurable: true }); this._isLoading = v; }});
	
	
appdooPublisherSettings.prototype.loadDatasetList = function appdooPublisherSettings_loadDatasetList(sender) {
	
		if (!this.username) return;
		if (this.isLoading) return;
		if (sender) sender.disabled = true;
		this.isLoading = true;
		
		var url = this.apiURL+'/datasets/list?username='+encodeURIComponent(this.username);
		
		var xmlHttp = new XMLHttpRequest();
		xmlHttp.open('GET', url, true);
		xmlHttp.onreadystatechange = function () {
			if (xmlHttp.readyState == 4) {
				this.isLoading = false;
				
				
				try {
					var obj = JSON.parse(xmlHttp.responseText);
					this.datasetList = obj.result;
			    	if (_context.editor.treeController.nodeIsSelected(this.node))
						_context.editor.refreshInspector();
					
				} catch (err) { alertd(xmlHttp.responseText); }
			}
		}.bind(this);
		xmlHttp.send(null);
};
	
	
appdooPublisherSettings.prototype.reloadDatasets = function appdooPublisherSettings_reloadDatasets(editor, sender) {
	
		this.loadDatasetList(sender);};
	
	
	Object.defineProperty(appdooPublisherSettings.prototype, "pushNotificationEventHandlers", {
	outlet: true, 
	enumerable: true, 
		get: function () {
			if (!this._pushNotificationEventHandlers) this.pushNotificationEventHandlers = {};
			return this._pushNotificationEventHandlers;
		}, set:function (v) {if (!Object.hasOwnProperty(this, "_pushNotificationEventHandlers")) Object.defineProperty(this, "_pushNotificationEventHandlers", { writable: true, configurable: true }); this._pushNotificationEventHandlers = v; }});
	
	
appdooPublisherSettings.prototype.pushNotificationEventHandlerForResourceID = function appdooPublisherSettings__pushNotificationEventHandlerForResourceID(resourceID) {
		if (!this.pushNotificationEventHandlers[resourceID])
			this.pushNotificationEventHandlers[resourceID] = {};
		return this.pushNotificationEventHandlers[resourceID];};
	

appdooPublisherSettings.prototype.initPropertiesFromData = function appdooPublisherSettings_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("pushNotificationsEnabled")) this.pushNotificationsEnabled = data.pushNotificationsEnabled;
if (data.hasOwnProperty("deviceStatisticsEnabled")) this.deviceStatisticsEnabled = data.deviceStatisticsEnabled;
if (data.hasOwnProperty("developerID")) this.developerID = data.developerID;
if (data.hasOwnProperty("isSignedOut")) this.isSignedOut = data.isSignedOut;
if (data.hasOwnProperty("username")) this.username = data.username;
if (data.hasOwnProperty("datasetList")) this.datasetList = data.datasetList;
if (data.hasOwnProperty("pushNotificationEventHandlers")) this.pushNotificationEventHandlers = data.pushNotificationEventHandlers;
};

appdooPublisherSettings.prototype.decodeData = function appdooPublisherSettings_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

appdooPublisherSettings.prototype.encode = function appdooPublisherSettings_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

appdooPublisherSettings.prototype.encodeCloned = function appdooPublisherSettings_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

appdooPublisherSettings.prototype.expectedTypeForProperty = function appdooPublisherSettings_expectedTypeForProperty(key) {
	if (key === "requiresPreviewBuildVersion") return "";
	if (key === "pluginIdentifier") return "";
	if (key === "sharedInstance") return "";
	if (key === "readableType") return "";
	if (key === "readableDescription") return "";
	if (key === "outlineIconURL") return "";
	if (key === "iconURL") return "";
	if (key === "isConnected") return "";
	if (key === "statusText") return "";
	if (key === "inspectorProperties") return "";
	if (key === "pushNotificationsEnabled") return "Boolean";
	if (key === "deviceStatisticsEnabled") return "Boolean";
	if (key === "apiURL") return "";
	if (key === "developerID") return "String";
	if (key === "isSignedOut") return "Boolean";
	if (key === "username") return "String";
	if (key === "datasetList") return "Object";
	if (key === "isLoading") return "";
	if (key === "pushNotificationEventHandlers") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return appdooPublisherSettings; }()));