//
//  NSURL+CreateWithParameters.m
//
//

#import "NSURL+CreateWithParameters.h"

@implementation NSURL (CreateWithParameters)

+ (instancetype)URLWithString:(NSString *)URLString parameters:(NSDictionary *)parameters {
	NSMutableString * parameterizedString = URLString.mutableCopy;
	
	[parameterizedString appendString:@"?"];
	
	int c = 0;
	for (NSString * key in parameters) {
		NSString * value = parameters[key];
		if ([value isKindOfClass:NSString.class]) {
			if (c) {
				[parameterizedString appendString:@"&"];
			}
			if(value) {
				value = [value stringByAddingPercentEncodingWithAllowedCharacters:[NSCharacterSet URLQueryAllowedCharacterSet]];
			}
			[parameterizedString appendFormat:@"%@=%@", key, value];
			c++;
		}
	}
	
	return [NSURL URLWithString:parameterizedString];
}

@end
