
#import "appdooPublisherSettings.h"

@implementation appdooPublisherSettings
static appdooPublisherSettings * sharedInstance;

- (instancetype)init
{
	if (sharedInstance) return sharedInstance;
    self = [super init];
    if (self) {
        sharedInstance = self;
    }
    return self;
}

+ (appdooPublisherSettings *)sharedSettings {
	return sharedInstance;
}

- (void)setPushNotificationEventHandlersJSON:(NSString *)json {
	id result = [NSJSONSerialization JSONObjectWithData:[json dataUsingEncoding:NSUTF8StringEncoding] options:0 error:nil];
	if ([result isKindOfClass:[NSDictionary class]])
		self.pushNotificationEventHandlers = result;
}

- (NSString *)developerID {
	if (!_developerID) return @"";
	return _developerID;
}

@end

