
registerType('appdoo', (function () { function BasicDataSource() {} var __super = setSupertypeFromDomain(BasicDataSource, 'BasicEditableObject', 'appdoo');

	Object.defineProperty(BasicDataSource.prototype, "isObservable", {
		value: true});
	

	Object.defineProperty(BasicDataSource.prototype, "excludeFromExport", {
	outlet: true, 
	enumerable: true, get:function () { return this._excludeFromExport; }, set:function (v) {if (!Object.hasOwnProperty(this, "_excludeFromExport")) Object.defineProperty(this, "_excludeFromExport", { writable: true, configurable: true }); this._excludeFromExport = v; }});
	

BasicDataSource.prototype.createForContext = function BasicDataSource_createForContext(context) {

		return createComponentFromDomain(
			this.constructor.name,
			this.__domain,
			context,
			{
			}
		);
		};
	

	Object.defineProperty(BasicDataSource.prototype, "positionIsEditable", {
	configurable: true, 
		value: false});
	

	Object.defineProperty(BasicDataSource.prototype, "sizeIsEditable", {
	configurable: true, 
		value: false});
	

	Object.defineProperty(BasicDataSource.prototype, "xIsEditable", {
		get: function () { return this.positionIsEditable; }});
	

	Object.defineProperty(BasicDataSource.prototype, "yIsEditable", {
		get: function () { return this.positionIsEditable; }});
	

	Object.defineProperty(BasicDataSource.prototype, "widthIsEditable", {
		get: function () { return this.sizeIsEditable; }});
	

	Object.defineProperty(BasicDataSource.prototype, "heightIsEditable", {
		get: function () { return this.sizeIsEditable; }});
	

BasicDataSource.prototype.createForSuperview = function BasicDataSource_createForSuperview(view) {
		return this.createForContext(view.context);};
	

BasicDataSource.prototype.createUITableViewForSuperview = function BasicDataSource_createUITableViewForSuperview(view, ds) {
	
		if (_context.editor.isPerformingDropOnItemView) return;
	
		if (!_context.editor.itemAcceptsMemberWithUTI(view, 'appdoo.iOS.UITableView'))
			return this.createForContext(view.context);
	
		var tv = _context.editor.insertFromBlueprint('appdoo.iOS.UITableView', view ? view.node : null);
		_context.editor.animateInsertion(tv);
		
		if (!ds) ds = this.createForContext(view.context);
		
		setTimeout(function () {
			tv.e_dataSourceID = ds.identify();
		}, 0);
		return ds;
};
	

BasicDataSource.prototype.init = function BasicDataSource_init() {
		var self = __super.prototype.init.call(this);
		if (self) {

			Object.defineProperty(this, "observers", {
				value: []});
			
			
			if (this.location === 'remote') this.load();

		}
		return self;};
	

	Object.defineProperty(BasicDataSource.prototype, "firstItemKey", {
		get: function () {
			if (this.itemArray) return this.determineFirstItemKey(this.itemArray[0]);
		}});
	
	
BasicDataSource.prototype.determineFirstItemKey = function BasicDataSource__determineFirstItemKey(item) {
		if (typeof item === 'object' && item !== null) {
			var allKeys = Object.keys(item);
			for (var i in allKeys) {
				if (typeof item[allKeys[i]] === 'string')
					return allKeys[i];
			}
		}};
	

	
BasicDataSource.prototype.destroy = function BasicDataSource_destroy() {
		if (this.xmlHttpRequest) this.xmlHttpRequest.abort();
		__super.prototype.destroy.call(this);};
	
	
BasicDataSource.prototype.deleteForEditor = function BasicDataSource_deleteForEditor(editor) {
		this.contents = undefined;
		this._isDestroyed = true;
		this.notifyObservers();};
	
	
BasicDataSource.prototype.readableValueDidChange = function BasicDataSource__readableValueDidChange() {
		__super.prototype.readableValueDidChange.call(this);
		if (Array.isArray(this.observers)) this.observers.every(function (observer) {
			observer.readableValueDidChange();return true; }, this);
		};
	

	Object.defineProperty(BasicDataSource.prototype, "URLRequest", {
	outlet: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_URLRequest")) Object.defineProperty(this, "_URLRequest", { writable: true, configurable: true });
			this._URLRequest = v;
			if (this.location === 'remote')
				this.load();
		}, 
		get: function () {
			if (!this._URLRequest) {
				Object.defineProperty(this, "_URLRequest", {
					value: createComponentFromDomain('URLRequest', 'Core', this.context, {}), 
					configurable: true});
				
			}
			return this._URLRequest;
		}});
	
	
	Object.defineProperty(BasicDataSource.prototype, "isLoading", {
	synthesized: true, get:function () { return this._isLoading; }, set:function (v) {if (!Object.hasOwnProperty(this, "_isLoading")) Object.defineProperty(this, "_isLoading", { writable: true, configurable: true }); this._isLoading = v; }});
	

	Object.defineProperty(BasicDataSource.prototype, "e_URL", {
		set: function (v) {

			if (this.isLoading || !v) return;
			this.isLoading = true;
			setTimeout(function() { this.isLoading = false; }.bind(this), 500);

			var isInitialSetting = !this.e_URL;
			this.URLRequest.URL = v;

			if (!isInitialSetting) {
				this._contents = undefined;
				this.notifyObservers();
			}
			this.load();
		}, 
		get: function () { return this.URLRequest.URL; }});
	

	
	Object.defineProperty(BasicDataSource.prototype, "URLString", {
		set: function (v) { this.e_URL = v; }, 
		get: function ( ) { return this.e_URL; }});
	

	Object.defineProperty(BasicDataSource.prototype, "contents", {
	outlet: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_contents")) Object.defineProperty(this, "_contents", { writable: true, configurable: true });
			this._contents = v;
		}, get:function () { return this._contents; }});
	

	Object.defineProperty(BasicDataSource.prototype, "rootData", {
		get: function () {
			return this.contents;
		}});
	

	Object.defineProperty(BasicDataSource.prototype, "rootDataKeyPath", {
		value: 'contents'});
	

	Object.defineProperty(BasicDataSource.prototype, "canBeKeyPathFiltered", {
		value: false});
	

	Object.defineProperty(BasicDataSource.prototype, "itemArray", {
		get: function () {
			if (Array.isArray(this.contents))
				return this.contents;
		}});
	

	Object.defineProperty(BasicDataSource.prototype, "providesRootData", {
		value: false});
	
	
	Object.defineProperty(BasicDataSource.prototype, "readableType", {
		get: function () { return this.constructor.name; }});
	
	
	Object.defineProperty(BasicDataSource.prototype, "canReload", {
		get: function () {
			if (this.location === 'remote')
				return true;
		}});
	
	
BasicDataSource.prototype.reload = function BasicDataSource_reload(callback) {
		this.load(callback, true);};
	

	Object.defineProperty(BasicDataSource.prototype, "didLoad", {
	synthesized: true, get:function () { return this._didLoad; }, set:function (v) {if (!Object.hasOwnProperty(this, "_didLoad")) Object.defineProperty(this, "_didLoad", { writable: true, configurable: true }); this._didLoad = v; }});
	

BasicDataSource.prototype.load = function BasicDataSource_load(callback, bypassCache) {
	
		setTimeout(function () {
		
			if (!this.URLRequest.URL) {
				if (callback) callback(this);
				return;
			}
			if (this.xmlHttpRequest) this.xmlHttpRequest.abort();
			var url = this.URLRequest.parameterizedURL;
			if (bypassCache) {
				if (url.indexOf('?') !== -1) url += '#';
				else url += '?';
				url += 'cache='+(new Date()).getTime();
			}

			var xmlHttp = new XMLHttpRequest();
			xmlHttp.open('GET', url, true);
			xmlHttp.onreadystatechange = function () {
				if (xmlHttp.readyState == 4) {
					this.xmlHttpRequest = null;
					this.data = xmlHttp.responseText;
					this.didLoad = true;
					this.notifyObservers();
					if (callback) callback(this);
				}
			}.bind(this);
			xmlHttp.send(null);
			this.xmlHttpRequest = xmlHttp;
		
		}.bind(this), 100);};
	
	
	Object.defineProperty(BasicDataSource.prototype, "xmlHttpRequest", {
	synthesized: true, get:function () { return this._xmlHttpRequest; }, set:function (v) {if (!Object.hasOwnProperty(this, "_xmlHttpRequest")) Object.defineProperty(this, "_xmlHttpRequest", { writable: true, configurable: true }); this._xmlHttpRequest = v; }});
	

// role DataSource (appdoo.DataSources) 
	
BasicDataSource.prototype.numberOfItemsInSection = function BasicDataSource_numberOfItemsInSection(section, keyPath) {
			if (!this.itemArray) return 0;
			return this.itemArray.length || 0;};
		

BasicDataSource.prototype.numberOfItemsInSectionAtKeyPath = function BasicDataSource_numberOfItemsInSectionAtKeyPath(section, keyPath) {
			return this.numberOfItemsInSection(section);};
		
		
BasicDataSource.prototype.dataForItemInSectionAtIndex = function BasicDataSource_dataForItemInSectionAtIndex(section, index) {
			if (!this.itemArray) return {};
			return this.itemArray[index] || {};};
		
		
BasicDataSource.prototype.dataForIndexPath = function BasicDataSource_dataForIndexPath(indexPath) {
			if (!indexPath) { console.trace(); return; }
			return this.dataForItemInSectionAtIndex(indexPath.section, indexPath.item);};
		
		
BasicDataSource.prototype.dataForIndexPathInKeyPath = function BasicDataSource_dataForIndexPathInKeyPath(indexPath, keyPath) {
			return this.dataForIndexPath(indexPath);};
		

BasicDataSource.prototype.keyAtIndex = function BasicDataSource_keyAtIndex(i) {
			if (!this.itemArray) return '';
			return Object.keys(this.itemArray)[i];};
		

BasicDataSource.prototype.nameForKey = function BasicDataSource_nameForKey(key) {
			if (!this.itemArray) return '';
			return key;};
		
		
BasicDataSource.prototype.numberOfSections = function BasicDataSource_numberOfSections() {
			return 1;};
		

BasicDataSource.prototype.numberOfSectionsInKeyPath = function BasicDataSource_numberOfSectionsInKeyPath(keyPath) {
			return this.numberOfSections();};
		

BasicDataSource.prototype.addObserver = function BasicDataSource_addObserver(observer, silent) {
		
			var index = this.observers.indexOf(observer);
			if (index === -1) {
				this.observers.push(observer);
				if (this.contents && !silent) {
					observer.dataSourceDidLoad(this);
				}
			} else {
			}
			return true;};
		
	
BasicDataSource.prototype.removeObserver = function BasicDataSource_removeObserver(observer) {
			var index = this.observers.indexOf(observer);
			if (index !== -1) {
				this.observers.splice(index, 1);
			} else {
				console.warn('Could not remove non-existent observer.',observer);
			}};
		
		
	

BasicDataSource.prototype.notifyObservers = function BasicDataSource__notifyObservers() {

		if (Array.isArray(this.observers)) this.observers.every(function (observer) {
			observer.dataSourceDidLoad(this);return true; }, this);
		
	};
	

	Object.defineProperty(BasicDataSource.prototype, "location", {
	outlet: true, 
	enumerable: true, get:function () { return this._location; }, set:function (v) {if (!Object.hasOwnProperty(this, "_location")) Object.defineProperty(this, "_location", { writable: true, configurable: true }); this._location = v; }});
	

	Object.defineProperty(BasicDataSource.prototype, "e_location", {
		get: function ( ) { return this.location; }, 
		set: function (v) {

			this.location = v;
			
			if (v === 'local') {
				this.data = this.localData;
				this.notifyObservers();
			}
			if (v === 'remote') {
				this.load();
			}
			this.outlineAccessoryTypeDidChange();
		}});
	

	Object.defineProperty(BasicDataSource.prototype, "localData", {
	outlet: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_localData")) Object.defineProperty(this, "_localData", { writable: true, configurable: true });

			this._localData = v;

			if (this.location === 'local') {
				this.data = v;
				this.didLoad = true;
				this.notifyObservers();
			}
		}, get:function () { return this._localData; }});
	

	Object.defineProperty(BasicDataSource.prototype, "inspectorProperties", {
		get: function () {
			return [
				{
					type: 'group',
					title: this.readableType,
					id: this.constructor.name,
					items: [
						{ name: this.readableNameForProperty('name'), keyPath: 'e_name', dataKeyPath: 'name', type: 'text', positionLeft: true, placeholder:LocalizedString('Optional') },
						{ name: LocalizedString("Location"), keyPath: 'e_location', type: "select", options:[
							["local", LocalizedString("local"), [
								{ keyPath: 'localData', type:'textarea', textFieldHeight:250, acceptsReturn: true, isFirstInGroup: true, marginTop:-5 },
								{ type: 'button', caption: LocalizedString('Load From File …'), buttonWidth: 110, buttonStyle: 'flat', positionLeft: true, actionKeyPath: 'importFile' },
							]],
							
							["remote", LocalizedString("remote"),[
								{ name: LocalizedString('URL'), keyPath: 'e_URL', type: 'textarea', spellcheck: false, textFieldHeight: 60, marginTop: 0, dataKeyPath: 'URLString' },
								{ type: 'button', caption: LocalizedString('Reload'), buttonWidth: 70, buttonStyle: 'flat', positionLeft: true, actionKeyPath: 'reloadFromButton' },
							]],


						] },
						
						{ type: 'space', hidden: true },
						{ type: 'boolean', name: LocalizedString('Exclude from Export'), keyPath: 'excludeFromExport', positionLeft: true, hidden: true },
					]
				}
			];
		}});
	

	Object.defineProperty(BasicDataSource.prototype, "lastCheckWasValid", {
	outlet: true, 
	enumerable: true, get:function () { return this._lastCheckWasValid; }, set:function (v) {if (!Object.hasOwnProperty(this, "_lastCheckWasValid")) Object.defineProperty(this, "_lastCheckWasValid", { writable: true, configurable: true }); this._lastCheckWasValid = v; }});
	
	
	Object.defineProperty(BasicDataSource.prototype, "validationResult", {
		get: function () {
			if (this.lastCheckWasValid !== false) return '';
			
			return '<div style="float:left;height:100px;font-size:24px;">⚠️</div><div style="margin-left:32px;color:#666;-webkit-user-select:auto;cursor:text;">Die Daten konnten nicht gelesen werden, da sie nicht das richtige Format haben.</span>';
		}});
	
	
BasicDataSource.prototype.importFile = function BasicDataSource_importFile() {

		var info = this.context.nativeProxy.sendMessage('chooseFileForImport', JSON.stringify({
			title: LocalizedString('Import'),
			allowedFileTypes: this.fileExtensionsForImport,
			prompt: LocalizedString("Import File"),
		}));

		if (typeof info !== 'string') return;
		info = JSON.parse(info);

		if (!info || !info.path) return;
		
		var path = info.path;
		var data = this.context.nativeProxy.sendMessage('stringFromFile', path);
		if (!data) return;
		
		this.dataController.setValueForKeyPath(data, 'localData');
		_context.editor.refreshInspector(this);
};
	
	
BasicDataSource.prototype.reloadFromButton = function BasicDataSource_reloadFromButton(button) {
		document.activeElement.blur();
		setTimeout(function () {
			this.load();
		}.bind(this), 10);};
	

	Object.defineProperty(BasicDataSource.prototype, "bindableProperties", {
		get: function () {
			var result = clone(__super.prototype.bindableProperties)||[];
			['URLString'].every(function (key) {
				result.unshift([key, this.readableNameForProperty(key)]);
				return true;
			}, this);
			return result;
		}});
	
	
BasicDataSource.prototype.readableNameForProperty = function BasicDataSource_readableNameForProperty(name) {
		if (name === 'URLString') return LocalizedString('URL');
		if (name === 'name') return LocalizedString('Name');
		return __super.prototype.readableNameForProperty.call(this, name);};
	
	
BasicDataSource.prototype.nameForKeyPath = function BasicDataSource_nameForKeyPath(keyPath) {
		if (keyPath.indexOf('contents.') === 0) {
			return keyPath.substr('contents.'.length);
		}
		return keyPath;};
	
	
	Object.defineProperty(BasicDataSource.prototype, "URL", {
		set: function (v) { this.e_URL = v; }, 
		get: function ( ) { return this.e_URL; }});
	
	
	Object.defineProperty(BasicDataSource.prototype, "performableActions", {
		get: function () {
			var performableActions =  {};
			
			if (this.location === 'remote')
				performableActions['refresh'] = { name: LocalizedString('Reload') };

			return performableActions;
		}});
	
	
BasicDataSource.prototype.simulateAction = function BasicDataSource_simulateAction(actionID) {
		if (actionID === 'refresh' && this.canReload) this.reload();};
	

BasicDataSource.prototype.transformData = function BasicDataSource_transformData(data, transformer) {
	
		

		transformer.demandPlugin('info.appdoo-mac.DataSourceBase');
		transformer.demandPlugin('info.appdoo-mac.NSStringPunycodeAdditions');

		var result = transformer.createObject(data);

		transformer.setStringProperty(result, 'identifier', data.$id);
				
		if (data.location === 'remote' && data.URLRequest && !this.bindingForKey.call(data, 'URLString')) {
			transformer.setStringProperty(result, 'URLString', data.URLRequest.URL);
		}
		else if (data.location === 'local') {
			transformer.setStringProperty(result, 'dataString', data.localData);
		}

		return result;};
	
	
	function keyIsKVCCompliant(key) {
		
		
		
		
		for (var i = 0, c = key.length; i < c; i++) {
			var cc = key.charCodeAt(i);
			if (cc >= 33 && cc <= 63 && cc !== 46) continue; 
			if (cc >= 65 && cc <= 126) continue; 
			if (cc === 32) continue; 

			if (cc >= 196) continue; 

			return false;
		}
		return true;
	}
	
BasicDataSource.prototype.testObjectForKVCCompliance = function BasicDataSource_testObjectForKVCCompliance(obj) {
		if (!obj) return true;
		if (this.context.isOffscreen) return true;
		var incompatibleKey = '';
		for (var key in obj) {
			if (!keyIsKVCCompliant(key)) {
				incompatibleKey = key;
				break;
			}
			if (typeof obj[key] === 'object') {
				incompatibleKey = this.testObjectForKVCCompliance(obj[key]);
				if (incompatibleKey) return incompatibleKey;
			}
		}
		if (incompatibleKey) {
			this.context.nativeProxy.sendMessage('alertWithDetails', JSON.stringify({
				
				message: LocalizedString2('The identifier %1 from %2 may cause problems.', incompatibleKey, this.readableValue),
				details: LocalizedString('Try to use letters and numbers and avoid whitespaces, periods or @-signs.')
			}));
		}
		return incompatibleKey;};
	
	
BasicDataSource.prototype.initPropertiesFromData = function BasicDataSource_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("excludeFromExport")) this.excludeFromExport = data.excludeFromExport;
if (data.hasOwnProperty("URLRequest")) this.URLRequest = data.URLRequest;
if (data.hasOwnProperty("contents")) this.contents = data.contents;
if (data.hasOwnProperty("location")) this.location = data.location;
if (data.hasOwnProperty("localData")) this.localData = data.localData;
if (data.hasOwnProperty("lastCheckWasValid")) this.lastCheckWasValid = data.lastCheckWasValid;
};

BasicDataSource.prototype.decodeData = function BasicDataSource_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
if (data.hasOwnProperty("URLRequest")) decoded.URLRequest = this.context.decodeObjectTree(data.URLRequest);
return decoded; };

BasicDataSource.prototype.encode = function BasicDataSource_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
if (this._URLRequest && this._URLRequest.encode) {encoded.URLRequest = this.URLRequest.encode();
}return encoded; };

BasicDataSource.prototype.encodeCloned = function BasicDataSource_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
if (this._URLRequest && this._URLRequest.encode) {encoded.URLRequest = this.URLRequest.encodeCloned();
}return encoded; };

BasicDataSource.prototype.expectedTypeForProperty = function BasicDataSource_expectedTypeForProperty(key) {
	if (key === "isObservable") return "Boolean";
	if (key === "excludeFromExport") return "Boolean";
	if (key === "positionIsEditable") return "";
	if (key === "sizeIsEditable") return "";
	if (key === "xIsEditable") return "";
	if (key === "yIsEditable") return "";
	if (key === "widthIsEditable") return "";
	if (key === "heightIsEditable") return "";
	if (key === "observers") return "";
	if (key === "firstItemKey") return "";
	if (key === "URLRequest") return "URLRequest";
	if (key === "isLoading") return "";
	if (key === "e_URL") return "";
	if (key === "URLString") return "String";
	if (key === "contents") return "";
	if (key === "rootData") return "";
	if (key === "rootDataKeyPath") return "";
	if (key === "canBeKeyPathFiltered") return "";
	if (key === "itemArray") return "";
	if (key === "providesRootData") return "";
	if (key === "readableType") return "";
	if (key === "canReload") return "";
	if (key === "didLoad") return "";
	if (key === "xmlHttpRequest") return "";
	if (key === "location") return "";
	if (key === "e_location") return "";
	if (key === "localData") return "String";
	if (key === "inspectorProperties") return "";
	if (key === "lastCheckWasValid") return "";
	if (key === "validationResult") return "";
	if (key === "bindableProperties") return "";
	if (key === "URL") return "";
	if (key === "performableActions") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return BasicDataSource; }()));
registerType('info.appdoo-mac', (function () { function DataProvider() {} var __super = setSupertypeFromDomain(DataProvider, 'BasicDataSource', 'appdoo');

	Object.defineProperty(DataProvider.prototype, "object", {
	outlet: true, get:function () { return this._object; }, set:function (v) {if (!Object.hasOwnProperty(this, "_object")) Object.defineProperty(this, "_object", { writable: true, configurable: true }); this._object = v; }});
	
	
	Object.defineProperty(DataProvider.prototype, "objectID", {
	outlet: true, 
	enumerable: true, 
		get: function () { if (this.object) this._objectID = this.object.$id; return this._objectID; }, set:function (v) {if (!Object.hasOwnProperty(this, "_objectID")) Object.defineProperty(this, "_objectID", { writable: true, configurable: true }); this._objectID = v; }});
	

	Object.defineProperty(DataProvider.prototype, "providesRootData", {
		value: true});
	
	
	Object.defineProperty(DataProvider.prototype, "shouldNotPreviewInEditor", {
		value: true});
	

	Object.defineProperty(DataProvider.prototype, "name", {
		get: function () {
			if (this.object)
				return this.object.readableValue;
		}});
	
	
DataProvider.prototype.transformData = function DataProvider_transformData(data, transformer) {

		transformer.demandPlugin('info.appdoo-mac.DataSourceBase');
		transformer.demandPlugin('info.appdoo-mac.NSStringPunycodeAdditions');

		var result = transformer.createObject(data);
		return result;		};
	
	
	Object.defineProperty(DataProvider.prototype, "propertiesForBindings", {
	outlet: true, 
	enumerable: true, get:function () { return this._propertiesForBindings; }, set:function (v) {if (!Object.hasOwnProperty(this, "_propertiesForBindings")) Object.defineProperty(this, "_propertiesForBindings", { writable: true, configurable: true }); this._propertiesForBindings = v; }});
	

	Object.defineProperty(DataProvider.prototype, "contents", {
	synthesized: true, 
		get: function () {
			if (!this._contents) this.contents = {};
			if (!this.object) {
			} else {
				if (Array.isArray(this.propertiesForBindings)) this.propertiesForBindings.every(function (key) {
					this._contents[key] = this.object[key];return true; }, this);
				
			}
			return this._contents;
		}, set:function (v) {if (!Object.hasOwnProperty(this, "_contents")) Object.defineProperty(this, "_contents", { writable: true, configurable: true }); this._contents = v; }});
	

DataProvider.prototype.nameForKeyPath = function DataProvider_nameForKeyPath(keyPath) {
		if (!this.object) return;
		if (keyPath.indexOf('contents.') === 0)
			return this.object.readableNameForProperty(keyPath.substr(9));};
	
	
DataProvider.prototype.addDataProviderToObject = function DataProvider_addDataProviderToObject(object) {
		var uti = this.UTI;
		
		if (!object.dataProvider) {
			object.dataProvider = createComponent(uti, object.context, {
				object: object,
			});
			object.dataProvider.$id = object.identify()+'DataProvider';
			object.context.identify(object.dataProvider);
		}
		else {
			object.dataProvider.object = object;
			object.dataProvider.notifyObservers();
		}
		_context.editor.registerItem(object.dataProvider);
	};
	

DataProvider.prototype.initPropertiesFromData = function DataProvider_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("object")) this.object = data.object;
if (data.hasOwnProperty("objectID")) this.objectID = data.objectID;
if (data.hasOwnProperty("propertiesForBindings")) this.propertiesForBindings = data.propertiesForBindings;
};

DataProvider.prototype.decodeData = function DataProvider_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
if (data.hasOwnProperty("object")) decoded.object = this.context.decodeObjectTree(data.object);
return decoded; };

DataProvider.prototype.encode = function DataProvider_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

DataProvider.prototype.encodeCloned = function DataProvider_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

DataProvider.prototype.expectedTypeForProperty = function DataProvider_expectedTypeForProperty(key) {
	if (key === "object") return "BasicObject";
	if (key === "objectID") return "String";
	if (key === "providesRootData") return "";
	if (key === "shouldNotPreviewInEditor") return "";
	if (key === "name") return "";
	if (key === "propertiesForBindings") return "";
	if (key === "contents") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return DataProvider; }()));
registerType('info.appdoo-mac', (function () { function ControlDataProvider() {} var __super = setSupertypeFromDomain(ControlDataProvider, 'DataProvider', 'info.appdoo-mac');

ControlDataProvider.prototype.transformData = function ControlDataProvider_transformData(data, transformer) {

		var result = __super.prototype.transformData.call(this, data, transformer);

		transformer.setReferenceProperty(result, 'control', data.$id, data.objectID);

		return result;};
	

ControlDataProvider.prototype.addDataProviderToControl = function ControlDataProvider_addDataProviderToControl(control) {
		return this.addDataProviderToObject(control);};
	
	
ControlDataProvider.prototype.notifyObservers = function ControlDataProvider_notifyObservers() {
		if (this.blocker) return;
		this.blocker = true;
		__super.prototype.notifyObservers.call(this);
		setTimeout(function () { this.blocker = false; }.bind(this), 10);};
	

ControlDataProvider.prototype.expectedTypeForProperty = function ControlDataProvider_expectedTypeForProperty(key) {
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return ControlDataProvider; }()));