
registerType('appdoo', (function () { function EditableImageControl() {} var __super = setSupertypeFromDomain(EditableImageControl, 'View', 'Core.UI');

EditableImageControl.prototype.initFromData = function EditableImageControl_initFromData(data) {
	
		if (!__super.prototype.initFromData.call(this, data, null, true))
			return;

		this.acceptsFocus = true;
		this.forceRetina = data.forceRetina;
		this.maxImageSize = {width: 0, height:0};
		
		this.style({ outline: 0 });

		if (data.drawsBackground !== false) {
			this.background = createComponentFromDomain(
				'SmartScalingImage', "Core.UI", this.context, {
				size: data.backgroundSize || this.size,
				position: {left:0,top:0},
				imageSrc: 
					data.backgroundImageSrc ||
					this.context.pathForResource('EditableIcon.png'),
				contentInset: [8,32,8,32],
				contentMode: 'repeat'
			});
			this.addSubview(this.background);
		}

		if (data.showsPlaceholder === true || data.placeholderImageSrc) {
			this.placeholder =  createComponentFromDomain(
				'ImageView', "Core.UI", this.context, {
				size: this.size,
				imageSrc: data.placeholderImageSrc || this.context.pathForResource('IconPlaceholder.png'),
				contentMode: 'scaleAspectFit',
			});
			this.addSubview(this.placeholder);
		}

		this.imageView =  createComponentFromDomain(
			'ImageView', "Core.UI", this.context, {
				size: {
					width: this.size.width-2,
					height: this.size.height-2
				},
				position: { left: 1, top: 1 },
				contentMode: data.contentMode || 'scaleAspectFitNoUpscaling',
				contentScale: 2,
				imageSrc: data.imageSrc,
				drawWithCanvas: this.drawsWithCanvas,
				delegate: this
			});
		this.imageView.style({ borderRadius: '5px' });

		var focusRingWidth = data.focusRingSize || this.size.width+4,
			focusRingHeight = data.focusRingSize || this.size.height+4,
			focusRingOffsetX = (this.size.width-focusRingWidth)/2,
			focusRingOffsetY = (this.size.height-focusRingHeight)/2;
		

		this.focusRing = createComponentFromDomain(
			'SmartScalingImage', "Core.UI", this.context, {
			size: { width: focusRingWidth, height: focusRingHeight },
			position: { left: focusRingOffsetX, top: focusRingOffsetY },
			imageSrc: data.focusRing || this.context.pathForResource('IconFocusRing.png'),
			style: {
				visibility: 'hidden',
				pointerEvents: 'none'
			},
			contentInset: data.focusRingContentInset || [10,32,10,32],
		});


		this.addSubview(this.imageView);
		this.addSubview(this.focusRing);
		
		this.applyBindings(true);

		
		this.DOMNode.addEventListener('focus', function (e) {
			this.focusRing.style({ visibility: '' });
			this.updatePlaceholder();
		}.bind(this));
		
		this.DOMNode.addEventListener('blur', function (e) {
			this.focusRing.style({ visibility: 'hidden' });
			this.updatePlaceholder();
		}.bind(this));

		this.DOMNode.addEventListener('contextmenu', function (e) {
			if (!this.imageRef) return;

			var menu = createComponentFromDomain("Menu", "Core.UI", this.context, {
				items: []})
			;
			if (this.canCopy()) {
				menu.items.push(createComponentFromDomain('MenuItem', 'Core.UI', this.context, {
					title: LocalizedString("Copy"),
					target: this,
					targetMethod: 'copy'
				}));
			}
			if (this.canPaste()) {
				menu.items.push(createComponentFromDomain('MenuItem', 'Core.UI', this.context, {
					title: LocalizedString("Paste"),
					target: this,
					targetMethod: 'paste'
				}));
			}

			if (this.canDelete()) {
				menu.items.push(createComponentFromDomain('MenuItem', 'Core.UI', this.context, {
					title: LocalizedString("Delete"),
					target: this,
					targetMethod: 'deleteSelection'
				}));
			}
			
			if (this.imageRef.fileReferenceID) {
				var ref = _context.projectContext.fileReferenceWithID(this.imageRef.fileReferenceID);
				if (ref) {
					menu.items.unshift(createComponentFromDomain('MenuItem', 'Core.UI', this.context, {
						title: LocalizedString("Show File Info"),
						action: function () {
							_context.loadEditor(function (editor) {
								alertd(editor);
								if (!_context.editorIsVisible())
									_context.showEditor();
								
								editor.selectSingleObject_withDelay_(ref, 1);
							});
						}.bind(this)
					}), createComponentFromDomain('MenuItem', 'Core.UI', this.context, { separator: true }));
					
					ref.addFileItemsToMenu(menu);
				}
			}

			menu.x = e.x; menu.y = e.y;
			this.context.showContextMenu(menu);
			
		}.bind(this));
		
		this.DOMNode.onkeydown = this.keyDownEventHandler.bind(this);
		
		this.prepareForDragAndDrop();
		
		if (data.fileTypesForImport) {
			this.fileTypesForImport = data.fileTypesForImport;
		}
		this.incompatibilityWarning = data.incompatibilityWarning;
		this.wantsRetinaImage = data.wantsRetinaImage;
		
		data = null;
		return this;
		};
	
	
EditableImageControl.prototype.updatePlaceholder = function EditableImageControl__updatePlaceholder() {
		if (!this.placeholder) return;

		if (document.activeElement === this.DOMNode) {
			this.placeholder.hidden = true;
		}
		else {
			this.placeholder.hidden = !!this.imageSrc;
		}};
	
	
EditableImageControl.prototype.prepareForDragAndDrop = function EditableImageControl__prepareForDragAndDrop() {
	
		this.dropHandler = {
		
			dropEffectForEvent: function (e) {
				if (e.dataTransfer) {


                    if (e.dataTransfer.types.indexOf('public.file-url') !== -1) {
                        return 'copy';
                    }
					if (e.dataTransfer.files.length)
						return 'copy';
					if (e.dataTransfer.types.indexOf(this.context.resourceReferenceDataType) !== -1)
						return 'copy';
				}
				return 'none';
			}.bind(this),
			
			didDropWithEvent: function (e) {
				
				if (!this.context.nativeProxy) return;

				if (e.dataTransfer.types.indexOf(this.context.resourceReferenceDataType) !== -1) {
					var ref = _context.projectContext.fileReferenceWithID(e.dataTransfer.getData(this.context.resourceReferenceDataType));
					if (ref) {
						
						
						if(this.maxImageSize !== undefined && (this.maxImageSize.width > 0 || this.maxImageSize.width > 0)) {
							if(ref.imageSize !== undefined && ref.imageSize.width !== undefined && ref.imageSize.height !== undefined) {
								if(ref.imageSize.width > this.maxImageSize.width || ref.imageSize.height > this.maxImageSize.height) {
									this.context.nativeProxy.sendMessage('alertWithDetails', JSON.stringify({
										message: LocalizedString('The image size of the file you selected is not supported at this location.'),
										details: LocalizedString('Tab bar icons have to be PNG images with a maximum size of 60 × 60 pixels.')
									}));
									return;
								}
							}
						}
						
						if (this.fileTypesForImport.indexOf(ref.contentType) === -1) {
							this.context.showIncompatibilityErrorForFile({}, false, this.fileTypesForImport, this.incompatibilityWarning);
						}
						else {
							this.changeImageID(ref.resourceID, ref);
							if (this.wantsRetinaImage)
								ref.addRetinaSuffixToName();
						}
					}
				}
				else if (e.dataTransfer.files.length) {
					var file = e.dataTransfer.files[0];
					var contentType = file.type;
					
					if (!this.compatibilityCheck(file)) {
						e.preventDefault();
						return;
					}

					
					if (!file.path) file.path = this.context.nativeProxy.sendMessage('pathForDraggedFileWithName', file.name);
				
					
					var reader = new FileReader();
					reader.onload = function(e) {
						var options = undefined;
						if(this.maxImageSize !== undefined && (this.maxImageSize.width > 0 || this.maxImageSize.width > 0)) {
							options = {maxImageSize: this.maxImageSize};
						}
						var imageID = this.context.nativeProxy.sendMessage('importImageFromData', e.target.result, contentType, JSON.stringify(options));
						
						this.handleFileImportWithImageID(file, imageID);

					}.bind(this);
					reader.readAsBinaryString(file);
				}
				e.preventDefault();
				
			}.bind(this)
			
		};};
	
	
EditableImageControl.prototype.handleFileImportWithImageID = function EditableImageControl__handleFileImportWithImageID(file, imageID) {

		if (!imageID) {
			alert(LocalizedString('The image could not be read.'));
			return;
		}
		if(imageID == "exceedsMaxImageSize") {
			this.context.showIncompatibilityErrorForImageSize(this.incompatibilityWarning);
			return;
		}
		
		var result = _context.shouldSyncFile(file.name, file.path);
		
		if (result === 2) return; 
		
		if (result === true) { 
			var ref;
			if (_context.editor) {
				ref = _context.editor.addResourceReference(imageID, file.name, file.type, undefined, file.path);
			} else {
				
				ref = _context.addResourceReference(imageID, file.name, file.type, undefined, file.path);
			}
			console.log("ref: "+ref.constructor.name);
			console.log("ref.UTI: "+ref.UTI);
			console.log("ref.imageSize: "+ref.imageSize);
			
			
			if(this.maxImageSize !== undefined && (this.maxImageSize.width > 0 || this.maxImageSize.width > 0)) {
				if(ref.imageSize !== undefined && ref.imageSize.width !== undefined && ref.imageSize.height !== undefined) {
					if(ref.imageSize.width > this.maxImageSize.width || ref.imageSize.height > this.maxImageSize.height) {
						this.context.nativeProxy.sendMessage('alertWithDetails', JSON.stringify({
							message: LocalizedString('The image size of the file you selected is not supported at this location.'),
							details: LocalizedString('Tab bar icons have to be PNG images with a maximum size of 60 × 60 pixels.')
						}));
						return;
					}
				}
			}
			
			if (_context.editor) {
				_context.editor.addUndoStepForInsertOperation(ref);
			} else {
				_context.projectContext.fileReferences.push(ref);
			}
			if (this.wantsRetinaImage) {
				ref.addRetinaSuffixToName();
			}
			this.changeImageID(imageID, ref);
		}
		else {
			
			var tempImageSrc = this.context.pathForImageWithID(imageID);
			var imageSize = JSON.parse(this.context.nativeProxy.sendMessage('getImageSize', tempImageSrc));
			if(this.maxImageSize !== undefined && (this.maxImageSize.width > 0 || this.maxImageSize.width > 0)) {
				if(imageSize !== undefined && imageSize.width !== undefined && imageSize.height !== undefined) {
					if(imageSize.width > this.maxImageSize.width || imageSize.height > this.maxImageSize.height) {
						this.context.nativeProxy.sendMessage('alertWithDetails', JSON.stringify({
							message: LocalizedString('The image size of the file you selected is not supported at this location.'),
							details: LocalizedString('Tab bar icons have to be PNG images with a maximum size of 60 × 60 pixels.')
						}));
						return;
					}
				}
			}
			this.changeImageID(imageID);
		}
		};
	
	
EditableImageControl.prototype.compatibilityCheck = function EditableImageControl__compatibilityCheck(file) {
		
		if (this.fileTypesForImport.indexOf(file.type) === -1) {
			setTimeout(function () {
				
				this.context.showIncompatibilityErrorForFile(file, false, this.fileTypesForImport, this.incompatibilityWarning);
			}.bind(this));
			return false;
		}				
		return true;};
	

	Object.defineProperty(EditableImageControl.prototype, "fileTypesForImport", {
	synthesized: true, 
		get: function () {
			if (this._fileTypesForImport === undefined)
				this.fileTypesForImport = _context.supportedImageMimeTypes;
			return this._fileTypesForImport;
		}, set:function (v) {if (!Object.hasOwnProperty(this, "_fileTypesForImport")) Object.defineProperty(this, "_fileTypesForImport", { writable: true, configurable: true }); this._fileTypesForImport = v; }});
	
	
EditableImageControl.prototype.loadFromFile = function EditableImageControl_loadFromFile() {

		var fileInfo = this.context.fileInfoByDialog();
		if (!fileInfo) {
			return;
		}
		if (!this.compatibilityCheck(fileInfo)) {
			return;
		}
		var imageID = this.context.nativeProxy.sendMessage('importImageFromPath', fileInfo.path);

		this.handleFileImportWithImageID(fileInfo, imageID);};
	

	

EditableImageControl.prototype.canCopy = function EditableImageControl_canCopy() {
		return !!this.imageSrc;};
	

EditableImageControl.prototype.canPaste = function EditableImageControl_canPaste() {
		return this.context.nativeProxy.sendMessage('pasteboardContainsImage');};
	

EditableImageControl.prototype.canCut = function EditableImageControl_canCut() {
		return true;};
	
	
EditableImageControl.prototype.copy = function EditableImageControl_copy(e) {
		return this.context.nativeProxy.sendMessage('copyFileAsImage', this.imageSrc);};
	

EditableImageControl.prototype.paste = function EditableImageControl_paste(e) {

		var imageID = this.context.nativeProxy.sendMessage('savePasteboardImageAsFile');
		if (!imageID) {
			return false;
		}
		
		var tempImageSrc = this.context.pathForImageWithID(imageID);
		var imageSize = JSON.parse(this.context.nativeProxy.sendMessage('getImageSize', tempImageSrc));
		if(this.maxImageSize !== undefined && (this.maxImageSize.width > 0 || this.maxImageSize.width > 0)) {
			if(imageSize !== undefined && imageSize.width !== undefined && imageSize.height !== undefined) {
				if(imageSize.width > this.maxImageSize.width || imageSize.height > this.maxImageSize.height) {
					this.context.nativeProxy.sendMessage('alertWithDetails', JSON.stringify({
						message: LocalizedString('The image size of the file you selected is not supported at this location.'),
						details: LocalizedString('Tab bar icons have to be PNG images with a maximum size of 60 × 60 pixels.')
					}));
					return;
				}
			}
		}

		return this.changeImageID(imageID);
};
	
	
EditableImageControl.prototype.cut = function EditableImageControl_cut(e) {
		this.copy(e);
		this.changeImageID('');
		return true;};
	
	
	
	
	
EditableImageControl.prototype.keyDownEventHandler = function EditableImageControl__keyDownEventHandler(e) {
		if (e.keyCode === 8 || e.keyCode === 46) {
			this.deleteSelection();
			e.preventDefault();
		}};
	
	
	
	
	
EditableImageControl.prototype.deleteSelection = function EditableImageControl__deleteSelection() {
		this.changeImageID('');};
	
	
EditableImageControl.prototype.canDelete = function EditableImageControl_canDelete() {
		return (this.imageRef && this.imageRef.imageID) ? true : false;};
	

EditableImageControl.prototype.changeImageID = function EditableImageControl__changeImageID(v, fileRef) {

		this.context.broadcastValueChangeAnnouncementForKeyPathInObject('imageRef', this, this);
		this.imageRef = this.context.decodeObjectTree(this.imageRef.encode());
		this.imageRef.imageID = v;
		this.imageRef.fileReferenceID = fileRef ? fileRef.$id : null;
		this.imageSrc = this.context.pathForImageWithID(this.imageRef.imageID);
		this.context.broadcastValueChangeForKeyPathInObject('imageRef', this, this);
		};
	


	















EditableImageControl.prototype.valueShouldChangeForKeyPath = function EditableImageControl_valueShouldChangeForKeyPath(value, keyPath) {

		if (keyPath === 'imageSrc' || keyPath === 'imageRef') {

			if (value === undefined) {
				this[keyPath] = null;
				return true;
			}

			
			
			if (Array.isArray(value)) {
				if (valuesAreEqual(value)) {
					if (value[0] === undefined || value[0] === '') this[keyPath] = this.undefinedValue;
					else this[keyPath] = value[0];
				}
				else {
					this[keyPath] = null;
				}
			}
			else this[keyPath] = value;
			
			return true;
		}
		
		if (keyPath === 'disabled') {
			this[keyPath] = value;
			return true;
		}
		
		return false;
};
	
	
EditableImageControl.prototype.get = function EditableImageControl_get(keyPath) {
	
		if (keyPath === 'imageRef') return this.imageRef;
		if (keyPath === 'imageSrc') return this.value;
	};
	
	

	

EditableImageControl.prototype.styleForDisabled = function EditableImageControl__styleForDisabled(v) {
		__super.prototype.styleForDisabled.call(this, v);};
	
	
	
	
	
	Object.defineProperty(EditableImageControl.prototype, "imageSrc", {
		get: function () {
			return this.imageView.imageSrc;
		}, 
		set: function (v) {
			this.imageView.imageSrc = v;
			this.updatePlaceholder();
		}});
	

	Object.defineProperty(EditableImageControl.prototype, "imageRef", {
	synthesized: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_imageRef")) Object.defineProperty(this, "_imageRef", { writable: true, configurable: true });
			if (!v)
				this._imageRef = null;
			else if (v.UTI === 'appdoo.ImageReference')
				this._imageRef = v;
			else {
				this._imageRef = createComponentFromDomain("ImageReference", "appdoo", this.context, {})
				;
				for (var key in v) {
					this._imageRef[key] = v[key];
				}
			}
			if (v) this.imageSrc = this.context.pathForImageWithID(v.imageID);
		}, 
		get: function () {
			if (!this._imageRef) {
				var imageRef = createComponentFromDomain("ImageReference", "appdoo", this.context, {})
				;
				Object.defineProperty(this, "_imageRef", {
					configurable: true, 
					value: imageRef});
				
			}
			return this._imageRef;
		}});
	
	
	Object.defineProperty(EditableImageControl.prototype, "maxImageSize", {
	synthesized: true, get:function () { return this._maxImageSize; }, set:function (v) {if (!Object.hasOwnProperty(this, "_maxImageSize")) Object.defineProperty(this, "_maxImageSize", { writable: true, configurable: true }); this._maxImageSize = v; }});
	

EditableImageControl.prototype.imageViewDidLoadImage = function EditableImageControl_imageViewDidLoadImage(imageView, img) {};
	

	
	
	Object.defineProperty(EditableImageControl.prototype, "drawsWithCanvas", {
		value: false});
	

EditableImageControl.prototype.expectedTypeForProperty = function EditableImageControl_expectedTypeForProperty(key) {
	if (key === "fileTypesForImport") return "";
	if (key === "imageSrc") return "";
	if (key === "imageRef") return "ImageReference";
	if (key === "maxImageSize") return "";
	if (key === "drawsWithCanvas") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return EditableImageControl; }()));
registerType('appdoo', (function () { function AppIconControl() {} var __super = setSupertypeFromDomain(AppIconControl, 'EditableImageControl', 'appdoo');

	Object.defineProperty(AppIconControl.prototype, "drawsWithCanvas", {
		value: true});
	
	
AppIconControl.prototype.imageViewDidLoadImage = function AppIconControl_imageViewDidLoadImage(imageView, img) {

		var canvas = imageView._canvas;
		var ctx = canvas.getContext('2d');
		var imageData = ctx.getImageData(0, 0, canvas.width, canvas.height);
		var newCanvas = document.createElement('canvas');
		newCanvas.width = canvas.width; newCanvas.height = canvas.height;
		newCanvas.getContext('2d').putImageData(imageData,0,0);
		canvas.style.visibility = 'hidden';

		this.context.whenImageIsReady(this.context.pathForOptimizedImage('Resources/AppIconMaskIOS7.png'), function (maskImage) {
			ctx.clearRect(0,0,120,120);
			ctx.drawImage(maskImage, 0, 0);
			ctx.globalCompositeOperation = 'source-atop';
			ctx.drawImage(newCanvas, 0, 0); 
			canvas.style.visibility = '';
		});
};
	

AppIconControl.prototype.expectedTypeForProperty = function AppIconControl_expectedTypeForProperty(key) {
	if (key === "drawsWithCanvas") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return AppIconControl; }()));