
registerType('appdoo.Editor', (function () { function BoundPropertyButton() {} var __super = setSupertypeFromDomain(BoundPropertyButton, 'Button', 'Core.UI');

BoundPropertyButton.prototype.initFromData = function BoundPropertyButton_initFromData(data) {
	
		if (data.text === '^NULL^')
			data.text = LocalizedString('(No Selection)');

		if (!__super.prototype.initFromData.call(this, data))
			return null;
		
		this.style({
			borderRadius: '12px',
			display: 'inline-block',
			width: 'auto',
			height: 'auto'
		});
		this.styleButton();
		
		this.labelContainer.style({
			display: 'inline',
			position: ''
		});

		this.label.style({
			width: 'auto',
			paddingLeft: '21px',
			paddingRight: '8px',
			fontSize: '11px',
		});
		
		this.icon = createComponentFromDomain("ImageView", "Core.UI", this.context, {
			size: { width: 18, height: 18 },
			position: {top:0,left:2},
			imageSrc: 'Resources/BoundIcon.png',})
		;
		this.addSubview(this.icon);
		
		this.DOMNode.addEventListener('mouseover', this.styleButtonOver.bind(this));
		this.DOMNode.addEventListener('mouseout', this.styleButtonOut.bind(this));
		
		return this;
};
	
	
BoundPropertyButton.prototype.destroy = function BoundPropertyButton_destroy() {
		this.DOMNode.onmouseover = null;
		this.DOMNode.onmousemouseout = null;
		__super.prototype.destroy.call(this);};
	

BoundPropertyButton.prototype.styleButton = function BoundPropertyButton__styleButton() {

		if (window.hasFocus === false) {
			this.style({
				backgroundColor: 'hsl(0,0%,93%)',
				border: '1px solid hsl(0,0%,82%)',
				borderTopColor: 'hsl(0,0%,85%)',
				backgroundImage: 'none',
				color: '#444'
				
			});
			if (this.icon) this.icon.imageSrc = 'Resources/BoundIconGrey.png';
			return;
		}
		
		if (this.icon) this.icon.imageSrc = 'Resources/BoundIcon.png';
		
		if (this._highlighted === true) {
			this.style({
				border: '1px solid hsl(258,56%,79%)',
				backgroundImage: '-webkit-linear-gradient(hsl(259,70%,91%), hsl(255,60%,91%))',
				boxShadow: 'inset 0 1px 1px rgba(0,0,0,.0)'
			});
		}
		else if (this.mouseIsOver === true) {
			this.style({
				border: '1px solid hsl(258,56%,82%)',
				borderTopColor: 'hsl(259,69%,85%)',
				backgroundImage: '-webkit-linear-gradient(hsl(259,70%,95%), hsl(255,60%,92%))',
				color: 'hsl(257,37%,33%)',
				boxShadow:'inset 0 1px 1px rgba(255,255,255,.1)',
			});
		}
		else {
			this.style({
				border: '1px solid hsl(258,56%,84%)',
				borderTopColor: 'hsl(259,69%,87%)',
				backgroundImage: '-webkit-linear-gradient(hsl(259,70%,96%), hsl(255,60%,94%))',
				color: 'hsl(257,37%,35%)',
				boxShadow:'inset 0 1px 1px rgba(255,255,255,.5)',
			});
		}
	};
	
	
BoundPropertyButton.prototype.styleButtonOver = function BoundPropertyButton__styleButtonOver() {
		this.mouseIsOver = true;
		this.styleButton();};
	

BoundPropertyButton.prototype.styleButtonOut = function BoundPropertyButton__styleButtonOut() {
		this.mouseIsOver = false;
		this.styleButton();};
	
	
BoundPropertyButton.prototype.expectedTypeForProperty = function BoundPropertyButton_expectedTypeForProperty(key) {
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return BoundPropertyButton; }()));