
registerType('appdoo.Editor', (function () { function ComponentContainerView() {} var __super = setSupertypeFromDomain(ComponentContainerView, 'View', 'Core.UI');

ComponentContainerView.prototype.initFromData = function ComponentContainerView_initFromData(data) {
		if (!__super.prototype.initFromData.call(this, data))
			return null;
			
		this.contentType = data.contentType;
		this.contentOptions = data.contentOptions;
		this.value = data.value;
		this.DOMNode.onmousedown = function () {
		
			
			this.context.nativeProxy.sendMessage('forceCursorUpdate', 'closedHandCursor');
			window.onmousemove = function (e) {
				setTimeout(function () {
					this.context.nativeProxy.sendMessage('forceCursorUpdate', 'closedHandCursor');
					}.bind(this), 1);
			}.bind(this);
			window.onmouseup = function () {
				document.body.style.cursor = 'default';
				window.onmousemove = null;
			};
			
		}.bind(this);

		this.DOMNode.className = 'canMove';
		
		return this;};
	
	
	Object.defineProperty(ComponentContainerView.prototype, "descriptionLabel", {
	synthesized: true, 
		get: function () {

			if (!this._descriptionLabel) {
				this.descriptionLabel = createComponentFromDomain("Label", "Core.UI", this.context, {
					size: { width: 145, height: 60 },
					position: { left: 71, top: 21 },
					style: { fontSize: '12px', _fontWeight: 'bold' },
					fontSize: 12,
					numberOfLines: 0,
					layoutMode: 'multiLine'})
				;
				this.addSubview(this._descriptionLabel);
			}
			
			return this._descriptionLabel;
		
		}
	, set:function (v) {if (!Object.hasOwnProperty(this, "_descriptionLabel")) Object.defineProperty(this, "_descriptionLabel", { writable: true, configurable: true }); this._descriptionLabel = v; }});
	

	Object.defineProperty(ComponentContainerView.prototype, "contentType", {
	synthesized: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_contentType")) Object.defineProperty(this, "_contentType", { writable: true, configurable: true });
			switch (v) {

			case 'component':
				break;

			case 'appdoo.iOS.UILabel':
				this.contentView = createComponentFromDomain("UILabel", "appdoo.iOS", this.context, {
					size: { width: this.size.width, height: 22 },
					autoresizingMask: 2,
					fontFamily: 'System',
					fontName: '_DEFAULT_',
					style: {
						webkitFontSmoothing: 'antialiased'
					}})
				;
				break;


			case 'appdoo.iOS.UIImageViewWithURL':
				this.contentView = createComponent(v, this.context, {
					size: { width: this.size.width, height: this.size.height },
					contentMode: 'scaleAspectFit',
					resourceContext: this.context.projectContext
				});
				
				var dv = this;
				
				this.listen(this.contentView, 'load', function (e) {

					var w = this.image.width / 2,
						h = this.image.height / 2;
						
					if (w > this.size.width)
						w = this.size.width;
						
					this.size.width = w;
					dv.size.width = w;
					dv = null;
				});
				
				break;

			case 'info.appdoo-mac.Hyperlink':
				this.contentView = createComponentFromDomain("Hyperlink", "info.appdoo-mac", this.context, {
					size: { width: this.size.width, height: 20 },
					style: {
						webkitFontSmoothing: 'antialiased'
					}})
				;
				break;

			case 'color':
				this.contentView = createComponentFromDomain("View", "Core.UI", this.context, {
					size: { width: 16, height: 16 },
					style: {
						border: '1px solid var(--editor-separator-color)'
					}})
				;
				this.style({ border: '1px solid var(--editor-separator-color)' });

				break;

			case 'appdoo.iOS.ASSimpleHTMLView':
				this.contentView = createComponentFromDomain("ASSimpleHTMLView", "appdoo.iOS", this.context, {
					size: { width: this.size.width, height: 100 },
					autoresizingMask: 18,
					fontFamily: 'System',
					fontName: '_DEFAULT_',
					style: {
						webkitFontSmoothing: 'antialiased'
					},
					fontSize: 15,
					margin: 15})
				;
				this.style({ border: '1px solid var(--editor-separator-color)' });
				break;

			}
			
			this._contentType = v;

			if (this.contentView) {
				this.addSubview(this.contentView);
			}
		}, get:function () { return this._contentType; }});
	
	
	Object.defineProperty(ComponentContainerView.prototype, "contentOptions", {
	synthesized: true, 
		set: function (obj) {if (!Object.hasOwnProperty(this, "_contentOptions")) Object.defineProperty(this, "_contentOptions", { writable: true, configurable: true });
			if (!this.contentView) return;
			for (key in obj) {
				if (key === 'size') {
					for (sizeKey in obj[key]) {
						this.contentView.size[sizeKey] = obj[key][sizeKey];
					}
					continue;
				}
				this.contentView[key] = obj[key];
			}
			this._contentOptions = obj;
		}, get:function () { return this._contentOptions; }});
	

	Object.defineProperty(ComponentContainerView.prototype, "value", {
	synthesized: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_value")) Object.defineProperty(this, "_value", { writable: true, configurable: true });

			switch (this.contentType) {

			case 'component':
				this.contentView = this.context.decodeObjectTree(v.preview || v.component);
				this.addSubview(this.contentView);
				break;

			case 'appdoo.iOS.UILabel':
				this.contentView.text = v;
				break;

			case 'appdoo.iOS.UIImageViewWithURL':
				this.contentView.imageURLString = v;
				break;

			case 'info.appdoo-mac.Hyperlink':
				this.contentView.text = v;
				this.contentView.URLString = v;
				break;

			case 'color':
				this.contentView.style({ backgroundColor: v });
				break;

			case 'appdoo.iOS.ASSimpleHTMLView':
				this.contentView.content = v;
				break;

			}
			this._value = v;
		}, get:function () { return this._value; }});
	
	
ComponentContainerView.prototype.expectedTypeForProperty = function ComponentContainerView_expectedTypeForProperty(key) {
	if (key === "descriptionLabel") return "";
	if (key === "contentType") return "";
	if (key === "contentOptions") return "";
	if (key === "value") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return ComponentContainerView; }()));