
registerType('appdoo.Editor', (function () { function DeviceBorderView() {} var __super = setSupertypeFromDomain(DeviceBorderView, 'View', 'Core.UI');

DeviceBorderView.prototype.layout = function DeviceBorderView_layout() {

		
		
		
		
		
		
		
        
        
        










		};
    

DeviceBorderView.prototype.expectedTypeForProperty = function DeviceBorderView_expectedTypeForProperty(key) {
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return DeviceBorderView; }()));
registerType('appdoo.Editor', (function () { function ContentFrameController() {} var __super = setSupertypeFromDomain(ContentFrameController, 'ViewController', 'Core.UI');

	var useSmoothZooming = 0;

	Object.defineProperty(ContentFrameController.prototype, "contentWrapper", {
	outlet: true, get:function () { return this._contentWrapper; }, set:function (v) {if (!Object.hasOwnProperty(this, "_contentWrapper")) Object.defineProperty(this, "_contentWrapper", { writable: true, configurable: true }); this._contentWrapper = v; }});
	

	Object.defineProperty(ContentFrameController.prototype, "delegate", {
	outlet: true, get:function () { return this._delegate; }, set:function (v) {if (!Object.hasOwnProperty(this, "_delegate")) Object.defineProperty(this, "_delegate", { writable: true, configurable: true }); this._delegate = v; }});
	

	Object.defineProperty(ContentFrameController.prototype, "editor", {
	outlet: true, get:function () { return this._editor; }, set:function (v) {if (!Object.hasOwnProperty(this, "_editor")) Object.defineProperty(this, "_editor", { writable: true, configurable: true }); this._editor = v; }});
	

	Object.defineProperty(ContentFrameController.prototype, "deviceBorderView", {
	outlet: true, get:function () { return this._deviceBorderView; }, set:function (v) {if (!Object.hasOwnProperty(this, "_deviceBorderView")) Object.defineProperty(this, "_deviceBorderView", { writable: true, configurable: true }); this._deviceBorderView = v; }});
	

// role BasicObject (Core) 

ContentFrameController.prototype.init = function ContentFrameController_init() {
		
			__super.prototype.init.call(this);
			
			document.body.tabIndex = 0;

			return this;};
		
	
	
	
	Object.defineProperty(ContentFrameController.prototype, "simulatedWindow", {
		get: function () { return this.containerView; }});
	
	
ContentFrameController.prototype.createSubviews = function ContentFrameController__createSubviews() {
	
		var size = { width: 250, height: 250 };
		var contentViewSize = clone(size);

		this.containerView = createComponentFromDomain("UIWindow", "appdoo.iOS", this.context, {
					style: {
						backgroundColor: '#000',
						boxShadow: !this.context.isOffscreen ? '0 3px 6px rgba(0,0,0,.28)' : '',
						webkitTransition: useSmoothZooming ? '-webkit-transform 0.2s ease-in-out':''
					},
					size: size,
					$id: 'containerView'})
				;
		this.containerView.DOMNode.className = 'forceHiddenScrollbars';
	
		this.contentView = createComponentFromDomain("View", "Core.UI", this.context, {
					style: {
						overflow: 'hidden'
					},
					size: contentViewSize,
					$id: 'contentView'})
				;
				
		this.overlayView = createComponentFromDomain("View", "Core.UI", this.context, {
					style: {
						pointerEvents: 'none',
						zIndex: '1001'
					},
					size: { width: 0, height: 0 },
					autoresizingMask: 18,
					$id: 'overlayView'})
				;

		this.deviceBorderView = createComponentFromDomain("DeviceBorderView", "appdoo.Editor", this.context, {
					style: {
						pointerEvents: 'none'
					},
					size: { width: 0, height: 0 },})
				;
	
		this.containerView.addSubview(this.contentView);
	
		this.contentWrapper.removeAllSubviews();
        this.contentWrapper.addSubview(this.deviceBorderView);
		this.contentWrapper.addSubview(this.containerView);
		this.contentWrapper.addSubview(this.overlayView);
};
	
	
	Object.defineProperty(ContentFrameController.prototype, "hasDarkBackground", {
	synthesized: true, get:function () { return this._hasDarkBackground; }, set:function (v) {if (!Object.hasOwnProperty(this, "_hasDarkBackground")) Object.defineProperty(this, "_hasDarkBackground", { writable: true, configurable: true }); this._hasDarkBackground = v; }});
	
	
ContentFrameController.prototype.toggleBackgroundStyle = function ContentFrameController_toggleBackgroundStyle() {
        this.hasDarkBackground = false; 
		this.updateBackground();};
	

ContentFrameController.prototype.toggleBackgroundStyleDark = function ContentFrameController_toggleBackgroundStyleDark() {
		if (!this.hasDarkBackground)
			this.toggleBackgroundStyle();};
	
	
ContentFrameController.prototype.updateBackground = function ContentFrameController__updateBackground() {

		if (!this.context.isOffscreen) {
			
			var shouldHaveDarkBackground = this.hasDarkBackground;
		
			var imageName, brightImageName, darkImageName, backgroundSize;

			if (this.simulatedSystemVersion < 7) {
				brightImageName = "Background10.png";
				darkImageName = "Background4-dark.png"
				backgroundSize = '200px 200px';
			}
			else {
				brightImageName = '';
				darkImageName = "";
				backgroundSize = '';
			}

			imageName = shouldHaveDarkBackground ? darkImageName : brightImageName;
			
			this.editor.rightSplitView.style({"backgroundImage" : "url(Resources/Background10.png)", "backgroundSize":""});
			this.view.superview.style({"backgroundImage" : "url(Resources/"+imageName+")", "backgroundSize":backgroundSize, backgroundColor: shouldHaveDarkBackground?'#262626':'#e5e5e5'});
			
		}

	};
	
	

ContentFrameController.prototype.resetContentViewSizeForScene = function ContentFrameController_resetContentViewSizeForScene(scene) {
		if(scene.simulatedWindowSize === undefined) {
			return;
		}
		var size = scene.simulatedWindowSize;
		
		if (this.isSimulating3_5InchDisplay) {
			if (this.interfaceOrientation === kInterfaceOrientationLandscape)
				size.width -= 88;
			else
				size.height -= 88;
		}

		var contentViewSize = clone(size);
		
		this.containerView.size = size;
		this.contentView.size = contentViewSize;

		if (!this.context.isOffscreen) {
			if (this._contentScale === undefined) {
				if (size.width >= 768) {
					this.contentScale = 0.5;
				}
				else if(size.height > this.view.size.height) {
					this.contentScale = 0.67;
				} else {
					this.contentScale = 1.0;
				}
			}
			else {
				this.contentScale = this.contentScale;
			}
		}
		
};
	

// role EditorViewProvider 


ContentFrameController.prototype.editorDidLoadScene = function ContentFrameController_editorDidLoadScene(scene) {
		
			if (this._interfaceOrientation !== undefined) {
				scene.simulatedInterfaceOrientation = scene.simulatedInterfaceOrientation;
				_context.sceneDidChangeSize(scene);
			}
			else this._interfaceOrientation = this.interfaceOrientation;

			this.createSubviews();

			if (this.context.projectContext.simulatedSystemVersion >= 7)
				this.showStatusBar(scene);

			this.updateBackground();
			this.resetContentViewSizeForScene(scene);

			if (this.shouldShowTabBarForScene(scene)) {
				this.showTabBar();
				this.updateTabBar();
			}

			if (this.shouldShowNavigationBarForScene(scene)) {
				this.showNavigationBar();
			}
		
			
			var vc = scene.viewController;
		
			vc.view.position.top = 0;
			vc.view.size = this.contentView.size;
			vc.view.autoresizingMask = 18;
			this.contentView.insertSubviewAtIndex(vc.view, 0);
			vc.view.viewDidLoad();

			needsWindowLayoutLocked = false;
			this.needsWindowLayout();
			
			this.addButtons();
};
		
		
ContentFrameController.prototype.shouldShowTabBarForScene = function ContentFrameController__shouldShowTabBarForScene(scene) {
			if (!scene.showsTabBar) return false;
			return this.context.projectContext.tabBarController.numberOfItems > 0;};
		

ContentFrameController.prototype.shouldShowNavigationBarForScene = function ContentFrameController__shouldShowNavigationBarForScene(scene) {
			if (!scene.navigationBar) return false;
			if (scene.navigationBar.hidden) return false;
			return true;};
		
		
ContentFrameController.prototype.addDummyPatch = function ContentFrameController__addDummyPatch() {
			var patch = createComponentFromDomain("View", "Core.UI", this.context, {
				size: { width: 165, height: 140 },
				position: { left: -190, top: 80 },
				style: {
					backgroundColor: '#f3f3f3',
					backgroundImage: '-webkit-linear-gradient(#fff 0%,#eee 10%)',
					borderRadius: '5px',
					border: '1px solid #bbb',
					borderTopColor: '#ccc',
					borderBottomColor: '#aaa',
					boxShadow: '0 2px 5px rgba(0,0,0,.1)'
				}})
			;
			var c = createComponentFromDomain("Label", "Core.UI", this.context, {
				text: 'Kalender',
				size: { width: 165 },
				position: { top: 4 },
				style: { textAlign: 'center', fontSize: '12px', fontWeight: '500', color: '#000', textShadow: '0 1px 0 rgba(255,255,255,.4)' }})
			;
			patch.addSubview(c);
			var zzL = createComponentFromDomain("Label", "Core.UI", this.context, {
				text: 'Zeitzone',
				size: { width: 60 },
				position: { top: 29+86+5 },
				style: { textAlign: 'right', fontSize: '11px', fontWeight: '500', color: '#000', textShadow: '0 1px 0 rgba(255,255,255,.4)' }})
			;
			patch.addSubview(zzL);
			var p = createComponentFromDomain("PopUpButton", "Core.UI", this.context, {
				size: { width: 92+3 },
				position: { top: 25+86+5, left: 65 },
				items: ['Paris','London'],
				style: { font:'11px "Helvetica Neue"', webkitAppearance:'none', borderRadius: '4px', padding:'2px 4px', border: '1px solid #bbb', backgroundImage: '-webkit-linear-gradient(#fff,#eee)', borderTopColor:'#ccc' }})
			;
			patch.addSubview(p);

			var v = createComponentFromDomain("View", "Core.UI", this.context, {
				size: { width: 165, height: 80+9 },
				position: { top: 24 },
				style: { backgroundColor: '#eee', borderTop: '1px solid #ddd', borderBottom: '1px solid #ddd' }})
			;
			patch.addSubview(v);

			var t = createComponentFromDomain("Label", "Core.UI", this.context, {
				text: '16:03:12',
				size: { width: 165 },
				position: { top: 5 },
				style: { textAlign: 'center', fontSize: '32px', fontWeight: '600', color: '#000', textShadow: '0 1px 0 rgba(255,255,255,.4)' }})
			;
			v.addSubview(t);

			this.containerView.addSubview(patch);};
		
		
ContentFrameController.prototype.editorWillUnloadScene = function ContentFrameController_editorWillUnloadScene(vc) {
			needsWindowLayoutLocked = true;
			this.hideNavigationBar();
			this.statusBarVisible = false;
			this.hideTabBar();
			this.removeStatusBarBackgroundView();
			this.removeButtons();};
		
		
ContentFrameController.prototype.editorDidUnloadScene = function ContentFrameController_editorDidUnloadScene(vc) {
			this.contentView.removeAllSubviews();};
		
		
		

ContentFrameController.prototype.editorDidBeginEditingSubview = function ContentFrameController_editorDidBeginEditingSubview(subview, options) {

			var contentWrapper = this.contentWrapper,
				contentFrame = this.view,
				containerView = this.containerView,
				superview = options.superview || subview.superview,
				subviewPosition = {
					left: -subview.getRelativeX(0, contentWrapper),
					top: -subview.getRelativeY(0, contentWrapper)
				},
				containerColor =
					this.opaqueColorOrNull(subview.DOMNode.style.backgroundColor) ||
					this.opaqueColorOrNull(superview.DOMNode.style.backgroundColor) ||
					this.opaqueColorOrNull(this.editor.editedView.DOMNode.style.backgroundColor) ||
								 'rgba(255, 255, 255, 1)';

			if (subviewPosition.top < 0 || subviewPosition.top > containerView.size.height) {
				subviewPosition.top = Math.abs(superview.superview.getRelativeY(0, contentWrapper));
			}
			
			
			var blockingLayer = createComponentFromDomain("View", "Core.UI", this.context, {
				size: clone(containerView.size),
				autoresizingMask: 18,
				style: {
					backgroundColor: 'rgba(0,0,0,.4)',
					zIndex: 2
				}})
			;
			
			containerView.addSubview(blockingLayer);


			var subviewContainer = createComponentFromDomain("UIView", "appdoo.iOS", this.context, {
				size: clone(subview.size),
				position: subviewPosition,
				style: {
					backgroundColor: containerColor,
					boxShadow: '0 0 20px #fff',
					outline:'2px solid rgba(255,255,255,.3)',
					zIndex: 3
				}})
			;
			
			subview._previousPosition = clone(subview.position);
			subview.position = { left: 0, top: 0 };
			containerView.addSubview(subviewContainer);

			this.subviewEditingModeData = {
				blockingLayer: blockingLayer,
				subviewContainer: subviewContainer,
				subview: subview,
				superview: superview,
				realSuperview: subview.superview,
				superviewSubviewIndex: subview.superview ? subview.superview.subviews.indexOf(subview) : -1
			};

			
			
			if (subview.superview && subview.superview.subviews.indexOf(subview) === -1)
				subview.superview = null;

			subviewContainer.addSubview(subview);


			
			contentFrame.DOMNode.onmousedown = this.onMouseDownInSubviewEditingMode.bind(this);
			contentFrame.DOMNode.onmouseup = this.onMouseUpInSubviewEditingMode.bind(this);
			
			
			subview.viewDidResize = function () {
				this.__proto__.viewDidResize.call(this);
				subviewContainer.style({
					width: this._size.width+'px',
					height: this._size.height+'px'
				});
				if (options.onResize) options.onResize(this);
			};
};
		

ContentFrameController.prototype.editorDidEndEditingSubview = function ContentFrameController_editorDidEndEditingSubview() {
		
			var data = this.subviewEditingModeData;
			if (!data) return;

			data.subview.removeFromSuperview(true);
			data.blockingLayer.removeFromSuperview();
			data.subviewContainer.removeFromSuperview();
			data.subview.position = data.subview._previousPosition;
			delete data.subview._previousPosition;
			delete data.subview.viewDidResize;

			if (data.superviewSubviewIndex !== -1) {
				data.realSuperview.insertSubviewAtIndex(data.subview, data.superviewSubviewIndex);
			}
			delete this.subviewEditingModeData;

			this.view.DOMNode.onmousedown = null;
			this.view.DOMNode.onmouseup = null;};
		
		
		Object.defineProperty(ContentFrameController.prototype, "canGoBackToList", {
		synthesized: true, get:function () { return this._canGoBackToList; }, set:function (v) {if (!Object.hasOwnProperty(this, "_canGoBackToList")) Object.defineProperty(this, "_canGoBackToList", { writable: true, configurable: true }); this._canGoBackToList = v; }});
		
	
	
	
ContentFrameController.prototype.addButtons = function ContentFrameController__addButtons() {
		if (this.canGoBackToList) this.showBackButton();};
	

ContentFrameController.prototype.removeButtons = function ContentFrameController__removeButtons() {
		this.hideBackButton();};
	

ContentFrameController.prototype.focus = function ContentFrameController_focus() {
		document.body.focus();};
	

ContentFrameController.prototype.onMouseDownInSubviewEditingMode = function ContentFrameController__onMouseDownInSubviewEditingMode(e) {

		this.subviewEditingModeData.pointerPos = [e.x, e.y];
};
	

ContentFrameController.prototype.onMouseUpInSubviewEditingMode = function ContentFrameController__onMouseUpInSubviewEditingMode(e) {
		
		if (this.editor.isActionClick(e)) return;

		var contentFrame = this.view,
			subview = this.subviewEditingModeData.subview,
			pointerPos = this.subviewEditingModeData.pointerPos;
		
		if (pointerPos === undefined) return;
	
		if (pointerPos[0] !== e.x ||
			pointerPos[1] !== e.y) return;
		
		delete this.subviewEditingModeData.pointerPos;
		
		if (e.target === subview.DOMNode) return;


		var selectedValues = this.editor.treeController.selectedValues;
		if (selectedValues.length && !(selectedValues.length===1 && selectedValues[0]===subview))
			return;
		
		this.editor.endEditingSubview();
};
	
	
ContentFrameController.prototype.opaqueColorOrNull = function ContentFrameController__opaqueColorOrNull(color) {
	
		if (!color) return null;
		
		color = color.replace("rgba(", '');
		color = color.replace("rgb(", '');
		color = color.replace(")", '');

		var rgbaSplit = color.split(',');
		
		if (rgbaSplit[3]) {
			if (rgbaSplit[3]*1 <= 0.5) return null;
		}

		return 'rgb('+rgbaSplit[0]+','+rgbaSplit[1]+','+rgbaSplit[2]+')';
	};
	


	
	
// role ZoomableViewController (appdoo.Editor) 

ContentFrameController.prototype.canZoomIn = function ContentFrameController_canZoomIn() {
			return Math.max.apply(null, this.zoomSteps) > this.contentScale;};
		

ContentFrameController.prototype.canZoomOut = function ContentFrameController_canZoomOut() {
			return Math.min.apply(null, this.zoomSteps) < this.contentScale;};
		

ContentFrameController.prototype.zoomIn = function ContentFrameController_zoomIn() {
			return this.zoomAStep(+1);};
		

ContentFrameController.prototype.zoomOut = function ContentFrameController_zoomOut(step) {
			return this.zoomAStep(-1);};
		

ContentFrameController.prototype.zoomToOriginalSize = function ContentFrameController_zoomToOriginalSize(step) {
			this.contentScale = 1.0;};
		

ContentFrameController.prototype.zoomAStep = function ContentFrameController_zoomAStep(step) {
			var didZoom;
			if (step > 0) {
				this.zoomSteps.every(function (scale) {
					if (scale > this.contentScale) {
						this.contentScale = scale;
						didZoom = true;
						return false;
					}
					return true;
				}.bind(this));
			}
			else if (step < 1) {
				this.zoomSteps.reverse();
				this.zoomSteps.every(function (scale) {
					if (scale < this.contentScale) {
						this.contentScale = scale;
						didZoom = true;
						return false;
					}
					return true;
				}.bind(this));
				this.zoomSteps.reverse();
			}

			return didZoom;};
		

		Object.defineProperty(ContentFrameController.prototype, "zoomSteps", {
			value: [
			0.125, 0.25, 0.33,
			0.5, 0.67, 1.0, 1.5, 2.0,
			3.0, 4.0 ] });
		
	
		Object.defineProperty(ContentFrameController.prototype, "contentScale", {
		synthesized: true, 
			get: function ( ) {
				if (this._contentScale === undefined) return 1.0;
				return this._contentScale;
			}, 
			set: function (scale) {if (!Object.hasOwnProperty(this, "_contentScale")) Object.defineProperty(this, "_contentScale", { writable: true, configurable: true });
				if (scale < 0.1) return;
				
				var valueBefore = this._contentScale;
				this._contentScale = scale;

				if (useSmoothZooming) {
					if (valueBefore && valueBefore !== scale) {
						this.containerView.style({
							webkitTransform: 'scale('+scale+')' });
						return;
					}
				}
				
				
				
				
				
				var scrollCenterHorizontalInPercent,
					scrollCenterVerticalInPercent;
					
				var contentFrame = this.view,
					contentWrapper = this.contentWrapper;
					
				if (contentFrame.DOMNode.scrollWidth ===
					contentFrame.DOMNode.clientWidth)
					scrollCenterHorizontalInPercent = 0.5;
				else
					scrollCenterHorizontalInPercent =
						(contentFrame.DOMNode.scrollLeft +
						contentFrame.DOMNode.clientWidth/2) /
						contentWrapper.size.width;
				
				if (contentFrame.DOMNode.scrollHeight ===
				contentFrame.DOMNode.clientHeight)
					scrollCenterVerticalInPercent = 0.5;
				else
					scrollCenterVerticalInPercent =
						(contentFrame.DOMNode.scrollTop +
						contentFrame.DOMNode.clientHeight/2) /
						contentWrapper.size.height;
			
				
				var factor = (0.5/scale)-0.5;
				var size = this.containerView.size;
				var translate = [-(size.width*factor),
								 -(size.height*factor)];
				
				this.containerView.style({
				webkitTransform: 'scale('+scale+') translate('+
					translate[0]+'px, '+translate[1]+'px)' });
				
				
				contentWrapper.size = {
					width: size.width*scale,
					height: size.height*scale
				};

				this.resizeLayout();
				
				if (!this.context.isOffscreen) {
				    var x = (contentWrapper.size.width * scrollCenterHorizontalInPercent) - contentFrame.DOMNode.clientWidth/2;
				    var y = (contentWrapper.size.height * scrollCenterVerticalInPercent) - contentFrame.DOMNode.clientHeight/2;
					contentFrame.DOMNode.scrollLeft = x || 0;
					contentFrame.DOMNode.scrollTop = y || 0;
				}
		
				this.delegate.contentFrameDidChangeContentScale(scale);
			}});
		

	


	

ContentFrameController.prototype.resizeLayout = function ContentFrameController__resizeLayout() {

		var contentFrame = this.view,
			contentWrapper = this.contentWrapper;
		
		if (this.context.isOffscreen) {
			return;
		}

		var left = (contentFrame.size.width / 2
					- contentWrapper.DOMNode.offsetWidth / 2),
			top = (contentFrame.size.height / 2
					- contentWrapper.DOMNode.offsetHeight / 2);


		if (left < 0) left = 0;
		if (top < 0) top = 0;
		
		contentWrapper.position = {
			left: parseInt(left),
			top: parseInt(top)
		};
		
		this.layoutOnscreenButtons();

        if (this.deviceBorderView) this.deviceBorderView.layout();
	};
	


	
	
// role iOSUISimulator (appdoo.Editor) 

		Object.defineProperty(ContentFrameController.prototype, "navigationBarVisible", {
			get: function () {
				if (!this.editor.editedScene.navigationBar) return false;
				return !this.editor.editedScene.navigationBar.hidden;
			}});
		

		Object.defineProperty(ContentFrameController.prototype, "statusBarVisible", {
		synthesized: true, 
			set: function (visible) {if (!Object.hasOwnProperty(this, "_statusBarVisible")) Object.defineProperty(this, "_statusBarVisible", { writable: true, configurable: true });
				if (visible === true)	this.showStatusBar();
				else					this.hideStatusBar();

				this._statusBarVisible = visible;
			}, get:function () { return this._statusBarVisible; }});
		

		Object.defineProperty(ContentFrameController.prototype, "tabBarVisible", {
		synthesized: true, 
			get: function () {
				return this.tabBar && this.tabBar.hidden !== true;
			}, set:function (v) {if (!Object.hasOwnProperty(this, "_tabBarVisible")) Object.defineProperty(this, "_tabBarVisible", { writable: true, configurable: true }); this._tabBarVisible = v; }});
		
		
ContentFrameController.prototype.showTabBar = function ContentFrameController_showTabBar() {
		
			if (this.tabBar) return;

			var tabBarController = this.context.projectContext.tabBarController;
			if (!tabBarController) return;
			
			var tabBar = tabBarController.tabBar;
			tabBar.delegate = this;
			tabBar.autoresizingMask = 2;
			
			this.containerView.addSubview(tabBar);

			this.tabBar = tabBar;

			this.editor.checkSpecialNodes();

			this.needsWindowLayout();
			
		};
		

ContentFrameController.prototype.hideTabBar = function ContentFrameController_hideTabBar() {
			if (!this.tabBar) return;
			this.tabBar.removeFromSuperview(true);
			delete this.tabBar;
			this.needsWindowLayout();};
		
		
	
	
ContentFrameController.prototype.transformEditableObject = function ContentFrameController__transformEditableObject(item) {

		if (item && item.prepareForEditor !== undefined) {
			item.prepareForEditor(this);
		}
};
	


// role Observer (Core) 

ContentFrameController.prototype.observedObjectValueDidChangeKey = function ContentFrameController_observedObjectValueDidChangeKey(obj, oldKey, newKey, keyPath, sender) {};
		

ContentFrameController.prototype.observedObjectValueDidChangeForKeyPath = function ContentFrameController_observedObjectValueDidChangeForKeyPath(obj, keyPath, sender) {};
		

ContentFrameController.prototype.observedObjectValueDidAppearForKey = function ContentFrameController_observedObjectValueDidAppearForKey(obj, key, sender) {};
		
		
ContentFrameController.prototype.observedObjectValueDidDisappearForKey = function ContentFrameController_observedObjectValueDidDisappearForKey(obj, value, key, sender) {};
		
		
	


	
	
ContentFrameController.prototype.showNavigationBar = function ContentFrameController__showNavigationBar() {
	
		var nb = this.editor.editedScene.navigationBar;
		nb.styleDefault(); 
		nb.hidden = false;
		nb.autoresizingMask = 2;
	
		this.containerView.addSubview(nb);

		var height = nb.size.height;

		nb.size.width = this.containerView.size.width;
		this.navigationBar = nb;
		
		this.needsWindowLayout();
};
	
	
	
ContentFrameController.prototype.hideNavigationBar = function ContentFrameController__hideNavigationBar() {
		if (!this.navigationBar) return;
		this.navigationBar.removeFromSuperview(true);
		delete this.navigationBar;
		this.needsWindowLayout();};
	
	
ContentFrameController.prototype.updateNavigationBar = function ContentFrameController__updateNavigationBar() {
		this.hideNavigationBar();
		if (this.editor.editedViewController &&
			this.editor.editedViewController.navigationBarIsVisible)
			this.showNavigationBar();};
	


	

ContentFrameController.prototype.showStatusBar = function ContentFrameController__showStatusBar(scene) {
	
		if (this.statusBar) return;
		
		var width = this.containerView.size.width;
		
		var brightContent = scene.shouldHaveBrightStatusBar;

		var statusBar = this.context.projectContext.decodeObjectTree({
			$type: 'UIStatusBar',
			$domain: 'appdoo.iOS',
			size: { width: width },
			autoresizingMask: 2,
			brightContent: brightContent,
			hidden: (scene.statusBarIsVisible === false)
		});
		this.statusBar = statusBar;
		this.statusBar.style({zIndex:1000});
		this.containerView.addSubview(statusBar);
		};
	

ContentFrameController.prototype.hideStatusBar = function ContentFrameController__hideStatusBar() {

		if (this.statusBar === undefined) return;
		this.statusBar.removeFromSuperview();
		delete this.statusBar;
	};
	

ContentFrameController.prototype.updateStatusBar = function ContentFrameController__updateStatusBar() {

		if (!this.statusBar) return;
		this.statusBar.brightContent = this.editor.editedScene.shouldHaveBrightStatusBar;
	};
	
	

	

ContentFrameController.prototype.updateTabBar = function ContentFrameController__updateTabBar() {

		if (!this.tabBar) return;

		this.layoutTabBar();

		var tabBarController = this.context.projectContext.tabBarController;
		if (tabBarController.updateTabBar()) {
			this.tabBar.prepareForEditor(this.editor);
			this.tabBar.styleDefault();
		}
};
	

// role UITabBarDelegate (appdoo.iOS) 

ContentFrameController.prototype.tabBarValueDidChange = function ContentFrameController_tabBarValueDidChange(tabBar) {

			var newIndex = tabBar.selectedIndex,
				tabBarController = this.context.projectContext.tabBarController,
				viewControllerToOpen = tabBarController.viewControllerIDs[newIndex],
				sceneToOpen = this.context.projectContext.sceneContainingViewController(viewControllerToOpen);
			
			if (sceneToOpen) {
				this.editor.openItem(sceneToOpen);
			}
			else {
				console.warn('Error: The scene could not be found.');
			}
		};
		

	


	
	
	var backButtonFileName = 'MasterViewButton.png';
	
ContentFrameController.prototype.showBackButton = function ContentFrameController__showBackButton() {

		if (this.context.isOffscreen) return;
		
		if (this._backButton !== undefined)
			return;
		
		var width = 62;
		this._backButton = createComponentFromDomain("SpriteButton", "Core.UI", this.context, {
			position: { left: -width, top: this.contentWrapper.size.height/2-17 },
			autoresizingMask: (1 << 3) | (1 << 5),
			size: { width: width, height: 36 },
			sprite: this.context.pathForResource(backButtonFileName),
			action: function () { this.editor.goBack(); }.bind(this),
			highlightOnMouseOver: true})
		;
		
		this.contentWrapper.addSubview(this._backButton);
		this.layoutOnscreenButtons();};
	

ContentFrameController.prototype.hideBackButton = function ContentFrameController__hideBackButton() {

		if (this._backButton === undefined)
			return;
		
		this._backButton.removeFromSuperview();
		
		delete this._backButton;};
	


	

ContentFrameController.prototype.scaledRectangleForComponent = function ContentFrameController_scaledRectangleForComponent(component) {
		var scale = this.contentScale;
		return {
			position: {
				left: -component.getRelativeX(0, this.contentWrapper) * scale,
				top: -component.getRelativeY(0, this.contentWrapper) * scale
			},
			size: {
				width: component.size.width * scale,
				height: component.size.height * scale
			}
		};};
	

	Object.defineProperty(ContentFrameController.prototype, "contentRect", {
		get: function () {

			var frame = {
				position: clone(this.contentWrapper.position),
				size: clone(this.contentWrapper.size)
			};
	
			frame.position.left -= this.view.DOMNode.scrollLeft;
			frame.position.top -= this.view.DOMNode.scrollTop;
			return frame;

		}});
	

	
	

// role ViewDelegate (Core.UI) 

ContentFrameController.prototype.viewDidLoad = function ContentFrameController_viewDidLoad(view) {
			if (view !== this.view) return;
			view.viewDidResize = this.resizeLayout.bind(this);
			view.viewDidResize();};
		

	
	
	
	
	
ContentFrameController.prototype.showOnScreenInfo = function ContentFrameController_showOnScreenInfo(msg) {
		if (!this.onScreenInfo) {
			this.onScreenInfo = createComponentFromDomain("OnScreenInfo", "appdoo.Editor", this.context, {
				releaseWhenFinished: false})
			;
		}
		this.view.addSubview(this.onScreenInfo);
		this.onScreenInfo.showMessage(msg);};
	
	
ContentFrameController.prototype.showContentScaleOnScreen = function ContentFrameController__showContentScaleOnScreen() {
		this.showOnScreenInfo(parseInt(this.contentScale*100)+'%');};
	
	
	
	

ContentFrameController.prototype.lock = function ContentFrameController_lock() {
					this.containerView.style({
						pointerEvents: 'none'
					});};
	
	
ContentFrameController.prototype.unlock = function ContentFrameController_unlock() {
					this.containerView.style({
						pointerEvents: 'all'
					});};
	
	
	
	
	
ContentFrameController.prototype.toggle3_5InchDisplay = function ContentFrameController_toggle3_5InchDisplay() {

		this.isSimulating3_5InchDisplay = !this.isSimulating3_5InchDisplay;
	
		if (this.context.isOffscreen) return;
		if (!this.containerView) return;
		
		this.resetContentViewSizeForScene(this.editor.editedScene);
		this.layoutWindow();
		this.editor.manipulator.updateSizeModifierButtons();
	};
	


	
	
	function maskHasBitSet(mask, bit) {
		return mask & bit;
	}
	
	function maskContainsLandscapeOrientation(mask, orientationString) {
		return (maskHasBitSet(mask, 8) || maskHasBitSet(mask, 16));
	}

	function maskContainsPortraitOrientation(mask, orientationString) {
		return (maskHasBitSet(mask, 2) || maskHasBitSet(mask, 4));
	}
	
	Object.defineProperty(ContentFrameController.prototype, "interfaceOrientation", {
	synthesized: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_interfaceOrientation")) Object.defineProperty(this, "_interfaceOrientation", { writable: true, configurable: true });
			if (this.interfaceOrientation === v) return;
			
			if (v === 'landscape' && !maskContainsLandscapeOrientation(this.context.projectContext.metadata.supportedInterfaceOrientations) && !maskContainsLandscapeOrientation(this.editor.editedScene.supportedInterfaceOrientations)) {

				var returnCode = this.context.nativeProxy.sendMessage('confirmWithOptions', JSON.stringify({
					message: LocalizedString('Do you want to enable landscape orientation for this project?'),
					details: LocalizedString('You can change the supported orientations later in the project settings.'),
					button1: LocalizedString('Activate'),
					button2: LocalizedString('Cancel')
				}));

				if (!returnCode) return;
				
				this.context.projectMetadataController.setValueForKey(this.context.projectContext.metadata.supportedInterfaceOrientations+(8+16), 'supportedInterfaceOrientations')

				this.context.projectContext.metadata.simulatedInterfaceOrientation = v;
				this._interfaceOrientation = v;
			}
			else if (v === 'portrait' && !maskContainsPortraitOrientation(this.context.projectContext.metadata.supportedInterfaceOrientations) && !maskContainsPortraitOrientation(this.editor.editedScene.supportedInterfaceOrientations)) {

				var returnCode = this.context.nativeProxy.sendMessage('confirmWithOptions', JSON.stringify({
					message: LocalizedString('Do you want to enable portrait orientation for this project?'),
					details: LocalizedString('You can change the supported orientations later in the project settings.'),
					button1: LocalizedString('Activate'),
					button2: LocalizedString('Don\'t Activate')
				}));

				if (!returnCode) return;
				
				this.context.projectMetadataController.setValueForKey(this.context.projectContext.metadata.supportedInterfaceOrientations+2, 'supportedInterfaceOrientations')

				this.context.projectContext.metadata.simulatedInterfaceOrientation = v;
				this._interfaceOrientation = v;
			}
			
			this.editor.editedScene.e_simulatedInterfaceOrientation = v;
			this.context.projectContext.metadata.simulatedInterfaceOrientation = v;
		}, 
		get: function () {

			if (this.editor.editedScene)
				return this.editor.editedScene.simulatedInterfaceOrientation;

		}});
	
	

	var kInterfaceOrientationPortrait = 'portrait',
		kInterfaceOrientationLandscape = 'landscape';
	
	
ContentFrameController.prototype.interfaceOrientationDidChangeForScene = function ContentFrameController_interfaceOrientationDidChangeForScene(scene) {

		this.editor.pauseSubviewEditing();
		this.resetContentViewSizeForScene(scene);
		this.layoutWindow();
		this.editor.resumeSubviewEditing();
		this.editor.manipulator.updateSizeModifierButtons();
		};
	
	
ContentFrameController.prototype.sizeForContentView = function ContentFrameController__sizeForContentView() {
		var h = this.containerView.size.height;

		h -= this.heightForTabBar();

		if ((this.navigationBarVisible && this.navigationBar.translucent !== true) ||  this.context.projectContext.simulatedSystemVersion >= 7) {
			h -= this.navigationBar.size.height;
		}

		return {
			width: this.containerView.size.width,
			height: h
		};};
	
	
ContentFrameController.prototype.heightForTabBar = function ContentFrameController__heightForTabBar() {
		if (!this.tabBarVisible) return 0;
		return 49;};
	
	
ContentFrameController.prototype.heightForNavigationBar = function ContentFrameController__heightForNavigationBar() {
		var isSystem7 = this.context.projectContext.simulatedSystemVersion >= 7;
		if (isSystem7) return 64;
		return (this.interfaceOrientation === kInterfaceOrientationPortrait) ? 44 : 31;};
	

	Object.defineProperty(ContentFrameController.prototype, "defaultTopScrollInset", {
		get: function () {
			if (this.navigationBarVisible && this.editor.editedScene.navigationBar.translucent) return this.editor.editedScene.navigationBar.size.height;
			return 0;
		}});
	

	Object.defineProperty(ContentFrameController.prototype, "defaultBottomScrollInset", {
		get: function () {
			var isSystem7 = this.context.projectContext.simulatedSystemVersion >= 7;
			if (this.tabBarVisible && this.tabBar.translucent && isSystem7) return this.tabBar.size.height;
			return 0;
		}});
	
	
ContentFrameController.prototype.rotate = function ContentFrameController_rotate() {
		if (this.interfaceOrientation === kInterfaceOrientationLandscape)
			this.interfaceOrientation = kInterfaceOrientationPortrait;
		else
			this.interfaceOrientation = kInterfaceOrientationLandscape;};
	



ContentFrameController.prototype.simulatedSystemDidChange = function ContentFrameController_simulatedSystemDidChange() {
		if (this.navigationBar) this.navigationBar.layoutSubviews();
		this.updateBackground();};
	

	var needsWindowLayoutLocked = true;
ContentFrameController.prototype.needsWindowLayout = function ContentFrameController_needsWindowLayout() {
		this.layoutWindow();};
	
	
ContentFrameController.prototype.layoutWindow = function ContentFrameController_layoutWindow() {
	
		var y = 0;
		if (this.statusBar) {
			this.statusBar.position.top = 0;
			if (this.editor.editedScene.v_separateStatusBar) {
				this.statusBarBackgroundView = this.editor.editedScene.statusBarBackgroundView;
				this.containerView.addSubview(this.statusBarBackgroundView);
				if (!this.statusBarBackgroundView.translucent)
					y += this.statusBar.size.height || 21;
			}
		}
		if (this.navigationBar) {
			if (!this.navigationBar.translucent) y += this.navigationBar.size.height;
		}

		var remainingHeight = this.containerView.size.height - y;
		
		if (this.tabBar) {
			if (!(this.simulatedSystemVersion >= 7 && this.tabBar.translucent))
				remainingHeight -= this.tabBar.size.height;
				
			this.tabBar.position.top = this.containerView.size.height-this.tabBar.size.height;
		}
		this.contentView.position.top = y;
		this.contentView.size.height = remainingHeight;
		
		if (this.editor.editedScene && this.editor.editedScene.statusBarBackgroundView && this.statusBar) {
			this.editor.editedScene.statusBarBackgroundView.size.width = this.statusBar.size.width;
		}};
	
	

ContentFrameController.prototype.layoutOnscreenButtons = function ContentFrameController__layoutOnscreenButtons() {

		if (this._backButton) {
		
			var bb = this._backButton,
				availableSpaceLeft = (this.view._size.width-this.contentWrapper._size.width)/2,
				backButtonShouldOverlay = (availableSpaceLeft < 62);


			if (backButtonShouldOverlay === true) {
			
				var isSystem7 = this.context.projectContext.simulatedSystemVersion >= 7;
				var top = isSystem7 ? 24 : 4;
				var leftPadding = 5;
				var imageSrc = 'MasterViewButtonFixed.png';
			
				bb.position = {
					left: this.view._position.left + leftPadding,
					top: top
				};
				
				if (bb.overlays !== true) {
					bb.style({ position: 'absolute' });
					bb.size = { width: 36, height: 36 };
					bb.sprite = this.context.pathForResource(imageSrc);
					bb.overlays = true;
				}
			}
			
			else if (bb.overlays === true) {

				bb.overlays = false;
				bb.size = { width: 62, height: 36 };
				bb.style({ position: 'absolute' });
				bb.sprite = this.context.pathForResource(backButtonFileName);
				bb.position = {
					left: -62,
					top: this.contentWrapper.size.height/2-17
				};
			}

		}
};
	
	
ContentFrameController.prototype.layoutTabBar = function ContentFrameController__layoutTabBar() {

		if (!this.tabBar) return;

		this.tabBar.size.width = this.contentView.size.width;
		this.tabBar.position.top = this.containerView.size.height - this.tabBar.size.height;
	};
	
	
		
ContentFrameController.prototype.removeStatusBarBackgroundView = function ContentFrameController__removeStatusBarBackgroundView() {
		if (this.statusBarBackgroundView)
			this.statusBarBackgroundView.removeFromSuperview(true);};
	
	
	Object.defineProperty(ContentFrameController.prototype, "simulatedSystemVersion", {
		get: function () {
			return this.context.projectContext.simulatedSystemVersion;
		}});
	
	
ContentFrameController.prototype.updateElement = function ContentFrameController_updateElement(name) {
		if (name === 'statusBar') this.updateStatusBar();};
	

ContentFrameController.prototype.initPropertiesFromData = function ContentFrameController_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("contentWrapper")) this.contentWrapper = data.contentWrapper;
if (data.hasOwnProperty("delegate")) this.delegate = data.delegate;
if (data.hasOwnProperty("editor")) this.editor = data.editor;
if (data.hasOwnProperty("deviceBorderView")) this.deviceBorderView = data.deviceBorderView;
};

ContentFrameController.prototype.decodeData = function ContentFrameController_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

ContentFrameController.prototype.encode = function ContentFrameController_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

ContentFrameController.prototype.encodeCloned = function ContentFrameController_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

ContentFrameController.prototype.expectedTypeForProperty = function ContentFrameController_expectedTypeForProperty(key) {
	if (key === "contentWrapper") return "";
	if (key === "delegate") return "";
	if (key === "editor") return "";
	if (key === "deviceBorderView") return "";
	if (key === "simulatedWindow") return "";
	if (key === "hasDarkBackground") return "Boolean";
	if (key === "canGoBackToList") return "";
	if (key === "zoomSteps") return "";
	if (key === "contentScale") return "";
	if (key === "navigationBarVisible") return "";
	if (key === "statusBarVisible") return "";
	if (key === "tabBarVisible") return "";
	if (key === "contentRect") return "";
	if (key === "interfaceOrientation") return "String";
	if (key === "defaultTopScrollInset") return "";
	if (key === "defaultBottomScrollInset") return "";
	if (key === "simulatedSystemVersion") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return ContentFrameController; }()));