
registerType('appdoo', (function () { function DataContext() {} var __super = setSupertypeFromDomain(DataContext, 'BasicObject', 'Core');

	Object.defineProperty(DataContext.prototype, "dataSource", {
	outlet: true, get:function () { return this._dataSource; }, set:function (v) {if (!Object.hasOwnProperty(this, "_dataSource")) Object.defineProperty(this, "_dataSource", { writable: true, configurable: true }); this._dataSource = v; }});
	
	
	Object.defineProperty(DataContext.prototype, "indexPath", {
	outlet: true, get:function () { return this._indexPath; }, set:function (v) {if (!Object.hasOwnProperty(this, "_indexPath")) Object.defineProperty(this, "_indexPath", { writable: true, configurable: true }); this._indexPath = v; }});
	
	
	Object.defineProperty(DataContext.prototype, "keyPath", {
	outlet: true, get:function () { return this._keyPath; }, set:function (v) {if (!Object.hasOwnProperty(this, "_keyPath")) Object.defineProperty(this, "_keyPath", { writable: true, configurable: true }); this._keyPath = v; }});
	

	Object.defineProperty(DataContext.prototype, "arrayWithNamedBindableKeyPaths", {
		get: function () {
			var r = [];
			if (Array.isArray(this.items)) this.items.every(function (item) {
				r.push([item.keyPath, item.name]);return true; }, this);
			
			return r;
		}});
	

	Object.defineProperty(DataContext.prototype, "icon", {
		get: function () {
			return this.dataSource.outlineIconURL;
		}});
	

	Object.defineProperty(DataContext.prototype, "name", {
		get: function () {
			if (this.indexPath)
				return '#'+(this.indexPath.item+1)+' '+LocalizedString('in')+' '+this.dataSource.readableValue;
			return this.dataSource.readableValue;
		}});
	

	Object.defineProperty(DataContext.prototype, "idForBindings", {
		get: function () {
			return this.dataSource.$id;
		}});
	

	Object.defineProperty(DataContext.prototype, "allowsBindings", {
		get: function () { return true; }});
	

	function dataContextItemsFromObject(obj, prefix, dataSource) {
	
		var items = [];

		if (typeof obj === 'object' && obj !== null && !Array.isArray(obj)) {
			for (var key in obj) {
			
				var keyPath = prefix?prefix+'.'+key:key,
					name = key;
				
				if (dataSource && dataSource.nameForKeyPath)
					name = dataSource.nameForKeyPath(keyPath)||key;
				
				items.push({
					key: key,
					keyPath: keyPath,
					value: obj[key],
					name: name
				});
			}
		}

		else {
			var key = '';
			var keyPath = prefix||'';
				name = LocalizedString('Value');

			items.push({
				key: key,
				keyPath: keyPath,
				value: obj,
				name: name
			});
		}

		return items;
	}

	Object.defineProperty(DataContext.prototype, "items", {
		get: function () {
			if (this.keyPath) {
				var obj = this.dataSource;
				if (this.indexPath)
					obj = this.dataSource.dataForIndexPath(this.indexPath);
				return dataContextItemsFromObject(
					this.context.dissolveKeyPathWithContextObject(this.keyPath, obj),
					this.keyPath,
					this.dataSource);
			}
			if (this.indexPath)
				return dataContextItemsFromObject(
					this.dataSource.dataForIndexPath(this.indexPath),
					'',
					this.dataSource);

			return dataContextItemsFromObject(
				this.dataSource.rootData,
				this.dataSource.rootDataKeyPath,
				this.dataSource);
		}});
	
	
DataContext.prototype.valueForKeyPath = function DataContext_valueForKeyPath(keyPath) {

		if (this.indexPath) {
			var data = this.dataSource.dataForIndexPath(this.indexPath);
			if (!keyPath) return data;
			return this.context.dissolveKeyPathWithContextObject(keyPath, data);
		}
		
		return this.context.dissolveKeyPathWithContextObject(keyPath, this.dataSource);};
	


DataContext.prototype.init = function DataContext_init() {
		__super.prototype.init.call(this);
		if (this.dataSource) {
			if (this.indexPath) this.$id = this.dataSource.identify()+'ContextWithIndexPath';
			else if (this.keyPath) this.$id = this.dataSource.identify()+'ContextWithKeyPath';
			else this.$id = this.dataSource.identify()+'Context';
		}
		return this;};
	

DataContext.prototype.updateDataSource = function DataContext_updateDataSource() {
	
		var indexPath = this.indexPath,
			newData = this.dataSource.dataForIndexPath(indexPath);

		this.dataItemController.replaceWithData(newData);

		this.context.projectContext.broadcastValueChangeForKeyPathInObject('dataItemController', dataContext, this);};
	


// role SegmentedControlDelegate 
	
DataContext.prototype.segmentedControlValidateSegmentAtIndex = function DataContext_segmentedControlValidateSegmentAtIndex(sc, index) {

			if (index === 0) { 
				return this.indexPath.item > 0;
			}
			else if (index === 1) { 
				return this.indexPath.item < this.dataSource.numberOfItemsInSection(this.indexPath.section)-1;
			}
			};
		
		
DataContext.prototype.segmentedControlDidChangeValue = function DataContext_segmentedControlDidChangeValue(sc) {
			switch (sc.selectedIndex) {
				case 0:
					this.indexPath.item--;
					break;
				case 1:
					this.indexPath.item++;
					break;
			}
			this.updateDataSource();};
		
	
	
	
DataContext.prototype.dropLastKeyPathComponent = function DataContext_dropLastKeyPathComponent() {
		var components = this.keyPath.split('.');
		components.pop();
		this.keyPath = components.join('.');
		if (this.keyPath === this.dataSource.rootDataKeyPath)
			this.keyPath = '';
		_context.editor.updateDataContext(this);};
	


DataContext.prototype.initPropertiesFromData = function DataContext_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("dataSource")) this.dataSource = data.dataSource;
if (data.hasOwnProperty("indexPath")) this.indexPath = data.indexPath;
if (data.hasOwnProperty("keyPath")) this.keyPath = data.keyPath;
};

DataContext.prototype.decodeData = function DataContext_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

DataContext.prototype.encode = function DataContext_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

DataContext.prototype.encodeCloned = function DataContext_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

DataContext.prototype.expectedTypeForProperty = function DataContext_expectedTypeForProperty(key) {
	if (key === "dataSource") return "";
	if (key === "indexPath") return "";
	if (key === "keyPath") return "";
	if (key === "arrayWithNamedBindableKeyPaths") return "";
	if (key === "icon") return "";
	if (key === "name") return "";
	if (key === "idForBindings") return "";
	if (key === "allowsBindings") return "";
	if (key === "items") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return DataContext; }()));