
registerType('appdoo.Editor', (function () { function DynamicsControl() {} var __super = setSupertypeFromDomain(DynamicsControl, 'View', 'Core.UI');

	var autoresizingFlexibleLeftMargin = 	(1 << 0), 
		autoresizingFlexibleWidth = 		(1 << 1), 
		autoresizingFlexibleRightMargin = 	(1 << 2), 
		autoresizingFlexibleTopMargin = 	(1 << 3), 
		autoresizingFlexibleHeight = 		(1 << 4), 
		autoresizingFlexibleBottomMargin = 	(1 << 5); 
	
	
	
	


DynamicsControl.prototype.initFromData = function DynamicsControl_initFromData(data) {

		data.size = { width: 114, height: 114 };

		data.style = {
			border: '1px solid #ccc',
			borderTopColor: '#bbb',
			borderRadius: '5px',
			boxShadow: '0 1px 0 rgba(255,255,255,.5)'
		};

		if (!__super.prototype.initFromData.call(this, data, null, true))
			return;
		
		this.createMiddleRectangle();
		this.createMagnetButtons();
		this.createSpringButtons();
		
		this.applyBindings(true);
		
		return this;};
	
	
DynamicsControl.prototype.createMiddleRectangle = function DynamicsControl__createMiddleRectangle() {

		var mr = createComponentFromDomain("View", "Core.UI", this.context, {
			size: { width: 50, height: 50 },
			position: { left: 32, top: 32 },
			style: {
				border: '1px solid #bbb',
				backgroundColor: '#fff',
			}})
		;

		this.addSubview(mr);};
	
	
DynamicsControl.prototype.createMagnetButtons = function DynamicsControl__createMagnetButtons() {
		
		this.magnetTop = createComponentFromDomain("Button", "Core.UI", this.context, {
			imageSrc: this.context.pathForResource('MagnetTopOff.png'),
			onStateImageSrc: this.context.pathForResource('MagnetTop.png'),
			size: { width: 52, height: 32 },
			position: { left: 31 },
			buttonType: 'onOff',
			action: function () {
				this.toggleBit(autoresizingFlexibleTopMargin);
				return false;
			}.bind(this)})
		;

		this.magnetBottom = createComponentFromDomain("Button", "Core.UI", this.context, {
			imageSrc: this.context.pathForResource('MagnetBottomOff.png'),
			onStateImageSrc: this.context.pathForResource('MagnetBottom.png'),
			size: { width: 52, height: 32 },
			position: { left: 31, top: 82 },
			buttonType: 'onOff',
			action: function () {
				this.toggleBit(autoresizingFlexibleBottomMargin);
				return false;
			}.bind(this)})
		;

		this.magnetLeft = createComponentFromDomain("Button", "Core.UI", this.context, {
			imageSrc: this.context.pathForResource('MagnetLeftOff.png'),
			onStateImageSrc: this.context.pathForResource('MagnetLeft.png'),
			size: { width: 32, height: 50 },
			position: { left: 0, top: 32 },
			buttonType: 'onOff',
			action: function () {
				this.toggleBit(autoresizingFlexibleLeftMargin);
				return false;
			}.bind(this)})
		;

		this.magnetRight = createComponentFromDomain("Button", "Core.UI", this.context, {
			imageSrc: this.context.pathForResource('MagnetRightOff.png'),
			onStateImageSrc: this.context.pathForResource('MagnetRight.png'),
			size: { width: 32, height: 50 },
			position: { left: 82, top: 32 },
			buttonType: 'onOff',
			action: function () {
				this.toggleBit(autoresizingFlexibleRightMargin);
				return false;
			}.bind(this)})
		;
		
		this.addSubview(this.magnetTop);
		this.addSubview(this.magnetBottom);
		this.addSubview(this.magnetLeft);
		this.addSubview(this.magnetRight);
		
		};
	

DynamicsControl.prototype.createSpringButtons = function DynamicsControl__createSpringButtons() {
		
		this.springVertical = createComponentFromDomain("Button", "Core.UI", this.context, {
			imageSrc: this.context.pathForResource('SpringVerticalOff.png'),
			onStateImageSrc: this.context.pathForResource('SpringVertical.png'),
			size: { width: 15, height: 50 },
			position: { left: 32+25-7, top: 33 },
			buttonType: 'onOff',
			action: function () {
				this.updateSpringZIndices();
				this.toggleBit(autoresizingFlexibleHeight);
				return false;
			}.bind(this)})
		;

		this.springHorizontal = createComponentFromDomain("Button", "Core.UI", this.context, {
			imageSrc: this.context.pathForResource('SpringHorizontalOff.png'),
			onStateImageSrc: this.context.pathForResource('SpringHorizontal.png'),
			size: { width: 50, height: 15 },
			position: { left: 32+1, top: 32+25-7 },
			buttonType: 'onOff',
			action: function () {
				this.updateSpringZIndices();
				this.toggleBit(autoresizingFlexibleWidth);
				return false;
			}.bind(this)})
		;

		this.addSubview(this.springVertical);
		this.addSubview(this.springHorizontal);
		};
	
	

	
	
DynamicsControl.prototype.updateSpringZIndices = function DynamicsControl__updateSpringZIndices() {

		if (this.springHorizontal.state) {
			this.springHorizontal.style({ zIndex: 2 });
			this.springVertical.style({ zIndex: 1 });
		}

		else if (this.springVertical.state) {
			this.springHorizontal.style({ zIndex: 1 });
			this.springVertical.style({ zIndex: 2 });
		}
		};
	

DynamicsControl.prototype.styleForDisabled = function DynamicsControl__styleForDisabled(v) {

		__super.prototype.styleForDisabled.call(this, v);

		if (v === true) {
			if (!this.magnetLeft) return;
			this.magnetLeft.state = 	false;
			this.magnetRight.state =	false;
			this.magnetTop.state =		false;
			this.magnetBottom.state = 	false;
			this.springHorizontal.state =	false;
			this.springVertical.state =	false;
		}};
	


	

DynamicsControl.prototype.toggleBit = function DynamicsControl__toggleBit(mask) {
		this._value ^= mask;
		this.updateButtons();
		this.context.broadcastValueChangeForKeyPathInObject('value', this, this);};
	

	function isBitSet(num, mask) {
		return (num & mask) !== 0;
	}
	
	Object.defineProperty(DynamicsControl.prototype, "value", {
	synthesized: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_value")) Object.defineProperty(this, "_value", { writable: true, configurable: true });
		
			
			if (!Array.isArray(v)) {
				this.disabled = true;
				return;
			}

			this.disabled = false;
		
			var value = v[0] || 0;
			
			this._value = value;
			this.updateButtons();
		}, get:function () { return this._value; }});
	
	
DynamicsControl.prototype.updateButtons = function DynamicsControl__updateButtons() {

		var value = this._value;

		this.magnetLeft.state = !isBitSet(value, autoresizingFlexibleLeftMargin);
		this.magnetRight.state = !isBitSet(value, autoresizingFlexibleRightMargin);
		this.magnetTop.state = !isBitSet(value, autoresizingFlexibleTopMargin);
		
		this.magnetBottom.state = !isBitSet(value, autoresizingFlexibleBottomMargin);

		this.springHorizontal.state = isBitSet(value, autoresizingFlexibleWidth);
		this.springVertical.state = isBitSet(value, autoresizingFlexibleHeight);
		
		this.updateSpringZIndices();
		};
	


DynamicsControl.prototype.expectedTypeForProperty = function DynamicsControl_expectedTypeForProperty(key) {
	if (key === "value") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return DynamicsControl; }()));