
registerType('appdoo.Editor', (function () { function GuidelineController() {} var __super = setSupertypeFromDomain(GuidelineController, 'BasicObject', 'Core');

	Object.defineProperty(GuidelineController.prototype, "shouldIgnoreSelection", {
	outlet: true, get:function () { return this._shouldIgnoreSelection; }, set:function (v) {if (!Object.hasOwnProperty(this, "_shouldIgnoreSelection")) Object.defineProperty(this, "_shouldIgnoreSelection", { writable: true, configurable: true }); this._shouldIgnoreSelection = v; }});
	
	
// role BasicObject (Core) 

GuidelineController.prototype.initFromData = function GuidelineController_initFromData(data) {
		
			var overlayView = data.overlayView,
				guidelineCanvas = document.createElement('canvas');
	
			guidelineCanvas.width = overlayView.size.width;
			guidelineCanvas.height = overlayView.size.height;
			guidelineCanvas.style.position = 'absolute';
	
			overlayView.DOMNode.appendChild(guidelineCanvas);
			this.guidelineCanvas = guidelineCanvas;
			
			this.manipulator = data.manipulator;
			this.hidden = true;
			
			return this;
	};
		
		
GuidelineController.prototype.destroy = function GuidelineController_destroy() {
			if (this.guidelineCanvas.parentNode)
				this.guidelineCanvas.parentNode.removeChild(this.guidelineCanvas);
			neighbours = null;};
		
	
	


GuidelineController.prototype.guidePositionForSize = function GuidelineController_guidePositionForSize(position, size, skipMiddle, skipLeft, skipRight) {
		if (!size) return;

		if (position.x !== undefined) {
			position.xe = position.x + size.width;
			position.xm = position.x + parseInt(size.width/2);
		}

		if (position.y !== undefined) {
			position.ye = position.y + size.height;
			position.ym = position.y + parseInt(size.height/2);
		}

		if (position.x !== undefined) {
			this.guideXPositionForSizeFromNeighbours(position, size, skipMiddle, skipLeft, skipRight) ||
			this.guideXPositionForSizeFromSuperview(position, size, skipMiddle, skipLeft, skipRight);
		}

		if (position.y !== undefined) {
			this.guideYPositionForSizeFromNeighbours(position, size, skipMiddle, skipLeft, skipRight) ||
			this.guideYPositionForSizeFromSuperview(position, size, skipMiddle, skipLeft, skipRight);
		}
};
	
	
GuidelineController.prototype.guideWidth = function GuidelineController_guideWidth(width, p, s, guideForEnd) {
		var xBefore = p.x;
		p.xe = p.x + s.width;
		if (!this.guideXPositionForSizeFromNeighbours(p, s, true, guideForEnd, !guideForEnd))
			this.guideXPositionForSizeFromSuperview(p, s, true, guideForEnd, !guideForEnd);
		return width + (p.x-xBefore);};
	

GuidelineController.prototype.guideHeight = function GuidelineController_guideHeight(height, p, s, guideForEnd) {
		var yBefore = p.y;
		p.ye = p.y + s.height;
		if (!this.guideYPositionForSizeFromNeighbours(p, s, true, guideForEnd, !guideForEnd))
			this.guideYPositionForSizeFromSuperview(p, s, true, guideForEnd, !guideForEnd);
		return height + (p.y-yBefore);};
	

GuidelineController.prototype.guideXForWidth = function GuidelineController_guideXForWidth(width, p, s, guideForEnd) {
		var xBefore = p.x;
		p.xe = p.x + s.width;
		if (!this.guideXPositionForSizeFromNeighbours(p, s, true, guideForEnd, !guideForEnd))
			this.guideXPositionForSizeFromSuperview(p, s, true, guideForEnd, !guideForEnd);
		return width + (p.x-xBefore);};
	
	
GuidelineController.prototype.beginShowingGuidelines = function GuidelineController_beginShowingGuidelines(shouldIgnoreSelection) {
		this.shouldIgnoreSelection = shouldIgnoreSelection;
		this.prepare();
		this.hidden = false;};
	

GuidelineController.prototype.endShowingGuidelines = function GuidelineController_endShowingGuidelines() {
		this.clear();
		this.hidden = true;};
	

GuidelineController.prototype.clear = function GuidelineController_clear() {
		ctx.clearRect(0, 0,
			width * contentScale,
			height * contentScale);};
	


	

	var width, width_2, height, height_2, ctx, neighbours,
		range, contentScale,
		red = 'rgb(234,36,50)',
		blue = 'rgb(14,143,237)',
		glowColor = 'rgba(255,255,255,.4)',
		glowBlur = 3,
		defaultRange = 5,
		sceneColor = blue,
		neighbourColor = red,
		sceneMargin = 15;

GuidelineController.prototype.prepare = function GuidelineController__prepare() {

		var editor = this.manipulator.delegate,
			editedSubviewRect = editor.editedSubviewRect,
			guidelineCanvas = this.guidelineCanvas;
		
		contentScale = this.manipulator.contentScale;

		width = editedSubviewRect.size.width;
		height = editedSubviewRect.size.height;
		width_2 = parseInt(width/2);
		height_2 = parseInt(height/2);

		guidelineCanvas.width = width * contentScale;
		guidelineCanvas.height = height * contentScale;
		guidelineCanvas.style.top =
			editedSubviewRect.position.top * contentScale
			 + 'px';
		guidelineCanvas.style.left =
			editedSubviewRect.position.left * contentScale
			 + 'px';

		ctx = this.guidelineCanvas.getContext('2d');
		ctx.shadowColor = glowColor;
		ctx.shadowBlur = glowBlur;
	    ctx.shadowOffsetX = 0;
    	ctx.shadowOffsetY = 0;
    	if (ctx.setLineDash) ctx.setLineDash([2,3]);

    	
    	range = defaultRange/contentScale;
		
		this.precalculateNeighbourPositions();
	};
	

GuidelineController.prototype.precalculateNeighbourPositions = function GuidelineController__precalculateNeighbourPositions() {

    	var selection = this.manipulator.observableItemsController.selectedValues;
    	
    	neighbours = [];
    	
    	if (Array.isArray(this.manipulator.editedViews)) this.manipulator.editedViews.every(function (item) {
    	
    		
    		
    		var x, w, y, h, xm, ym, xe, ye;

    		if (!this.shouldIgnoreSelection && selection.indexOf(item) !== -1)
    			return true;
    		
    		x = item.position.left;
    		y = item.position.top;
    		w = item.size.width;
    		h = item.size.height;
    		xm = x + parseInt(w/2);
    		ym = y + parseInt(h/2);
    		xe = x + w;
    		ye = y + h;
    		
    		neighbours.push({ x: x, y: y, xm: xm, ym: ym, xe: xe, ye: ye,
    			w: w, h: h });
    		return true; }, this);
    	
    	};
	

	
	Object.defineProperty(GuidelineController.prototype, "hidden", {
	synthesized: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_hidden")) Object.defineProperty(this, "_hidden", { writable: true, configurable: true });
			this.guidelineCanvas.style.display = v === true ? 'none' : '';
			this._hidden = v;
		}, get:function () { return this._hidden; }});
	


	

GuidelineController.prototype.guideXPositionForSizeFromSuperview = function GuidelineController__guideXPositionForSizeFromSuperview(position, size, skipMiddle, skipLeft, skipRight) {
	
		if (!skipMiddle) {
			
			var xc = position.x + parseInt(size.width/2);
			if (Math.abs(width_2 - xc) < range) {
				this.drawVerticalLine(width_2, 0, height, sceneColor);
				position.x = width_2-parseInt(size.width/2);
				return true;
			}
		}

		if (!skipLeft) {
			
			if (Math.abs(position.x) < range) {
				this.drawVerticalLine(0, 0, height, sceneColor);
				position.x = 0;
				return true;
			}
		}

		if (!skipRight) {
			
			var xr = position.x + size.width;
			if (Math.abs(width - xr) < range) {
				this.drawVerticalLine(width-1, 0, height, sceneColor);
				position.x = width-size.width;
				return true;
			}
		}
		

		if (!skipLeft) {
			
			if (Math.abs(position.x - sceneMargin) < range) {
				this.drawVerticalLine(sceneMargin, 0, height, sceneColor);
				position.x = sceneMargin;
				return true;
			}
		}

		if (!skipRight) {
			
			if (Math.abs(width - xr - sceneMargin) < range) {
				this.drawVerticalLine(width-1 - sceneMargin, 0, height, sceneColor);
				position.x = width-size.width - sceneMargin;
				return true;
			}
		}
};
	

GuidelineController.prototype.guideYPositionForSizeFromSuperview = function GuidelineController__guideYPositionForSizeFromSuperview(position, size, skipMiddle, skipLeft, skipRight) {
	
		if (!skipMiddle) {
			
			var ym = position.y + parseInt(size.height/2);
			if (Math.abs(height_2 - ym) < range) {
				this.drawHorizontalLine(height_2, 0, width, sceneColor);
				position.y = height_2-parseInt(size.height/2);
				return true;
			}
		}
		
		if (!skipLeft) {
			
			if (Math.abs(position.y) < range) {
				this.drawHorizontalLine(.5, 0, width, sceneColor);
				position.y = 0;
				return true;
			}
		}

		if (!skipRight) {
			
			var yb = position.y + size.height;
			if (Math.abs(height - yb) < range) {
				this.drawHorizontalLine(height-.5, 0, width, sceneColor);
				position.y = height-size.height;
				return true;
			}
		}
		
		if (!skipLeft) {
			
			if (Math.abs(position.y - sceneMargin) < range) {
				this.drawHorizontalLine(sceneMargin, 0, width, sceneColor);
				position.y = sceneMargin;
				return true;
			}
		}

		if (!skipRight) {
			
			if (Math.abs(height - yb - sceneMargin) < range) {
				this.drawHorizontalLine(height-sceneMargin, 0, width, sceneColor);
				position.y = height-size.height-sceneMargin;
				return true;
			}
		}
};
	

	

GuidelineController.prototype.guideXPositionForSizeFromNeighbours = function GuidelineController__guideXPositionForSizeFromNeighbours(position, size, skipMiddle, skipLeft, skipRight) {

		var result,
			drawLine = function (neighbour, x) {
				this.drawVerticalLine(x,
					Math.min(position.y, neighbour.y),
					Math.max(neighbour.y + neighbour.h,
							 position.y + size.height),
					neighbourColor);
			}.bind(this);

		if (Array.isArray(neighbours)) neighbours.every(function (neighbour) {

			if (!skipMiddle) {
				
				if (Math.abs(neighbour.xm - position.xm) < range) {
					drawLine(neighbour, neighbour.xm);
					position.x = neighbour.xm - parseInt(size.width/2);
					result = true;
					return false;
				}
			}
		
			if (!skipLeft) {
				
				if (Math.abs(neighbour.x - position.x) < range) {
					drawLine(neighbour, neighbour.x);
					position.x = neighbour.x;
					result = true;
					return false;
				}
			}

			if (!skipRight) {
				
				if (Math.abs(neighbour.xe - position.xe) < range) {
					drawLine(neighbour, neighbour.xe);
					position.x = neighbour.xe - size.width;
					result = true;
					return false;
				}
			}
return true; }, this);
		

		return result;
};
	

GuidelineController.prototype.guideYPositionForSizeFromNeighbours = function GuidelineController__guideYPositionForSizeFromNeighbours(position, size, skipMiddle, skipLeft, skipRight) {

		var result,
			drawLine = function (neighbour, y) {
				this.drawHorizontalLine(y,
					Math.min(position.x, neighbour.x),
					Math.max(neighbour.x + neighbour.w,
							 position.x + size.width),
					neighbourColor);
			}.bind(this);

		if (Array.isArray(neighbours)) neighbours.every(function (neighbour) {

			if (!skipMiddle) {
				
				if (Math.abs(neighbour.ym - position.ym) < range) {
					drawLine(neighbour, neighbour.ym);
					position.y = neighbour.ym - parseInt(size.height/2);
					result = true;
					return false;
				}
			}
		
			if (!skipLeft) {
				
				if (Math.abs(neighbour.y - position.y) < range) {
					drawLine(neighbour, neighbour.y);
					position.y = neighbour.y;
					result = true;
					return false;
				}
			}

			if (!skipRight) {
				
				if (Math.abs(neighbour.ye - position.ye) < range) {
					drawLine(neighbour, neighbour.ye);
					position.y = neighbour.ye - size.height;
					result = true;
					return false;
				}
			}
return true; }, this);
		

		return result;
};
	


	

GuidelineController.prototype.drawVerticalLine = function GuidelineController__drawVerticalLine(x, y1, y2, color) {
		x = parseInt(x*contentScale) + .5;
		y1 = parseInt(y1*contentScale) + .5;
		y2 = parseInt(y2*contentScale) + .5;

		ctx.strokeStyle = color;
		ctx.beginPath();
		ctx.moveTo(x, y1);
		ctx.lineTo(x, y2);
		ctx.stroke();};
	
	
GuidelineController.prototype.drawHorizontalLine = function GuidelineController__drawHorizontalLine(y, x1, x2, color) {
		x1 = parseInt(x1*contentScale) + .5;
		x2 = parseInt(x2*contentScale) + .5;
		y = parseInt(y*contentScale) + .5;

		ctx.strokeStyle = color;
		ctx.beginPath();
		ctx.moveTo(x1, y);
		ctx.lineTo(x2, y);
		ctx.stroke();};
	

GuidelineController.prototype.initPropertiesFromData = function GuidelineController_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("shouldIgnoreSelection")) this.shouldIgnoreSelection = data.shouldIgnoreSelection;
};

GuidelineController.prototype.decodeData = function GuidelineController_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

GuidelineController.prototype.encode = function GuidelineController_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

GuidelineController.prototype.encodeCloned = function GuidelineController_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

GuidelineController.prototype.expectedTypeForProperty = function GuidelineController_expectedTypeForProperty(key) {
	if (key === "shouldIgnoreSelection") return "Boolean";
	if (key === "hidden") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return GuidelineController; }()));