
registerType('appdoo.Editor', (function () { function Inspector() {} var __super = setSupertypeFromDomain(Inspector, 'SegmentedViewController', 'Core.UI');

	var headerHeight = 38,
		bindingsSegmentButton, geometrySegmentButton, propertiesSegmentButton, helpSegmentButton;


	

Inspector.prototype.initFromData = function Inspector_initFromData(data) {

		if (!__super.prototype.initFromData.call(this, data))
			return;

		this.editor = data.editor;
		this.selection = data.selection;
		this.observeObject(data.selection);
	
		this.view.size = data.size;
		this.view.position = data.position;
		this.scrollOffset = { left: 0, top: 0 };
		
		this.initBackgroundView();

		this.contentView.position.top = headerHeight;
		this.contentView.size.height -= (headerHeight-35);
		this.contentView.adjustsSubviewToFitWidth = true;
		this.contentView.style({
			'overflow-y': 'auto',
			'overflow-x': 'hidden',
			backgroundColor: 'transparent',
		});
	
		helpSegmentButton = this.segmentedControl.subviews[3];
		bindingsSegmentButton = this.segmentedControl.subviews[2];
		geometrySegmentButton = this.segmentedControl.subviews[1];
		propertiesSegmentButton = this.segmentedControl.subviews[0];

		this.bindingsArePossible = false;
		
		return this;
};
	
	
Inspector.prototype.initBackgroundView = function Inspector__initBackgroundView() {

		this.backgroundView = createComponentFromDomain("View", "Core.UI", this.context, {
			size: {
				width: this.size.width,
				height: headerHeight-1
			},
			autoresizingMask: 2})
		;
		this.view.insertSubviewAtIndex(this.backgroundView, 0);
		
		var separator = createComponentFromDomain("View", "Core.UI", this.context, {
			size: {width: this.size.width, height:3 },
			position: { top: headerHeight-1, left: 0 },
			autoresizingMask: 2,
			style: {
				borderTop: '1px dashed #ddd',
				opacity: .8
			}})
		;
		this.backgroundView.addSubview(separator);
		};
	

Inspector.prototype.createSegmentedControlData = function Inspector__createSegmentedControlData() {
	
		var selfWidth = this.size.width;
		var width = selfWidth-22;
	
		var data = __super.prototype.createSegmentedControlData.call(this);
		data.size.height = headerHeight;
		data.size.width = width;
		data.position.left = selfWidth/2-width/2;
		data.position.top = -1;
		data.drawsBackground = false;
		data.displaysText = false;
		data.textOffsetY = 2;
		data.fontSize = 10;
		
		return data;
};
	
	


	
	
Inspector.prototype.updateCurrentSegment = function Inspector_updateCurrentSegment(forceRefresh) {
		
		if (!this.selection) return;

		switch (this.segmentedControl.selectedIndex) {
			case 0:
				if (forceRefresh) this.refreshPropertiesSegment();
				else this.updatePropertiesSegment();
				break;
			case 1:
				this.updateGeometrySegment();
				break;
			case 2:
				this.updateBindingsSegment();
				break;
			case 3:
				this.updateHelpSegment();
				break;
			case 4:
				this.updateActionsSegment();
				break;
		}
	};
	

	
	

Inspector.prototype.updatePropertiesSegment = function Inspector__updatePropertiesSegment() {
		
		var selection = this.selection.contents;

		if (arraysAreEqual(this.lastSelection, selection))
			return;
			
		this.lastSelection = selection;

		if (selection.length === 0) return;

		var itemsHaveEqualType = this.selection.itemsHaveEqualUTI,
			currentView = this.contentView.subviews[0],
			componentProperties;
			
		if (itemsHaveEqualType === true) {
			componentProperties = selection[0].inspectorProperties;
		}

		if (componentProperties === undefined) {

			var placeholderText = itemsHaveEqualType ? LocalizedString('No Properties') : LocalizedString('Different Kinds of Objects');

			currentView.removeAllSubviews();
			currentView.autoresizingMask = 18;
			currentView.size.height = 150 - 32;
			currentView.addSubview(createComponentFromDomain(
				'Label', 'Core.UI', this.context,
				{
					size: { width: currentView.superview.size.width },
					position: {
						top: currentView.superview.size.height/2 - 27
						},
					autoresizingMask: 42,
					text: placeholderText,
					style: {
						textAlign: 'center',
						color: '#999',
						textShadow: '0 1px 0 rgba(255,255,255,1)',
						fontSize: '13px'
					}
				}));

			this.componentProperties = null;
			return;
		}

		if (componentProperties === this.componentProperties) return;
		this.componentProperties = componentProperties;
		

		currentView.removeAllSubviews();
		currentView.autoresizingMask = 2;
		
		this.unregisterAllProperties();
		
		
		this.isRebuilding = true;
		
		var propertiesSubview = createComponentFromDomain("StackedView", "Core.UI", this.context, {
			id: 'propertiesSubview',
				size: {
					width: currentView.size.width,
					height: this.contentView.size.height
				},
				autoresizingMask: 2,
				style: {
					'overflow-y': 'hidden',
					'overflow-x': 'hidden'
				},
				delegate: this})
			;

		currentView.addSubview(propertiesSubview);
		this.currentSubview = propertiesSubview;
		this.propertiesSubview = propertiesSubview;

		if (Array.isArray(componentProperties)) componentProperties.every(function (property) {
		
			if (property.type === 'dataSourceGroup') {
				this.addDataSourceGroup();
				return true;
			}

			if (property.type === 'navigationGroup') {
				this.addNavigationGroup();
				return true;
			}

			if (property.type === 'formatGroup') {
				this.addFormatGroup(property);
				return true;
			}
		
			if (property.type !== 'group') {
				return true;
			}
			
			this.addPropertyGroup(property);
			return true; }, this);
		
		
		for (var i = 0, c = propertiesSubview.subviews.length; i !== c; i++) {
			if (this.isPropertyGroupVisible(i) === false)
				propertiesSubview.collapseViewAtIndex(i);
		}
		

		this.isRebuilding = false;
		this.currentSubview.arrangeSubviews();
		this.setPropertiesViewSizeToFit();
		};
	
	
Inspector.prototype.refreshPropertiesSegment = function Inspector__refreshPropertiesSegment() {
		delete this.lastSelection;
		delete this.componentProperties;
		
		if (this.selectedIndex === 0)
			this.updatePropertiesSegment();};
	
	
Inspector.prototype.setPropertiesViewSizeToFit = function Inspector__setPropertiesViewSizeToFit(foo) {
	
		if (this.selectedIndex !== 0) return;
		if (this.isRebuilding) return;
		
		var propertiesSubview = this.propertiesSubview,
			lastGroupView = propertiesSubview.subviews[propertiesSubview.subviews.length-1];
			
		if (!lastGroupView) return;
		
		var height = lastGroupView.position.top + lastGroupView.size.height + 10;
		
		if (propertiesSubview.superview)
			propertiesSubview.superview.size.height = height;

		propertiesSubview.size.height = height;

		this.contentView.layoutSubviews();
};
	

Inspector.prototype.isPropertyGroupVisible = function Inspector__isPropertyGroupVisible(groupIndex) {
		var groupId = this.componentProperties[groupIndex].id;
		return this.collapsedGroups.indexOf(groupId) === -1;};
	
	
	
	
	
Inspector.prototype.updateGeometrySegment = function Inspector__updateGeometrySegment() {
	
		var selection = this.selection,
			data = selection.get('layoutRelations') || [];
		
		if (Array.isArray(selection.items)) selection.items.every(function (item) {
			if (item.layoutRelationsController) {
				this.observeObject(item.layoutRelationsController);
			}return true; }, this);
		
		
		this.areLayoutRelationsEditable = 
			selection.items.length === 1 && 
			isArrayWithValue(selection.get('canHaveLayoutRelations'), true);

		this.areLayoutRelationsAvailable = (this.areLayoutRelationsEditable === true && data.length === 1 && data[0] && data[0].length);

		this.areObjectAlignmentsPossible = arrayHasUniqueValue(selection.get('positionIsEditable'), true) && selection.items.length > 1;

		this.prepareLayoutRelationsForSelection();

		var layoutRelationsDS = this.context.connectableObjects.layoutRelationsDataSource;

		layoutRelationsDS.dataController.contents = data[0];
		
		if (data[0])
			layoutRelationsDS.listView.reloadDataLazy();
		
		this.contentView.layoutSubviews();
};
	
	
Inspector.prototype.layoutRelationDidChange = function Inspector__layoutRelationDidChange() {
		this.editor.updateLayout();};
	
	
Inspector.prototype.updateEditableGeometryPropertiesForItem = function Inspector__updateEditableGeometryPropertiesForItem(item) {
	
		var xIsEditable = true,
			yIsEditable = true;

		if (item.layoutRelations)
		if (Array.isArray(item.layoutRelations)) item.layoutRelations.every(function (lr) {

			var t = lr.type;

			if (t === 'x' || t === 'right')
				xIsEditable = false;
			if (t === 'y' || t === 'below')
				yIsEditable = false;return true; }, this);
		
		
		item.dataController.set({
			xIsEditable: xIsEditable,
			yIsEditable: yIsEditable
		}, item.dataController);};
	
	
Inspector.prototype.prepareLayoutRelationsForSelection = function Inspector__prepareLayoutRelationsForSelection() {
	
		var selectionItems = this.selection.items;

		if (selectionItems.length > 0) {

			
			if (Array.isArray(selectionItems)) selectionItems.every(function (item) {
				
				
				
				this.verifyLayoutRelationsFromItem(item);
				if (!item._didSetEditableGeometryProperties) {
					Object.defineProperty(item, '_didSetEditableGeometryProperties', {value:true})
					this.updateEditableGeometryPropertiesForItem(item);
				}
return true; }, this);
			
			
		}
		};
	
	
Inspector.prototype.prepareLayoutRelationFromItem = function Inspector__prepareLayoutRelationFromItem(layoutRelation, item) {
	
		layoutRelation.identify = function () {};
	
		if (layoutRelation._prepared)
			return false;
		
		(function () {
			var inspector = this;
				
			Object.defineProperty(layoutRelation, '_destination', {
				set: function (value) {
					delete this.destinationObject;
					inspector.setWithRootDataControllerValueForKeyInLayoutRelation(value, 'destination', this);
				},
				get: function () {
					return this.destination;
				}
			});

			Object.defineProperty(layoutRelation, '_type', {
				set: function (value) {
					inspector.setWithRootDataControllerValueForKeyInLayoutRelation(value, 'type', this);
				},
				get: function () {
					return this.type;
				}
			});

			Object.defineProperty(layoutRelation, '_offset', {
				set: function (value) {
					inspector.setWithRootDataControllerValueForKeyInLayoutRelation(value, 'offset', this);
				},
				get: function () {
					return this.offset;
				}
			});

			Object.defineProperty(layoutRelation, 'sourceObject', {
				value: item
			});

			Object.defineProperty(layoutRelation, '_prepared', {
				value: true
			});
			
		}.call(this));
};
	
	
	
	
Inspector.prototype.updateBindingsSegment = function Inspector__updateBindingsSegment() {
		if (this.bindingsView)
			this.bindingsView.update();};
	
	
	
	
Inspector.prototype.updateHelpSegment = function Inspector__updateHelpSegment() {
		if (this.helpView)
			this.helpView.update();};
	
	
	
	
	
Inspector.prototype.setWithRootDataControllerValueForKeyInLayoutRelation = function Inspector__setWithRootDataControllerValueForKeyInLayoutRelation(value, key, layoutRelation) {
		var sourceObject = layoutRelation.sourceObject;
		var index = sourceObject.layoutRelations.indexOf(layoutRelation)
		
		sourceObject.layoutRelationsController.setValueForKeyPath(value, index+'.'+key);};
	

Inspector.prototype.verifyLayoutRelationsFromItem = function Inspector__verifyLayoutRelationsFromItem(item) {
	
		if (item.layoutRelations)
		if (Array.isArray(item.layoutRelations)) item.layoutRelations.every(function (lr) {
			this.prepareLayoutRelationFromItem(lr, item);return true; }, this);
		
};
	
	
	
	Object.defineProperty(Inspector.prototype, "areLayoutRelationsEditable", {
	synthesized: true, 
	observable: true, get:function () { return this._areLayoutRelationsEditable; }, set:function (v) {if (!Object.hasOwnProperty(this, "_areLayoutRelationsEditable")) Object.defineProperty(this, "_areLayoutRelationsEditable", { writable: true, configurable: true }); this._areLayoutRelationsEditable = v; this.context.broadcastValueChangeForKeyPathInObject("areLayoutRelationsEditable", this, this);}});
	

	Object.defineProperty(Inspector.prototype, "areLayoutRelationsAvailable", {
	synthesized: true, 
	observable: true, get:function () { return this._areLayoutRelationsAvailable; }, set:function (v) {if (!Object.hasOwnProperty(this, "_areLayoutRelationsAvailable")) Object.defineProperty(this, "_areLayoutRelationsAvailable", { writable: true, configurable: true }); this._areLayoutRelationsAvailable = v; this.context.broadcastValueChangeForKeyPathInObject("areLayoutRelationsAvailable", this, this);}});
	

	Object.defineProperty(Inspector.prototype, "areObjectAlignmentsPossible", {
	synthesized: true, 
	observable: true, get:function () { return this._areObjectAlignmentsPossible; }, set:function (v) {if (!Object.hasOwnProperty(this, "_areObjectAlignmentsPossible")) Object.defineProperty(this, "_areObjectAlignmentsPossible", { writable: true, configurable: true }); this._areObjectAlignmentsPossible = v; this.context.broadcastValueChangeForKeyPathInObject("areObjectAlignmentsPossible", this, this);}});
	


	

Inspector.prototype.updateActionsSegment = function Inspector__updateActionsSegment() {

		var eventsListView = this.contentView.subviews[0].subviews[0];
		eventsListView.selectRowAtIndexPath({item:0, section:0});
		};
	
	

	
	
// role StackedViewDelegate (Core.UI) 
	
Inspector.prototype.viewIsExpandedAtIndex = function Inspector_viewIsExpandedAtIndex(index) {
			return this.isPropertyGroupVisible(index);};
		
		
Inspector.prototype.viewDidCollapseAtIndex = function Inspector_viewDidCollapseAtIndex(index) {
			var groupId = this.componentProperties[index].id;
			this.collapsedGroups.push(groupId);
			this.setPropertiesViewSizeToFit();	};
		

Inspector.prototype.viewDidExpandAtIndex = function Inspector_viewDidExpandAtIndex(index) {
			var groupId = this.componentProperties[index].id;
			this.collapsedGroups.splice(this.collapsedGroups.indexOf(groupId), 1);
			this.setPropertiesViewSizeToFit();	};
		
	
	

	var indexBefore;
// role SegmentedControlDelegate (Core.UI) 

Inspector.prototype.segmentedControlDidChangeValue = function Inspector_segmentedControlDidChangeValue(sc) {
		
			this.updateSegmentImage();
			__super.prototype.segmentedControlDidChangeValue.call(this, sc);
			
			
			this.updateCurrentSegment(indexBefore === 2); 

			if (sc.selectedIndex === 1) {
				
				
				if (this.selection)
					this.selection.items = this.selection.items;
			}
			
			indexBefore = sc.selectedIndex;
};
		
	
	
Inspector.prototype.updateSegmentImage = function Inspector__updateSegmentImage() {
		var sc = this.segmentedControl;
		
		var i; var s;
		if (Array.isArray(sc.subviews)) sc.subviews.every(function (cell) {
			
			if (cell === propertiesSegmentButton) { s = 'Properties'; i=0; }
			else if (cell === geometrySegmentButton) { s = 'Geometry'; i=1; }
			else if (cell === bindingsSegmentButton) { s = 'Bindings'; i=2; }
			else if (cell === helpSegmentButton) { s = 'Help'; i=3; }
			else {
				return true;
			}

			if (i === this.selectedIndex) {
				cell.image.imageSrc = 'Resources/Inspector'+s+'Selected.png';
			}
			else {
				cell.image.imageSrc = 'Resources/Inspector'+s+'.png';
			}return true; }, this);
		
		};
	
	


	
	
	var leftLabelWidth = 80-5-5-20+8+10,
		shortLabelWidth = 35,
		defaultYOffset = 30;

Inspector.prototype.addPropertyGroup = function Inspector__addPropertyGroup(data) {
	
		if (data.condition) {
		
			var result = true;
			if (Array.isArray(this.selection.items)) this.selection.items.every(function (item) {
				result = result && data.condition(item);return true; }, this);
			
			if (result !== true)
				return;
		
		}
		
		this._y = 5;
		this._x = 0;
		
		var superview = this.currentSubview,
			groupView = createComponentFromDomain("View", "Core.UI", this.context, {
				size: { width: superview.size.width, height: 0 },
				autoresizingMask: 2,
				style: { overflow: 'hidden' }})
			;
		
		this.currentSubview = groupView;
		
		this.addPropertyItems(data.items);

		this.registerPropertyGroup(data.items);
		
		groupView.size.height = this._y - 3;
		superview.arrangeSubviews();

		var view = superview.addViewWithTitle(groupView, data.title);
		
		this.currentSubview = superview;
};
	
	
Inspector.prototype.propertyFromEditableProperty = function Inspector__propertyFromEditableProperty(name, property) {

		
		
		
		

		if (!property) return;

		if (this.presets[property.type])
			return this.presets[property.type][name];};
	
	
Inspector.prototype.addPropertyItems = function Inspector__addPropertyItems(items) {
	
		var selectionItems = this.selection.items;

		if (Array.isArray(items)) items.every(function (property) {
		
			

			var bindingExists = false, theBinding, bindingIndex;

			if (Array.isArray(selectionItems)) selectionItems.every(function (item) {

				theBinding = item.bindingForKey(property.dataKeyPath||keyPathFromProperty(property));
				if (theBinding) {
					bindingExists = true;
					bindingIndex = item.bindings.indexOf(theBinding);
					return false;
				}return true; }, this);
			

			if (bindingExists) {
				this.addBoundProperty(property, theBinding, bindingIndex);
				this._y += defaultYOffset;
				return true;
			}
			
			if (property.condition) {
			
				var result = true;
				if (Array.isArray(this.selection.items)) this.selection.items.every(function (item) {
					result = result && property.condition(item);return true; }, this);
				
				if (result !== true)
					return true;
			
			}

			if (property.hidden) return true;
			
			this.addProperty(property);
			
			if (property.noLinebreak !== true)
				this._y += defaultYOffset;
			return true; }, this);
		
	};
	
	
	var useLabelOnTopLayout = false;

Inspector.prototype.addLeftLabel = function Inspector__addLeftLabel(text, isOnTop, nowrap) {
	
		if (!text) return;

		var size = { height: 22 },
			textAlign,
			left,
			shouldBeSmall = text.length > 20;

		if (isOnTop) {
			size.width = this.view._size.width - 18*2;
			textAlign = 'left';
			left = 26;
		}
		else {
			size.width = leftLabelWidth;
			textAlign = 'right';
			left = 10;
		}
		
		var top = this._y + (shouldBeSmall ? 1 : 0);

		if (useLabelOnTopLayout) {
			isOnTop = true;
			shouldBeSmall = true;
			textAlign = 'left';
			size.width = this.view._size.width - 18*2;
			left = 26;
			top = this._y;
		}
		var l = createComponentFromDomain(
			'Label', 'Core.UI', this.context,
			{
				position: { left: left, top: top },
				size: size,
				style: {
					textAlign: textAlign,
					whiteSpace: (nowrap ? 'nowrap' : 'normal'),
					fontSize: shouldBeSmall ? '11px' : '12px',
				},
				text: text,
			});
		this.currentSubview.addSubview(l);
		
		if (isOnTop) {
			this._y += 16;
		}
		
		return l;};
	
	
Inspector.prototype.addProperty = function Inspector__addProperty(property) {
		
		switch (property.type) {
			case 'boolean':
				this.addBooleanProperty(property);
				break;
			case 'select':
				this.addSelectProperty(property);
				break;
			case 'color':
				this.addColorProperty(property);
				break;
			case 'range':
				this.addRangeProperty(property);
				break;
			case 'textarea':
				this.addTextareaProperty(property);
				break;
			case 'keyValue':
				this.addKeyValueProperty(property);
				break;
			case 'button':
				this.addButton(property);
				break;
			case 'image':
				this.addImageProperty(property);
				break;
			case 'custom':
				this.addCustomProperty(property);
				break;
			case 'number':
				this.addNumberProperty(property);
				break;
			case 'info':
				this.addInfo(property);
				break;
			case 'space':
				this.addSpace();
				break;
			case 'scene':
				this.addSceneProperty(property);
				break;
			case 'action':
				this.addActionProperty(property);
				break;
			case 'view':
				this.addViewProperty(property);
				break;
			case 'dataSource':
				property.objectType = 'dataSource';
				this.addObjectProperty(property);
				break;
			case 'dataSourceContents':
				property.objectType = 'dataSourceContents';
				this.addObjectProperty(property);
				break;
			case 'object':
				this.addObjectProperty(property);
				break;
			case 'fileReference':
				this.addFileReferenceProperty(property);
				break;
			case 'imageURL':
				this.addImageURLProperty(property);
				
				break;
			case 'fileURL':
				this.addFileURLProperty(property);
				break;
			case 'html':
				this.addHTMLProperty(property);
				break;
			case 'promisedObjects':
				this.addPromisedObjectsProperty(property);
				break;
			case 'text':
			case undefined:
				this.addTextProperty(property);
				break;
			default:
				this.addSpecialProperty(property);
		}
	};
	
	
	var rightMargin = 10;

Inspector.prototype.addTextProperty = function Inspector__addTextProperty(theProperty) {
				
		if (theProperty.marginTop) this._y += theProperty.marginTop;

		this.addLeftLabel(theProperty.name, theProperty.labelOnTop);

		var left;
		var top = this._y-5+1;
		var width;

		if (useLabelOnTopLayout || theProperty.labelOnTop) {
			left = 26;
			top = this._y;
			width = this.currentSubview.size.width-left-rightMargin;
		}
		else {
			left = leftLabelWidth+20;
			width = this.currentSubview.size.width-left-rightMargin;
		}

		this.currentSubview.addSubview(createComponentFromDomain(
			'TextField', 'Editor.Inspector', this.context,
			{
				position: { left: left, top: top },
				size: { width: width },
				autoresizingMask: 2,
				"bindings": [
					{ sourceKeyPath:"value", destination:"selection", destinationKeyPath: keyPathFromProperty(theProperty), 
						destinationObject: this.selection,
						bidirectional: true
					}
				],
				disabled: theProperty.disabled || false,
				undefinedValue: theProperty.undefinedValue || '',
				placeholder: theProperty.placeholder
			}));
		
				};
	

Inspector.prototype.addTextareaProperty = function Inspector__addTextareaProperty(theProperty) {

		this.addLeftLabel(theProperty.name, true, true);
		
		var height = theProperty.textFieldHeight || 66;
		if (theProperty.marginTop) this._y += theProperty.marginTop;
		var top = this._y+2;

		var tf = createComponentFromDomain(
			'TextField', 'Editor.Inspector', this.context,
			{
				position: { left: 26, top: top },
				size: { width: this.currentSubview.size.width-rightMargin-20-5, height: height },
				multiLine: true,
				acceptsOnReturn: !theProperty.acceptsReturn,
				autoresizingMask: 2,
				text: theProperty.name,
				"bindings": [
					{ sourceKeyPath:"value", destination:"selection", destinationKeyPath: keyPathFromProperty(theProperty), 
						destinationObject: this.selection,
						bidirectional: true
					}
				],
				autoupdateWithTimer: theProperty.autoupdateWithTimer !== false,
				undefinedValue: '',
				allowTabs: (theProperty.allowTabs!==false),
				placeholder: theProperty.placeholder
			});
		if (theProperty.textareaID) tf.inputNode.id = theProperty.textareaID;
		if (theProperty.spellcheck !== undefined) tf.inputNode.spellcheck = theProperty.spellcheck;
		
		tf.delegate = {
			textFieldDidChangeValue: function (textField) {
				setTimeout(function () {
					if (theProperty.actionKeyPath) {
						if (Array.isArray(this.selection.contents)) this.selection.contents.every(function (selectedItem) {
							var func = selectedItem.get(theProperty.actionKeyPath);
							if (!func) {
								console.warn('The action '+theProperty.actionKeyPath+' is not available in this object.', selectedItem);
								return true;
							}
							func.call(selectedItem);return true; }, this);
						
					}
				}.bind(this), 100);
			}.bind(this)
		};
		
		this.currentSubview.addSubview(tf);
		tf = null;
		
		this._y += height-18+5;};
	


Inspector.prototype.addBooleanProperty = function Inspector__addBooleanProperty(theProperty) {
	
		if (theProperty.marginTop) this._y += theProperty.marginTop;
		

		if (theProperty.moveUp) this._y -= defaultYOffset-8;

		if (theProperty.label) {
			var l = this.addLeftLabel(theProperty.label);
			l.style({ color: '#444' });
		}

		var left = this._x+leftLabelWidth+15+1;
		var top = this._y;
		var width = this.currentSubview.size.width-25-rightMargin-2-35;
		
		if (useLabelOnTopLayout) {
			left = 26;
			top -= 2;
			
			if (theProperty.label && theProperty.forceLeftLabel) {
				top -= 16;
				left += 70-5;
				this._y -= 16;
			}
		} else {
			top -= 1;
			if (theProperty.positionLeft && !theProperty.label) {
				left = 26-4;
				width += 22;
			}
			if (theProperty.alignLabel) left -= 17;
		}
		
		if (theProperty.offsetX) left += theProperty.offsetX;
		if (theProperty.offsetY) top += theProperty.offsetY;
		


		var checkBox = createComponentFromDomain(
			'Checkbox', 'Editor.Inspector', this.context,
			{
				position: { left: left, top: top },
				size: { width: width },
				autoresizingMask: 2,
				title: theProperty.name,
				"bindings": [
					{ sourceKeyPath: "value", destination: "selection", destinationKeyPath: keyPathFromProperty(theProperty), 
						destinationObject: this.selection,
						bidirectional: true,
						valueTransformer: theProperty.valueTransformer
					}
				],
				disabled: theProperty.disabled,
				toolTip: theProperty.toolTip,
				style: {
					fontSize: '11px'
				}
			});
		this.currentSubview.addSubview(checkBox);
		
		this._y -= 10-2;
		
		if (theProperty.conditionalProperties) {
			checkBox.checkboxNode.addEventListener('change', function (e) {
				setTimeout(function () {
					_context.editor.refreshInspector();
				}, 1);
			});
			if (checkBox.value) {
				this._y += defaultYOffset
				this.addPropertyItems(theProperty.conditionalProperties);
				this._y -= defaultYOffset-4;
			}
		}
};
	
	
	function keyPathFromProperty(theProperty) {
		if (theProperty.keyPathPrefix) 
			return theProperty.keyPathPrefix+'.'+theProperty.keyPath;
		return theProperty.keyPath;
	}

Inspector.prototype.addSelectProperty = function Inspector__addSelectProperty(theProperty, isFirstInGroup) {

		if (theProperty.marginTop) this._y += theProperty.marginTop;
		if (theProperty.moveUp) this._y -= 8;
		if (theProperty.isFirstInGroup) this._y -= 5;

		this.addLeftLabel(theProperty.name, theProperty.labelOnTop);
		
		if (useLabelOnTopLayout || theProperty.labelOnTop || theProperty.positionLeft) {
			var left = 26+1;
			var top = this._y;
			var width = this.currentSubview.size.width-25-rightMargin-2;
		}
		else {
			this._y -= 3;
			var left = leftLabelWidth+21-1;
			var top = this._y-1;
			var width = theProperty.width || this.currentSubview.size.width-leftLabelWidth-rightMargin-20;
		}
		
		
		if (theProperty.selectType === 'segments') {


			this.currentSubview.addSubview(createComponentFromDomain(
				'SegmentedControl', 'Editor.Inspector', this.context,
				{
					position: { left: left, top: top+1 },
					size: { width: width-1, height: 22 },
					autoresizingMask: (1 << 1),
					segments: theProperty.options,
					"bindings": [
						{sourceKeyPath:"value", destination: "selection", destinationKeyPath: keyPathFromProperty(theProperty),
						destinationObject: this.selection,
							bidirectional: true
						}
					],
					undefinedValue: theProperty.undefinedValue
				}));
		
		}
		else if(theProperty.numberOfVisibleItems > 1) {
			var height = theProperty.numberOfVisibleItems*18+2;
			
			var dataSource = createComponentFromDomain("SelectTableViewDataSource", "Editor.Inspector", this.context, {
					items: theProperty.options,
					value: this.selection.get(keyPathFromProperty(theProperty)),
					bindings: [{
						sourceKeyPath:"value",
						destinationObject: this.selection,
						destinationKeyPath: keyPathFromProperty(theProperty), 
							bidirectional: true
						}],
					selectionAllowsMultiple: theProperty.multiple})
			;
			
			var columnView = {
						$type: 'View',
						$domain: 'Core.UI',
						size: { width: 200, height: 18 },
						style: {overflow:'hidden'},
						subviews: [
							
							{
								"$type": "Label",
								"$domain": "Core.UI",
								"size": { width: 165+10,height:18},
								autoresizingMask: 2,
								position: {left:15,top:2},
								text: 'TEXT',
								bindings: [{ sourceKeyPath:'text',destination:dataSource.identify(),enumerableItemAccess:true,destinationKeyPath:'name' }],
								style: {fontSize: '11px',color:'',overflow:'hidden',textOverflow:'ellipsis',whiteSpace:'nowrap'},
								normalStyle: {color:'inherit'},
								selectedStyle: {color:'#fff'},
								selectedStyleWithoutFocus: {color:'inherit'},
							}
						]
					};
			
			if (theProperty.showsIcons !== false) {
				columnView.subviews[0].position.left += 15;
				columnView.subviews[0].size.width -= 15;
				var ivSize = { width: 22, height: 20 };
				var ivPosition = { left: 5, top: -1 };
				var ivContentMode = 'scaleAspectFit';
				if (theProperty.squareIcons) {
					ivSize = { width: 16, height: 16 };
					ivPosition = { left: 7, top: 1 };
				}
				columnView.subviews.unshift({
					"$type": "ImageView",
					"$domain": "Core.UI",
					"size": ivSize,
					position: ivPosition,
					contentMode: ivContentMode,
					bindings: [{ sourceKeyPath:'imageSrc',destination:dataSource.identify(),enumerableItemAccess:true,destinationKeyPath:'icon' }],
				});
			}
			if (theProperty.multiple) {

				if (Array.isArray(columnView.subviews)) columnView.subviews.every(function (column) {
					column.position.left += 16;return true; }, this);
				
				columnView.subviews.unshift({
								"$type": "Checkbox",
								"$domain": "Editor.Inspector",
								"size": { width: 22, height: 20 },
								position: { left: 5, top: -1 },
								contentMode: 'scaleAspectFit',
								bindings: [{ sourceKeyPath:'value', destination:dataSource.identify(), enumerableItemAccess:true, destinationKeyPath:'rowIsSelected', bidirectional: true }],
							});
			}
		
			var tableView = createComponentFromDomain("TableView", "Core.UI", this.context, {
				position: { left: left, top: top+3 },
				size: { width: width, height: height },
				style: { backgroundColor:''},
				selectable: true,
				acceptsFocus: false,
				shouldReloadImmediately:true,
				columns: [{
					name:'item',
					caption:'',
					width:1,
					view: columnView
				},
				],
				headerIsHidden: true,
				dataSource: dataSource,
				autoresizingMask: 2})
			;
			
			dataSource.tableView = tableView;

			this.currentSubview.addSubview(tableView);
			
			this._y += height-20;
			
			return tableView;
		
		
		} else {
		
			
			var bindings = theProperty.keyPath ? [
						{
						sourceKeyPath:"value",
						destinationObject: this.selection,
						destinationKeyPath: keyPathFromProperty(theProperty), 
							bidirectional: true
						}
					] : [];
			
			var popUpButton = createComponentFromDomain(
				'PopUpButton', 'Editor.Inspector', this.context,
				{
					position: { left: left, top: top+1 },
					size: { width: width },
					autoresizingMask: (1 << 1),
					items: theProperty.options,
					bindings: bindings,
					undefinedValue: theProperty.undefinedValue,
					inspector: this,
				});
			
			if (theProperty.onChange) {
				popUpButton.DOMNode.addEventListener('change', theProperty.onChange);
			}
		
			this.currentSubview.addSubview(popUpButton);


			popUpButton.updateSuboptions();
			
			return popUpButton;
		
		}
};
	

Inspector.prototype.addRangeProperty = function Inspector__addRangeProperty(theProperty) {

		this.addLeftLabel(theProperty.name);
		
		var currentSubview = this.currentSubview;
		
		if (useLabelOnTopLayout||theProperty.positionLeft) {
			var left = 26-2;
			var sliderWidth = currentSubview.size.width-90-rightMargin;
		
		} else {
			var left = leftLabelWidth+20;
			var sliderWidth = theProperty.width || currentSubview.size.width-left-90-5-10+1+4+27;
		}
		if (theProperty.sliderOnly) sliderWidth += 60;
		if (theProperty.marginRight) sliderWidth -= theProperty.marginRight;
		
		var slider = createComponentFromDomain(
			'Slider', 'Editor.Inspector', this.context,
			{
				position: { left: left, top: this._y-1 },
				size: { width: sliderWidth },
				autoresizingMask: (1 << 1),
				range: theProperty.range,
				"bindings": [
					{sourceKeyPath:"value", destination:"selection", destinationKeyPath: keyPathFromProperty(theProperty), bidirectional: true,
						destinationObject: this.selection
					}
				],
				undefinedValue: theProperty.undefinedValue
			});
		
		var textField = createComponentFromDomain(
			'TextField', 'Editor.Inspector', this.context,
			{
				position: { left: currentSubview.size.width-50-7-10+3-2, top: this._y-4 },
				size: { width: 50 },
				autoresizingMask: 1,
				text: theProperty.name,
				inputType: 'number',
				"bindings": [
					{sourceKeyPath: "value", destination:"selection", destinationKeyPath: keyPathFromProperty(theProperty), 
						bidirectional: true,
						destinationObject: this.selection
					}
				],
				undefinedValue: theProperty.undefinedValue,
				hidden: theProperty.numberField === false
			}
		);
		if(slider.range) {
			textField.range = slider.range;
		}
		if(slider.undefinedValue) {
			textField.undefinedValue = slider.undefinedValue;
		}
		
		slider.textField = textField;
		textField.slider = slider;
		
		slider.DOMNode.addEventListener('input', function (e) {
			var value = this.DOMNode.value;
			this.textField.value = value;
		}.bind(slider));

		textField.addEventListener('input', function (e) {
			var value = this.value;

			if (this.slider.range) {
				if (value < this.slider.range[0]) {
					value = this.slider.range[0];
				}
				if (value > this.slider.range[1]) {
					value = this.slider.range[1];
				}
			}
			this.inputNode.value = value;
			this.slider.DOMNode.value = value;
		});
		
		textField.addEventListener('change', function (e) {
			
			var value = 0;
			if(!isNaN(parseFloat(this.value)) || isFinite(this.value)) {
				value = this.value;
			} else {
				if (this.range) {
					value = this.range[0];
				} else if(this.undefinedValue) {
					value = this.undefinedValue;
				} else {
					value = 0;
				}
			}
			
			if (this.range) {
				if (value < this.range[0]) {
					value = this.range[0];
				} else if (value > this.range[1]) {
					value = this.range[1];
				}
			}
			if (this.onlyPositive) {
				if (value < 0) {
					value = 0;
				}
			}
			if (this.zeroIsInfinite) {
				if (value === 0) {
					this.suffixLabel.text = '∞';
				} else {
					this.suffixLabel.text = this.suffix;
				}
			}
			this.value = value;
			this.slider.DOMNode.value = value;
		});
		
		currentSubview.addSubview(slider);

		if (!theProperty.sliderOnly) {
			currentSubview.addSubview(textField);
		}
		textField = null;
		slider = null;};
	

Inspector.prototype.addColorProperty = function Inspector__addColorProperty(theProperty) {

		var l = this.addLeftLabel(theProperty.name, false, true),
			top, left, width, autoresizingMask;

		if (useLabelOnTopLayout) {
			top = this._y;
			left = 26;
			width = this.currentSubview.size.width-left-15;
			autoresizingMask = 2;
		}
		else {
			if (theProperty.forceLeftLabel) {
				top = this._y-4;
				width = 34;
				left = leftLabelWidth+ 20;
				autoresizingMask = 36;
			}
			else {
				top = this._y;
				left = 42+4;
				width = 34;
				autoresizingMask = 36;
				if (l) {
					l.position.left = 25+leftLabelWidth-5;
					l.position.top += 4;
					l.style({textAlign:'left'});
				}
			}
		}

		var colorPicker = createComponentFromDomain(
			'ColorPicker', 'Editor.Inspector', this.context,
			{
				position: { left: left, top: top },
				size: { width: width, height: 21 },
				autoresizingMask: autoresizingMask,
				items: theProperty.options,
				"bindings": [
					{sourceKeyPath: "value", destination:"selection", destinationKeyPath: keyPathFromProperty(theProperty), 
						destinationObject: this.selection,
						bidirectional: true
					}
				],
				useDropDownMenu: false,
				undefinedValue: theProperty.undefinedValue
			});
		
		this.currentSubview.addSubview(colorPicker);
};
	

Inspector.prototype.addOldColorProperty = function Inspector__addOldColorProperty(theProperty) {

		this.addLeftLabel(theProperty.name);

		var colorPicker = createComponentFromDomain(
			'ColorPicker', 'Editor.Inspector', this.context,
			{
				position: { left: leftLabelWidth+27, top: this._y-3+1 },
				size: { width: 31-2, height: 21-2 },
				items: theProperty.options,
				"bindings": [
					{sourceKeyPath: "value", destination:"selection", destinationKeyPath: keyPathFromProperty(theProperty), 
						destinationObject: this.selection,
						bidirectional: true
					}
				],
				undefinedValue: theProperty.undefinedValue
			});


		var textField = createComponentFromDomain(
			'TextField', 'Editor.Inspector', this.context,
			{
				position: { left: leftLabelWidth+61, top: this._y-4 },
				size: { width: this.currentSubview.size.width-leftLabelWidth-72 },
				autoresizingMask: 2,
				text: theProperty.name,
				"bindings": [
					{sourceKeyPath: "value", destination:"selection", destinationKeyPath: keyPathFromProperty(theProperty), 
						bidirectional: true,
						destinationObject: this.selection
					}
				],
				undefinedValue: theProperty.undefinedValue,
				hidden: theProperty.numberField === false
			});


		this.currentSubview.addSubview(colorPicker);
		this.currentSubview.addSubview(textField);
};
	

Inspector.prototype.addNumberProperty = function Inspector__addNumberProperty(theProperty) {

		this.addLeftLabel(theProperty.name,theProperty.labelOnTop);
		
		var top, width, left, autoresizingMask;
		
		autoresizingMask = 2;
		if (useLabelOnTopLayout || theProperty.labelOnTop) {
			top = this._y;
			width = this.currentSubview.size.width-26-rightMargin;
			left = 26;
		}
		else {
			top = this._y-4;
			width = this.currentSubview.size.width - leftLabelWidth - 20 -rightMargin-1;
			left = leftLabelWidth+20-1+1;
		}
		
		if (theProperty.width) {
			var delta = width-theProperty.width;
			width = theProperty.width;
			left += delta;
			autoresizingMask = 1;
		}
		if (theProperty.offsetY) top += theProperty.offsetY;

		var textField = createComponentFromDomain(
			'TextField', 'Editor.Inspector', this.context,
			{
				position: { left: left, top: top },
				size: { width: width },
				autoresizingMask: autoresizingMask, 
				inputType: 'number',
				step: theProperty.step,
				"bindings": [
					{ sourceKeyPath:"value", destination:"selection", destinationKeyPath: keyPathFromProperty(theProperty), 
						destinationObject: this.selection,
						bidirectional: true
					}
				],
				disabled: theProperty.disabled,
				undefinedValue: theProperty.undefinedValue || 0,
				toolTip: theProperty.toolTip,
			});
		this.currentSubview.addSubview(textField);

		var suffixLabel = createComponentFromDomain(
			'Label', 'Core.UI', this.context,
			{
				size: { width: 100, height: 20 },
				position: { left: left+(width-20-100), top: top+4 },
				autoresizingMask: 1,
				text: theProperty.suffix,
				style: { fontSize: '12px', color: '#888', pointerEvents:'none', textAlign: 'right' }
			});
		if (theProperty.suffix) {
			this.currentSubview.addSubview(suffixLabel);
		}
		
		if (theProperty.zeroIsInfinite) {
			if (!textField.value) suffixLabel.text = '∞';
		}
		
		textField.addEventListener('change', function (e) {
			
			if(!isNaN(parseFloat(textField.value)) && isFinite(textField.value)) {
				textField.value = textField.value;
			} else {
				if (theProperty.range) {
					textField.value = theProperty.range[0];
				} else if(theProperty.undefinedValue) {
					textField.value = theProperty.undefinedValue;
				} else {
					textField.value = 0;
				}
			}
			if (theProperty.range) {
				if (textField.value < theProperty.range[0]) {
					textField.value = theProperty.range[0];
				} else if (textField.value > theProperty.range[1]) {
					textField.value = theProperty.range[1];
				}
			}
			if (theProperty.onlyPositive) {
				if (textField.value < 0) {
					textField.value = 0;
				}
			}
			if (theProperty.zeroIsInfinite) {
				if (textField.value === 0) {
					suffixLabel.text = '∞';
				} else {
					suffixLabel.text = theProperty.suffix;
				}
			}
		});
	};
	

Inspector.prototype.addButton = function Inspector__addButton(theProperty) {

		if (theProperty.marginTop) this._y += theProperty.marginTop;

		var width = theProperty.buttonWidth || 37,
			isRightAligned = theProperty.align === 'right',
			left = isRightAligned ? this.currentSubview.size.width-10-width : this._x + leftLabelWidth + 20,
			autoresizingMask = isRightAligned ? 1 : 0;
		
		if (theProperty.positionLeft) {
			left = 25+1+1;
		}

		if (theProperty.align === 'center') {
			left = this.currentSubview.size.width/2 - width/2 + 10;
			autoresizingMask = 5;
		}

		if (theProperty.left) {
			left = theProperty.left;
		}
	
		var buttonBindings = theProperty.keyPath ? [{
		sourceKeyPath: "state",
						destinationObject: this.selection,
						destinationKeyPath: keyPathFromProperty(theProperty), 
					}] : undefined;
		
		var top = this._y;
		if (theProperty.offsetY) top += theProperty.offsetY;
		
		var button = createComponentFromDomain(
			'Button', 'Editor.Inspector', this.context,
			{
				text: theProperty.caption,
				position: { left: left, top: top },
				size: { width: width, height: theProperty.buttonHeight || 18 },
				autoresizingMask: autoresizingMask,
				title: theProperty.name,
				buttonStyle: theProperty.buttonStyle || 'default',
				buttonType: theProperty.buttonType,
				imageSrc: theProperty.buttonImageSrc,
				toolTip: theProperty.toolTip,
				style: theProperty.style || {
					fontSize: '11px',
					textAlign: 'center'
				},
				disabled: theProperty.disabled,
				action: function () {
					if (theProperty.action) {
						theProperty.action.call(button, this.selection.contents);
						return;
					}

					if (theProperty.actionKeyPath) {
						if (Array.isArray(this.selection.contents)) this.selection.contents.every(function (selectedItem) {
							var func = selectedItem.get(theProperty.actionKeyPath);
							if (!func) {
								console.warn('The action '+theProperty.actionKeyPath+' is not available in this object.', selectedItem);
								return true;
							}
							func.call(selectedItem, this.editor, button);return true; }, this);
						
					}
					
					if (theProperty.keyPath) {
						var value = button.state,
							keyPath = keyPathFromProperty(theProperty);

						if (Array.isArray(this.selection.contents)) this.selection.contents.every(function (selectedItem) {
							selectedItem.setValueForKeyPath(value, keyPath, this);return true; }, this);
						
					}
				}.bind(this),
				"bindings": buttonBindings
			});

		this.currentSubview.addSubview(button);
		
		if (theProperty.noLinebreak !== true) this._y += 4;
};
	
	
Inspector.prototype.addInfo = function Inspector__addInfo(theProperty) {
		if (theProperty.marginTop) this._y += theProperty.marginTop;

		var style = theProperty.style || {};
		if (!style.fontSize) style.fontSize = '11px';
		
		if (theProperty.showIcon) {
			style.background = 'url(Resources/Info@2x.png) no-repeat';
			style.backgroundSize = '16px 16px';
			style.backgroundPosition = '0 0';
			style.paddingLeft = '20px';
		}
		
		var left = theProperty.left || leftLabelWidth+27-5;
		var width = this.currentSubview.size.width-left-rightMargin;
		if (theProperty.positionLeft) { left = 25+1; width +=40+10; }

		var infoView = createComponentFromDomain("View", "Core.UI", this.context, {
			size: { width: width, height: theProperty.height || 18 },
			position: { left: left, top: this._y },
			style: style,
			autoresizingMask: 2})
		;
		
		if (this.selection.items.length > 1 && theProperty.htmlForMultiple !== undefined) {
			infoView.DOMNode.innerHTML = theProperty.htmlForMultiple;
		}
		else infoView.DOMNode.innerHTML = theProperty.html;
		
		this.currentSubview.addSubview(infoView);
		this._y += infoView.size.height-20;};
	

Inspector.prototype.addSpace = function Inspector__addSpace() {
		this._y -= (defaultYOffset-10);};
	

Inspector.prototype.addImageProperty = function Inspector__addImageProperty(theProperty) {

		this.addLeftLabel(theProperty.name);
		var controlSize = theProperty.size || 48*2+16;
		var controlSizeHeight = theProperty.height || controlSize;
		
		var eic = createComponentFromDomain(
			'EditableImageControl', 'appdoo', this.context,
			{
				position: { left: leftLabelWidth+20, top: this._y-4 },
				size: { width: controlSize, height: controlSizeHeight },
				autoresizingMask: 0,
				contentMode: theProperty.contentMode,
				"bindings": [
					{ sourceKeyPath: "imageRef", destination: "selection", destinationKeyPath: keyPathFromProperty(theProperty), 
						destinationObject: this.selection,
						bidirectional: true
					},
					{
						sourceKeyPath: 'disabled',
						destination:"selection",
						destinationKeyPath: '', 
						destinationObject: this.selection,
						valueTransformer: function (a) {
							return !a || a.length !== 1;
						}
					},
				],
				undefinedValue: '',
				fileTypesForImport: theProperty.fileTypesForImport,
				incompatibilityWarning: theProperty.incompatibilityWarning,
				wantsRetinaImage: theProperty.wantsRetinaImage
			}
		);
		if(theProperty.maxImageSize !== undefined) {
			eic.maxImageSize = {width: theProperty.maxImageSize.width, height:theProperty.maxImageSize.height};
		}
		this.currentSubview.addSubview(eic);
			
		if (!theProperty.noChooserButton && theProperty.imageType && theProperty.imageType.indexOf('com.apple.TabBarItemIcon' === 0)) {

			var chooserButton = createComponentFromDomain('IconChooserButton','appdoo',this.context,{
				editableImageControl: eic, 
				imageType: theProperty.imageType, 
				size: { 
					width:0, 
					height:0 
				}, 
				position: {
					left: 144, 
					top:this._y 
				}
			});
			this.currentSubview.addSubview(chooserButton);
		
		}
		
		this._y += controlSizeHeight-20;};
	

Inspector.prototype.addSceneProperty = function Inspector__addSceneProperty(theProperty) {

		var p = clone(theProperty),
			o = [];
		
		if (theProperty.allowsEmptySelection !== false && !theProperty.multiple)
			o.push(['',LocalizedString('(No Selection)')]);
		
		var editedSceneId = this.editor.editedScene.$id;

		if (Array.isArray(this.context.projectScenesController.contents)) this.context.projectScenesController.contents.every(function (scene) {
			o.push([scene.$id, scene.viewController.title]);return true; }, this);
		
		
		p.options = o;
		p.showsIcons = false;
		
		this.addSelectProperty(p);
	};
	

Inspector.prototype.addViewProperty = function Inspector__addViewProperty(theProperty) {
		
		
		var selectionContainsGlobalObject = false;
		if (Array.isArray(this.selection.contents)) this.selection.contents.every(function (object) {
			if (!object.superview && this.context.projectContext.objects.indexOf(object) !== -1) {
				selectionContainsGlobalObject = true;
				return false;
			}return true; }, this);
		

		var p = clone(theProperty),
			o = [];
		
		if (theProperty.canChooseNothing || theProperty.allowsEmptySelection) o.unshift(['',theProperty.emptySelectionTitle|| LocalizedString('(No Selection)')]);
		
		if (!selectionContainsGlobalObject) {
			var editedView = this.editor.editedView;
			if (theProperty.shouldIncludeRootView) {
				o.push([editedView.identify(), editedView.readableValue]);
			}
	
			if (Array.isArray(clone(editedView.subviews).reverse())) clone(editedView.subviews).reverse().every(function (subview) {
				o.push([subview.identify(), subview.readableValue]);return true; }, this);
			
		}
		
		p.options = o;
		
		this.addSelectProperty(p);
	};
	

Inspector.prototype.addActionProperty = function Inspector__addActionProperty(theProperty) {
	
		if (!theProperty.keyPath) theProperty.keyPath = 'actionInfo';
		if (!theProperty.context) theProperty.context = '';
		
		if (Array.isArray(this.selection.contents)) this.selection.contents.every(function (item) {
			if (!item.get(theProperty.keyPath))
				item.setValueForKeyPath(createComponentFromDomain('ActionInfo','appdoo',this.context.projectContext,{}), theProperty.keyPath);return true; }, this);
		

		var parameter1;
		var numberOfPerformableActions = 0;
		var currentActionType = theProperty.currentActionType||this.context.dissolveKeyPathWithContextObject(theProperty.keyPath+'.actionType', this.selection.contents[0]);

		if (currentActionType === 'objectAction') {
			var objID = theProperty.currentActionObjectID||this.context.dissolveKeyPathWithContextObject(theProperty.keyPath+'.objectID', this.selection.contents[0]);
			var obj = this.context.projectContext.connectableObjects[objID] || this.context.projectContext.globals[objID];

			var objectActions = (obj?obj.performableActions:null)||{};
			numberOfPerformableActions = Object.keys(objectActions).length;

			var objectActionOptions = Object.keys(objectActions).map(function (key) {
				var parameters = clone(objectActions[key].parameters);
				if (Array.isArray(parameters)) parameters.every(function (parameter) {
					parameter.keyPath = theProperty.keyPath+'.arguments.'+parameter.key;return true; }, this);
				

				return [key, objectActions[key].name, parameters];
			}.bind(this));

			objectActionOptions.unshift(['',theProperty.emptySelectionTitle|| LocalizedString('(No Selection)')]);
		}
		
		if (numberOfPerformableActions > 10) numberOfPerformableActions = 9.5;
		
		var keyPath = theProperty.actionTypeKeyPath||theProperty.keyPath+'.actionType';
console.log("context: "+theProperty.context);
		return this.addProperty(
			{ name: typeof theProperty.name === 'string'?theProperty.name:LocalizedString('Action'), type: 'select', numberOfVisibleItems: theProperty.numberOfVisibleItems, isFirstInGroup:theProperty.isFirstInGroup, labelOnTop: theProperty.labelOnTop, keyPath: keyPath, options: [

					['',LocalizedString('(No Action)')],

					['showScene',LocalizedString('Show Screen'), [
					  { name: LocalizedString('Screen'), type: 'scene', keyPath: theProperty.keyPath+'.destinationSceneID', numberOfVisibleItems: 1, labelOnTop: true, allowsEmptySelection: true, showsIcons: false },
					  { name: LocalizedString('Modal Presentation'), keyPath: theProperty.keyPath+'.modalTransitionStyle', type: 'select', options: [
					  	  ['-1',LocalizedString('None')],
					  	  ['UIModalTransitionStyleCoverVertical',LocalizedString('Push from Bottom')],
					  	  ['UIModalTransitionStyleFlipHorizontal',LocalizedString('Flip')],
					  	  ['UIModalTransitionStyleCrossDissolve',LocalizedString('Crossfade')]
					    ], numberOfVisibleItems: 4, labelOnTop: true, showsIcons:false },
					    
					    { type: 'space' },
					    { name: LocalizedString('Transfer Data'), type: 'boolean', keyPath: theProperty.keyPath+'.transfersDataAsInput', positionLeft: true, conditionalProperties: [

							{ name: '', keyPath: theProperty.keyPath+'.transferDataSourceID', type: "object", objectType: 'dataSource', numberOfVisibleItems: 4.5, labelOnTop: true, excludeSelection: true, placeholder: LocalizedString('No data source available') },

							{ showIcon: true, type: "info", html: (theProperty.context == 'actionset' ? LocalizedString('Press ⌘+⎇ while performing this action set to make this data available on the target screen') : LocalizedString('⌘+⎇+Click on this button to make this data available on the target screen')), positionLeft: true, height:'35'},

					    ] },
					]],
					
					['navigateBack',LocalizedString('Go Back') ],

					['objectAction',LocalizedString('Perform Object Action'),[
					  { name: '', type: 'object', keyPath: theProperty.actionObjectIDKeyPath||theProperty.keyPath+'.e_objectID', numberOfVisibleItems: 4.5, labelOnTop: true, allowsEmptySelection: false, includesViews: true, showsSelectButton: true, filter: function (obj) {
							if (obj.UTI === 'appdoo.iOS.ActionSet') return true;
							if (obj.UTI === 'info.appdoo-mac.JavaScriptContainer') return true;
							return obj.performableActions && Object.keys(obj.performableActions).length > 0;
						  }, placeholder: LocalizedString('There are no objects with actions on this screen yet.'), isFirstInGroup: true },
					  { name: '', type: 'select', keyPath: theProperty.keyPath+'.objectActionID', numberOfVisibleItems: 1, labelOnTop: true, allowsEmptySelection: false, showsIcons: false, options: objectActionOptions, hidden: !objectActionOptions||objectActionOptions.length < 2 },
					  { type: 'space' },

					] ],
					

				] }
			);};
	
	
	function objectConformsToType(obj, t, f) {
		if (f) return f(obj);
		if (t===undefined) return true;
		if (t==='dataSource' || t==='dataSourceContents') {
			if (obj.storesContents && t==='dataSourceContents') return true;
			return obj.isDataSource || isKindOfType(obj, getType('appdoo.BasicDataSource'));
		}
		if (t===obj.UTI) return true;
		return false;
	}


Inspector.prototype.addFileReferenceProperty = function Inspector__addFileReferenceProperty(theProperty) {
		
		var contentTypeFilter = undefined;
		
		if(theProperty.contentTypeFilter !== undefined) {
			
			contentTypeFilter = theProperty.contentTypeFilter
			
		} else if(theProperty.contentType !== undefined) {
			
			contentTypeFilter = function (contentType) {
				return this.contentType === contentType; 
			}.bind(theProperty);
			
		} else if(theProperty.contentTypes !== undefined) {
			contentTypeFilter = function (contentTypes) {
				if(contentTypes.indexOf(this.contentType) !== -1) {
					console.log(this.contentType+" is allowed");
				} else {
					console.log(this.contentType+" is NOT supported");
				}
				return (contentTypes.indexOf(this.contentType) !== -1 );
			}.bind(theProperty);
			
		}
		
	
		if (!theProperty.multiple) {

			var p = clone(theProperty);
	
			var o = [];
			if (theProperty.canChooseNothing) o.push(['',LocalizedString('(No Selection)')]);
	
			if (Array.isArray(_context.projectContext.fileReferences)) _context.projectContext.fileReferences.every(function (obj) {
				if (theProperty.objectType || theProperty.filter) {
					if (!objectConformsToType(obj, theProperty.objectType, theProperty.filter)) return true;
				}
				if (theProperty.excludeSelection !== false && this.selection.contents.indexOf(obj) !== -1) return true;
				o.push([obj.$id, obj.readableValue, null, obj]);return true; }, this);
			
	
			p.options = o;
	
			var yBefore = this._y;
			var s = this.addSelectProperty(p);
			
			if (p.showsSelectButton) {
				this.addSelectButtonForProperty(p, yBefore, s);
			}
		
		}
		else {
		
			var width = this.currentSubview.size.width-25-rightMargin-1,
				height = theProperty.numberOfVisibleItems*22 || 150;

			var l = createComponentFromDomain("UILabel", "appdoo.iOS", this.context, {
				size: { width: width-20, height: height },
				position: { left: 25+10, top: this._y+0 },
				text: LocalizedString('Drag files into this area'),
				style: { color: 'hsla(210,20%,40%,.75)', textAlign: 'center', pointerEvents: 'none' },
				fontSize: 15,
				autoresizingMask: 2,
				layoutMode: 'multiLine',
				hidden: true})
			;
			
			var a = this.selection.get(keyPathFromProperty(theProperty));
				
			var ds = createComponentFromDomain("InspectorFileReferencesDataSource", "appdoo", this.context, {
				placeholderLabel: l,
				bindings: [{
					sourceKeyPath:"valuesAsString",
					destinationObject: this.selection,
					destinationKeyPath: keyPathFromProperty(theProperty),
					bidirectional: true,
					valueTransformer: function (v) {
						if (Array.isArray(v)) {
							if (v.length === 1) return v[0];
						};
						return v;
					},
					ignoreWhenInitializing: true
				}],
				valuesAsString: a[0],
				contentTypeFilter: contentTypeFilter})
			;

			var ov = createComponentFromDomain("OutlineView", "Core.UI", this.context, {
				size: { width: width, height: height },
				position: { left: 25, top:this._y },
				drawsBackground: true,
				usesAlternatingRowBackgroundColors: true,
				style: { outline:'1px solid #ccc'},
				autoresizingMask: 2,
				dataSource: ds,
				delegate: ds,
                            "draggable" : true,
                            "acceptsDrop" : true,
				selectable: false,
				"cellPrototype" : {
                              "$type" : "View",
                              "$domain" : "Core.UI",
                              "size" : {
                                "height" : 22,
                                "width" : 210
                              },
                              "autoresizingMask" : 2,
                              "subviews" : [
                                {
                                  "$type" : "ImageView",
                                  "$domain" : "Core.UI",
                                  "position" : {
                                    "left" : 18-10,
                                    "top" : -1
                                  },
                                  "size" : {
                                    "width" : 22,
                                    "height" : 20
                                  },
                                  "contentMode" : "scaleAspectFitNoUpscaling",
                                  "bindings" : [
                                    {
                                      "sourceKeyPath" : "imageSrc",
                                      "destination" : ds.identify(),
                                      "destinationKeyPath" : "outlineIconURL",
                                      "enumerableItemAccess" : true,
                                    }
                                  ]
                                },
                                {
                                  "$type" : "Label",
                                  "$domain" : "Core.UI",
                                  "position" : {
                                    "left" : 43-10,
                                    "top" : 2
                                  },
                                  "size" : {
                                    "width" : 152,
                                    "height" : 18
                                  },
                                  "autoresizingMask" : 2,
                                  "numberOfLines": 1,
                                  "text" : "",
                                  "style" : {
                                    "fontSize" : "11px",
                                    "color" : "",
                                    "textShadow" : "none",
                                    "fontWeight" : "",
                                    "boxSizing": "border-box"
                                  },
                                  "selectedStyle" : {
                                    "color" : "white",
                                    "textShadow" : "0 1px 2px rgba(0,0,0,.25)",
                                    "fontWeight" : "bold"
                                  },
                                  "selectedStyleWithoutFocus" : {
                                    "color" : "white",
                                    "textShadow" : "0 1px 2px rgba(0,0,0,.25)",
                                    "fontWeight" : "bold"
                                  },
                                  "bindings" : [
                                    {
                                      "sourceKeyPath" : "text",
                                      "destination" : ds.identify(),
                                      "destinationKeyPath" : "name",
                                      "enumerableItemAccess" : true,
                                    },
                                  ],
                                },
                                {
								  "$type" : "SpriteButton",
								  "$domain" : "Core.UI",
								  "size" : {
									"width" : 14,
									"height" : 14
								  },
								  "position" : {
									"left" : 210-20,
									"top" : 2
								  },
								  "autoresizingMask" : 1,
								  "sprite" : "Resources/RemoveButtonSmall.png",
								  "targetMethod" : "deleteItem",
								  target: ds,
								},
                              ]
                            },
})
			;
			ds.outlineView = ov;

			this.currentSubview.addSubview(ov);
			

			this.currentSubview.addSubview(l);
			
			this._y += height-20;
		
		}
};
	
	
Inspector.prototype.addPromisedObjectsProperty = function Inspector__addPromisedObjectsProperty(theProperty) {

		var width = this.currentSubview.size.width-25-rightMargin-1,
			height = theProperty.numberOfVisibleItems*22 || 150;

		var l = createComponentFromDomain("UILabel", "appdoo.iOS", this.context, {
			size: { width: width-20, height: height },
			position: { left: 25+10, top: this._y+0 },
			text: theProperty.placeholderText||'',
			style: { color: 'hsla(210,20%,40%,.75)', textAlign: 'center', pointerEvents: 'none' },
			fontSize: 15,
			autoresizingMask: 2,
			layoutMode: 'multiLine',
			hidden: true})
		;
		
		var a = this.selection.get(keyPathFromProperty(theProperty));
			
		var ds = createComponentFromDomain("InspectorPromisedObjectsDataSource", "appdoo", this.context, {
			placeholderLabel: l,
			values: a[0],})
		;

		var ov = createComponentFromDomain("OutlineView", "Core.UI", this.context, {
			size: { width: width-3, height: height },
			position: { left: 25+3, top:this._y },
			drawsBackground: true,
			usesAlternatingRowBackgroundColors: true,
			style: { outline:'1px solid #ccc'},
			autoresizingMask: 2,
			dataSource: ds,
			delegate: ds,
			draggable : true,
			acceptsDrop : true,
			selectable: false,
			cellPrototype : {
			  "$type" : "View",
			  "$domain" : "Core.UI",
			  "size" : {
				"height" : 22,
				"width" : 210
			  },
			  "autoresizingMask" : 2,
			  "subviews" : [
				{
				  "$type" : "ImageView",
				  "$domain" : "Core.UI",
				  "position" : {
					"left" : 18-10,
					"top" : -1
				  },
				  "size" : {
					"width" : 22,
					"height" : 20
				  },
				  "contentMode" : "scaleAspectFitNoUpscaling",
				  "bindings" : [
					{
					  "sourceKeyPath" : "imageSrc",
					  "destination" : ds.identify(),
					  "destinationKeyPath" : "outlineIconURL",
					  "enumerableItemAccess" : true,
					}
				  ]
				},
				{
				  "$type" : "Label",
				  "$domain" : "Core.UI",
				  "position" : {
					"left" : 43-10,
					"top" : 2
				  },
				  "size" : {
					"width" : 152,
					"height" : 18
				  },
				  "autoresizingMask" : 2,
				  "numberOfLines": 1,
				  "text" : "",
				  "style" : {
					"fontSize" : "11px",
					"color" : "",
					"textShadow" : "none",
					"fontWeight" : "",
					"boxSizing": "border-box"
				  },
				  "selectedStyle" : {
					"color" : "white",
					"textShadow" : "0 1px 2px rgba(0,0,0,.25)",
					"fontWeight" : "bold"
				  },
				  "selectedStyleWithoutFocus" : {
					"color" : "white",
					"textShadow" : "0 1px 2px rgba(0,0,0,.25)",
					"fontWeight" : "bold"
				  },
				  "bindings" : [
					{
					  "sourceKeyPath" : "text",
					  "destination" : ds.identify(),
					  "destinationKeyPath" : "name",
					  "enumerableItemAccess" : true,
					},
				  ],
			  }
			  ]
			}})
		;
		ds.outlineView = ov;

		this.currentSubview.addSubview(ov);
		this.currentSubview.addSubview(l);
		
		this._y += height-20;
		
		if (theProperty.addRemoveButtons) {

			var addItemButton = createComponentFromDomain("Button", "Core.UI", this.context, {
					imageSrc: this.context.pathForResource('AddButtonMini.png'),
					buttonStyle: 'flat',
					position: { left: this.currentSubview.size.width-10-22,
						top: this._y+3 },
					size: { width: 22, height: 18 },
					autoresizingMask: 1,
					action: function () {
					}})
				;
			this.currentSubview.addSubview(addItemButton);

			var removeItemButton = createComponentFromDomain("Button", "Core.UI", this.context, {
				imageSrc: this.context.pathForResource('RemoveButtonMini.png'),
				buttonStyle: 'flat',
					position: { left: this.currentSubview.size.width-10-22-21,
						top: this._y+3 },
					size: { width: 22, height: 18 },
					autoresizingMask: 1,
				action: function () {
				},
				disabled: true})
			;
			this.currentSubview.addSubview(removeItemButton);
		
		}		
	};
	
	
Inspector.prototype.addObjectProperty = function Inspector__addObjectProperty(theProperty) {

		var p = clone(theProperty),
			o = [];
		
		var editedSceneId = this.editor.editedScene.$id;
		var objects = this.editor.editedScene.objects;
		
		function addSubviewsFromView__toArray__(view, o) {
			if (Array.isArray(view.subviews)) view.subviews.every(function (obj) {
				if (!objectConformsToType(obj, theProperty.objectType, theProperty.filter))
					return true;
				o.push([obj.$id, obj.readableValue, null, obj]);
				addSubviewsFromView__toArray__(obj, o);return true; }, this);
			
		}

		if (theProperty.includesViews) {
			addSubviewsFromView__toArray__(this.editor.editedScene.viewController.view, o);
		}
		
		if (theProperty.includeDynamicContext && _context.editor.isInSubviewEditingMode) {
			o.push(['$dynamic',LocalizedString('Context-sensitive data')]);
		}
		
		
		if (this.context.projectContext.objects.indexOf(this.selection.contents[0]) === -1) {
			if (Array.isArray(this.editor.editedScene.objects)) this.editor.editedScene.objects.every(function (obj) {
				if (!objectConformsToType(obj, theProperty.objectType, theProperty.filter))
					return true;
				if (theProperty.excludeSelection !== false && this.selection.contents.indexOf(obj) !== -1) return true;
				o.push([obj.$id, obj.readableValue, null, obj]);return true; }, this);
			
		}

		if (Array.isArray(this.context.projectContext.objects)) this.context.projectContext.objects.every(function (obj) {
			if (!objectConformsToType(obj, theProperty.objectType, theProperty.filter))
				return true;
			if (theProperty.excludeSelection !== false && this.selection.contents.indexOf(obj) !== -1) return true;
			o.push([obj.$id, obj.readableValue, null, obj]);return true; }, this);
		
		
		if (!o.length) {
			this._y -= (defaultYOffset+4);
			
			if (theProperty.placeholder) {
				var label = createComponentFromDomain('Label', 'Core.UI', this.context, {
					text: theProperty.placeholder,
					size: { width: 180, height: theProperty.placeholderHeight||20 },
					position: { left:26, top: this._y+35 },
					style:{fontSize:'11px',color:'#666'}
				});
				this.currentSubview.addSubview(label);
				this._y += theProperty.placeholderHeight?(theProperty.placeholderHeight+25):45;
			}
			
			return;
		}

		if (theProperty.canChooseNothing || theProperty.allowsEmptySelection) o.unshift(['',theProperty.emptySelectionTitle|| LocalizedString('(No Selection)')]);
		
		p.options = o;
		
		var yBefore = this._y;
		

		var s = this.addSelectProperty(p);

		if (theProperty.showsSelectButton) {
			this.addSelectButtonForProperty(theProperty, yBefore, s);
		}
	};
	
	
Inspector.prototype.addSelectButtonForProperty = function Inspector__addSelectButtonForProperty(theProperty, yBefore, s) {
				s.size.width -= 25;
			
			var y = yBefore + 4+((theProperty.numberOfVisibleItems)*18)/2-9;
	
			
			var extraButton = createComponentFromDomain(
				'SpriteButton', 'Core.UI', this.context,
				{
					position: { left: s.position.right+5+2, top: y },
					size: { width: 18, height: 18 },
					autoresizingMask: 1,
					sprite: 'Resources/SelectObjectButton.png',
					highlightOnMouseOver: true,
					action: function () {
						var selectedItem = this.selection.contents[0];
						if (!selectedItem) return;
						var objID = selectedItem.get(keyPathFromProperty(theProperty));
						if (!objID) return;
						var item = this.context.projectContext.globals[objID];
						this.editor.treeController.beginSelectionChange();
						this.editor.treeController.unselectAll();
						this.editor.treeController.selectValue(item);
						this.editor.treeController.commitSelectionChange(this);
					}.bind(this)
				});
			this.currentSubview.addSubview(extraButton);};
	
	
Inspector.prototype.addImageURLProperty = function Inspector__addImageURLProperty(theProperty) {
		
		if (Array.isArray(this.selection.items)) this.selection.items.every(function (item) {
			var v = item.get(theProperty.keyPath);
			if (typeof v !== 'object' || v === null)
				item.setValueForKeyPath({}, theProperty.keyPath);return true; }, this);
		
		
		var keyPath = theProperty.fileReferenceIDKeyPath || theProperty.keyPath+".localImageObjectID";

		var p = { "keyPath": theProperty.sourceKeyPath || theProperty.keyPath+".source", "type":"select", "name": LocalizedString("Source"), "options":[

			["local", LocalizedString("local"), [
				{
					"multiple": theProperty.multiple,
					"name": "", 
					"keyPath": keyPath, 
					"type": "fileReference", 
					"filter": function (obj) { 
						return obj.isImage || (theProperty.includePDFs && obj.isPDF); 
					}, 
					contentTypeFilter: function (contentType) {
						return contentType && (contentType.indexOf('image/') === 0 || (theProperty.includePDFs && contentType === 'application/pdf'));
					}, 
					"numberOfVisibleItems": 7.5, 
					"labelOnTop": true 
				},






































				
				]],

			["remote", LocalizedString("remote"), [
				{ "name": theProperty.multiple ? LocalizedString("Image URLs, line by line") : LocalizedString("Image URL"), "type":"textarea", "acceptsReturn": true, "keyPath": theProperty.imageURLKeyPath || theProperty.keyPath+".remoteImageURL", "labelOnTop": true, "textFieldHeight":127 }
			]]

		] };
		this.addProperty(p);
	};
	

Inspector.prototype.addFileURLProperty = function Inspector__addFileURLProperty(theProperty) {
		
		if (Array.isArray(this.selection.items)) this.selection.items.every(function (item) {
			var v = item.get(theProperty.keyPath);
			if (typeof v !== 'object' || v === null)
				item.setValueForKeyPath({}, theProperty.keyPath);return true; }, this);
		

		var p = { "keyPath": theProperty.keyPath+".source", "type":"select", "name": LocalizedString("Source"), "options":[

			["local", LocalizedString("local"), [
				{  "multiple": theProperty.multiple,"name": "", "keyPath": theProperty.fileReferenceIDKeyPath || theProperty.keyPath+".localFileID", "type":"fileReference", "filter": theProperty.filter || function (obj) { return true; }, contentTypeFilter: theProperty.contentTypeFilter || function (contentType) { return true; }, "numberOfVisibleItems": 8, "labelOnTop": true }]],

			["remote", LocalizedString("remote"), [
				{ "name": theProperty.multiple ? LocalizedString("URLs zeilenweise") : LocalizedString("URL"), "type":"textarea", "acceptsReturn": true, "keyPath": theProperty.imageURLKeyPath || theProperty.keyPath+".remoteURL", "labelOnTop": true, "textFieldHeight":127 }
			]]

		] };
		this.addProperty(p);
	};
	

Inspector.prototype.addHTMLProperty = function Inspector__addHTMLProperty(theProperty) {
				
		this.addLeftLabel(theProperty.name, true);
		
		var width = this.currentSubview.size.width-25-rightMargin-2-1,
			height = 200;

		this.currentSubview.addSubview(createComponentFromDomain(
			'HTMLEditor', 'Editor.Inspector', this.context,
			{
				position: { left: 25+2, top: this._y+25 },
				size: { width: width, height: height-25 },
				autoresizingMask: 2,
				"bindings": [
					{ sourceKeyPath:"value", destination:"selection", destinationKeyPath: keyPathFromProperty(theProperty), 
						destinationObject: this.selection,
						bidirectional: true
					}
				],
			}));
		
		this._y += height-20;
				};
	

Inspector.prototype.addCustomProperty = function Inspector__addCustomProperty(theProperty) {
	

		if (!theProperty.UTI) theProperty.UTI = 
			theProperty.domain +'.'+ theProperty.componentType;

		this.addLeftLabel(theProperty.name);
		
		var options = theProperty.properties || {
				position: { left: leftLabelWidth+27, top: this._y-4 },
				size: { width: 48, height: 48 },
				autoresizingMask: (1 << 1),
				backgroundSize: { width: 48, height: 49 },
				contentMode: theProperty.contentMode,
				"bindings": [
					{
						sourceKeyPath: theProperty.bindingKey,
						destination: "selection",
						destinationKeyPath: keyPathFromProperty(theProperty), 
						destinationObject: this.selection,
						bidirectional: true,
						valueTransformer: function (a) {
							if (Array.isArray(a)) return a[0];
							return a;
						}
					}
				],
				undefinedValue: ''
			};
		if (!options.position) options.position = {left:0,top:0};
		
		if (theProperty.customOptions)
		for (key in theProperty.customOptions) {
			options[key] = theProperty.customOptions[key];
		}
		
		if (theProperty.center) {
			options.position = { left: (this.contentView.size.width-options.size.width)/2 };
			options.autoresizingMask = 5;
		}
		if (theProperty.left) {
			options.position = theProperty.left;
		}
		options.position.top = this._y+(theProperty.offsetY||0);

		var subview = createComponent(theProperty.UTI, this.context, options);
		if (theProperty.fullWidth) {
			subview.size.width = this.currentSubview.size.width;
		}

		this.currentSubview.addSubview(subview);
		
		this._y += options.size.height-defaultYOffset;};
	
	
Inspector.prototype.addBoundProperty = function Inspector__addBoundProperty(theProperty, binding) {
	
		if (theProperty.boundOffsetY)
			this._y += theProperty.boundOffsetY;
	
		var bindingIndex, i = 0;
		if (Array.isArray(this.selection.items[i].bindableProperties)) this.selection.items[i].bindableProperties.every(function (p) {
			if (p[0] === binding.sourceKeyPath) {
				bindingIndex = i;
				return false;
			}
			i++;return true; }, this);
		

		this.addLeftLabel(theProperty.dataName || theProperty.name);
		
		var text = this.readableDestinationForBinding(binding) || LocalizedString('Value');
		var left = leftLabelWidth + 20;
		
		if (theProperty.positionLeft && !theProperty.name) left = 25;
		
		var inspector = this;
		
		this.currentSubview.addSubview(createComponentFromDomain(
			'BoundPropertyButton', 'appdoo.Editor', this.context,
			{
				position: { left: left, top: this._y-2 },
				size: { width: 200, height: 18+2 },
				text: text,
				action: function () {
					this.mouseIsOver = false;
					inspector.showDataLinksAndHighlight(bindingIndex);
				}
			}));
		};
	
	
Inspector.prototype.showDataLinksAndHighlight = function Inspector_showDataLinksAndHighlight(index) {
		this.selectedIndex = 2;
		setTimeout(function () {
			var bindingsListView = this.contentView.subviews[0].subviews[2];
			if (!isNaN(index) && bindingsListView.highlightRowAtIndexPath) {
				bindingsListView.highlightRowAtIndexPath({
					item: index
				}, 'hsl(259,29%,90%)');
			}
		}.bind(this), 220);};
	
	
	Object.defineProperty(Inspector.prototype, "presets", {
		get: function () {
			if (this._presets)
				return this._presets;
			
			return this._presets = {
				'textAlignment': {
						name: LocalizedString('Alignment'),
						keyPath: 'textAlignment',
						type: 'select',
						selectType: 'segments',
						options: [
							{ value: 'left', caption: LocalizedString('left'), imageSrc: 'Resources/AlignLeft.png', imageSize: { width: 15, height: 8 } },
							{ value: 'center', caption: LocalizedString('centered'), imageSrc: 'Resources/AlignCenter.png', imageSize: { width: 15, height: 8 } },
							{ value: 'right', caption: LocalizedString('right'), imageSrc: 'Resources/AlignRight.png', imageSize: { width: 15, height: 8 } },
						],
						undefinedValue: 'left'
					},
				'fontSize': { name: LocalizedString('Size'), keyPath: 'fontSize', type: 'number', range: [4, 120], suffix:'pt' },
				'font': {
						keyPath: 'fontFamily',
						type: 'select',
						labelOnTop: true,
						positionLeft: true,
						isFirstInGroup: true,
						options: this.fontFamilyOptions,
						undefinedValue: "_DEFAULT_",
					}
			};
		}});
	;
	
Inspector.prototype.addSpecialProperty = function Inspector__addSpecialProperty(theProperty) {
	
		if (!this.presets[theProperty.type]) {
			console.warn('Property preset not available for ', theProperty.type);
			return;
		}

		var preset = clone(this.presets[theProperty.type]);

		
		for (var key in theProperty) {
			if (key !== 'type') preset[key] = theProperty[key];
		}
		
		if (preset.options) {
			if (Array.isArray(preset.options)) preset.options.every(function (option) {
				if (option.length === 3) {
					var suboptions = option[2];
					if (Array.isArray(suboptions)) suboptions.every(function (suboption) {
						suboption.keyPathPrefix = theProperty.keyPathPrefix;return true; }, this);
					
				}return true; }, this);
			
		}
		
		this.addProperty(preset);
};
	
	
	
	
	
Inspector.prototype.addDataSourceGroup = function Inspector__addDataSourceGroup() {
		return;
	
		if (!this.context.isDebugging)
			return;
		
		
		var dataSourceUTIs = [
			'info.appdoo-mac.AtomDataSource',
			'info.appdoo-mac.JSONDataSource',
			'info.appdoo-mac.SQLite3DataSource',
			'info.appdoo-mac.XMLDataSource',
		];
		
		var options = [];
		
		if (Array.isArray(dataSourceUTIs)) dataSourceUTIs.every(function (UTI) {
			var dataSourcePrototype = getType(UTI).prototype;
			options.push(
				[UTI, dataSourcePrototype.readableValue]
			);return true; }, this);
		
	
		var dataSourceIds = [];
		
		if (Array.isArray(this.editor.editedScene.objects)) this.editor.editedScene.objects.every(function (obj) {
			dataSourceIds.push([obj.$id, obj.name]);return true; }, this);
		

		if (Array.isArray(this.context.projectContext.objects)) this.context.projectContext.objects.every(function (obj) {
			dataSourceIds.push([obj.$id, obj.name]);return true; }, this);
		

		if (Array.isArray(dataSourceIds)) dataSourceIds.every(function (groupItem) {
			var infoText;
			var ds = this.context.projectContext.getOrCreateInstance(groupItem[0]);
			if (!ds) {
				infoText = '(nicht vorhanden)';
			}
			else {
				var numberOfItems;
				try { numberOfItems = ds.numberOfItemsInSection(0); }
				catch (err) {}
				if (!numberOfItems) {
					if (numberOfItems === 0)
						infoText = 'No Entries';
					else
						infoText = 'Fehler beim Abrufen';
				}
				else if (numberOfItems === 1) {
					infoText = '1 Eintrag';
				}
				else {
					infoText = LocalizedString1('%1 Entries', numberOfItems);
				}
			}
			groupItem.push([
				{ name: 'Wurzelpfad', keyPath: 'dataSource.rootKeyPath' },
				{ type: 'info', html: ''+infoText+'' },
				{ type: 'button', caption: '/', buttonWidth: 20, buttonStyle: 'rounded', align: 'right', action: function (items) {

					var item = items[0];
					this.editor.dataSourcesController.editDataSource(item.dataSource);
					this.refreshPropertiesSegment();

				}.bind(this) }
			]);return true; }, this);
		

		dataSourceIds.push('-',['','Neue …']);
		
		var dataSourceTypes = [['appdoo.DataSources.AtomDataSource','Atom Feed'], ['appdoo.DataSources.SQLite3DataSource', 'Tabelle (CSV)']],
			dataSourceTypesOpt = [];
			
		if (Array.isArray(dataSourceTypes)) dataSourceTypes.every(function (dsType) {
			var dataSourceIdSelect = { name: '', keyPath: 'dataSourceId', type: 'select', options: dataSourceIds }
			dsType.push([dataSourceIdSelect]);
			dataSourceTypesOpt.push(dsType);return true; }, this);
		

		var detailViewControllers = this.context.projectInstancesController.allViewControllers;
		detailViewControllers.unshift(['','–']);


		var group = {
			title: LocalizedString('Data Source And Navigation'),
			id: 'DataSource',
			items: [
				{ name: LocalizedString('Data Source'), keyPath: 'dataSourceId', type: 'select', options: dataSourceIds },
				{ name: LocalizedString('Go to'), keyPath: 'detailViewControllerId', type: 'select', options: detailViewControllers, undefinedValue: '', miniLabel: true }
			]
		};


		this.addPropertyGroup(group);
		};
	

Inspector.prototype.addNavigationGroup = function Inspector__addNavigationGroup() {
		return;

		var detailViewControllers = this.context.projectInstancesController.allViewControllers;
		detailViewControllers.splice(0, 0, ['','none'], '-');

		var group = {
			title: LocalizedString('Navigation'),
			id: 'navigation',
			items: [
				{ name: LocalizedString('Detail Screen'), keyPath: 'detailViewControllerId', type: 'select', options: detailViewControllers, undefinedValue: '' },
			]
		};
		
		this.addPropertyGroup(group);
	};
	
	
Inspector.prototype.addFormatGroup = function Inspector__addFormatGroup(property) {

		var group = {
				type: 'formatGroup',
				title: LocalizedString('Font'),
				id: 'UILabelFormat',
				items: [
				
					{ type: 'font', keyPathPrefix: property.keyPathPrefix },
					{ type: 'space', keyPathPrefix: property.keyPathPrefix },
					{ type: 'fontSize', keyPathPrefix: property.keyPathPrefix },

				]
			};
		this.addPropertyGroup(group);
};
	

	var infoNotInstalled = { type: 'info', html: LocalizedString('This font is not installed on this Computer.'), height:50, showIcon:true };
	var cachedFontFamilyOptions;
	
Inspector.prototype.resetFontCache = function Inspector_resetFontCache() {
		cachedFontFamilyOptions = null;
		this._presets = null;};
	

	Object.defineProperty(Inspector.prototype, "fontFamilyOptions", {
		get: function () {

			if (cachedFontFamilyOptions) return cachedFontFamilyOptions;
			
			var data = window.iOS6FontsByFamily,
				r = [],
				i = 0;
			
			if (Array.isArray(data)) data.every(function (font) {
			
				var variantOptions = [];
				for (var variant in font.variants) {
					var v = [font.variants[variant], LocalizedString(variant)];
					if (!this.context.nativeProxy.sendMessage('isFontInstalled', realIOSFont(font.variants[variant])))
						v.push([infoNotInstalled]);
					variantOptions.push(v);
				}
				
				var suboptions = [{
						name: "",
						keyPath: "fontName",
						type: 'select',
						positionLeft: true,
						options: variantOptions,
						moveUp: true
					}];

				r.push([font.name, font.name, suboptions]);
				if (i === 0) {
					r.push('-');
					
					var fontNames = [];
					if (Array.isArray(this.context.projectContext.fileReferences)) this.context.projectContext.fileReferences.every(function (ref) {
						if (!ref.isFont) return true;
						var info = ref.fontInfo;
						if (info) fontNames.push(info.name);return true; }, this);
					
					if (fontNames.length) {
						if (Array.isArray(fontNames)) fontNames.every(function (fontName) {
							r.push([fontName, fontName]);
							i++;return true; }, this);
						
						r.push('-');
					}
				}
				
				i++;return true; }, this);
			
			
			cachedFontFamilyOptions = r;
			return r;
		}});
	


	

Inspector.prototype.registerPropertyGroup = function Inspector__registerPropertyGroup(propertyGroup) {
		if (!this.regiteredProperties) {
			this.regiteredProperties = [];
		}

		var selectionController = this.editor.selection;

		if (Array.isArray(propertyGroup)) propertyGroup.every(function (property) {
			selectionController.observeProperty(property.keyPath);
			this.regiteredProperties.push(property);return true; }, this);
		};
	
	
Inspector.prototype.unregisterAllProperties = function Inspector__unregisterAllProperties() {
	
		var selectionController = this.editor.selection;
		
		if (this.regiteredProperties) {
			if (Array.isArray(this.regiteredProperties)) this.regiteredProperties.every(function (property) {
				selectionController.unobserveProperty(property.keyPath);return true; }, this);
			
		}
		
		delete this.regiteredProperties;};
	
	
	
	
	
Inspector.prototype.setSuboptionsForControl = function Inspector_setSuboptionsForControl(control, suboptions) {
	
		var propertiesView = this.contentView.subviews[0].subviews[0],
			groupView = control.superview;
		
		if (!groupView) {
			return;
		}
		
		if (control.suboptions === suboptions) return;
		
		if (control.suboptionsView) {
		
			var height = control.suboptionsView.size.height;

			
			var subviewIndex = groupView.subviews.indexOf(control);
			for (var i = subviewIndex+1, c = groupView.subviews.length; i < c; i++) {
				groupView.subviews[i].position.top -= height;
			}

			groupView.size.height -= height;
			groupView.superview.size.height -= height;
			
			control.suboptionsView.removeFromSuperview();
			delete control.suboptionsView;
			if (propertiesView && propertiesView.arrangeSubviews)
				propertiesView.arrangeSubviews();
			this.setPropertiesViewSizeToFit();

		}
			
		if (suboptions !== null) {
		
		
			var suboptionsView = createComponentFromDomain("View", "Core.UI", this.context, {
				position: { top: control.position.top + 33 },
				size: { width: this.currentSubview._size.width, height: 0 },
				autoresizingMask: 2})
			;
			groupView.addSubview(suboptionsView);
			control.suboptionsView = suboptionsView;
			
			var yBefore = this._y,
				subviewBefore = this.currentSubview;

			this._y = 0;
			this.currentSubview = suboptionsView;
			
			this.addPropertyItems(suboptions);
			
			var height = this._y;
			
			suboptionsView.size.height = height;
			groupView.size.height += height;
			if (groupView.superview) {
				groupView.superview.size.height += height;
			}

			
			var subviewIndex = groupView.subviews.indexOf(control);
			for (var i = subviewIndex+1, c = groupView.subviews.length-1; i < c; i++) {
				groupView.subviews[i].position.top += height;
			}
			
			this._y = yBefore + height;
			this.currentSubview = subviewBefore;
			
			if (propertiesView && propertiesView.arrangeSubviews)
				propertiesView.arrangeSubviews();

			this.setPropertiesViewSizeToFit(true);

		}

		control.suboptions = suboptions;
		};
	
	
	
	var arraysAreEqual = function (a1, a2) {
		if (!a1 || !a2) return;
		if (a1.length !== a2.length) return false;
		for (var i = 0, c = a1.length; i < c; i++) {
			if (a1[i] !== a2[i]) return false;
		}
		return true;
	};
	
// role Observer (Core) 

Inspector.prototype.observedObjectValuesDidReplace = function Inspector_observedObjectValuesDidReplace(obj, sender) {

			this.checkIfBindingsArePossible();
			this.checkIfGeometryIsAvailable();
			this.updateCurrentSegment();
};
		
		
Inspector.prototype.observedObjectValueDidAppearForKey = function Inspector_observedObjectValueDidAppearForKey(obj, key, sender) {
			if (obj.controllerKey === 'layoutRelationsController') {
				this.updateEditableGeometryPropertiesForItem(obj.get(key).sourceObject);
			   	this.updateGeometrySegment();
			}};
		

Inspector.prototype.observedObjectValueDidDisappearForKey = function Inspector_observedObjectValueDidDisappearForKey(obj, value, key, sender) {
			if (obj.controllerKey === 'layoutRelationsController') {
				this.updateEditableGeometryPropertiesForItem(value.sourceObject);
			   	this.updateGeometrySegment();
			}};
		

Inspector.prototype.observedObjectValueDidChangeForKeyPath = function Inspector_observedObjectValueDidChangeForKeyPath(obj, keyPath, sender) {
			if (obj.controllerKey === 'layoutRelationsController') {
				this.layoutRelationDidChange();

				var keys = keyPath.split('.');
				if (keys[1] === 'type')
					this.updateEditableGeometryPropertiesForItem(obj.get(keys[0]).sourceObject);
			}};
		

	
	
	
	

Inspector.prototype.readableDestinationForBinding = function Inspector__readableDestinationForBinding(binding) {
		
		if (binding.destinationKeyPath === 'contents') {
		
			if (binding.destinationObject)
				return binding.destinationObject.readableValue;
		
			if (binding.destination.indexOf('Input') !== -1) return '';
			
		}

		if (binding.destinationObject && binding.destinationObject.readableNameForProperty) {
			var text = binding.destinationObject.readableNameForProperty(binding.destinationKeyPath);
			
			if (text) return text;
		}
	
		var pathComponents = binding.destinationKeyPath.split('.');
		return pathComponents[pathComponents.length-1];
};
	


	

	Object.defineProperty(Inspector.prototype, "collapsedGroups", {
	synthesized: true, 
		get: function () {
			return this._collapsedGroups || ['UILabelShadow','UILabelAdvanced','UIViewControllerTitleBar','UIViewControllerTitleBarAppearance'];
		}, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_collapsedGroups")) Object.defineProperty(this, "_collapsedGroups", { writable: true, configurable: true });
			this._collapsedGroups = v;
			this.updateCurrentSegment();
		}});
	

	Object.defineProperty(Inspector.prototype, "bindingsArePossible", {
	synthesized: true, 
	observable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_bindingsArePossible")) Object.defineProperty(this, "_bindingsArePossible", { writable: true, configurable: true });
			if (this._bindingsArePossible === v) return;
			this._bindingsArePossible = v;
			return;
			if (!v) {
				if (this.selectedIndex === 3)
					this.selectedIndex = 0;
				bindingsSegmentButton.disabled = true;
			}
			else {
				bindingsSegmentButton.disabled = false;
				this.updateSegmentImage();
			}
			this.checkSegmentedControl();
		this.context.broadcastValueChangeForKeyPathInObject("bindingsArePossible", this, this);}, get:function () { return this._bindingsArePossible; }});
	

	Object.defineProperty(Inspector.prototype, "geometryIsAvailable", {
	synthesized: true, 
	observable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_geometryIsAvailable")) Object.defineProperty(this, "_geometryIsAvailable", { writable: true, configurable: true });
			if (this._geometryIsAvailable === v) return;
			this._geometryIsAvailable = v;
			return;
			if (!v) {
				if (this.selectedIndex === 1)
					this.selectedIndex = 0;
				geometrySegmentButton.disabled = true;
			}
			else {
				geometrySegmentButton.disabled = false;
			}
			this.checkSegmentedControl();
		this.context.broadcastValueChangeForKeyPathInObject("geometryIsAvailable", this, this);}, get:function () { return this._geometryIsAvailable; }});
	

Inspector.prototype.checkIfBindingsArePossible = function Inspector__checkIfBindingsArePossible() {
		this.allBindableProperties = [];
		var bps = this.selection.get('bindableProperties');
		bps = bps[0];
		this.allBindableProperties = clone(bps);
		this.bindingsArePossible = (bps && bps.length > 0) && this.selection.items.length === 1;};
	
	
Inspector.prototype.checkIfGeometryIsAvailable = function Inspector__checkIfGeometryIsAvailable() {
		this.geometryIsAvailable = this.selection.getSingle('positionIsEditable') || this.selection.getSingle('sizeIsEditable') || false;};
	
	
Inspector.prototype.checkSegmentedControl = function Inspector__checkSegmentedControl() {
		return;
		if (this.segmentedControl.subviews.length === 1) {
			if (!this.segmentedControl.hidden) {
				this.segmentedControl.hidden = true;
				this.backgroundView.hidden = true;
				this.contentView.position.top = 0;
				this.contentView.size.height += headerHeight;
			}
		}
		else {
			if (this.segmentedControl.hidden) {
				this.segmentedControl.hidden = false;
				this.backgroundView.hidden = false;
				this.contentView.position.top = headerHeight;
				this.contentView.size.height -= headerHeight;
			}
		}};
	
	
	

Inspector.prototype.addRelation = function Inspector_addRelation(sender) {

		var selectedItem = this.selection.items[0];

		var layoutRelation = {
			type: 'below',
			offset: 10
		};

		this.context.projectContext.identify(layoutRelation);
		this.prepareLayoutRelationFromItem(layoutRelation, selectedItem);

		selectedItem.layoutRelationsController.addValue(layoutRelation, sender);
};
	

Inspector.prototype.deleteRelation = function Inspector_deleteRelation(sender) {
		
		var layoutRelation = sender.superview.superview.dataset;
		
		if (!layoutRelation.sourceObject) {
			console.error('Source object missing in layout relation.');
			return;
		}
		
		layoutRelation.sourceObject.layoutRelationsController.removeValue(layoutRelation, sender);
		};
	
	
Inspector.prototype.alignSelectionFromButton = function Inspector_alignSelectionFromButton(button) {
		
		switch (button.tag) {
			case 0:
				this.selection.alignSelectionHorizontally();
				break;
			case 1:
				this.selection.alignSelectionLeft();
				break;
			case 2:
				this.selection.alignSelectionRight();
				break;
			case 3:
				this.selection.alignSelectionVertically();
				break;
			case 4:
				this.selection.alignSelectionTop();
				break;
			case 5:
				this.selection.alignSelectionBottom();
				break;
		}
		
		this.updateGeometrySegment();
};
	

Inspector.prototype.expectedTypeForProperty = function Inspector_expectedTypeForProperty(key) {
	if (key === "areLayoutRelationsEditable") return "";
	if (key === "areLayoutRelationsAvailable") return "";
	if (key === "areObjectAlignmentsPossible") return "";
	if (key === "presets") return "";
	if (key === "fontFamilyOptions") return "";
	if (key === "collapsedGroups") return "";
	if (key === "bindingsArePossible") return "";
	if (key === "geometryIsAvailable") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return Inspector; }()));
registerType('appdoo', (function () { function LayoutRelationsListView() {} var __super = setSupertypeFromDomain(LayoutRelationsListView, 'ListView', 'Core.UI');

	Object.defineProperty(LayoutRelationsListView.prototype, "addButton", {
	outlet: true, get:function () { return this._addButton; }, set:function (v) {if (!Object.hasOwnProperty(this, "_addButton")) Object.defineProperty(this, "_addButton", { writable: true, configurable: true }); this._addButton = v; }});
	

LayoutRelationsListView.prototype.setHeightToFit = function LayoutRelationsListView__setHeightToFit() {
		__super.prototype.setHeightToFit.call(this);
		if (this.addButton) {
			this.addButton.position.top = this.size.height ? this.position.bottom + 10 : 8;
			
		}};
	

LayoutRelationsListView.prototype.initPropertiesFromData = function LayoutRelationsListView_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("addButton")) this.addButton = data.addButton;
};

LayoutRelationsListView.prototype.decodeData = function LayoutRelationsListView_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
if (data.hasOwnProperty("addButton")) decoded.addButton = this.context.decodeObjectTree(data.addButton);
return decoded; };

LayoutRelationsListView.prototype.encode = function LayoutRelationsListView_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

LayoutRelationsListView.prototype.encodeCloned = function LayoutRelationsListView_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

LayoutRelationsListView.prototype.expectedTypeForProperty = function LayoutRelationsListView_expectedTypeForProperty(key) {
	if (key === "addButton") return "Core.UI.Button";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return LayoutRelationsListView; }()));
registerType('Editor.Inspector', (function () { function HTMLEditor() {} var __super = setSupertypeFromDomain(HTMLEditor, 'View', 'Core.UI');

	Object.defineProperty(HTMLEditor.prototype, "inputNode", {
	synthesized: true, get:function () { return this._inputNode; }, set:function (v) {if (!Object.hasOwnProperty(this, "_inputNode")) Object.defineProperty(this, "_inputNode", { writable: true, configurable: true }); this._inputNode = v; }});
	

HTMLEditor.prototype.init = function HTMLEditor_init() {
		__super.prototype.init.call(this);
		
		this.inputNode = document.createElement('div');
		this.style.call({DOMNode:this.inputNode},{
			backgroundColor:'#fff',
			webkitUserSelect: 'auto',
			overflow: 'auto',
			border: '1px solid #ccc',
			boxSizing: 'border-box',
			outline: 'none'
		});
		this.DOMNode.appendChild(this.inputNode);
		this.DOMNode.class += ' selectable';
		this.acceptsFocus = true;
		return this;};
	
	
HTMLEditor.prototype.paste = function HTMLEditor_paste() {};
	

HTMLEditor.prototype.canSelectAll = function HTMLEditor_canSelectAll() {
		return true;};
	

HTMLEditor.prototype.selectAll = function HTMLEditor_selectAll(sender) {
		document.execCommand('selectall');};
	
	
HTMLEditor.prototype.copy = function HTMLEditor_copy() {
		document.execCommand('copy');};
	

HTMLEditor.prototype.cut = function HTMLEditor_cut() {
		document.execCommand('cut');};
	
	
	Object.defineProperty(HTMLEditor.prototype, "value", {
		set: function (v) {
			this.inputNode.innerHTML = v;
		}, 
		get: function () {
			return this.inputNode.innerHTML;
		}});
	

HTMLEditor.prototype.expectedTypeForProperty = function HTMLEditor_expectedTypeForProperty(key) {
	if (key === "inputNode") return "";
	if (key === "value") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return HTMLEditor; }()));
registerType('appdoo', (function () { function IconChooserButton() {} var __super = setSupertypeFromDomain(IconChooserButton, 'View', 'Core.UI');

	Object.defineProperty(IconChooserButton.prototype, "editableImageControl", {
	outlet: true, get:function () { return this._editableImageControl; }, set:function (v) {if (!Object.hasOwnProperty(this, "_editableImageControl")) Object.defineProperty(this, "_editableImageControl", { writable: true, configurable: true }); this._editableImageControl = v; }});
	
	
	Object.defineProperty(IconChooserButton.prototype, "imageType", {
	outlet: true, get:function () { return this._imageType; }, set:function (v) {if (!Object.hasOwnProperty(this, "_imageType")) Object.defineProperty(this, "_imageType", { writable: true, configurable: true }); this._imageType = v; }});
	

	var panel, panelIsShown;
	
IconChooserButton.prototype.init = function IconChooserButton_init() {
		__super.prototype.init.call(this);

		this.style({
			border: '1px solid rgba(0,0,0,.1)',
			borderRadius: '5px',
			boxSizing: 'border-box'
		});
		this.size = {width:60,height:20};
		var label = createComponentFromDomain("Label", "Core.UI", this.context, {
			size:this.sizeCopy,
			position: {top: 2},
			text: LocalizedString('Choose…'),
			style: {fontSize:'11px',textAlign:'center'}})
		;
		this.addSubview(label);
		
		var didClick;
		this.DOMNode.onmousedown = function () {
			didClick = false;
			this.style({boxShadow:'',backgroundColor:'rgba(0,0,0,.1)'});
			window.onmouseup = function () {
				this.style({boxShadow:'',backgroundColor:''});
				window.onmouseup = null;
				setTimeout(function () {
					if (!didClick) this.hidePanel();
				}.bind(this), 1);
			}.bind(this);
			if (panelIsShown) this.hidePanel();
			else this.showPanel();
		}.bind(this);
		this.DOMNode.onclick = function () {
			didClick = true;
		};

		this.identify();
		
		return this;};
	
	
IconChooserButton.prototype.showPanel = function IconChooserButton_showPanel() {
		if (!this.DOMNode) return;

		if (!panel) this.createPanel();
		else this.populatePanel();
		panel.selectedIconTag = -1;

		var rootView = _context.editor.view;
		rootView.addSubview(panel);
		
		var top = -this.getRelativeY(0)+this.size.height;
		if (top+panel.size.height>rootView.size.height) {
			top = rootView.size.height-panel.size.height;
		}
		
		panel.position = {
			right: 10,
			top: top
		};
		panelIsShown = true;

		panel.DOMNode.onmousedown = function (e) {
			e.stopPropagation();
		}.bind(this);

		panel.DOMNode.onmouseup = function () {
			this.performSelection();
		}.bind(this);
		
		this.hidePanelOnClickEventHandler =  function (e) {
			this.hidePanel();
		}.bind(this);
		this.hidePanelOnEscapeEventHandler = function (e) {
			if (this.context.isCancelEvent(e)) {
				this.hidePanel();
				e.preventDefault();
			}
		}.bind(this);
		
		setTimeout(function () {
			document.body.addEventListener('mousedown', this.hidePanelOnClickEventHandler);
	    	window.addEventListener('keypress', this.hidePanelOnEscapeEventHandler);
	    }.bind(this));};
	

IconChooserButton.prototype.hidePanel = function IconChooserButton_hidePanel() {
		if (panel) {
			panel.removeFromSuperview(true);
			document.body.removeEventListener('mousedown', this.hidePanelOnClickEventHandler);
			window.removeEventListener('keypress', this.hidePanelOnEscapeEventHandler);
		}
		panelIsShown = false;};
	
	
IconChooserButton.prototype.createPanel = function IconChooserButton__createPanel() {
		panel = createComponentFromDomain("View", "Core.UI", this.context, {
			size: {width: 40*4+10, height: 200},
			style: {backgroundColor:'#eee',borderRadius:'5px',
			boxShadow: '0 8px 15px rgba(0,0,0,.2)',
			border:'1px solid rgba(0,0,0,.15)'},})
		;
		this.populatePanel();};
	
	
	var icons = [
		{ id: 'UITabBarBookmarksTemplate', hasSelectedVariant: true },
		{ id: 'UITabBarContactsTemplate', hasSelectedVariant: true },
		{ id: 'UITabBarDownloadsTemplate', hasSelectedVariant: true },
		{ id: 'UITabBarFavoritesTemplate', hasSelectedVariant: true },
		{ id: 'UITabBarHistoryTemplate', hasSelectedVariant: true },
		{ id: 'UITabBarMostViewedTemplate', hasSelectedVariant: true },
		{ id: 'UITabBarSearchTemplate', hasSelectedVariant: true },
	];
	
IconChooserButton.prototype.populatePanel = function IconChooserButton__populatePanel() {
		panel.removeAllSubviews();
		var padding = 10;
		var x = padding, y = 5, i = 0;
		var projectFiles = [];

		if (Array.isArray(_context.projectContext.fileReferences)) _context.projectContext.fileReferences.every(function (obj) {
			if (obj.isImage) {
				var size = obj.imageSize;
				if (size.width > 0 && size.width <= 60 &&
					size.height > 0 && size.height <= 60) {
						projectFiles.push(obj);
				}
			}return true; }, this);
		

		if (projectFiles.length) {
			y += 5;
			panel.addSubview(this.createLabel(LocalizedString('Projekt'), y));
			y += 20;
			if (Array.isArray(projectFiles)) projectFiles.every(function (obj) {
	
				if (x+30 > panel.size.width) {
					x = padding;
					y += 30 + padding;
				}
						

				var canvasView = this.createCanvasView(obj.filePath, null, x, y, obj.$id, obj.name);
			
				panel.addSubview(canvasView);
				x += 30 + padding;return true; }, this);
			
			y += 30+padding;
		}
		
		if (this.imageType === 'com.apple.TabBarItemIcon') {
			y += 5;
				panel.addSubview(this.createLabel(LocalizedString('System Icons'), y));
				y += 20;
			
					
			x = padding;
	
			if (Array.isArray(icons)) icons.every(function (icon) {
	
				if (x+30 > panel.size.width) {
					x = padding;
					y += 30 + padding;
				}
				
				var canvasView = this.createCanvasView('PlugIns/IconLibrary.cpsplugin/Shared/'+icon.id+'@2x.png', 'PlugIns/IconLibrary.cpsplugin/Shared/'+icon.id+'Selected@2x.png', x, y, i);
				
				panel.addSubview(canvasView);
				
				x += 30 + padding;
				i++;return true; }, this);
			
			
			y+=30+padding+2;
		}
		
		var height = y;
		
		var buttonBorderColor = 'transparent';
		var importButton = createComponentFromDomain("Button", "Core.UI", this.context, {
			size: { width: panel.size.width-10, height: 20 },
			position: { top: y, left: 5 },
			autoresizingMask: 2,
			text: LocalizedString('Load From File …'),
			align: 'left',
			style: { backgroundColor: '', textAlign:'left', borderRadius:'2px', boxSizing:'border-box',border:'1px solid '+buttonBorderColor },})
		;
		panel.addSubview(importButton);
		importButton.DOMNode.onmouseover = function (e) {
			importButton.style({ backgroundColor: 'hsl(209,100%,47%)', color: '#fff',borderColor:'hsl(209,100%,47%)' });
		};
		importButton.DOMNode.onmouseout = function (e) {
			importButton.style({ backgroundColor: '', color: '',borderColor:buttonBorderColor });
		};
		importButton.DOMNode.onmouseup = function (e) {
			setTimeout(function () {
				this.editableImageControl.loadFromFile();
			}.bind(this), 10);
		}.bind(this);
		
		height += 25;
		
		panel.size.height = height;
		};
	
	
IconChooserButton.prototype.createCanvasView = function IconChooserButton__createCanvasView(imageSrc, onImageSrc, x, y, tag, name) {
	
		
			var canvasView = createComponentFromDomain("CanvasView", "Core.UI", this.context, {
				size: { width: 30+10, height: 30+10 },
				position: { left: x-5, top: y-5 },})
			;
			
			if (name) canvasView.DOMNode.title = name;
			canvasView.imageSrc = imageSrc;
			if (onImageSrc)
				canvasView.onImageSrc = onImageSrc;
			else
				canvasView.onImageSrc = imageSrc;

			canvasView.tag = tag;
			canvasView.draw = function (width, height) {
				
				this.context.whenImageIsReady(this.imageSrc, function (img) {
					this.context.whenImageIsReady(this.onImageSrc, function (img2) {
						if (!this.DOMNode) return;
						var ctx = this.DOMNode.getContext('2d');
						ctx.save();
						ctx.scale(this.contentScale,this.contentScale);
						
						if (this.isActive) {
							ctx.fillStyle = 'hsl(209,100%,47%)';
							ctx.roundRect(0, 0, width, height, 2);
							ctx.fill();
							ctx.restore();
							ctx.globalCompositeOperation = 'destination-out';
						}
						else {
							ctx.fillStyle = 'hsl(0,0%,20%)';
							ctx.fillRect(0, 0, width, height);
							ctx.restore();
							ctx.globalCompositeOperation = 'destination-in';
						}

						ctx.scale(this.contentScale,this.contentScale);
						
						var image = this.isActive ? img2 : img;
						var w = image.width/2, h = image.height/2;

						ctx.drawImage(image, Math.round(width/2-w/2), Math.round(height/2-h/2), w, h);
						
						ctx.restore();
					}.bind(this));
				}.bind(this));

			}.bind(canvasView);
			canvasView.layoutSubviews();
			
			canvasView.DOMNode.onmouseover = function () {
				canvasView.isActive = true;
				canvasView.layoutSubviews();
				panel.selectedIconTag = canvasView.tag;
			}.bind(this);

			canvasView.DOMNode.onmouseout = function () {
				canvasView.isActive = false;
				canvasView.layoutSubviews();
				setTimeout(function () {
					if (panel.selectedIconTag === canvasView.tag)
						panel.selectedIconTag = -1;
				}.bind(this), 50);
			}.bind(this);
		
		return canvasView;};
	
	
IconChooserButton.prototype.createLabel = function IconChooserButton__createLabel(text, y) {
		var label = createComponentFromDomain("Label", "Core.UI", this.context, {
			text: text,
			position: { left: 10, top: y-3 },
			style: { color:'#888',fontSize:'12px'}})
		;
		return label;};
	
	
IconChooserButton.prototype.destroy = function IconChooserButton_destroy() {
		this.hidePanel();
		__super.prototype.destroy.call(this);};
	
	
IconChooserButton.prototype.performSelection = function IconChooserButton__performSelection() {
		if (!isNaN(panel.selectedIconTag)) {
			this.performSystemIconSelection();
		} else {
			var fileRefID = panel.selectedIconTag;
			var fileRef = this.context.projectContext.fileReferenceWithID(fileRefID);
			if (!fileRef) return;
							this.editableImageControl.changeImageID(fileRef.resourceID, fileRef);
							if (this.editableImageControl.wantsRetinaImage)
								fileRef.addRetinaSuffixToName();
			this.hidePanel();
		}};
	

IconChooserButton.prototype.performSystemIconSelection = function IconChooserButton__performSystemIconSelection() {

		this.hidePanel();
		
		var selectedIcon = icons[panel.selectedIconTag];
		if (!selectedIcon) return;
		
		var iconDirPath = this.context.nativeProxy.sendMessage('bundlePath')+'/PlugIns/IconLibrary.cpsplugin/Shared/';
		var dataController = _context.editor.editedScene.dataController;

		if (selectedIcon.hasSelectedVariant) {
			var imageRef = createComponentFromDomain('ImageReference','appdoo',this.context.projectContext,{
				temporaryFilePath: iconDirPath+selectedIcon.id+'Selected@2x.png'
			});
			dataController.setValueForKeyPath(imageRef, 'viewController.tabBarItem.e_image', dataController);

			var imageRef2 = createComponentFromDomain('ImageReference','appdoo',this.context.projectContext,{
				temporaryFilePath: iconDirPath+selectedIcon.id+'@2x.png'
			});
			dataController.setValueForKeyPath(imageRef2, 'viewController.tabBarItem.e_unselectedImage', dataController);
		}
		else {
			var imageRef = createComponentFromDomain('ImageReference','appdoo',this.context.projectContext,{
				temporaryFilePath: iconDirPath+selectedIcon.id+'@2x.png'
			});
			dataController.setValueForKeyPath(imageRef, 'viewController.tabBarItem.e_image', dataController);

			var imageRef2 = createComponentFromDomain('ImageReference','appdoo',this.context.projectContext,{
			});
			dataController.setValueForKeyPath(imageRef2, 'viewController.tabBarItem.e_unselectedImage', dataController);
		}

		};
	
	
IconChooserButton.prototype.initPropertiesFromData = function IconChooserButton_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("editableImageControl")) this.editableImageControl = data.editableImageControl;
if (data.hasOwnProperty("imageType")) this.imageType = data.imageType;
};

IconChooserButton.prototype.decodeData = function IconChooserButton_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
if (data.hasOwnProperty("editableImageControl")) decoded.editableImageControl = this.context.decodeObjectTree(data.editableImageControl);
return decoded; };

IconChooserButton.prototype.encode = function IconChooserButton_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

IconChooserButton.prototype.encodeCloned = function IconChooserButton_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

IconChooserButton.prototype.expectedTypeForProperty = function IconChooserButton_expectedTypeForProperty(key) {
	if (key === "editableImageControl") return "EditableImageControl";
	if (key === "imageType") return "String";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return IconChooserButton; }()));