
registerType('appdoo.Editor', (function () { function InspectorBar() {} var __super = setSupertypeFromDomain(InspectorBar, 'View', 'Core.UI');

	Object.defineProperty(InspectorBar.prototype, "selection", {
	outlet: true, get:function () { return this._selection; }, set:function (v) {if (!Object.hasOwnProperty(this, "_selection")) Object.defineProperty(this, "_selection", { writable: true, configurable: true }); this._selection = v; }});
	

	Object.defineProperty(InspectorBar.prototype, "fontFamilyButton", {
	outlet: true, get:function () { return this._fontFamilyButton; }, set:function (v) {if (!Object.hasOwnProperty(this, "_fontFamilyButton")) Object.defineProperty(this, "_fontFamilyButton", { writable: true, configurable: true }); this._fontFamilyButton = v; }});
	

	Object.defineProperty(InspectorBar.prototype, "fontVariantButton", {
	outlet: true, get:function () { return this._fontVariantButton; }, set:function (v) {if (!Object.hasOwnProperty(this, "_fontVariantButton")) Object.defineProperty(this, "_fontVariantButton", { writable: true, configurable: true }); this._fontVariantButton = v; }});
	

	Object.defineProperty(InspectorBar.prototype, "fontSizeField", {
	outlet: true, get:function () { return this._fontSizeField; }, set:function (v) {if (!Object.hasOwnProperty(this, "_fontSizeField")) Object.defineProperty(this, "_fontSizeField", { writable: true, configurable: true }); this._fontSizeField = v; }});
	

	Object.defineProperty(InspectorBar.prototype, "textColorButton", {
	outlet: true, get:function () { return this._textColorButton; }, set:function (v) {if (!Object.hasOwnProperty(this, "_textColorButton")) Object.defineProperty(this, "_textColorButton", { writable: true, configurable: true }); this._textColorButton = v; }});
	

InspectorBar.prototype.viewDidLoad = function InspectorBar_viewDidLoad() {
		this.createSubviews();
		this.observeObject(this.selection);
		this.updateFontFamilyMenu();};
	
	
	var popUpButtonStyle = {
                              "border" : "1px solid #bbb",
                              "backgroundImage" : "-webkit-linear-gradient(#fff,hsl(0,0%,90%))",
                              "webkitAppearance" : "none",
                              "textShadow" : "0 1px 0 rgba(255,255,255,.4)",
                              "paddingLeft" : "8px",
                              "fontSize" : "10px",
                              "boxShadow" : "0 1px 0 rgba(255,255,255,.25)"
                            };
	
InspectorBar.prototype.createSubviews = function InspectorBar__createSubviews() {

		var data = {
                        "$type" : "View",
                        "$domain" : "Core.UI",
                        "position" : {
                          "left" : 0
                        },
                        "subviews" : [
                          {
                            "$id" : "fontFamilyButton",
                            "$type" : "PopUpButton",
                            "style" : popUpButtonStyle,
                            "items" : [
                              "Helvetica Neue",
                              "Arial"
                            ],
                            "position" : {
                              "left" : 25,
                              "top" : 2
                            },
                            "size" : {
                              "width" : 140,
                              "height" : 18
                            }
                          },
                          {
                            "$id" : "fontVariantButton",
                            "$type" : "PopUpButton",
                            "style" : popUpButtonStyle,
                            "items" : [
                              "Normal",
                              "Kursiv"
                            ],
                            "position" : {
                              "left" : 170,
                              "top" : 2
                            },
                            "size" : {
                              "width" : 110,
                              "height" : 18
                            }
                          },
                          {
                            "$id" : "fontSizeField",
                            "$type" : "TextField",
                            "style" : {
                              "border" : "1px solid #bbb",
                              "boxShadow" : "0 1px 0 rgba(255,255,255,.25), inset 0px 1px 2px #e4e4e4",
                              "fontSize" : "10px"
                            },
                            "value" : "12",
                            "position" : {
                              "left" : 285,
                              "top" : 2
                            },
                            "size" : {
                              "width" : 40,
                              "height" : 12
                            },
                            "inputType" : "text"
                          },
                          {
                            "$id" : "textColorButton",
                            "$type" : "View",
                            "style" : {
                              "border" : "1px solid #888",
                              "backgroundColor" : "black"
                            },
                            "position" : {
                              "left" : 337,
                              "top" : 4
                            },
                            "size" : {
                              "width" : 21,
                              "height" : 13
                            }
                          }
                        ]
                      };
		
		var v = this.context.decodeObjectTree(data);
		this.addSubview(v);
};
	
	
InspectorBar.prototype.updateFontFamilyMenu = function InspectorBar_updateFontFamilyMenu() {};
	

InspectorBar.prototype.observedObjectValuesDidReplace = function InspectorBar_observedObjectValuesDidReplace(obj, sender) {
		this.selectionDidChange();};
	
	
InspectorBar.prototype.selectionDidChange = function InspectorBar__selectionDidChange() {
		return;
		var fontFamily = this.selection.getSingle('fontFamily');
		var fontName = this.selection.getSingle('fontName');
		var font = window.fontFamilyNamed(fontFamily);
		var controlsAreEnabled = this.selection.getSingle('UTI') !== 'appdoo.iOS.Scene';

		this.fontFamilyButton.disabled = !controlsAreEnabled;
		this.fontVariantButton.disabled = !controlsAreEnabled;
		this.fontSizeField.disabled = !controlsAreEnabled;
		
		if (!controlsAreEnabled) {
			this.fontFamilyButton.value = 'System';
			this.fontVariantButton.items = ['Normal'];
			this.fontVariantButton.value = 'Normal';
			this.fontSizeField.value = '';
			return;
		}

		if (font) {
			this.fontFamilyButton.value = this.selection.getSingle('fontFamily');
			this.fontVariantButton.items = Object.keys(font.variants).map(function (variantName) {
				return [font.variants[variantName], LocalizedString(variantName)];
			});
			this.fontVariantButton.value = fontName;
			this.fontSizeField.value = this.selection.getSingle('fontSize');
		}
		else {
			this.fontFamilyButton.value = '';
			this.fontVariantButton.items = [];
		}};
	

InspectorBar.prototype.initPropertiesFromData = function InspectorBar_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("selection")) this.selection = data.selection;
if (data.hasOwnProperty("fontFamilyButton")) this.fontFamilyButton = data.fontFamilyButton;
if (data.hasOwnProperty("fontVariantButton")) this.fontVariantButton = data.fontVariantButton;
if (data.hasOwnProperty("fontSizeField")) this.fontSizeField = data.fontSizeField;
if (data.hasOwnProperty("textColorButton")) this.textColorButton = data.textColorButton;
};

InspectorBar.prototype.decodeData = function InspectorBar_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

InspectorBar.prototype.encode = function InspectorBar_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

InspectorBar.prototype.encodeCloned = function InspectorBar_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

InspectorBar.prototype.expectedTypeForProperty = function InspectorBar_expectedTypeForProperty(key) {
	if (key === "selection") return "";
	if (key === "fontFamilyButton") return "";
	if (key === "fontVariantButton") return "";
	if (key === "fontSizeField") return "";
	if (key === "textColorButton") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return InspectorBar; }()));