
registerType('appdoo', (function () { function InspectorBindingsView() {} var __super = setSupertypeFromDomain(InspectorBindingsView, 'View', 'Core.UI');

	var oddCellBackgroundColor = "rgba(255,255,255,.3)";
	
	Object.defineProperty(InspectorBindingsView.prototype, "selection", {
	outlet: true, get:function () { return this._selection; }, set:function (v) {if (!Object.hasOwnProperty(this, "_selection")) Object.defineProperty(this, "_selection", { writable: true, configurable: true }); this._selection = v; }});
	

InspectorBindingsView.prototype.initFromData = function InspectorBindingsView_initFromData(data) {

		__super.prototype.initFromData.call(this, data);

		this.createSubviews();
		this.observeObject(this.selection);
		this.observeObject(_context.editor.dataContextsController);
		this.update();
		_context.editor.inspector.bindingsView = this;

		return this;};
	
	
InspectorBindingsView.prototype.createSubviews = function InspectorBindingsView__createSubviews() {
		
		this.selectionIconAndNameView = this.context.decodeObjectTree({
			$type : "View",
			$domain : "Core.UI",
			size: { width: 210, height: 40 },
			position: { left: 0, top: 0 },
			autoresizingMask: 2,
			subviews: [
				 {
					$type: "ImageView",
					$domain: "Core.UI",
					imageSrc: "Resources/UITableView.png",
					contentMode: "scaleAspectFit",
					size: { width:22,height:20 },
					position: { left: -3+15, top: 2+10-2 },
				 },
				 {
					$type : "Label",
					$domain : "Core.UI",
					text: "SELECTION",
					style: {
						fontSize: "12px",
						color: "#444",
						webkitTransform: "translateY(-0.5px)",
						fontWeight: "bold",
					},
					numberOfLines: 1,
					autoresizingMask: 2,
					position: { left: 22+15, top: 5+10-2 },
					size: { width: 165-2, height: 15 },
				}
			]
		});
		this.addSubview(this.selectionIconAndNameView);

		this.infoLabel = this.context.decodeObjectTree({
			$type: "Label",
			$domain: "Core.UI",
			size: { width: this.size.width - 20 },
			position: { top: this.size.height/2 - 27, left: 10 },
			autoresizingMask : 42,
			style: {
				color: "#999",
				textAlign: "center",
				textShadow: "0 1px 0 rgba(255,255,255,1)"
			},
			text : LocalizedString("No Data Links Available"),
		});
		this.addSubview(this.infoLabel);
		
		var top = 5+25+5+5;

		this.list = this.context.decodeObjectTree({
				"$type" : "ListView",
				"$domain" : "Core.UI",
				"$id" : "bindingsListView",
				"size" : {
				  "width" : this.size.width,
				  "height" : this.size.height-top
				},
				"autoresizingMask" : 18,
				"position" : {
				  "left" : 0,
				  "top" : top
				},
				"style" : {
				  "_borderTopLeftRadius" : "5px",
				  "_borderTopRightRadius" : "5px",
				  "borderTop": '1px solid #ddd',
				  "_borderTopLeftRadius": "5px",
				  "_borderTopRightRadius": "5px"
				},
				"separatorColor" : 'transparent',
				"drawsBackground":true,
				"usesAlternatingRowBackgroundColors":true,
				"selectable" : false,
				"cellPrototype" : {
					$type:'View',
					$domain:'Core.UI',
					size: { width:this.size.width,height: 34-1-2 },
					autoresizingMask: 18,
				  "oddBackgroundColor" : oddCellBackgroundColor,
					subviews: [
					  {
						"$type" : "Label",
						"$domain" : "Core.UI",
						"position" : {
						  "left" : 15,
						  "top" : 11+2-5
						},
						"size" : {
						  "width" : 170
						},
						"autoresizingMask" : 2,
						"text" : "Text",
						"style": { fontSize: '12px',
						color:'#333'
						},
						"bindings" : [
						  {
							"sourceKeyPath" : "text",
							"destination" : this.$id,
							"destinationKeyPath" : "name",
							"bidirectional" : true,
							"enumerableItemAccess" : true
						  }
						]
					  },
					  {
						"$type" : "Button",
						"$domain" : "Core.UI",
						"size" : {
						  "width" : 50+10-5+2-2+1, height: 20-2-2+2-1-2+1+1+2
						},
						position: {left:this.size.width-60-15+5-2+2+5,top:5+3-1-1},
						autoresizingMask: 1,
						text: LocalizedString("Link"),
						buttonStyle:'flat',
						"style": { fontSize: '10px'},
						"targetMethod": "createBinding",
						"connections" : [
							{
							"key" : "target",
							"destination" : this.$id
							}
						]
					  }
					]
				}
			  });
		this.list.dataSource = this;
		this.addSubview(this.list);
			};
	

InspectorBindingsView.prototype.updateHeaderBindings = function InspectorBindingsView__updateHeaderBindings() {

		var headerIcon = this.subviews[0].subviews[0];
		var headerLabel = this.subviews[0].subviews[1];

		var selectedItem = this.selection.items[0];
		headerIcon.imageSrc = selectedItem.outlineIconURL;
		headerLabel.text = selectedItem.readableValue;
		
		
		
		
		if (this.headerLabelBinding) this.context.projectContext.unregisterBinding(this.headerLabelBinding);
		
		this.headerLabelBinding = {
			sourceKeyPath: 'text',
			destinationObject: selectedItem,
			destinationKeyPath: 'readableValue'
		};
		
		this.context.projectContext.registerBindingForObject(this.headerLabelBinding, headerLabel);


		
		
		if (this.headerIconBinding) this.context.projectContext.unregisterBinding(this.headerIconBinding);
		
		this.headerIconBinding = {
			sourceKeyPath: 'imageSrc',
			destinationObject: selectedItem,
			destinationKeyPath: 'outlineIconURL'
		};
		
		this.context.projectContext.registerBindingForObject(this.headerIconBinding, headerIcon);
};
	

// role ListViewDataSource 
	
InspectorBindingsView.prototype.numberOfSections = function InspectorBindingsView_numberOfSections() {
			if (!this.bindingsArePossible) return 0;
			return 1;};
		
	
InspectorBindingsView.prototype.numberOfItemsInSection = function InspectorBindingsView_numberOfItemsInSection(section) {
			if (!this.allBindableProperties) return 0;
			return this.allBindableProperties.length;};
		
	
InspectorBindingsView.prototype.dataForItemInSectionAtIndex = function InspectorBindingsView_dataForItemInSectionAtIndex(section, row) {
		
			var bpData = this.allBindableProperties[row];
			var obj = this.selection.items[0];
			
			var binding = obj.bindingForKey(bpData[0]);
			if (binding) {
				var controller = this.controllerForObjectBinding(binding, obj);
				if (binding.enumerableItemAccess)
					controller.fetchCurrentValue();
				return controller;
			}
		
			return { name: bpData[1], sourceKeyPath: bpData[0] };};
		
		
InspectorBindingsView.prototype.addObserver = function InspectorBindingsView_addObserver(o) {};
		
	
InspectorBindingsView.prototype.removeObserver = function InspectorBindingsView_removeObserver() {
			this.list = null;};
		
		
InspectorBindingsView.prototype.listViewCellForRowAtIndexPath = function InspectorBindingsView_listViewCellForRowAtIndexPath(listView,indexPath) {
			
			var bindableProperty = this.allBindableProperties[indexPath.item];
			var binding = this.selection.items[0].bindingForKey(bindableProperty[0]);
			if (!binding)
				return;
			
			var propertyType = propertyTypeInObject(binding.sourceKeyPath, this.selection.items[0]),
				propertyExpectsBoolean = propertyType === 'Boolean',
				showsCheckbox = 0,
				dl = 0,
				pbleft = 15 + dl,
				pbwidth = 180 - dl,
				pbdy = 13,
				dsItemID = this.$id,
				height = 120;
			
			if (propertyExpectsBoolean) height += 20;
			if (binding.hasCustomValueTransformer) height += 28;
			
			var cellPrototype = {
				  "$type" : "View",
				  "$domain" : "Core.UI",
				  "size" : {
					"width" : 210,
					"height" : height
				  },
				  "autoresizingMask" : 2,
				  "oddBackgroundColor" : oddCellBackgroundColor,
				  "style": {
				  	},
				  "subviews" : [
					{
					  "$type" : "Label",
					  "$domain" : "Core.UI",
					  "position" : {
						"left" : 15+(showsCheckbox?18:0),
						"top" : 11+2-5+2+1
					  },
					  "size" : {
						"width" : 170
					  },
					  "autoresizingMask" : 2,
					  "text" : "Text",
					  hidden: showsCheckbox,
					  "style": { fontSize: '12px',
					  	fontWeight: '600'
					  },
					  "bindings" : [
						{
						  "sourceKeyPath" : "text",
							"destination" : dsItemID,
							"destinationKeyPath" : "name",
						  "enumerableItemAccess" : true,
						}
					  ]
					},
					{
					  "$type" : "Label",
					  "$domain" : "Core.UI",
					  "text" : LocalizedString("Link from"),
					  "size" : {
						"width" : 120
					  },
					  "position" : {
						"left" : 15+dl,
						"top" : 36-5-1
					  },
					  "style" : {
						"fontSize" : "11px",
						"textAlign" : "left",
						color:'#777',
					  }
					},
					{
					  "$type" : "BindingsPopUpButtonView",
					  "$domain" : "Editor.Inspector",
					  "position" : {
						"left" : pbleft,
						"top" : pbdy+38-5
					  },
					  "size" : {
						"width" : pbwidth
					  },
					  "autoresizingMask" : 2,
					  style: { color: 'red'},
					  "bindings" : [
					   {
						  "sourceKeyPath" : "items",
						  "destination" : this.$id,
						  "destinationKeyPath" : "availableDataContextsForBindings"
						},
						{
						  "sourceKeyPath" : "value",
						  "destination" : this.$id,
						  "destinationKeyPath" : "dataContextID",
						  "bidirectional" : true,
						  "enumerableItemAccess" : true,
						}
					  ]
					},
					{
					  "$type" : "ImageView",
					  "$domain" : "Core.UI",
					  "position" : {
						"left" : pbleft+2,
						"top" : pbdy+38+1-5
					  },
					  "size" : {
						"width" : 22, height: 20
					  },
					  bindings: [{
						  "sourceKeyPath" : "imageSrc",
							"destination" : dsItemID,
							"destinationKeyPath" : "dataSourceIcon",
						  "enumerableItemAccess" : true,
						}]
					},
					{
					  "$type" : "ImageView",
					  "$domain" : "Core.UI",
					  "position" : {
						"left" : pbleft+5+1,
						"top" : pbdy+58+3-5+3
					  },
					  "size" : {
						"width" : 9, height: 9
					  },
					  imageSrc: 'Resources/ConnectingLine.png',
					},
					{
					  "$type" : "BindingsPopUpButtonView",
					  "$domain" : "Editor.Inspector",
					  "position" : {
						"left" : pbleft+20,
						"top" : pbdy+58+3-5
					  },
					  "size" : {
						"width" : pbwidth-20
					  },
					  "autoresizingMask" : 2,
					  "bindings" : [
						{
						  "sourceKeyPath" : "items",
						  "destination" : dsItemID,
						  "destinationKeyPath" : "availableKeyPathsForCurrentDestination",
						  "enumerableItemAccess" : true
						},
						{
						  "sourceKeyPath" : "value",
						  "destination" : dsItemID,
						  "destinationKeyPath" : "destinationKeyPathUsingController",
						  "bidirectional" : true,
						  "enumerableItemAccess" : true
						}
					  ]
					},
					{
					  "$type" : "SpriteButton",
					  "$domain" : "Core.UI",
					  "size" : {
						"width" : 17,
						"height" : 17
					  },
					  "autoresizingMask" : 1,
					  "position" : {
						"left" : 178,
						"top" : 11
					  },
					  "sprite" : "Resources/RemoveButton.png",
					  "targetMethod" : "deleteBinding",
					  "connections" : [
						{
						  "key" : "target",
						  "destination" : this.$id
						}
					  ],
					  "toolTip" : "Data Link",
					  "localizeToolTip" : true,
					},
					{
					  "$type" : "SelectableLabel",
					  "$domain" : "Core.UI",
					  "size" : {
						"width" : 170-15,
						"height" : 13
					  },
					  "position" : {
						"left" : 15+15+20+4+4-15+dl,
						"top" : 94+1+1
					  },
					  style: {fontSize:'10px',
					  	color: 'hsl(257,37%,35%)'
					  	},
					  numberOfLines: 1,
					  autoresizingMask: 2,
					  text: 'CURRENT VALUE',
					  bindings: [{sourceKeyPath:'text',destination:dsItemID,destinationKeyPath:'currentReadableValue',"enumerableItemAccess" : true,
							}]
					},
				  ],
				};
			  var top = 114;
				
			if (propertyExpectsBoolean) {
			
				   cellPrototype.subviews.push({
					  "$type" : "Checkbox",
					  "$domain" : "Editor.Inspector",
					  "size" : {
						"width" : 180,
						"height" : 17
					  },
					  "position" : {
						"left" : pbleft-2+18+2,
						"top" : top
					  },
					  style: {fontSize:'12px'},
					  bindings: [{sourceKeyPath:'value',destination:dsItemID,destinationKeyPath:'valueTransformerIsBooleanInverter',"enumerableItemAccess" : true, bidirectional: true
						  }],
					  title: LocalizedString('Invert Value'),
					  small: true
					});
					
				 top += 20;
			
			}

			var cell = this.context.decodeObjectTree(cellPrototype);
			cell.size.width = this.size.width;
			return cell;};
		

	

	var timer;
	
	
InspectorBindingsView.prototype.controllerForObjectBinding = function InspectorBindingsView__controllerForObjectBinding(binding, obj) {

		if (binding.dataController) return binding.dataController;

		var obc = createComponentFromDomain("ObjectBindingController", "appdoo", this.context, {
			contents: binding,
			owner: obj,
			inspectorView: this})
		;
		
		Object.defineProperty(binding, 'dataController', { value: obc });
		this.observeObject(obc);
		
		return obc;
};
	
	
	
// role Observer 
	
InspectorBindingsView.prototype.observedObjectValuesDidReplace = function InspectorBindingsView_observedObjectValuesDidReplace(obj, sender) {
			this.update();};
		

InspectorBindingsView.prototype.observedObjectValueDidAppearForKey = function InspectorBindingsView_observedObjectValueDidAppearForKey(obj, key, sender) {
			this.update();};
		

	
	

	Object.defineProperty(InspectorBindingsView.prototype, "availableDataContextsForBindings", {
		get: function () {

			var r = [];
			var dcc = this.context.editor.dataContextsController;
			if (Array.isArray(dcc.contents)) dcc.contents.every(function (ctx) {
				r.push([ctx.identify(), ctx.name]);return true; }, this);
			
			r.unshift(['',LocalizedString('(No Selection)')]);
			return r;
		}});
	


InspectorBindingsView.prototype.createBinding = function InspectorBindingsView_createBinding(sender) {
	
		var selection = this.selection.contents;
		if (selection.length !== 1) return;
		var propertyInfo = sender.superview.superview.dataset;
		if (!propertyInfo) {
			 alertd('Error in createBinding(): no propertyInfo.');
			return;
		}
		
		var selectedItem = selection[0];
		
		
		selectedItem.dataController.setValueForKey(undefined, propertyInfo.sourceKeyPath);
		
		var binding = {
			sourceKeyPath: propertyInfo.sourceKeyPath,
			destination: '',
			destinationKeyPath: '',
		};

		selectedItem.context.registerBindingForObject(binding, selectedItem);
		selectedItem.bindingsController.addValue(binding, this);
		
		var controller = this.controllerForObjectBinding(binding, selectedItem);
		var availableContexts = this.availableDataContextsForBindings;
		if (availableContexts.length > 1) {
			controller.setValueForKeyPath(availableContexts[1][0], 'dataContextID');
			var destinationKeyPath = this.context.editor.bestKeyPathGuessForBinding(binding);
			if (destinationKeyPath)
				controller.setValueForKeyPath(destinationKeyPath, 'destinationKeyPathUsingController');
		}
		
		if (this.list) this.list.reloadData();
		
		selectedItem.outlineAccessoryTypeDidChange();

		_context.editor.inspector.refreshPropertiesSegment(true);
};
	
	
InspectorBindingsView.prototype.deleteBinding = function InspectorBindingsView_deleteBinding(sender) {
		
		var selectedItem = this.selection.contents[0],
			bindingController = sender.superview.superview.dataset;
			
		if (!bindingController) return;
		var binding = bindingController.contents;
		selectedItem.bindingsController.removeValue(binding);
		selectedItem.context.unregisterBinding(binding);
		
		if (this.list) this.list.reloadData();
		
		_context.editor.inspector.refreshPropertiesSegment(true);
			};
	
	
	Object.defineProperty(InspectorBindingsView.prototype, "bindingsArePossible", {
		get: function () {
			return _context.editor.inspector.bindingsArePossible;
		}});
	

InspectorBindingsView.prototype.update = function InspectorBindingsView__update() {

		var v = this.bindingsArePossible;
		this.infoLabel.hidden = v;
		this.selectionIconAndNameView.hidden = !v;
		this.list.hidden = !v;

		if (!v) this.allBindableProperties = [];
		else {
			this.allBindableProperties = clone(this.selection.get('bindableProperties')[0]);
			this.updateHeaderBindings();
			if (this.list) this.list.reloadDataLazy();
		}};
	

InspectorBindingsView.prototype.initPropertiesFromData = function InspectorBindingsView_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("selection")) this.selection = data.selection;
};

InspectorBindingsView.prototype.decodeData = function InspectorBindingsView_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

InspectorBindingsView.prototype.encode = function InspectorBindingsView_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

InspectorBindingsView.prototype.encodeCloned = function InspectorBindingsView_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

InspectorBindingsView.prototype.expectedTypeForProperty = function InspectorBindingsView_expectedTypeForProperty(key) {
	if (key === "selection") return "";
	if (key === "availableDataContextsForBindings") return "";
	if (key === "bindingsArePossible") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return InspectorBindingsView; }()));