
registerType('Editor.Inspector', (function () { function Checkbox() {} var __super = setSupertypeFromDomain(Checkbox, 'View', 'Core.UI');

Checkbox.prototype.initFromData = function Checkbox_initFromData(data) {

		if (!__super.prototype.initFromData.call(this, data, null, true))
			return;

		this.checkboxNode = document.createElement('input');
		this.checkboxNode.type = 'checkbox';
		this.checkboxNode.style.fontSize = data.small ? '14px':'16px';
		this.checkboxNode.style.position = 'relative';
		if (!data.small) this.checkboxNode.style.top = '-1px';
		this.checkboxNode.id = this.context.createUID('CheckboxNode');
		this.checkboxNode.disabled = data.disabled ? 'disabled' : false;
		this.checkboxNode.onmousedown = function (e) {
			e.stopPropagation();
		};
		
		var labelNode = document.createElement('label');
		labelNode.style.position = 'absolute';
		labelNode.style.width = (this.size.width || 150+5)+'px';
		labelNode.style.height = 16;
		labelNode.style.left = (data.small?20:22)+'px';
		labelNode.style.top = 2+'px';
		labelNode.style.overflow = 'hidden';
		labelNode.style.textOverflow = 'ellipsis';
		labelNode.style.whiteSpace = 'nowrap';
		if (data.small) labelNode.style.fontSize = '11px';
        labelNode.style.fontSize = '12px';
        if (window.systemVersion.minor===10) {
            labelNode.style.left = (data.small?20-2:22-2)+'px';
        }
		labelNode.appendChild(document.createTextNode(' '+data.title));
		labelNode.setAttribute('for', this.checkboxNode.id);
		if (data.disabled) labelNode.style.color = '#888';
		
		this.DOMNode.appendChild(this.checkboxNode);
		
		if (data.title) this.DOMNode.appendChild(labelNode);

		this.undefinedValue = data.undefinedValue;
		
		this._tristateIndicator = createComponentFromDomain(
			'ImageView', 'Core.UI', this.context, {
				size: { width: 10, height: 10 },
				position: { top: 4, left: 3+3 },
				imageSrc: this.context.pathForResource('CheckboxTristate.png'),
				style: { pointerEvents: 'none' }
			});
		this.addSubview(this._tristateIndicator);

		if (data.value) this.value = data.value;

		
		this.checkboxNode.addEventListener('change', function (e) {

			var value = this.checkboxNode.checked;
			this.value = value;

			this.context.broadcastValueChangeForKeyPathInObject('value', this, this);
			
		}.bind(this));
		
		data = null;
		
		this.applyBindings(true);
		
		return this;};
	

Checkbox.prototype.valueShouldChangeForKeyPath = function Checkbox_valueShouldChangeForKeyPath(value, keyPath) {
	
		if (keyPath === 'value') {
		
			if (value === undefined) {
				this.disabled = true;
				this.value = this.undefinedValue;
				return true;
			}
			
			this.disabled = false;
			
			if (Array.isArray(value)) {
				if (valuesAreEqual(value)) {
					if (value[0] === undefined || value[0] === '') this.value = this.undefinedValue;
					else this.value = value[0];
				}
				else {
					this.value = 2;
				}
			}
			else this.value = value;
			
			return true;
		}
		
		return false;
		};
	


	

Checkbox.prototype._setHasTristateValue = function Checkbox___setHasTristateValue(trueOrFalse) {
		this._tristateIndicator.hidden =
			(trueOrFalse === true) ? false : true;};
	


	

	Object.defineProperty(Checkbox.prototype, "value", {
	enumerable: true, 
		set: function (v) {
			Object.defineProperty(this, '_value', {
				value: v,
				writable: true
			});
			if (v === 2) {
				this._setHasTristateValue(true);
			}
			else {
				this._setHasTristateValue(false);
				if (v === 1 || v === true) {
					this.checkboxNode.checked = true;
				}
				else {
					this.checkboxNode.checked = false;
				}
			}
		}, 
		get: function () {
			return this._value;
		}});
	

	Object.defineProperty(Checkbox.prototype, "disabled", {
	synthesized: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_disabled")) Object.defineProperty(this, "_disabled", { writable: true, configurable: true });
			this._disabled = v;
		}, get:function () { return this._disabled; }});
	

Checkbox.prototype.expectedTypeForProperty = function Checkbox_expectedTypeForProperty(key) {
	if (key === "value") return "";
	if (key === "disabled") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return Checkbox; }()));