
registerType('Editor.Inspector', (function () { function ColorPicker() {} var __super = setSupertypeFromDomain(ColorPicker, 'View', 'Core.UI');

	

ColorPicker.prototype.initFromData = function ColorPicker_initFromData(data) {
	
		if (!__super.prototype.initFromData.call(this, data, null, true))
			return;
			
		this.useDropDownMenu = data.useDropDownMenu;
		
		var pickerButtonWidth = data.size.width;

		this.backgroundView = createComponentFromDomain(
			'SmartScalingImage', 'Core.UI', this.context,
			{
				imageSrc: this.context.pathForResource('ColorPicker.png'),
				size: { width: pickerButtonWidth, height: data.size.height+3 },
				position: { left: 0, top: 0 },
				autoresizingMask: 2,
				contentInset: [5,20,5,10],
				style: { pointerEvents: 'none' }
			}
		);
		this.backgroundView._canvas.style.pointerEvents = 'none';
		this.addSubview(this.backgroundView);
		
		
		var padding = -2;
		var colorAreaWidth = pickerButtonWidth-8+padding*2;
		var colorAreaHeight = data.size.height-8-2+3+padding*2;
		var colorAreaLeft = 3+1-padding;
		var colorAreaTop = 4+1-padding;
		var scale = this.context.highResolutionEnabled ? 2 : 1;
		
		this.alphaBackgroundNode = document.createElement('canvas');
		this.alphaBackgroundNode.width = (colorAreaWidth-2)*scale;
		this.alphaBackgroundNode.height = (colorAreaHeight-2)*scale;
		this.style.call({ DOMNode: this.alphaBackgroundNode }, {
			position: 'absolute',
			left: (colorAreaLeft+1)+'px',
			top: (colorAreaTop+1)+'px',
			width: (colorAreaWidth-2)+'px',
			height: (colorAreaHeight-2)+'px',
			pointerEvents: 'none'
		});
		this.DOMNode.appendChild(this.alphaBackgroundNode);

		this.colorNode = document.createElement('div');
		this.style.call({ DOMNode: this.colorNode }, {
			width: colorAreaWidth+'px',
			height: colorAreaHeight+'px',
			position: 'absolute',
			left: (colorAreaLeft)+'px',
			top: colorAreaTop+'px',
			pointerEvents: 'none'
		});
		this.DOMNode.appendChild(this.colorNode);
		
		var span = 1;

		this.colorBorder = document.createElement('div');
		this.style.call({ DOMNode: this.colorBorder }, {
			width: (colorAreaWidth+span*2)+'px',
			height: (colorAreaHeight+span*2)+'px',
			position: 'absolute',
			left: (colorAreaLeft-span)+'px',
			top: (colorAreaTop-span)+'px',
			border: '1px solid rgba(0,0,0,.05)',
			boxSizing: 'border-box',
			borderRadius: '2px',
			pointerEvents: 'none'
		});
		this.DOMNode.appendChild(this.colorBorder);

		this.undefinedValue = data.undefinedValue;
		
		
		this.colorLabel = createComponentFromDomain("Label", "Core.UI", this.context, {
			style: { fontSize: '12px' },
			position: { left: colorAreaWidth+8, top: 3+1 },
			text: '',
			hidden: (data.size.width < 100 || colorAreaWidth > 50)})
		;
		this.addSubview(this.colorLabel);


		if (data.useDropDownMenu) {
			var arrow = createComponentFromDomain("ImageView", "Core.UI", this.context, {
				size: { width: 8, height: 8 },
				position: { left: pickerButtonWidth-14+2, top: (this.size.height/2-1)|0+3 },
				imageSrc: 'Resources/ColorPickerArrow.png',
				autoresizingMask: 1})
			;
			this.addSubview(arrow);
		}

		
		data = null;
		
		var mouseIsDown;
		this.DOMNode.onmousedown = function (e) {

			if (this._disabled) return;
			if (e.button > 1) return;
			mouseIsDown = true;
		
			this.highlighted = true;
			
			window.onmouseup = function (e) {
				mouseIsDown = false;
				this.highlighted = this.selected;
				window.onmouseup = null;
			}.bind(this);
		
		}.bind(this);

		this.DOMNode.onmouseout = function (e) {
			if (this._disabled) return;
		}.bind(this);

		this.DOMNode.onmouseover = function (e) {
			if (this._disabled) return;
			if (mouseIsDown)
				this.highlighted = true;
		}.bind(this);

		this.DOMNode.onclick = function (e) {
			if (this._disabled) return;
			this.selected = !this.selected;
			this.highlighted = this.selected;
		}.bind(this);


		this.DOMNode.oncontextmenu = function (e) {
		
			var menu = createComponentFromDomain("Menu", "Core.UI", this.context, {
				items: []})
			;
			menu.items.push(createComponentFromDomain('MenuItem', 'Core.UI', this.context, {
				title: LocalizedString("Copy Color"),
				target: this,
				targetMethod: 'copyColor'
			}));

			if (this.context.nativeProxy.sendMessage('canPasteColor')) {
				menu.items.push(createComponentFromDomain('MenuItem', 'Core.UI', this.context, {
					title: LocalizedString("Paste Color"),
					target: this,
					targetMethod: 'pasteColor'
				}));
			}

			menu.items.push(createComponentFromDomain('MenuItem', 'Core.UI', this.context, {
				title: LocalizedString("Reset"),
				target: this,
				targetMethod: 'setStandardColor'
			}));

			menu.x = e.x; menu.y = e.y;
			this.context.showContextMenu(menu);
			
		}.bind(this);
		
		this.applyBindings(true);
		
		return this;};
	

ColorPicker.prototype.destroy = function ColorPicker_destroy() {
		this.selected = false;
		__super.prototype.destroy.call(this);};
	
	
ColorPicker.prototype.layoutSubviews = function ColorPicker_layoutSubviews() {
		__super.prototype.layoutSubviews.call(this);
		
		var colorAreaWidth = 20;
		this.alphaBackgroundNode.width = colorAreaWidth-2;
		this.colorNode.style.width = colorAreaWidth+'px';
		this.colorBorder.style.width = (colorAreaWidth-2)+'px';};
	


	

ColorPicker.prototype.valueShouldChangeForKeyPath = function ColorPicker_valueShouldChangeForKeyPath(value, keyPath) {
	
		if (keyPath === 'value') {
			
			if (Array.isArray(value)) {

				if (value === undefined) {
					this.value = this.undefinedValue;
					this.disabled = true;
					return true;
				}
	
				this.disabled = false;
		
				if (valuesAreEqual(value)) {
					if (value[0] === undefined || value[0] === '') this.color = '';
					else this.color = value[0];
				}
				else {
					this.color = 'rgb(0,0,0,0)';
				}
			
			} else {
				this.color = value;
			}
			
			return true;
		}
		
		return false;
		};
	


	

ColorPicker.prototype.colorPanelDidChangeColor = function ColorPicker_colorPanelDidChangeColor(rgbaColor) {
		this.changeColor(rgbaColor);};
	
	
ColorPicker.prototype.colorPanelDidClose = function ColorPicker_colorPanelDidClose() {
		this.selected = false;};
	
	
ColorPicker.prototype.changeColor = function ColorPicker_changeColor(newColor) {
		this.color = newColor;
		this.context.broadcastValueChangeForKeyPathInObject('value', this, this);};
	


	

ColorPicker.prototype._drawAlphaBackgroundNode = function ColorPicker___drawAlphaBackgroundNode(transparent) {

		var ctx = this.alphaBackgroundNode.getContext('2d'),
			width = this.alphaBackgroundNode.width,
			height = this.alphaBackgroundNode.height;
		
		ctx.setFillColor('white');
		ctx.fillRect(0, 0, width, height);
		ctx.beginPath();
		ctx.moveTo(0,0);
		ctx.lineTo(width, 0);
		ctx.lineTo(0, height);
		ctx.setFillColor('black');
		ctx.fill();
};
	

ColorPicker.prototype._drawUndefinedBackgroundNode = function ColorPicker___drawUndefinedBackgroundNode() {

		var ctx = this.alphaBackgroundNode.getContext('2d'),
			width = this.alphaBackgroundNode.width,
			height = this.alphaBackgroundNode.height;

		ctx.setFillColor('white');
		ctx.fillRect(0, 0, width, height);
		ctx.beginPath();
		ctx.moveTo(width, 0);
		ctx.lineTo(0, height);
		ctx.lineWidth = 2;
		ctx.strokeStyle = "red";
		ctx.stroke();
	};
	


	

	var selectedPicker = null,
		isChangingPicker = false;


	

	Object.defineProperty(ColorPicker.prototype, "color", {
	synthesized: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_color")) Object.defineProperty(this, "_color", { writable: true, configurable: true });
	
			if (!v) {
				v = this.undefinedValue;
				this.colorLabel.text = 'Default';
				this._color = '';
			}
			else {
				this.colorLabel.text = this.readableColor(v);
				this._color = v;
			}
			
			
			if (!v) {
				this._drawUndefinedBackgroundNode();
				return;
			}

			this.style.call({ DOMNode: this.colorNode }, {
				backgroundColor: v
			});
	
			
		}, get:function () { return this._color; }});
	
	
ColorPicker.prototype.readableColor = function ColorPicker__readableColor(v) {
		if (typeof v !== 'string') return;
	
		if (v.substr(0,3) === 'rgb') {
			
			var split = parseRgbCSSColor(v);
			
			if (split.length === 3) {
				if (split[0] === 0 && split[1] === 0 && split[2] === 0)
					return 'Schwarz';
				if (split[0] === 255 && split[1] === 255 && split[2] === 255)
					return 'Weiß';
			}
			else if (split.length === 4) {
				if (split[3] === 0)
					return 'Transparent';
			}
			
			return split;
		
		}
		
		return '?';

		};
	
	
	Object.defineProperty(ColorPicker.prototype, "value", {
		get: function () {
			if (this.color === this.undefinedValue) return undefined;
			return this.color;
		}, 
		set: function (v) {
			this.color = v;
		}});
	

	Object.defineProperty(ColorPicker.prototype, "colorIsInvisible", {
		set: function (v) {
			if (this._colorIsInvisible === v) return;
			Object.defineProperty(this, '_colorIsInvisible', {
				value: v, writable: true
			});
			this._drawAlphaBackgroundNode(v);
		}});
	

	Object.defineProperty(ColorPicker.prototype, "highlighted", {
		set: function (v) {
			if (v === true) {
				this.backgroundView.imageSrc = this.context.pathForResource('ColorPickerHighlighted.png');
			}
			else {
				this.backgroundView.imageSrc = this.context.pathForResource('ColorPicker.png');
			}
		}});
	
	
	Object.defineProperty(ColorPicker.prototype, "useDropDownMenu", {
	synthesized: true, get:function () { return this._useDropDownMenu; }, set:function (v) {if (!Object.hasOwnProperty(this, "_useDropDownMenu")) Object.defineProperty(this, "_useDropDownMenu", { writable: true, configurable: true }); this._useDropDownMenu = v; }});
	

	Object.defineProperty(ColorPicker.prototype, "selected", {
	synthesized: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_selected")) Object.defineProperty(this, "_selected", { writable: true, configurable: true });

			this._selected = v;
			
			if (this.useDropDownMenu) {
				if (v)	this.showFloatingView();
				else	this.hideFloatingView();
			}
			else {
				if (v)	this.showAppleColorPaletteWindow();
				else	this.hideAppleColorPaletteWindow();	
			}
		}, get:function () { return this._selected; }});
	
	
	var floatingView;
	
ColorPicker.prototype.showFloatingView = function ColorPicker__showFloatingView() {
		if (!floatingView) {
			floatingView = createComponentFromDomain("ColorPickerFloatingView", "appdoo", this.context, {
				size: { width: 200, height: 200 },
				recentlyUsedColors: []})
			;
		}
		floatingView.showForButton(this);};
	
	
ColorPicker.prototype.hideFloatingView = function ColorPicker__hideFloatingView() {
		this.hideAppleColorPaletteWindow();
		if (!floatingView) return;
		floatingView.hide();};
	

ColorPicker.prototype.showAppleColorPaletteWindow = function ColorPicker__showAppleColorPaletteWindow() {
		if (selectedPicker !== null) {
			isChangingPicker = true;
			selectedPicker.selected = false;
			isChangingPicker = false;
		}
		this.context.colorPanelDelegate = this;
		this.context.nativeProxy.sendMessage('showColorPicker',
			this.colorNode.style.backgroundColor);
		this.highlighted = true;
		selectedPicker = this;};
	

ColorPicker.prototype.hideAppleColorPaletteWindow = function ColorPicker__hideAppleColorPaletteWindow() {
		if (isChangingPicker !== true)
			this.context.nativeProxy.sendMessage('hideColorPicker');
		this.context.colorPanelDelegate = undefined;
		this.highlighted = false;
		selectedPicker = null;};
	
	
	Object.defineProperty(ColorPicker.prototype, "disabled", {
		set: function (v) {
			if (v === true) {
				this.selected = false;
				this.style({ opacity: .5 });
			}
			else this.style({ opacity: 1 });
		
			Object.defineProperty(this, "_disabled", {
			writable: true, 
				value: v});
			
		}, 
		get: function () {
			return this._disabled;
		}});
	
	
ColorPicker.prototype.setStandardColor = function ColorPicker_setStandardColor() {
		this.changeColor(this.undefinedValue);
		setTimeout(function () {
			if (_context.editor)
				_context.editor.refreshInspector(this);
		}, 10);};
	
	
	
	
ColorPicker.prototype.copyColor = function ColorPicker_copyColor() {
		this.context.nativeProxy.sendMessage('copyColor', this.color);};
	
	
ColorPicker.prototype.pasteColor = function ColorPicker_pasteColor() {
		var color = this.context.nativeProxy.sendMessage('pasteColor');
		this.changeColor(color);};
	

ColorPicker.prototype.expectedTypeForProperty = function ColorPicker_expectedTypeForProperty(key) {
	if (key === "color") return "";
	if (key === "value") return "";
	if (key === "colorIsInvisible") return "";
	if (key === "highlighted") return "";
	if (key === "useDropDownMenu") return "";
	if (key === "selected") return "";
	if (key === "disabled") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return ColorPicker; }()));
registerType('appdoo', (function () { function ColorPickerFloatingView() {} var __super = setSupertypeFromDomain(ColorPickerFloatingView, 'View', 'Core.UI');

	var viewMinimumWidth = 190+5;

ColorPickerFloatingView.prototype.init = function ColorPickerFloatingView_init() {
		__super.prototype.init.call(this);
		this.size = { width: viewMinimumWidth, height: 200 };
		this.style({
			backgroundColor: 'hsla(0,0%,99%,.97)',
			border: '1px solid rgba(0,0,0,.2)',
			borderRadius: '5px',
			boxShadow: '0 8px 15px rgba(0,0,0,.2)',
			zIndex: 10000
		});
		
		this.__y = 5;

		this.addMenuButton({
			text: 'Default', action: function () {
			this.hide();
			this.colorPickerButton.changeColor(undefined);
			this.colorPickerButton.selected = false;
		}.bind(this)
		});

		

		this.addMenuButton({ text: 'Colors…', action: function () {
			this.hide();
			this.colorPickerButton.showAppleColorPaletteWindow();
		}.bind(this) });
		
		this.addSeparator();
		
		this.recentlyUsedColorsPalette = this.addPalette({
			title: 'Zuletzt verwendet',
			paletteColors: this.recentlyUsedColors,
			size: { width: 160-1, height: 40-5 }
		});

		this.addPalette({
			title: 'Palette',
			paletteImageSrc: 'Resources/ColorPalettePages.png',
			size: { width: 160-1, height: 130+20+2-20+7 }
		});
		
		
		this.size.height = this.__y+5;
		
		return this;};
	
	
	Object.defineProperty(ColorPickerFloatingView.prototype, "recentlyUsedColors", {
	outlet: true, get:function () { return this._recentlyUsedColors; }, set:function (v) {if (!Object.hasOwnProperty(this, "_recentlyUsedColors")) Object.defineProperty(this, "_recentlyUsedColors", { writable: true, configurable: true }); this._recentlyUsedColors = v; }});
	
	
ColorPickerFloatingView.prototype.destroy = function ColorPickerFloatingView_destroy() {
		this.colorPickerButton = null;
		__super.prototype.destroy.call(this);};
	
	
ColorPickerFloatingView.prototype.showForButton = function ColorPickerFloatingView_showForButton(colorPickerButton) {
		if (colorPickerButton.size.width > viewMinimumWidth) this.size.width = colorPickerButton.size.width-2;
		var left = -colorPickerButton.getRelativeX(0);
		if (left+this.size.width+5 > window.innerWidth) left = window.innerWidth-(this.size.width+10+2);
		
		var top = -colorPickerButton.getRelativeY(0) + colorPickerButton.size.height+1;
		if (top+this.size.height+5 > window.innerHeight) top = window.innerHeight-this.size.height-10;

		this.position.left = left;
		this.position.top = top;
		document.body.appendChild(this.DOMNode);
		this.colorPickerButton = colorPickerButton;
		
		this.recentlyUsedColorsPalette.drawPalette();};
	

ColorPickerFloatingView.prototype.hide = function ColorPickerFloatingView_hide() {
		if (this.DOMNode && this.DOMNode.parentNode)
			this.DOMNode.parentNode.removeChild(this.DOMNode);};
	
	
ColorPickerFloatingView.prototype.addPalette = function ColorPickerFloatingView__addPalette(paletteInfo) {
	
		var paletteContainerView = createComponentFromDomain("View", "Core.UI", this.context, {
			size: { width: this.size.width-2, height: paletteInfo.size.height+10 },
			position: { left: 0, top: this.__y },})
		;

		var paletteView = createComponentFromDomain("ColorPickerPaletteView", "appdoo", this.context, {
			paletteImageSrc: paletteInfo.paletteImageSrc,
			paletteColors: paletteInfo.paletteColors,
			title: paletteInfo.title,
			size: paletteInfo.size,
			position: {
				left: 21-1,
				top: 3
			},
			delegate: this})
		;

		paletteContainerView.addSubview(paletteView);
		this.addSubview(paletteContainerView);
		
		this.__y += paletteContainerView.size.height;
		
		return paletteView;};
	
	
ColorPickerFloatingView.prototype.addSeparator = function ColorPickerFloatingView__addSeparator() {
		var separator = createComponentFromDomain("View", "Core.UI", this.context, {
			size: { width:this.size.width-2, height: 1 },
			position: { left: 1, top: this.__y+5 },
			style: { backgroundColor: 'rgba(0,0,0,.1)' }})
		;
		this.__y += 11;
		this.addSubview(separator);};
	

ColorPickerFloatingView.prototype.addMenuButton = function ColorPickerFloatingView__addMenuButton(menuButtonInfo) {
	
		var text = menuButtonInfo.text,
			top = this.__y,
			addX = 0;
		
		var defaultStyle = {"backgroundImage": "","borderTop":"1px solid transparent","borderBottom":"1px solid transparent","color":"black"};
		
		var labelLeft = 21; if (addX) labelLeft+=addX;
	
		var button = this.context.decodeObjectTree({
			"$type": "View",
			"$domain": "Core.UI",
			"position": {"left": 0, "top": top },
			"size": {"width": this.size.width, "height": 16 },
			"autoresizingMask": 2,
			"style": defaultStyle,
			"subviews": [{
			  "$type": "Label",
			  "$domain": "Core.UI",
			  "text": text,
			  "style": {"fontSize":"12px"},
			  "position": {"left": labelLeft, "top": 0 }
			}]
		});
		
		button.DOMNode.onmouseover = function (e) {
			this.style({"backgroundImage": "-webkit-gradient(linear,left top,left bottom,color-stop(0,#6983fe),color-stop(1,#3750fd))","borderTop":"1px solid #627bf4","borderBottom":"1px solid #2D3FF4","color":"white"});
		}.bind(button);
		
		button.DOMNode.onmouseout = function (e) {
			this.style(defaultStyle);
		}.bind(button);
		
		button.DOMNode.onmouseup = menuButtonInfo.action;
		
		this.addSubview(button);
		
		this.__y += button.size.height+2;
		
		return button;};
	
	
ColorPickerFloatingView.prototype.colorPaletteDidChangeColor = function ColorPickerFloatingView_colorPaletteDidChangeColor(palette, color) {
		this.colorPickerButton.changeColor(color);};
	
	
ColorPickerFloatingView.prototype.colorPaletteDidPickColor = function ColorPickerFloatingView_colorPaletteDidPickColor(palette, color) {
		this.hide();
		this.colorPickerButton.selected = false;
		this.addColorToRecentList(color);};
	
	
ColorPickerFloatingView.prototype.addColorToRecentList = function ColorPickerFloatingView__addColorToRecentList(color) {

		
		var i = this.recentlyUsedColors.indexOf(color);
		if (i !== -1) {
			this.recentlyUsedColors.splice(i, 1);
		}
		this.recentlyUsedColors.splice(0,0,color);
};
	
	
ColorPickerFloatingView.prototype.initPropertiesFromData = function ColorPickerFloatingView_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("recentlyUsedColors")) this.recentlyUsedColors = data.recentlyUsedColors;
};

ColorPickerFloatingView.prototype.decodeData = function ColorPickerFloatingView_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

ColorPickerFloatingView.prototype.encode = function ColorPickerFloatingView_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

ColorPickerFloatingView.prototype.encodeCloned = function ColorPickerFloatingView_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

ColorPickerFloatingView.prototype.expectedTypeForProperty = function ColorPickerFloatingView_expectedTypeForProperty(key) {
	if (key === "recentlyUsedColors") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return ColorPickerFloatingView; }()));
registerType('appdoo', (function () { function ColorPickerPaletteView() {} var __super = setSupertypeFromDomain(ColorPickerPaletteView, 'View', 'Core.UI');

	Object.defineProperty(ColorPickerPaletteView.prototype, "paletteImageSrc", {
	outlet: true, 
	enumerable: true, get:function () { return this._paletteImageSrc; }, set:function (v) {if (!Object.hasOwnProperty(this, "_paletteImageSrc")) Object.defineProperty(this, "_paletteImageSrc", { writable: true, configurable: true }); this._paletteImageSrc = v; }});
	
	
	Object.defineProperty(ColorPickerPaletteView.prototype, "paletteColors", {
	outlet: true, 
	enumerable: true, get:function () { return this._paletteColors; }, set:function (v) {if (!Object.hasOwnProperty(this, "_paletteColors")) Object.defineProperty(this, "_paletteColors", { writable: true, configurable: true }); this._paletteColors = v; }});
	

	Object.defineProperty(ColorPickerPaletteView.prototype, "title", {
	outlet: true, 
	enumerable: true, get:function () { return this._title; }, set:function (v) {if (!Object.hasOwnProperty(this, "_title")) Object.defineProperty(this, "_title", { writable: true, configurable: true }); this._title = v; }});
	
	
	Object.defineProperty(ColorPickerPaletteView.prototype, "delegate", {
	outlet: true, get:function () { return this._delegate; }, set:function (v) {if (!Object.hasOwnProperty(this, "_delegate")) Object.defineProperty(this, "_delegate", { writable: true, configurable: true }); this._delegate = v; }});
	

ColorPickerPaletteView.prototype.init = function ColorPickerPaletteView_init() {
		__super.prototype.init.call(this);
		this.createCanvas();
		this.createLabel();
		this.arrangeSubviews();
		this.drawPalette();
		return this;};
	
	
ColorPickerPaletteView.prototype.createCanvas = function ColorPickerPaletteView__createCanvas() {

		this.canvas = document.createElement('canvas');
		this.canvas.width = this.size.width;
		this.canvas.height = this.size.height - (this.title ? 20 : 0);

		var lastMouseMovePosition;
		this.canvas.onmousemove = function (e) {

			
			var positionAsString = e.offsetX+','+e.offsetY;

			if (lastMouseMovePosition === positionAsString) return;
			lastMouseMovePosition = positionAsString;
			
			this.pickColorFromPaletteWithMouseEvent(e);
			
		}.bind(this);

		this.canvas.onmouseup = function (e) {
			this.delegate.colorPaletteDidPickColor(this, this.pickedColor);
		}.bind(this);
		
		this.DOMNode.appendChild(this.canvas);};
	
	
ColorPickerPaletteView.prototype.createLabel = function ColorPickerPaletteView__createLabel() {
		if (!this.title) return;
		this.label = createComponentFromDomain("Label", "Core.UI", this.context, {
			text: this.title,
			style: { fontSize: '11px', color: '#888' },
			position: {left:1}})
		;
		this.addSubview(this.label);};
	

ColorPickerPaletteView.prototype.arrangeSubviews = function ColorPickerPaletteView__arrangeSubviews() {
		this.canvas.style.position = 'absolute';
		if (this.label) {
			this.canvas.style.top = '17px';
		}
		else {
			this.canvas.style.top = '5px';
		}};
	
	
ColorPickerPaletteView.prototype.drawPalette = function ColorPickerPaletteView_drawPalette() {

		if (!this.canvas) return;

		if (this.paletteImageSrc)		this.drawPaletteFromImage();
		else if (this.paletteColors)	this.drawPaletteFromColors();
};
	
	
	var tileBorderColor = '#fff';

ColorPickerPaletteView.prototype.drawPaletteFromImage = function ColorPickerPaletteView__drawPaletteFromImage() {
		var ctx = this.canvas.getContext('2d');
		
		ctx.fillStyle = tileBorderColor;
		ctx.fillRect(1,1,this.size.width-2,this.size.height-2);
		
		this.context.whenImageIsReady(this.paletteImageSrc, function (img) {
			ctx.drawImage(img, 2, 2);
		});};
	
	
	var tileSize = 13;

ColorPickerPaletteView.prototype.drawPaletteFromColors = function ColorPickerPaletteView__drawPaletteFromColors() {

		var ctx = this.canvas.getContext('2d');
		var x = 0, y = 0;
		
	
		ctx.strokeStyle = tileBorderColor;
		ctx.lineWidth = 1;

		if (Array.isArray(this.paletteColors)) this.paletteColors.every(function (cssColor) {
			ctx.fillStyle = cssColor;
			ctx.beginPath();
			ctx.rect(x+2-0.5, y+2-0.5, tileSize, tileSize);
			ctx.fill();
			ctx.stroke();
			x += tileSize;return true; }, this);
		
		y += tileSize;
};
	
	
ColorPickerPaletteView.prototype.pickColorFromPaletteWithMouseEvent = function ColorPickerPaletteView__pickColorFromPaletteWithMouseEvent(e) {

		var x = e.offsetX, y = e.offsetY;
		
		x = ((x/tileSize) | 0) * tileSize + 2;
		y = ((y/tileSize) | 0) * tileSize + 2;
		
		var ctx = this.canvas.getContext('2d');
		var p = ctx.getImageData(x, y, 1, 1).data; 
		
		var rgbString = 'rgb('+p[0]+', '+p[1]+', '+p[2]+')';
		
		this.pickedColor = rgbString;
		this.delegate.colorPaletteDidChangeColor(this, rgbString);
		};
	

ColorPickerPaletteView.prototype.initPropertiesFromData = function ColorPickerPaletteView_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("paletteImageSrc")) this.paletteImageSrc = data.paletteImageSrc;
if (data.hasOwnProperty("paletteColors")) this.paletteColors = data.paletteColors;
if (data.hasOwnProperty("title")) this.title = data.title;
if (data.hasOwnProperty("delegate")) this.delegate = data.delegate;
};

ColorPickerPaletteView.prototype.decodeData = function ColorPickerPaletteView_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

ColorPickerPaletteView.prototype.encode = function ColorPickerPaletteView_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

ColorPickerPaletteView.prototype.encodeCloned = function ColorPickerPaletteView_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

ColorPickerPaletteView.prototype.expectedTypeForProperty = function ColorPickerPaletteView_expectedTypeForProperty(key) {
	if (key === "paletteImageSrc") return "String";
	if (key === "paletteColors") return "Array";
	if (key === "title") return "String";
	if (key === "delegate") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return ColorPickerPaletteView; }()));