
registerType('Editor.Inspector', (function () { function PopUpButton() {} var __super = setSupertypeFromDomain(PopUpButton, 'PopUpButton', 'Core.UI');


	

PopUpButton.prototype.initFromData = function PopUpButton_initFromData(data) {
	
		if (!__super.prototype.initFromData.call(this, data, true))
			return;
			
		Object.defineProperty(this, '_hasMultipleValuesItem', {
			value: false, writable: true
		});
		
		this.DOMNode.changeEventBound = function (e) {
			this.removeMultipleValuesItem();
			
			
			
			setTimeout(function () {
				this.updateSuboptions();
			}.bind(this), 2);
		}.bind(this);
		
		this.DOMNode.addEventListener('change', this.DOMNode.changeEventBound);

		['undefinedValue', 'value', 'inspector'].every(function (option) {
			if (data[option] !== undefined)
				this[option] = data[option];return true; }, this);
		

		if (data.value === undefined)
			this.value = this.undefinedValue;
		
		this.applyBindings(true);
		
		return this;
};
	
	
PopUpButton.prototype.destroy = function PopUpButton_destroy() {
		this.DOMNode.removeEventListener('change', this.DOMNode.changeEventBound);
		__super.prototype.destroy.call(this);};
	


	

PopUpButton.prototype.valueShouldChangeForKeyPath = function PopUpButton_valueShouldChangeForKeyPath(value, keyPath) {
		
		if (keyPath === 'value') {

			if (value === undefined) {
				this.value = this.undefinedValue;
				this.disabled = true;
				return true;
			}

			this.disabled = false;
			
			if (Array.isArray(value)) {
			
				if (valuesAreEqual(value)) {
					this.removeMultipleValuesItem();
					if (value[0] === undefined || value[0] === '') this.value = this.undefinedValue;
					else this.value = value[0];
				}
				else {
					this.addMultipleValuesItem(value);
					this.DOMNode.value = '__multiple__';
				}
				
				this.updateSuboptions();
			
			}
			else this.value = value;
			
			return true;
		}
		
		return __super.prototype.valueShouldChangeForKeyPath.call(this, value, keyPath);
	};
	


	

PopUpButton.prototype.addMultipleValuesItem = function PopUpButton__addMultipleValuesItem(value) {
		if (this._hasMultipleValuesItem === true) return;
		this._hasMultipleValuesItem = true;
		
		var option = document.createElement('option');
		option.value = '__multiple__';
		option.text = '('+LocalizedString('multiple values')+')';
		this.DOMNode.insertBefore(option, this.DOMNode.firstChild);};
	

PopUpButton.prototype.removeMultipleValuesItem = function PopUpButton__removeMultipleValuesItem() {
		if (this._hasMultipleValuesItem !== true) return;
		this._hasMultipleValuesItem = false;

		this.DOMNode.removeChild(this.DOMNode.firstChild);};
	
	
		
PopUpButton.prototype.updateSuboptions = function PopUpButton__updateSuboptions() {
		
		if (!this.DOMNode) return;
		if (!this.inspector) return;
	
		var value = this.DOMNode.value,
			option = this.getOption(value);
			
		if (!option || !Array.isArray(option) || !option[2]) {
			this.inspector.setSuboptionsForControl(this, null);
		}
		else {
			this.inspector.setSuboptionsForControl(this, option[2]);
		}
		};
	
	
PopUpButton.prototype.getOption = function PopUpButton__getOption(value) {
		var result;
		if (Array.isArray(this._items)) this._items.every(function (option) {
			if (option === value || option[0] === value) {
				result = option;
				return false;
			}return true; }, this);
		
		return result;};
	


PopUpButton.prototype.expectedTypeForProperty = function PopUpButton_expectedTypeForProperty(key) {
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return PopUpButton; }()));
registerType('Editor.Inspector', (function () { function BindingsPopUpButtonView() {} var __super = setSupertypeFromDomain(BindingsPopUpButtonView, 'View', 'Core.UI');

BindingsPopUpButtonView.prototype.init = function BindingsPopUpButtonView_init() {
		__super.prototype.init.call(this);

		this.popUpButton = createComponentFromDomain("PopUpButton", "Core.UI", this.context, {
			size: this.size,
			autoresizingMask: 2,
			target: this,
			method: 'onChange'})
		;
		
		this.addSubview(this.popUpButton);

		return this;};
	

BindingsPopUpButtonView.prototype.validate = function BindingsPopUpButtonView__validate() {
	
		if (!this.popUpButton.DOMNode) return;

        var valueIsValid = this.popUpButton.DOMNode.value === this.value;
       	this.invalidValueLabel.hidden = valueIsValid;

        if (!valueIsValid) {
			
        	setTimeout(function () {
	        	if (this.popUpButton.DOMNode)
		        	this.popUpButton.DOMNode.value = 1;
	        	this.invalidValueLabel.text = this.value;
	        }.bind(this), 0);
        }
        };
	
	
	Object.defineProperty(BindingsPopUpButtonView.prototype, "invalidValueLabel", {
		get: function () {
			if (!this._invalidValueLabel) {
				Object.defineProperty(this, "_invalidValueLabel", {
					value: createComponentFromDomain('Label', 'Core.UI', this.context, {
						text: '',
						position: { left: 8, top: 4 },
						size: { width: this.size.width-22, height: 15 },
						autoresizingMask: 2,
						numberOfLines: 1,
						style: { color:'red', fontSize: '11px', 
							pointerEvents: 'none' },
						
					})});
				
				this.addSubview(this._invalidValueLabel);
			}
			return this._invalidValueLabel;
		}});
	
	
	Object.defineProperty(BindingsPopUpButtonView.prototype, "items", {
		set: function (v) { this.popUpButton.items = v; }, 
		get: function () { return this.popUpButton.items; }});
	

	Object.defineProperty(BindingsPopUpButtonView.prototype, "value", {
		set: function (v) { this.popUpButton.value = v; }, 
		get: function () { return this.popUpButton.value; }});
	

BindingsPopUpButtonView.prototype.valueShouldChangeForKeyPath = function BindingsPopUpButtonView_valueShouldChangeForKeyPath(value, keyPath) {
		
		if (keyPath === 'value') {
			this.popUpButton.valueShouldChangeForKeyPath(value, keyPath);
			this.validate();
			return true;
		}
		
		return __super.prototype.valueShouldChangeForKeyPath.call(this, value, keyPath);};
	
	
BindingsPopUpButtonView.prototype.onChange = function BindingsPopUpButtonView_onChange(popUpButton) {
		this.validate();
		this.context.broadcastValueChangeForKeyPathInObject('value', this, this);};
	

BindingsPopUpButtonView.prototype.expectedTypeForProperty = function BindingsPopUpButtonView_expectedTypeForProperty(key) {
	if (key === "invalidValueLabel") return "";
	if (key === "items") return "";
	if (key === "value") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return BindingsPopUpButtonView; }()));