
registerType('Editor.Inspector', (function () { function Slider() {} var __super = setSupertypeFromDomain(Slider, 'View', 'Core.UI');

Slider.prototype.initFromData = function Slider_initFromData(data) {

		if (!__super.prototype.initFromData.call(this, data, 'input', true))
			return;

		this.DOMNode.type = 'range';
		var range = data.range || [0,100];
		this.range = range;
		this.DOMNode.min = range[0];
		this.DOMNode.max = range[1];
		this.DOMNode.value = data.value || 0;
		this.undefinedValue = data.undefinedValue;
		
		
		this.DOMNode.addEventListener('input', function (e) {
			this.context.broadcastValueChangeForKeyPathInObject('value', this, this);
		}.bind(this));
		
		data = null;
		
		this.applyBindings(true);

		return this;};
	

Slider.prototype.valueShouldChangeForKeyPath = function Slider_valueShouldChangeForKeyPath(value, keyPath) {
	
		if (keyPath === 'value') {
		
			if (value === undefined) {
				this.value = this.undefinedValue;
				this.disabled = true;
				return true;
			}

			this.disabled = false;
		
			if (valuesAreEqual(value)) {
				if (value[0] === undefined || value[0] === '') this.value = this.undefinedValue;
				else this.value = value[0];
			}
			else {
			}
			
			return true;
		}
		
		return false;
		};
	
	
	Object.defineProperty(Slider.prototype, "value", {
		set: function (v) {
			this.DOMNode.value = v;
		}, 
		get: function () {
			return this.DOMNode.valueAsNumber;
		}});
	

	Object.defineProperty(Slider.prototype, "range", {
	synthesized: true, get:function () { return this._range; }, set:function (v) {if (!Object.hasOwnProperty(this, "_range")) Object.defineProperty(this, "_range", { writable: true, configurable: true }); this._range = v; }});
	

	Object.defineProperty(Slider.prototype, "disabled", {
	enumerable: true, 

		set: function (v) {
			this.DOMNode.disabled = v;
			this.DOMNode.style.pointerEvents = v ? 'none' : '';
		}, 

		get: function () {
			return this.DOMNode.disabled;
		}
});
	

Slider.prototype.expectedTypeForProperty = function Slider_expectedTypeForProperty(key) {
	if (key === "value") return "";
	if (key === "range") return "";
	if (key === "disabled") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return Slider; }()));