
registerType('Editor.Inspector', (function () { function TableViewDataSource() {} var __super = setSupertypeFromDomain(TableViewDataSource, 'BasicObject', 'Core');


TableViewDataSource.prototype.initFromData = function TableViewDataSource_initFromData(data) {
		__super.prototype.initFromData.call(this, data, true);
		this.addItemButton = data.addItemButton;
		this.removeItemButton = data.removeItemButton;
		return this;};
	

	
// role TableViewDataSource (Core.UI) 

TableViewDataSource.prototype.dataForColumnNameAtRow = function TableViewDataSource_dataForColumnNameAtRow(columnName, rowIndex) {
			var key = this.dataObjectKeys[rowIndex];
			if (columnName === "key") return key;
			if (columnName === "value") return this.dataObject[key];};
		
		
TableViewDataSource.prototype.dataForRowAtIndex = function TableViewDataSource_dataForRowAtIndex(rowIndex) {
			return {
				key: this.dataForColumnNameAtRow('key', rowIndex),
				value: this.dataForColumnNameAtRow('value', rowIndex)
			};};
		
		
TableViewDataSource.prototype.numberOfRows = function TableViewDataSource_numberOfRows() {
			if (this.dataObject === undefined) return 0;
			return this.dataObjectKeys.length;};
		
		
TableViewDataSource.prototype.bindableDataKeyPath = function TableViewDataSource_bindableDataKeyPath() {};
		
		
TableViewDataSource.prototype.bindableDataKeyPathForColumnNameAtRow = function TableViewDataSource_bindableDataKeyPathForColumnNameAtRow(columnName, row) {};
		

TableViewDataSource.prototype.setRowIsSelected = function TableViewDataSource_setRowIsSelected(rowIndex, isSelected) {
			var hasSelection = (this.tableView.selectedIndices.length !== 0);
			this.removeItemButton.disabled = hasSelection ? false : true;};
		

TableViewDataSource.prototype.setValueForColumnNameInRow = function TableViewDataSource_setValueForColumnNameInRow(value, columnName, row) {

			var key = this.dataObjectKeys[row];
			
			if (columnName === 'value') {
				this.dataObject[key] = value;
			}
			else if (columnName === 'key') {
				var index = this.dataObjectKeys.indexOf(value);

				if (index !== -1 && index !== row)
					return false;

				
				
				var dataObjectCopy = clone(this.dataObject);
				for (_key in this.dataObject) {
					delete this.dataObject[_key];
				}
				for (_key in dataObjectCopy) {
					var _value = dataObjectCopy[_key];
					if (_key === key) {
						_key = value;
					}
					this.dataObject[_key] = _value;
				}
				this.dataObjectKeys[row] = value;
			}
			return true;};
		
		
TableViewDataSource.prototype.deleteDataForRow = function TableViewDataSource_deleteDataForRow(rowIndex) {
			var key = this.dataObjectKeys[rowIndex];
			this.dataObjectKeys.splice(rowIndex, 1);
			delete this.dataObject[key];};
		
		
TableViewDataSource.prototype.addEmptyData = function TableViewDataSource_addEmptyData() {
			if (this.dataObject[''] !== undefined) {
				return false;
			}
			this.dataObject[''] = '';
			this.dataObjectKeys.push('');
			return true;};
		

TableViewDataSource.prototype.addObserver = function TableViewDataSource_addObserver(tableView) {
			this.tableView = tableView;
			this.applyBindings(true);};
		
		
TableViewDataSource.prototype.removeObserver = function TableViewDataSource_removeObserver(tableView) {
			this.tableView = null;};
		
	
	
	
	
	
// role BindingsCapableObject (Core) 

TableViewDataSource.prototype.valueShouldChangeForKeyPath = function TableViewDataSource_valueShouldChangeForKeyPath(value, keyPath) {
	
			if (keyPath === 'dataObject') {
			
				if (value === undefined) {
					delete this.dataObject;
					this.disabled = true;
				}
				
				else {
					this.disabled = false;
	
					if (value.length === 1) {
						this.dataObject = value[0];
						if (this.dataObject)
							this.dataObjectKeys = Object.keys(this.dataObject);
					}
					else
						delete this.dataObject;
					}

				this.tableView.reloadData();
				
				return true;
			}
			
			return __super.prototype.valueShouldChangeForKeyPath.call(this, value, keyPath);
	};
		

	

TableViewDataSource.prototype.expectedTypeForProperty = function TableViewDataSource_expectedTypeForProperty(key) {
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return TableViewDataSource; }()));
registerType('Editor.Inspector', (function () { function SelectTableViewDataSource() {} var __super = setSupertypeFromDomain(SelectTableViewDataSource, 'BasicObject', 'Core');


	Object.defineProperty(SelectTableViewDataSource.prototype, "selectionAllowsMultiple", {
	outlet: true, get:function () { return this._selectionAllowsMultiple; }, set:function (v) {if (!Object.hasOwnProperty(this, "_selectionAllowsMultiple")) Object.defineProperty(this, "_selectionAllowsMultiple", { writable: true, configurable: true }); this._selectionAllowsMultiple = v; }});
	

	Object.defineProperty(SelectTableViewDataSource.prototype, "tableView", {
	outlet: true, get:function () { return this._tableView; }, set:function (v) {if (!Object.hasOwnProperty(this, "_tableView")) Object.defineProperty(this, "_tableView", { writable: true, configurable: true }); this._tableView = v; }});
	

SelectTableViewDataSource.prototype.numberOfRows = function SelectTableViewDataSource_numberOfRows() {
			if (this.items) return this.items.length;
			return 0;};
		
	
SelectTableViewDataSource.prototype.dataForColumnNameAtRow = function SelectTableViewDataSource_dataForColumnNameAtRow(columnName, rowIndex) {
			var item = this.items[rowIndex];
			if (columnName === 'name') return item[1];
			return columnName;
			return item;};
		
	
SelectTableViewDataSource.prototype.dataForIndexPath = function SelectTableViewDataSource_dataForIndexPath(indexPath) {
			var a = this.dataForRowAtIndex(indexPath.item);
			var data = createComponentFromDomain("BasicObject", "Core", this.context, {})
			;
			data.id = a[0];
			data.name = a[1];
			data.obj = a[3];
			
			if (data.obj) {
				data.icon = data.obj.outlineIconURL;
			}
			else data.icon = a[4];
			
			
			
			
			
			data.$id = this.$id+data.id;
			
			
			data._rowIsSelected = this.currentValues.indexOf(this.items[indexPath.item][0]) !== -1;

			
			Object.defineProperty(data, 'rowIsSelected', {
				get: function () { return this._rowIsSelected; },
				set: function (v) {
					data._rowIsSelected = v;
					this.setRowCheckboxIsChecked(indexPath.item, v);
				}.bind(this)
			});
			
			return data;};
		
		
SelectTableViewDataSource.prototype.dataForRowAtIndex = function SelectTableViewDataSource_dataForRowAtIndex(rowIndex) {
			return this.items[rowIndex];};
		

SelectTableViewDataSource.prototype.bindableDataKeyPath = function SelectTableViewDataSource_bindableDataKeyPath() {};
		
		
SelectTableViewDataSource.prototype.bindableDataKeyPathForColumnNameAtRow = function SelectTableViewDataSource_bindableDataKeyPathForColumnNameAtRow(columnName, row) {};
		
	
	Object.defineProperty(SelectTableViewDataSource.prototype, "value", {
	outlet: true, get:function () { return this._value; }, set:function (v) {if (!Object.hasOwnProperty(this, "_value")) Object.defineProperty(this, "_value", { writable: true, configurable: true }); this._value = v; }});
	

	Object.defineProperty(SelectTableViewDataSource.prototype, "items", {
	outlet: true, get:function () { return this._items; }, set:function (v) {if (!Object.hasOwnProperty(this, "_items")) Object.defineProperty(this, "_items", { writable: true, configurable: true }); this._items = v; }});
	
	
SelectTableViewDataSource.prototype.indexForSelectedValue = function SelectTableViewDataSource__indexForSelectedValue() {
		if (!this.items) return -1;
		var value = Array.isArray(this.value) ? this.value[0] : this.value;
		for (var i = 0, c = this.items.length; i < c; i++) {
			if (this.items[i][0] === value) {
				return i;
			}
		}
		return -1;};
	
	
SelectTableViewDataSource.prototype.isRowSelectedAtIndex = function SelectTableViewDataSource_isRowSelectedAtIndex(rowIndex) {
		if (this.selectionAllowsMultiple) return;
		return rowIndex === this.indexForSelectedValue();};
	
	
	Object.defineProperty(SelectTableViewDataSource.prototype, "currentValues", {
		get: function () {
			var v = this.value;
			if (Array.isArray(v)) v = v[0];
			if (typeof v !== 'string' || !v.length) return [];
			return v.split(',');
		}});
	
	
SelectTableViewDataSource.prototype.setRowCheckboxIsChecked = function SelectTableViewDataSource_setRowCheckboxIsChecked(rowIndex, setChecked) {
	
		var rowView = this.tableView.rowAtIndex(rowIndex);
		var checkbox = rowView.subviews[0].subviews[0];

		var isUnchecking = !setChecked;
		checkbox.value = setChecked;
		
		var value = this.items[rowIndex][0];
		var currentValues = this.currentValues;
		if (isUnchecking) {
			currentValues.splice(currentValues.indexOf(value), 1);
		}
		else if (currentValues.indexOf(value) === -1) {
			currentValues.push(value);
		}

		this.value = currentValues.join(',');
		this.context.broadcastValueChangeForKeyPathInObject('value', this, this);
};
	
	

SelectTableViewDataSource.prototype.setRowIsSelected = function SelectTableViewDataSource_setRowIsSelected(rowIndex, setSelected) {
		
		if (!setSelected) return;
		
		if (this.selectionAllowsMultiple) {
			var rowView = this.tableView.rowAtIndex(rowIndex);
			var checkbox = rowView.subviews[0].subviews[0];
			this.setRowCheckboxIsChecked(rowIndex, !checkbox.value);
			this.tableView.unselectRow(rowIndex);
		}
		else {
			this.value = this.items[rowIndex][0];
			this.context.broadcastValueChangeForKeyPathInObject('value', this, this);
		}};
	
	
SelectTableViewDataSource.prototype.addObserver = function SelectTableViewDataSource_addObserver() {};
	

SelectTableViewDataSource.prototype.removeObserver = function SelectTableViewDataSource_removeObserver() {};
	

SelectTableViewDataSource.prototype.initPropertiesFromData = function SelectTableViewDataSource_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("selectionAllowsMultiple")) this.selectionAllowsMultiple = data.selectionAllowsMultiple;
if (data.hasOwnProperty("tableView")) this.tableView = data.tableView;
if (data.hasOwnProperty("value")) this.value = data.value;
if (data.hasOwnProperty("items")) this.items = data.items;
};

SelectTableViewDataSource.prototype.decodeData = function SelectTableViewDataSource_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

SelectTableViewDataSource.prototype.encode = function SelectTableViewDataSource_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

SelectTableViewDataSource.prototype.encodeCloned = function SelectTableViewDataSource_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

SelectTableViewDataSource.prototype.expectedTypeForProperty = function SelectTableViewDataSource_expectedTypeForProperty(key) {
	if (key === "selectionAllowsMultiple") return "";
	if (key === "tableView") return "";
	if (key === "value") return "";
	if (key === "items") return "";
	if (key === "currentValues") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return SelectTableViewDataSource; }()));
registerType('appdoo', (function () { function InspectorFileReferencesDataSource() {} var __super = setSupertypeFromDomain(InspectorFileReferencesDataSource, 'BasicObject', 'Core');

	Object.defineProperty(InspectorFileReferencesDataSource.prototype, "placeholderLabel", {
	outlet: true, get:function () { return this._placeholderLabel; }, set:function (v) {if (!Object.hasOwnProperty(this, "_placeholderLabel")) Object.defineProperty(this, "_placeholderLabel", { writable: true, configurable: true }); this._placeholderLabel = v; }});
	
	
	Object.defineProperty(InspectorFileReferencesDataSource.prototype, "values", {
	synthesized: true, 
		get: function () { if (!this._values) this.values = []; return this._values; }, set:function (v) {if (!Object.hasOwnProperty(this, "_values")) Object.defineProperty(this, "_values", { writable: true, configurable: true }); this._values = v; }});
	
	
	Object.defineProperty(InspectorFileReferencesDataSource.prototype, "outlineView", {
	outlet: true, get:function () { return this._outlineView; }, set:function (v) {if (!Object.hasOwnProperty(this, "_outlineView")) Object.defineProperty(this, "_outlineView", { writable: true, configurable: true }); this._outlineView = v; }});
	
	
	Object.defineProperty(InspectorFileReferencesDataSource.prototype, "valuesAsString", {
	outlet: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_valuesAsString")) Object.defineProperty(this, "_valuesAsString", { writable: true, configurable: true });
			if (this.valuesAsString === v) return;
			this.values = (typeof v === 'string' && v.length) ? v.split(',') : [];
			if (this.outlineView) this.outlineView.reloadItem(null);
		}, 
		get: function () { if (!this.values) return ''; return this.values.join(','); }});
	
	
	Object.defineProperty(InspectorFileReferencesDataSource.prototype, "contentTypeFilter", {
	outlet: true, get:function () { return this._contentTypeFilter; }, set:function (v) {if (!Object.hasOwnProperty(this, "_contentTypeFilter")) Object.defineProperty(this, "_contentTypeFilter", { writable: true, configurable: true }); this._contentTypeFilter = v; }});
	
	
InspectorFileReferencesDataSource.prototype.deleteItem = function InspectorFileReferencesDataSource_deleteItem(sender) {
		try {
			var row = sender.superview.superview;
			var indexPath = row.indexPath;
			if (!indexPath) return;
			var refID = this.values[indexPath.item];
			var valueIndex = this.values.indexOf(refID);
			this.values.splice(valueIndex, 1);
			this.valuesDidChange();
		} catch (err) {
		}};
	
	
InspectorFileReferencesDataSource.prototype.valuesDidChange = function InspectorFileReferencesDataSource__valuesDidChange() {
			this.context.broadcastValueChangeForKeyPathInObject('valuesAsString', this, this);
		if (this.outlineView)
			this.outlineView.reloadItem(null);};
	
	
	function isFileDrop(e) {
		return e && e.dataTransfer && e.dataTransfer.files && e.dataTransfer.files.length;
	}
	
InspectorFileReferencesDataSource.prototype.acceptsFiles = function InspectorFileReferencesDataSource__acceptsFiles(files) {

		if (!this.contentTypeFilter) return true;
	
		for (var i = 0, c = files.length; i < c; i++) {
			if (this.contentTypeFilter(files[i].type) !== true) return false;
		}
		return true;
};
	

// role OutlineViewDataSource (Core.UI) 
	
InspectorFileReferencesDataSource.prototype.numberOfChildrenOfItem = function InspectorFileReferencesDataSource_numberOfChildrenOfItem(item) {
			var n = this.values ? this.values.length : 0;
			this.placeholderLabel.hidden = (n > 0);
			return n;};
		

InspectorFileReferencesDataSource.prototype.childWithIndexOfItem = function InspectorFileReferencesDataSource_childWithIndexOfItem(index, item) {
			var id = this.values[index];
			var ref = _context.projectContext.fileReferenceWithID(id);
			if (!ref) return { name: '?' };
			return ref;};
		
		
InspectorFileReferencesDataSource.prototype.captionForItem = function InspectorFileReferencesDataSource_captionForItem(item) {};
		

InspectorFileReferencesDataSource.prototype.isItemExpandable = function InspectorFileReferencesDataSource_isItemExpandable(item) {
			return false;};
		

InspectorFileReferencesDataSource.prototype.isItemCollapsable = function InspectorFileReferencesDataSource_isItemCollapsable(item) {
			return false;};
		
		
InspectorFileReferencesDataSource.prototype.parentItemForItem = function InspectorFileReferencesDataSource_parentItemForItem(item) {};
		


		
		
InspectorFileReferencesDataSource.prototype.setItemIsSelected = function InspectorFileReferencesDataSource_setItemIsSelected(item, isSelected) {};
		

InspectorFileReferencesDataSource.prototype.beginChangingSelection = function InspectorFileReferencesDataSource_beginChangingSelection() {};
		
		
InspectorFileReferencesDataSource.prototype.endChangingSelection = function InspectorFileReferencesDataSource_endChangingSelection(sender) {};
		
		
InspectorFileReferencesDataSource.prototype.setItemIsExpanded = function InspectorFileReferencesDataSource_setItemIsExpanded(item, isExpanded) {};
		


		

InspectorFileReferencesDataSource.prototype.validateDragWithItems = function InspectorFileReferencesDataSource_validateDragWithItems(items) {
			return true;};
		
		
		
InspectorFileReferencesDataSource.prototype.validateDropInItemWithIndex = function InspectorFileReferencesDataSource_validateDropInItemWithIndex(e, item, index) {
			if (item === null) {
				if (isFileDrop(e) && this.acceptsFiles(e.dataTransfer.files)) return 2;
				return (e.dataTransfer.types.indexOf(this.context.resourceReferenceDataType) !== -1);
			}};
		
		
InspectorFileReferencesDataSource.prototype.validateUnspecificDrop = function InspectorFileReferencesDataSource_validateUnspecificDrop(e) {
			return this.validateDropInItemWithIndex(e, null, this.values.length);};
		
		
InspectorFileReferencesDataSource.prototype.handleDropInItemWithIndex = function InspectorFileReferencesDataSource_handleDropInItemWithIndex(e, item, index, dropEffect) {

			if (index === -1) index = this.values.length;
		
			if (isFileDrop(e)) {
			
				_context.editor.dropFilesAtItemWithEventCompletion(e.dataTransfer.files, null, e, function (objects) {
					
				
					if (!objects) return;
					if (Array.isArray(objects)) objects.every(function (ref) {
						this.values.splice(index, 0, ref.identify());return true; }, this);
					
					this.valuesDidChange();
				
				}.bind(this));
			}
			else {
				var ids = e.dataTransfer.getData(this.context.resourceReferenceDataType).split(',');
				if (Array.isArray(ids)) ids.every(function (id) {
					var existingIndex = this.values.indexOf(id);
					if (existingIndex !== -1) {
						this.values.splice(existingIndex, 1);
						if (existingIndex < index) index--;
					}
					this.values.splice(index, 0, id);return true; }, this);
				
				this.valuesDidChange();
			}
			
};
		
		
		
		
InspectorFileReferencesDataSource.prototype.menuForItems = function InspectorFileReferencesDataSource_menuForItems(items) {
			selectionForContextMenu = items;
			var menuData = {
			"$type": "Menu",
			"$domain": "Core.UI",
			"items": [
			  {
				"$type": "MenuItem",
				"$domain": "Core.UI",
				"title": LocalizedString("Delete"),
				"target": this,
				"targetMethod": "deleteFromContextMenu",
			  },
			]};
			return this.context.decodeObjectTree(menuData);};
		
		
		
		
InspectorFileReferencesDataSource.prototype.addObserver = function InspectorFileReferencesDataSource_addObserver(outlineView) {
			this.outlineView = outlineView;};
		
		
InspectorFileReferencesDataSource.prototype.removeObserver = function InspectorFileReferencesDataSource_removeObserver(outlineView) {
			this.outlineView = null;};
		

	
	
	

// role ListViewDelegate 
		
InspectorFileReferencesDataSource.prototype.listViewWillUseDataTransferForDraggingItems = function InspectorFileReferencesDataSource_listViewWillUseDataTransferForDraggingItems(listView, dataTransfer, items) {
			
			
			
			
			if (!items.length) return;
			
			var itemsString = items.map(function (item) { return item.$id; }).join(',');
			dataTransfer[this.context.resourceReferenceDataType] = itemsString;
			};
		
		
	
	
	
	var selectionForContextMenu;
InspectorFileReferencesDataSource.prototype.deleteFromContextMenu = function InspectorFileReferencesDataSource_deleteFromContextMenu() {
		if (Array.isArray(selectionForContextMenu)) selectionForContextMenu.every(function (ref) {
			this.values.splice(this.values.indexOf(ref.identify()), 1);return true; }, this);
		
		this.valuesDidChange();};
	
	
InspectorFileReferencesDataSource.prototype.destroy = function InspectorFileReferencesDataSource_destroy() {
		selectionForContextMenu = null;
		__super.prototype.destroy.call(this);};
	

InspectorFileReferencesDataSource.prototype.initPropertiesFromData = function InspectorFileReferencesDataSource_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("placeholderLabel")) this.placeholderLabel = data.placeholderLabel;
if (data.hasOwnProperty("outlineView")) this.outlineView = data.outlineView;
if (data.hasOwnProperty("valuesAsString")) this.valuesAsString = data.valuesAsString;
if (data.hasOwnProperty("contentTypeFilter")) this.contentTypeFilter = data.contentTypeFilter;
};

InspectorFileReferencesDataSource.prototype.decodeData = function InspectorFileReferencesDataSource_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
if (data.hasOwnProperty("placeholderLabel")) decoded.placeholderLabel = this.context.decodeObjectTree(data.placeholderLabel);
return decoded; };

InspectorFileReferencesDataSource.prototype.encode = function InspectorFileReferencesDataSource_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

InspectorFileReferencesDataSource.prototype.encodeCloned = function InspectorFileReferencesDataSource_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

InspectorFileReferencesDataSource.prototype.expectedTypeForProperty = function InspectorFileReferencesDataSource_expectedTypeForProperty(key) {
	if (key === "placeholderLabel") return "UILabel";
	if (key === "values") return "String[]";
	if (key === "outlineView") return "";
	if (key === "valuesAsString") return "String";
	if (key === "contentTypeFilter") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return InspectorFileReferencesDataSource; }()));
registerType('appdoo', (function () { function InspectorPromisedObjectsDataSource() {} var __super = setSupertypeFromDomain(InspectorPromisedObjectsDataSource, 'BasicObject', 'Core');

	Object.defineProperty(InspectorPromisedObjectsDataSource.prototype, "placeholderLabel", {
	outlet: true, get:function () { return this._placeholderLabel; }, set:function (v) {if (!Object.hasOwnProperty(this, "_placeholderLabel")) Object.defineProperty(this, "_placeholderLabel", { writable: true, configurable: true }); this._placeholderLabel = v; }});
	
	
	Object.defineProperty(InspectorPromisedObjectsDataSource.prototype, "values", {
	outlet: true, 
		get: function () { if (!this._values) this.values = []; return this._values; }, set:function (v) {if (!Object.hasOwnProperty(this, "_values")) Object.defineProperty(this, "_values", { writable: true, configurable: true }); this._values = v; }});
	
	
	Object.defineProperty(InspectorPromisedObjectsDataSource.prototype, "outlineView", {
	outlet: true, get:function () { return this._outlineView; }, set:function (v) {if (!Object.hasOwnProperty(this, "_outlineView")) Object.defineProperty(this, "_outlineView", { writable: true, configurable: true }); this._outlineView = v; }});
	
	
	Object.defineProperty(InspectorPromisedObjectsDataSource.prototype, "contentTypeFilter", {
	outlet: true, get:function () { return this._contentTypeFilter; }, set:function (v) {if (!Object.hasOwnProperty(this, "_contentTypeFilter")) Object.defineProperty(this, "_contentTypeFilter", { writable: true, configurable: true }); this._contentTypeFilter = v; }});
	
	
InspectorPromisedObjectsDataSource.prototype.deleteItem = function InspectorPromisedObjectsDataSource_deleteItem(sender) {
		try {
			var row = sender.superview.superview;
			var indexPath = row.indexPath;
			if (!indexPath) return;
			var refID = this.values[indexPath.item];
			var valueIndex = this.values.indexOf(refID);
			this.values.splice(valueIndex, 1);
			this.valuesDidChange();
		} catch (err) {
		}};
	
	
InspectorPromisedObjectsDataSource.prototype.valuesDidChange = function InspectorPromisedObjectsDataSource__valuesDidChange() {
			this.context.broadcastValueChangeForKeyPathInObject('valuesAsString', this, this);
		if (this.outlineView)
			this.outlineView.reloadItem(null);};
	
	
	function isFileDrop(e) {
		return e && e.dataTransfer && e.dataTransfer.files && e.dataTransfer.files.length;
	}
	
InspectorPromisedObjectsDataSource.prototype.acceptsFiles = function InspectorPromisedObjectsDataSource__acceptsFiles(files) {

		if (!this.contentTypeFilter) return true;
	
		for (var i = 0, c = files.length; i < c; i++) {
			if (this.contentTypeFilter(files[i].type) !== true) return false;
		}
		return true;
};
	

// role OutlineViewDataSource (Core.UI) 
	
InspectorPromisedObjectsDataSource.prototype.numberOfChildrenOfItem = function InspectorPromisedObjectsDataSource_numberOfChildrenOfItem(item) {
			var n = this.values ? this.values.length : 0;
			this.placeholderLabel.hidden = (n > 0);
			return n;};
		

InspectorPromisedObjectsDataSource.prototype.childWithIndexOfItem = function InspectorPromisedObjectsDataSource_childWithIndexOfItem(index, item) {
		
			return this.values[index];
			};
		
		
InspectorPromisedObjectsDataSource.prototype.captionForItem = function InspectorPromisedObjectsDataSource_captionForItem(item) {};
		

InspectorPromisedObjectsDataSource.prototype.isItemExpandable = function InspectorPromisedObjectsDataSource_isItemExpandable(item) {
			return false;};
		

InspectorPromisedObjectsDataSource.prototype.isItemCollapsable = function InspectorPromisedObjectsDataSource_isItemCollapsable(item) {
			return false;};
		
		
InspectorPromisedObjectsDataSource.prototype.parentItemForItem = function InspectorPromisedObjectsDataSource_parentItemForItem(item) {};
		


		
		
InspectorPromisedObjectsDataSource.prototype.setItemIsSelected = function InspectorPromisedObjectsDataSource_setItemIsSelected(item, isSelected) {};
		

InspectorPromisedObjectsDataSource.prototype.beginChangingSelection = function InspectorPromisedObjectsDataSource_beginChangingSelection() {};
		
		
InspectorPromisedObjectsDataSource.prototype.endChangingSelection = function InspectorPromisedObjectsDataSource_endChangingSelection(sender) {};
		
		
InspectorPromisedObjectsDataSource.prototype.setItemIsExpanded = function InspectorPromisedObjectsDataSource_setItemIsExpanded(item, isExpanded) {};
		


		

InspectorPromisedObjectsDataSource.prototype.validateDragWithItems = function InspectorPromisedObjectsDataSource_validateDragWithItems(items) {
			return true;};
		
		
		
InspectorPromisedObjectsDataSource.prototype.validateDropInItemWithIndex = function InspectorPromisedObjectsDataSource_validateDropInItemWithIndex(e, item, index) {
			return false;};
		
		
InspectorPromisedObjectsDataSource.prototype.validateUnspecificDrop = function InspectorPromisedObjectsDataSource_validateUnspecificDrop(e) {
			return false;};
		

InspectorPromisedObjectsDataSource.prototype.handleDropInItemWithIndex = function InspectorPromisedObjectsDataSource_handleDropInItemWithIndex(e, item, index, dropEffect) {
			return;};
		
		
		
		
InspectorPromisedObjectsDataSource.prototype.menuForItems = function InspectorPromisedObjectsDataSource_menuForItems(items) {
			return;
			
			selectionForContextMenu = items;
			var menuData = {
			"$type": "Menu",
			"$domain": "Core.UI",
			"items": [
			  {
				"$type": "MenuItem",
				"$domain": "Core.UI",
				"title": LocalizedString("Delete"),
				"target": this,
				"targetMethod": "deleteFromContextMenu",
			  },
			]};
			return this.context.decodeObjectTree(menuData);};
		
		
		
		
InspectorPromisedObjectsDataSource.prototype.addObserver = function InspectorPromisedObjectsDataSource_addObserver(outlineView) {
			this.outlineView = outlineView;};
		
		
InspectorPromisedObjectsDataSource.prototype.removeObserver = function InspectorPromisedObjectsDataSource_removeObserver(outlineView) {
			this.outlineView = null;};
		

	
	
	

// role ListViewDelegate 
		
InspectorPromisedObjectsDataSource.prototype.listViewWillUseDataTransferForDraggingItems = function InspectorPromisedObjectsDataSource_listViewWillUseDataTransferForDraggingItems(listView, dataTransfer, items) {
			
			
			
			
			if (items.length !== 1) return;
			
			var itemsString = items.map(function (item) {
				return item.id; }).join(',');

			dataTransfer[this.context.objectBlueprintDataType] = JSON.stringify({"UTI":"info.appdoo-mac.appdooPublisherDataSource","properties":{"publisherResourceID":items[0].resourceID,"metadata":items[0]}});
			};
		
		
	
	
	
	var selectionForContextMenu;
InspectorPromisedObjectsDataSource.prototype.deleteFromContextMenu = function InspectorPromisedObjectsDataSource_deleteFromContextMenu() {
		if (Array.isArray(selectionForContextMenu)) selectionForContextMenu.every(function (ref) {
			this.values.splice(this.values.indexOf(ref.identify()), 1);return true; }, this);
		
		this.valuesDidChange();};
	
	
InspectorPromisedObjectsDataSource.prototype.destroy = function InspectorPromisedObjectsDataSource_destroy() {
		selectionForContextMenu = null;
		__super.prototype.destroy.call(this);};
	

InspectorPromisedObjectsDataSource.prototype.initPropertiesFromData = function InspectorPromisedObjectsDataSource_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("placeholderLabel")) this.placeholderLabel = data.placeholderLabel;
if (data.hasOwnProperty("values")) this.values = data.values;
if (data.hasOwnProperty("outlineView")) this.outlineView = data.outlineView;
if (data.hasOwnProperty("contentTypeFilter")) this.contentTypeFilter = data.contentTypeFilter;
};

InspectorPromisedObjectsDataSource.prototype.decodeData = function InspectorPromisedObjectsDataSource_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
if (data.hasOwnProperty("placeholderLabel")) decoded.placeholderLabel = this.context.decodeObjectTree(data.placeholderLabel);
if (data.hasOwnProperty("values")) decoded.values = this.context.decodeObjectTree(data.values);
return decoded; };

InspectorPromisedObjectsDataSource.prototype.encode = function InspectorPromisedObjectsDataSource_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

InspectorPromisedObjectsDataSource.prototype.encodeCloned = function InspectorPromisedObjectsDataSource_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

InspectorPromisedObjectsDataSource.prototype.expectedTypeForProperty = function InspectorPromisedObjectsDataSource_expectedTypeForProperty(key) {
	if (key === "placeholderLabel") return "UILabel";
	if (key === "values") return "array";
	if (key === "outlineView") return "";
	if (key === "contentTypeFilter") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return InspectorPromisedObjectsDataSource; }()));