
registerType('Editor.Inspector', (function () { function TextField() {} var __super = setSupertypeFromDomain(TextField, 'TextField', 'Core.UI');


	
	
TextField.prototype.initFromData = function TextField_initFromData(data) {

		if (!__super.prototype.initFromData.call(this, data, true))
			return;

		this.undefinedValue = data.undefinedValue;
		this.unfocusWithEscapeKey = true;

		this.applyBindings(true);
		return this;
};
	


	

TextField.prototype.valueShouldChangeForKeyPath = function TextField_valueShouldChangeForKeyPath(value, keyPath) {
		if (!this.DOMNode) return;

		if (keyPath === 'value') {
		
			if (value === undefined || !value.length) {
				this.value = '';
				this.placeholder = '';
				this.disabled = 'disabled';
				this.disabledByUndefinedValue = true;
			}
			
			else {
				if (this.disabledByUndefinedValue) {
					this.disabled = '';
					
					
					
					this.DOMNode.style.color = '#010101'; 

					delete this.disabledByUndefinedValue;
				}
				
				if (Array.isArray(value) === false) return;

				
				if (valuesAreEqual(value)) {

					if (value[0] === undefined || value[0] === '') {
						this.value = this.undefinedValue;
					}
					else this.value = value[0];
				}
				else {
					this.value = '';
					this.placeholder = '…';
				}
			}
			
			return true;
		}
		
		return __super.prototype.valueShouldChangeForKeyPath.call(this, value, keyPath);
};
	

TextField.prototype.loadFromFile = function TextField_loadFromFile() {

		var fileInfo = this.context.fileInfoByDialog();
		if (!fileInfo) return;
		
		if (!this.compatibilityCheck(fileInfo))
			return;
		
		this.value = this.context.nativeProxy.sendMessage('stringFromFile',fileInfo.path);
		this.onChange();
		};
	

TextField.prototype.compatibilityCheck = function TextField__compatibilityCheck(file) {

		if (this.fileTypesForImport.indexOf(file.type) === -1) {
			setTimeout(function () {
				this.context.showIncompatibilityErrorForFile(file, false, this.fileTypesForImport, null);
			}.bind(this));
			return false;
		}				
		return true;};
	
	
	Object.defineProperty(TextField.prototype, "fileTypesForImport", {
		value: ['text/plain','application/json','text/javascript','text/csv','text/xml','text/html']});
	

TextField.prototype.expectedTypeForProperty = function TextField_expectedTypeForProperty(key) {
	if (key === "fileTypesForImport") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return TextField; }()));