
registerType('appdoo.Editor', (function () { function LayoutResolver() {} var __super = setSupertypeFromDomain(LayoutResolver, 'BasicObject', 'Core');

	Object.defineProperty(LayoutResolver.prototype, "view", {
	outlet: true, get:function () { return this._view; }, set:function (v) {if (!Object.hasOwnProperty(this, "_view")) Object.defineProperty(this, "_view", { writable: true, configurable: true }); this._view = v; }});
	

	Object.defineProperty(LayoutResolver.prototype, "subviewsByID", {
	synthesized: true, get:function () { return this._subviewsByID; }, set:function (v) {if (!Object.hasOwnProperty(this, "_subviewsByID")) Object.defineProperty(this, "_subviewsByID", { writable: true, configurable: true }); this._subviewsByID = v; }});
	

// role BasicObject (Core) 
	
LayoutResolver.prototype.init = function LayoutResolver_init() {
			__super.prototype.init.call(this);
			return this;};
		
		
LayoutResolver.prototype.destroy = function LayoutResolver_destroy() {
			this.view = null;
			this.subviewsByID = null;
			__super.prototype.destroy.call(this);};
		
	
	
	
LayoutResolver.prototype.updateLayout = function LayoutResolver_updateLayout() {
	
		this.updateLayoutLazy();
	
	};
	
LayoutResolver.prototype.updateLayoutLazy = function LayoutResolver__updateLayoutLazy() {
		if (this.timer) return;
		this.timer = setTimeout(function () {
			this.updateLayoutNow();
			this.timer = null;
		}.bind(this), 0);
	};
	

LayoutResolver.prototype.updateLayoutNow = function LayoutResolver__updateLayoutNow() {
	
		if (!this.view) return;
		
		if (this.context.undoManager)
			this.context.undoManager.disableRegistration();
		else
			console.warn('Could not disable undo manager!');

		var layoutRelations = this.sortedLayoutRelationsForView(this.view, this.context.projectContext);

		if (Array.isArray(layoutRelations)) layoutRelations.every(function (lr) {
		
			var destinationObject = this.subviewsByID[lr.destination];
			var sourceObject = this.subviewsByID[lr.source];
			
			if (!sourceObject) {
				console.warn('Source object not found', lr.source);
				return true;
			}

			if (!destinationObject) {
				console.warn('Destination object not found', lr.destination);
				return true;
			}
		
			if (lr.type === 'below') {
				var y = destinationObject.position.top + destinationObject.size.height + (lr.offset || 0);
				this.setViewProperty(sourceObject, 'position.top', y);
			}
			else if (lr.type === 'right') {
				var x = destinationObject.position.left + destinationObject.size.width + (lr.offset || 0);
				this.setViewProperty(sourceObject, 'position.left', x);
			}
			else if (lr.type === 'y') {
				this.setViewProperty(sourceObject, 'position.top', destinationObject.position.top + (lr.offset || 0));
			}
			else if (lr.type === 'x') {
				this.setViewProperty(sourceObject, 'position.left', destinationObject.position.left + (lr.offset || 0));
			}
return true; }, this);
		

		if (this.context.undoManager)
			this.context.undoManager.enableRegistration();
};
	
	
LayoutResolver.prototype.setViewProperty = function LayoutResolver__setViewProperty(view, keyPath, value) {
				
		if (view.dataController) {
			view.dataController.setValueForKeyPath(value,
				keyPath,
				view.dataController
			);
		}
		else {
			view.setValueForKeyPath(value, keyPath, this);
		}
	};
	
	
LayoutResolver.prototype.sortedLayoutRelationsForView = function LayoutResolver_sortedLayoutRelationsForView(view, context) {
	
		if (!view || !view.subviews) return [];
	
		var result = [];
		
		var yOrdered = [],
			xOrdered = [];
		
		var subviewByID = {};
		
		var rounds = 1;
		
		
		while(rounds--) {
		
			if (Array.isArray(view.subviews)) view.subviews.every(function (subview) {

				subviewByID[subview.$id] = subview;
	
				if (!subview.layoutRelations)
					return true;
				
				if (Array.isArray(subview.layoutRelations)) subview.layoutRelations.every(function (lr) {
	
					if (lr.destination === 'null') return true;
	
					if (!lr.source) {
						Object.defineProperty(lr, 'source', {
							value: subview.$id,
							configurable: true
						});					
					}
						
					var destinationObject = this.subviewInView(lr.destination, view);
					
					if (!destinationObject) return true;
					
					var subviewIndex, relatedSubviewIndex, arr;
	
					if (lr.type == 'below' || lr.type === 'y') {
						arr = yOrdered;
					}
					else if (lr.type == 'right' || lr.type == 'x') {
						arr = xOrdered;
					}
					else {
						return;
					}

					
					subviewIndex = arr.indexOf(subview.$id);
					if (subviewIndex !== -1) {
						yOrdered.splice(subviewIndex, 1);
					}
					
					
					relatedSubviewIndex = arr.indexOf(lr.destination);
					if (relatedSubviewIndex !== -1) {
						arr.splice(relatedSubviewIndex, 0, subview.$id);
					}
					else {
						arr.push(lr.destination, subview.$id);
					}
					return true; }, this);
				
	return true; }, this);
			
		
		}
		
		if (Array.isArray(xOrdered)) xOrdered.every(function (ID) {
			var subview = subviewByID[ID];
			if (!subview) {
				console.warn('Subview not found with ID', ID);
				return true;
			}
			if (subview.layoutRelations)
			if (Array.isArray(subview.layoutRelations)) subview.layoutRelations.every(function (lr) {
				if (lr.type === 'right' || lr.type === 'x')
					result.push(lr);return true; }, this);
			return true; }, this);
		

		if (Array.isArray(yOrdered)) yOrdered.every(function (ID) {
			var subview = subviewByID[ID];
			if (!subview) {
				console.warn('Subview not found with ID', ID);
				return true;
			}
			if (subview.layoutRelations)
			if (Array.isArray(subview.layoutRelations)) subview.layoutRelations.every(function (lr) {
				if (lr.type === 'below' || lr.type === 'y')
					result.push(lr);return true; }, this);
			return true; }, this);
		

		this.subviewsByID = subviewByID;
		
		return result.reverse();
		};
	
	
LayoutResolver.prototype.subviewInView = function LayoutResolver__subviewInView(subviewID, view) {
		var result;
		if (Array.isArray(view.subviews)) view.subviews.every(function (subview) {
			if (subview.$id === subviewID) {
				result = subview;
				return false;
			}return true; }, this);
		
		return result;};
	
	
LayoutResolver.prototype.layoutRelationsInViewForAppdooPreview = function LayoutResolver_layoutRelationsInViewForAppdooPreview(view, transformer) {
		var sortedRelations = this.sortedLayoutRelationsForView(view, _context.projectContext);
		
		var result = [];
		
		if (Array.isArray(sortedRelations)) sortedRelations.every(function (relation) {
			result.push({
				subjectViewID: relation.source,
				objectViewID: relation.destination,
				offset: relation.offset,
				type: relation.type
			});return true; }, this);
		
		
		return result;};
	

LayoutResolver.prototype.initPropertiesFromData = function LayoutResolver_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("view")) this.view = data.view;
};

LayoutResolver.prototype.decodeData = function LayoutResolver_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

LayoutResolver.prototype.encode = function LayoutResolver_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

LayoutResolver.prototype.encodeCloned = function LayoutResolver_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

LayoutResolver.prototype.expectedTypeForProperty = function LayoutResolver_expectedTypeForProperty(key) {
	if (key === "view") return "";
	if (key === "subviewsByID") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return LayoutResolver; }()));