
registerType('appdoo', (function () { function LeftEditorView() {} var __super = setSupertypeFromDomain(LeftEditorView, 'View', 'Core.UI');

	Object.defineProperty(LeftEditorView.prototype, "scenesView", {
	outlet: true, get:function () { return this._scenesView; }, set:function (v) {if (!Object.hasOwnProperty(this, "_scenesView")) Object.defineProperty(this, "_scenesView", { writable: true, configurable: true }); this._scenesView = v; }});
	

	Object.defineProperty(LeftEditorView.prototype, "outlineViewContainer", {
	outlet: true, get:function () { return this._outlineViewContainer; }, set:function (v) {if (!Object.hasOwnProperty(this, "_outlineViewContainer")) Object.defineProperty(this, "_outlineViewContainer", { writable: true, configurable: true }); this._outlineViewContainer = v; }});
	

	Object.defineProperty(LeftEditorView.prototype, "addSomethingView", {
	outlet: true, get:function () { return this._addSomethingView; }, set:function (v) {if (!Object.hasOwnProperty(this, "_addSomethingView")) Object.defineProperty(this, "_addSomethingView", { writable: true, configurable: true }); this._addSomethingView = v; }});
	
	
	Object.defineProperty(LeftEditorView.prototype, "navigationButtonsView", {
	outlet: true, get:function () { return this._navigationButtonsView; }, set:function (v) {if (!Object.hasOwnProperty(this, "_navigationButtonsView")) Object.defineProperty(this, "_navigationButtonsView", { writable: true, configurable: true }); this._navigationButtonsView = v; }});
	

	Object.defineProperty(LeftEditorView.prototype, "displayedIndex", {
	synthesized: true, get:function () { return this._displayedIndex; }, set:function (v) {if (!Object.hasOwnProperty(this, "_displayedIndex")) Object.defineProperty(this, "_displayedIndex", { writable: true, configurable: true }); this._displayedIndex = v; }});
	

	Object.defineProperty(LeftEditorView.prototype, "animationDuration", {
		value: 0.4});
	
	
	var outlineBackgroundColor = '';

LeftEditorView.prototype.init = function LeftEditorView_init() {
		__super.prototype.init.call(this);
		this.style({ webkitTransition: 'background-color '+this.animationDuration+'s', backgroundColor:outlineBackgroundColor });
		return this;};
	
	
LeftEditorView.prototype.viewDidLoad = function LeftEditorView_viewDidLoad() {
		__super.prototype.viewDidLoad.call(this);
		this.prepareForNavigation();
		this.layoutSubviews();
		
		this.goToOutlineAnimated(false);
};
	
	
	
LeftEditorView.prototype.arrangeSubviews = function LeftEditorView__arrangeSubviews(heightOnly) {

		if (heightOnly || this.displayedIndex === 1) {
			if (!heightOnly) {
				this.outlineViewContainer.size.width = this.size.width;
			}
			this.outlineViewContainer.size.height = this.size.height-this.outlineViewContainer.position.top;
		}
};
	
	
LeftEditorView.prototype.layoutSubviews = function LeftEditorView_layoutSubviews() {
		this.navigationButtonsView.size.width = this.size.width;
		this.arrangeSubviews(false);};
	

LeftEditorView.prototype.prepareForNavigation = function LeftEditorView__prepareForNavigation() {
		
		var buttonsView = this.navigationButtonsView;
		if (buttonsView && !buttonsView.hidden) {
			var overviewButtonWidth = 75;
			this.backToScenesButton = this.context.makeButton(LocalizedString('Overview'), 75, 7-1, function (e) {
				_context.editor.goToOverview();
			}.bind(this));
			
			buttonsView.addSubview(this.backToScenesButton);
			this.backToScenesButton.toolTip = LocalizedString('Go to Overview (Space)');
	
	
			this.backButton = this.context.makeButton('', 30, overviewButtonWidth+10, function (e) {
				_context.editor.goBack();
			}.bind(this), 'Transparent');
			this.backButton.addSubview(createComponentFromDomain('ImageView','Core.UI', this.context, { size: {width:20,height:20},position:{left:5,top:2},imageSrc:'Resources/BackArrow.svg', style:{opacity:1} }));
			
			this.backButton.addBinding({
				sourceKeyPath: 'disabled',
				destination: 'historyManager',
				destinationKeyPath: 'canGoBack',
				valueTransformer: function (v) { return !v; }
			});
			
			this.backButton.styleForDisabled = function (v) {
				__super.prototype.styleForDisabled.call(this, v);
				this.style({opacity:1});
				this.subviews[this.subviews.length-1].style({opacity:v?.35:.8});
			};
			
			this.backButton.applyBindings();
			
			buttonsView.addSubview(this.backButton);
			
			this.forwardButton = this.context.makeButton('', 30, overviewButtonWidth+10+33-2-6+4-1, function (e) {
				_context.editor.goForward();
			}.bind(this), 'Transparent');
			this.forwardButton.addSubview(createComponentFromDomain('ImageView','Core.UI', this.context, { size: {width:20,height:20},position:{left:5,top:2},imageSrc:'Resources/ForwardArrow.svg', style:{opacity:.8} }));
	
			this.forwardButton.addBinding({
				sourceKeyPath: 'disabled',
				destination: 'historyManager',
				destinationKeyPath: 'canGoForward',
				valueTransformer: function (v) { return !v; }
			});
			
			this.forwardButton.styleForDisabled = this.backButton.styleForDisabled;
			
			this.forwardButton.applyBindings();
	
			buttonsView.addSubview(this.forwardButton);

		}
	};
	
	
	
	var dX = 50, btoDX = 0;
	
LeftEditorView.prototype.goToOutlineAnimated = function LeftEditorView_goToOutlineAnimated(animated) {
		this.style({backgroundColor:outlineBackgroundColor});
		this.scrollToViewAtIndexAnimated(1, animated);};
	

LeftEditorView.prototype.goToNewItemsAnimated = function LeftEditorView_goToNewItemsAnimated(animated) {
	
		this.style({backgroundColor:'rgba(255,255,255,.33)'});
		this.scrollToViewAtIndexAnimated(2, animated);

		this.forwardButton.style({opacity:0, pointerEvents:'none'});
		
		if (animated) this.backToScenesButton.beginAnimations();
		this.backToScenesButton.animationDuration = this.animationDuration;
		this.backToScenesButton.position.left = 10 - dX;
		this.backToScenesButton.style({opacity:0, pointerEvents:'none'});
		if (animated) this.backToScenesButton.commitAnimations();
		
		if (animated) this.addButton.beginAnimations();
		this.addButton.animationDuration = this.animationDuration;
		this.addButton.position.left = this.size.width-this.addButton.size.width-10 - dX;
		this.addButton.style({opacity:0, pointerEvents:'none'});
		if (animated) this.addButton.commitAnimations();

		if (animated) this.backToOutlineButton.beginAnimations();
		this.backToOutlineButton.animationDuration = this.animationDuration;
		this.backToOutlineButton.position.left = 10+btoDX;
		this.backToOutlineButton.style({opacity:1, pointerEvents:'all'});
		if (animated) this.backToOutlineButton.commitAnimations();
		};
	
	
LeftEditorView.prototype.scrollToViewAtIndexAnimated = function LeftEditorView__scrollToViewAtIndexAnimated(i, animated) {

		this.displayedIndex = i;

		this.arrangeSubviews(true);

		var targetView = this.outlineViewContainer,
			currentView = (i !== 1) ? this.outlineViewContainer : this.addSomethingView;
		
		targetView.size.width = this.size.width;
		
		var v = this.subviews[1];
		if (animated) {
			v.beginAnimations();
			v.animationDuration = this.animationDuration;
		}
		v.position.left = -targetView.position.left;
		if (animated) v.commitAnimations();
};
	

LeftEditorView.prototype.initPropertiesFromData = function LeftEditorView_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("scenesView")) this.scenesView = data.scenesView;
if (data.hasOwnProperty("outlineViewContainer")) this.outlineViewContainer = data.outlineViewContainer;
if (data.hasOwnProperty("addSomethingView")) this.addSomethingView = data.addSomethingView;
if (data.hasOwnProperty("navigationButtonsView")) this.navigationButtonsView = data.navigationButtonsView;
};

LeftEditorView.prototype.decodeData = function LeftEditorView_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
if (data.hasOwnProperty("scenesView")) decoded.scenesView = this.context.decodeObjectTree(data.scenesView);
if (data.hasOwnProperty("outlineViewContainer")) decoded.outlineViewContainer = this.context.decodeObjectTree(data.outlineViewContainer);
if (data.hasOwnProperty("addSomethingView")) decoded.addSomethingView = this.context.decodeObjectTree(data.addSomethingView);
if (data.hasOwnProperty("navigationButtonsView")) decoded.navigationButtonsView = this.context.decodeObjectTree(data.navigationButtonsView);
return decoded; };

LeftEditorView.prototype.encode = function LeftEditorView_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

LeftEditorView.prototype.encodeCloned = function LeftEditorView_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

LeftEditorView.prototype.expectedTypeForProperty = function LeftEditorView_expectedTypeForProperty(key) {
	if (key === "scenesView") return "View";
	if (key === "outlineViewContainer") return "View";
	if (key === "addSomethingView") return "View";
	if (key === "navigationButtonsView") return "View";
	if (key === "displayedIndex") return "";
	if (key === "animationDuration") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return LeftEditorView; }()));