
registerType('appdoo', (function () { function NewItemListDataSource() {} var __super = setSupertypeFromDomain(NewItemListDataSource, 'BasicObject', 'Core');

	Object.defineProperty(NewItemListDataSource.prototype, "dataContextsController", {
	outlet: true, get:function () { return this._dataContextsController; }, set:function (v) {if (!Object.hasOwnProperty(this, "_dataContextsController")) Object.defineProperty(this, "_dataContextsController", { writable: true, configurable: true }); this._dataContextsController = v; }});
	

	Object.defineProperty(NewItemListDataSource.prototype, "groups", {
	synthesized: true, get:function () { return this._groups; }, set:function (v) {if (!Object.hasOwnProperty(this, "_groups")) Object.defineProperty(this, "_groups", { writable: true, configurable: true }); this._groups = v; }});
	
	
	Object.defineProperty(NewItemListDataSource.prototype, "filteredResults", {
	synthesized: true, get:function () { return this._filteredResults; }, set:function (v) {if (!Object.hasOwnProperty(this, "_filteredResults")) Object.defineProperty(this, "_filteredResults", { writable: true, configurable: true }); this._filteredResults = v; }});
	
	
	Object.defineProperty(NewItemListDataSource.prototype, "collapsedSections", {
	outlet: true, get:function () { return this._collapsedSections; }, set:function (v) {if (!Object.hasOwnProperty(this, "_collapsedSections")) Object.defineProperty(this, "_collapsedSections", { writable: true, configurable: true }); this._collapsedSections = v; }});
	
	
	Object.defineProperty(NewItemListDataSource.prototype, "searchField", {
	synthesized: true, get:function () { return this._searchField; }, set:function (v) {if (!Object.hasOwnProperty(this, "_searchField")) Object.defineProperty(this, "_searchField", { writable: true, configurable: true }); this._searchField = v; }});
	

	Object.defineProperty(NewItemListDataSource.prototype, "listView", {
	synthesized: true, get:function () { return this._listView; }, set:function (v) {if (!Object.hasOwnProperty(this, "_listView")) Object.defineProperty(this, "_listView", { writable: true, configurable: true }); this._listView = v; }});
	
	
	
NewItemListDataSource.prototype.init = function NewItemListDataSource_init() {
		__super.prototype.init.call(this);
		if (!this.collapsedSections) this.collapsedSections = [];
		
		
		
		
		this.dataContexts = [];

		this.observeObject(this.dataContextsController);
		
		this.groups = this.context.elementGroups;
		this.listen(this.context.userPlugInManager, 'change', function (e) {
			this.groups = this.context.elementGroups;
			this.listView.reloadData();
		}.bind(this));

		this.prepareDataForSearch();
		return this;};
	
	
NewItemListDataSource.prototype.prepareDataForSearch = function NewItemListDataSource__prepareDataForSearch() {
		if (Array.isArray(this.groups)) this.groups.every(function (group) {
			if (Array.isArray(group.items)) group.items.every(function (item) {
				
				var a = [];
				if (item.dataType === 'view') {
					a.push(item.value["description"].toLowerCase());
					a.push(item.value["name"].toLowerCase());
					a.push(item.value["text"].toLowerCase());
				} else {
					for (var key in item) {
						if (typeof item[key] === 'string') {
							a.push(item[key].toLowerCase());
						}
					}
				}
				item.textForSearch = a.join(' ');return true; }, this);
			return true; }, this);
		};
	
	
NewItemListDataSource.prototype.filterWithQuery = function NewItemListDataSource__filterWithQuery(query) {
	
		if (typeof query !== 'string' || !query) {
			this.filteredResults = null;
			this.listView._listFooterEnabled = false;
			return;
		}
		this.listView._listFooterEnabled = true;
	
		query = query.toLowerCase();

		var r = [];
		
		if (Array.isArray(this.groups)) this.groups.every(function (group) {
			if (Array.isArray(group.items)) group.items.every(function (item) {
				if (!item.textForSearch) return true;
				if (item.textForSearch.indexOf(query) !== -1)
					r.push(item);return true; }, this);
			return true; }, this);
		
		
		this.filteredResults = r;};
	
	
// role TextFieldDelegate 
	
NewItemListDataSource.prototype.textFieldDidGetInput = function NewItemListDataSource_textFieldDidGetInput(textField) {
			this.filterWithQuery(textField.value);
			this.list.reloadData();};
		
	
	

NewItemListDataSource.prototype.sectionIsCollapsed = function NewItemListDataSource__sectionIsCollapsed(section) {
		if (!this.collapsedSections) return false;
		var id = this.idForDataInSection(section);
		return this.collapsedSections.indexOf(id) !== -1;};
	
	
NewItemListDataSource.prototype.sectionShouldBeExcluded = function NewItemListDataSource__sectionShouldBeExcluded(section) {

		if (this.sectionIsDataContextAtIndex(section)) {
			var dataContext = this.dataContexts[section];
			if (dataContext.dataSource && dataContext.dataSource.shouldNotPreviewInEditor)
				return true;
		}
		return false;};
	
	
NewItemListDataSource.prototype.groupForSection = function NewItemListDataSource__groupForSection(section) {
		return this.groups[section-this.dataContexts.length];};
	
	
NewItemListDataSource.prototype.createDataPreviewCellForItem_inListView_ = function NewItemListDataSource__createDataPreviewCellForItem_inListView_(item, listView, dataContext) {

		var cell = createComponentFromDomain("DataPreviewCell", "appdoo", this.context, {
			size: { width: listView.size.width, height: 40 },
			autoresizingMask: 2,
			input: item,
			dataType: item.dataType,
			originalDataSource: dataContext ? dataContext.dataSource : null,
			originalDataContext: dataContext})
		;

		cell.styleDefault();
		return cell;
	};
	
	
	function preparePlugInCellOnMouseOver(cell, item) {
		this.mouseOverUserPlugIn = item;

		if (cell.isPrepared) return;
		cell.isPrepared = true;
		cell.contextMenu = this.contextMenuForPlugins;
	}

// role ListViewDataSource 
	
NewItemListDataSource.prototype.numberOfSections = function NewItemListDataSource_numberOfSections() {
			if (this.filteredResults) return 1;
			return this.dataContexts.length + this.groups.length;};
		
	
NewItemListDataSource.prototype.numberOfItemsInSection = function NewItemListDataSource_numberOfItemsInSection(section) {
		
			if (this.filteredResults) return this.filteredResults.length;
			
			if (this.sectionIsCollapsed(section)) return 0;
			
			if (this.sectionShouldBeExcluded(section)) return 0;
			
			if (this.sectionIsDataContextAtIndex(section)) {
				var dataContext = this.dataContexts[section];
				if (!dataContext) return 0;
				return dataContext.items.length;
			}
		
			var group = this.groupForSection(section);
			if (!group) return 0;

			return group.items.length;
};
		
	
NewItemListDataSource.prototype.dataForItemInSectionAtIndex = function NewItemListDataSource_dataForItemInSectionAtIndex(section, row) {
			if (this.filteredResults) return this.filteredResults[row];
			if (this.sectionIsDataContextAtIndex(section)) {
				var dataContext = this.dataContexts[section];
				return dataContext.items[row];
			}
			return this.groupForSection(section).items[row];};
		
		
NewItemListDataSource.prototype.listViewCellForRowAtIndexPath = function NewItemListDataSource_listViewCellForRowAtIndexPath(listView, indexPath) {
		
			var cell, canMove = true;
			
			if (!this.filteredResults) {

				if (this.sectionIsDataContextAtIndex(indexPath.section)) {
					var dataContext = this.dataContexts[indexPath.section];
					var item = dataContext.items[indexPath.item];
					cell = this.createDataPreviewCellForItem_inListView_(item, listView, dataContext);
					canMove = cell.isDraggable;

				} else {
				
					var item = this.groupForSection(indexPath.section).items[indexPath.item];

					cell = this.cachedCellForItem(item);

					if (!cell) {
									
						if (item.useDataCell) {
							cell = this.createDataPreviewCellForItem_inListView_(item, listView);
						}
						else {
							cell = listView.createRowContentView();
						}
						
						if (item.isUserPlugIn) {
							cell.DOMNode.onmouseover = preparePlugInCellOnMouseOver.bind(this, cell, item);
						}
						
						this.cacheCellForItem(cell, item);
					}
					else {
						cell.size.width = this.listView.size.width;
					}
				
				}
				
			}
		
			if (!cell) {
				cell = listView.createRowContentView();
				if(this.filteredResults !== undefined) {
					var item = this.filteredResults[indexPath.item];
					if (item.useDataCell) {
						cell = this.createDataPreviewCellForItem_inListView_(item, listView);
					}
					else {
						cell = listView.createRowContentView();
					}
					if (item.isUserPlugIn) {
						cell.DOMNode.onmouseover = preparePlugInCellOnMouseOver.bind(this, cell, item);
					}
					this.cacheCellForItem(cell, item);
				}
			}
			
			if (canMove) cell.DOMNode.className = 'canMove';
			
			cell.DOMNode.ondblclick = function (e) {
			
				var UTI = this.utiForCell(cell, e);
				if (!UTI) return;
				
				var transferData = this.transferDataForCell(cell);
				var proto = getPrototype(UTI);
				var isView = (proto instanceof getType('Core.UI.View'));
				
				_context.editor.handleDblClickInsertion(UTI, transferData, isView);
				


			}.bind(this);
			
			return cell;
			};
		
		
NewItemListDataSource.prototype.cachedCellForItem = function NewItemListDataSource__cachedCellForItem(item) {
			return null;};
		
		
NewItemListDataSource.prototype.cacheCellForItem = function NewItemListDataSource__cacheCellForItem(cell, item) {
			};
		
		
NewItemListDataSource.prototype.titleForHeaderInSection = function NewItemListDataSource_titleForHeaderInSection(section) {
			if (this.filteredResults) return;
			if (this.sectionIsDataContextAtIndex(section)) {
				var dataContext = this.dataContexts[section];
				return dataContext.name;
			}
			var group = this.groupForSection(section);
			return group.name;};
		
		
NewItemListDataSource.prototype.addObserver = function NewItemListDataSource_addObserver(o) {
			this.list = o;};
		
	
NewItemListDataSource.prototype.removeObserver = function NewItemListDataSource_removeObserver() {
			this.list = null;};
		

	
	
	Object.defineProperty(NewItemListDataSource.prototype, "contextMenuForPlugins", {
	synthesized: true, 
		get: function () {
			if (!this._contextMenuForPlugins) {
				this.contextMenuForPlugins = this.context.decodeObjectTree({
					"$type": "Menu",
					"$domain": "Core.UI",
					"items": [
					  {
						"$type": "MenuItem",
						"$domain": "Core.UI",
						"title": LocalizedString("Delete"),
						"target": this,
						"targetMethod": "uninstallHoveredPlugIn",
					  },
					]
				});
			}
			return this._contextMenuForPlugins;
		}, set:function (v) {if (!Object.hasOwnProperty(this, "_contextMenuForPlugins")) Object.defineProperty(this, "_contextMenuForPlugins", { writable: true, configurable: true }); this._contextMenuForPlugins = v; }});
	
	
NewItemListDataSource.prototype.uninstallHoveredPlugIn = function NewItemListDataSource_uninstallHoveredPlugIn() {
		this.context.userPlugInManager.uninstallPlugIn(this.mouseOverUserPlugIn);};
	
	
	
// role ListViewDelegate 

NewItemListDataSource.prototype.listViewWillBeginDraggingRowWithEvent = function NewItemListDataSource_listViewWillBeginDraggingRowWithEvent(listView, rowView, e) {
			
			if (rowView.contentView.isDraggable === false) return true;
	
			this.context.showGrabCursor();
			
			var isDraggingPreviewedData = rowView.contentView.output !== undefined;
			
			if (isDraggingPreviewedData)
			{ return this.dragPreviewedDataRowWithEvent(rowView, e); }
			else
			{ return this.dragPrototypeRowWithEvent(rowView, e); }
				};
		
		
NewItemListDataSource.prototype.validateDragWithItems = function NewItemListDataSource_validateDragWithItems(items) {
			return false;};
		

	
	
NewItemListDataSource.prototype.completeOutputBindings = function NewItemListDataSource__completeOutputBindings(bindings, indexPath) {

		if (this.sectionIsDataContextAtIndex(indexPath.section)) {
			var dataContext = this.dataContexts[indexPath.section];
			if (!dataContext) return false;
			var data = dataContext.items[indexPath.item];
			if (!data) return false;


			if (Array.isArray(bindings)) bindings.every(function (b) {
				b.destination = dataContext.dataSource.$id;
				if (!b.destinationKeyPath) b.destinationKeyPath = data.keyPath;
				if (dataContext.indexPath)
					b.enumerableItemAccess = true;return true; }, this);
			
	
			return true;
		}
		else {
			console.warn('Something went wrong');
			return false;
		}
};
	
	
NewItemListDataSource.prototype.startDraggingView_withDataTransfer_event = function NewItemListDataSource__startDraggingView_withDataTransfer_event(view, dataTransferData, e, isBlueprint) {
	

		var dragItem = createComponentFromDomain("DragItem", "Core.UI", this.context, {
			sourceView: view,
			dragContext: this.context.projectContext,
			
			position: {
				left: -view.getRelativeX(0),
				top: -view.getRelativeY(-2)
			},
			
			dataTransferData: dataTransferData,
			onFinish: function () {
			}.bind(this)})
		;

		dragItem.sourceViewClone.DOMNode.className += 'forceHiddenScrollbars';
		if (!isBlueprint)
			dragItem.sourceViewClone.DOMNode.style.outline = '1px solid rgba(180,180,180,.4)';

		dragItem.dragWithEvent(e);

		return false;
	};
	
	
NewItemListDataSource.prototype.dragPreviewedDataRowWithEvent = function NewItemListDataSource__dragPreviewedDataRowWithEvent(rowView, e) {

		var dataTransferData = this.transferDataForCell(rowView.contentView);
		var dragItemSourceView = rowView.contentView.output;
		return this.startDraggingView_withDataTransfer_event(dragItemSourceView, dataTransferData, e, false);
	};
	
	
NewItemListDataSource.prototype.dragPrototypeRowWithEvent = function NewItemListDataSource__dragPrototypeRowWithEvent(rowView, e) {
		
		var dataTransferData = this.transferDataForCell(rowView.contentView);
		var dragItemSourceView = rowView.contentView.subviews[0];
		return this.startDraggingView_withDataTransfer_event(dragItemSourceView, dataTransferData, e, true);
};
	
	
NewItemListDataSource.prototype.transferDataForCell = function NewItemListDataSource__transferDataForCell(cell) {
	
		var rowView = cell.superview;
	
		if (cell.output) {

			var dataPreviewCell = rowView.contentView;
			var dragItemSourceView = dataPreviewCell.output;
			var data = dragItemSourceView.encode();
			if(dragItemSourceView.constructor.name == "UIButton") {
				data.CSSTextColor = this.context.projectContext.defaultOrSystemTintColor;
			}
			if (dataPreviewCell.outputBindings) {
				data.bindings = dataPreviewCell.outputBindings;
				if (!this.completeOutputBindings(data.bindings, rowView.indexPath)) return false;
			}
	
			var dataTransferData = {};
			dataTransferData[this.context.objectTreeDataType] = JSON.stringify(data);
		
		} else {
	
			var indexPath = rowView.indexPath;
			var item = this.dataForItemInSectionAtIndex(indexPath.section, indexPath.item);
			
			var dataTransferData = {};
			dataTransferData[this.context.objectBlueprintDataType] = JSON.stringify(item);
		
		}
		return dataTransferData;};
	
	
NewItemListDataSource.prototype.utiForCell = function NewItemListDataSource__utiForCell(cell, e) {

		if (cell.dataType === 'items') return null;

		if (cell.output) return cell.output.UTI;
		
		var indexPath = cell.superview.indexPath;
		var item = this.dataForItemInSectionAtIndex(indexPath.section, indexPath.item);
		if (item) return item.UTI;
	};
	
	
NewItemListDataSource.prototype.idForDataInSection = function NewItemListDataSource__idForDataInSection(section) {
		if (this.sectionIsDataContextAtIndex(section)) {
			var dataContext = this.dataContexts[section];
			return dataContext.identify();
		}
		else {
			var group = this.groupForSection(section);
			return this.context.identify(group);
		}};
	


NewItemListDataSource.prototype.setSectionIsCollapsed = function NewItemListDataSource_setSectionIsCollapsed(section, isCollapsed) {
	
		if (isNaN(section)) return;
		
		var id = this.idForDataInSection(section);
		var indexInCollapsedSections = this.collapsedSections.indexOf(id);
		var isAlreadyInDesiredState = isCollapsed === !(indexInCollapsedSections === -1);
		
		if (isAlreadyInDesiredState)
			return;

		if (isCollapsed) {
			this.collapsedSections.push(id);
		}
		else {
			this.collapsedSections.splice(indexInCollapsedSections, 1);
		}
		
		this.list.reloadDataLazy();
		
};
	
	
NewItemListDataSource.prototype.sectionIsCollapsedAtIndex = function NewItemListDataSource_sectionIsCollapsedAtIndex(section) {

		var id = this.idForDataInSection(section);
		return this.collapsedSections.indexOf(id) !== -1;
	};
	

		
NewItemListDataSource.prototype.sectionIsDataContextAtIndex = function NewItemListDataSource_sectionIsDataContextAtIndex(section) {
		return section < this.dataContexts.length;};
	
	
NewItemListDataSource.prototype.iconForDataContextAtIndex = function NewItemListDataSource_iconForDataContextAtIndex(section) {
		var dataContext = this.dataContexts[section];
		if (dataContext) return dataContext.icon;};
	

NewItemListDataSource.prototype.dataContextAtIndex = function NewItemListDataSource_dataContextAtIndex(section) {
		var dataContext = this.dataContexts[section];
		if (dataContext) return dataContext;};
	
	
// role Observer 
	
NewItemListDataSource.prototype.observedObjectValueDidAppearForKey = function NewItemListDataSource_observedObjectValueDidAppearForKey(obj, key, sender) {
		
			var dataContext = obj.get(key);
			if (dataContext && dataContext.dataSource.shouldNotPreviewInEditor)
				return;

			this.updateAndReload();
			this.list.DOMNode.scrollTop = 0;};
		
		
NewItemListDataSource.prototype.observedObjectValueDidDisappearForKey = function NewItemListDataSource_observedObjectValueDidDisappearForKey(obj, key, sender) {
			this.updateAndReload();};
		

NewItemListDataSource.prototype.observedObjectValuesDidReplace = function NewItemListDataSource_observedObjectValuesDidReplace(obj, sender) {
			this.updateAndReload();
			this.list.DOMNode.scrollTop = 0;};
		

NewItemListDataSource.prototype.observedObjectValueDidChangeForKeyPath = function NewItemListDataSource_observedObjectValueDidChangeForKeyPath(obj, keyPath, sender) {
			if (obj === this.dataContextsController) {
				var dataContext = obj.get(keyPath);
				if (dataContext && dataContext.dataSource) {
					if (!dataContext.dataSource.shouldNotPreviewInEditor) {
						this.updateAndReload();
					}
				}
			}};
		
	
	
	
NewItemListDataSource.prototype.updateAndReload = function NewItemListDataSource__updateAndReload() {
		this.dataContexts = [];
		if (Array.isArray(this.dataContextsController.contents)) this.dataContextsController.contents.every(function (ctx) {
			if (ctx.items && ctx.items.length) this.dataContexts.push(ctx);return true; }, this);
		
		this.dataContexts.reverse();
		if (this.list) this.list.reloadData();};
	

NewItemListDataSource.prototype.initPropertiesFromData = function NewItemListDataSource_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("dataContextsController")) this.dataContextsController = data.dataContextsController;
if (data.hasOwnProperty("collapsedSections")) this.collapsedSections = data.collapsedSections;
};

NewItemListDataSource.prototype.decodeData = function NewItemListDataSource_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

NewItemListDataSource.prototype.encode = function NewItemListDataSource_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

NewItemListDataSource.prototype.encodeCloned = function NewItemListDataSource_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

NewItemListDataSource.prototype.expectedTypeForProperty = function NewItemListDataSource_expectedTypeForProperty(key) {
	if (key === "dataContextsController") return "";
	if (key === "groups") return "";
	if (key === "filteredResults") return "";
	if (key === "collapsedSections") return "";
	if (key === "searchField") return "";
	if (key === "listView") return "";
	if (key === "contextMenuForPlugins") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return NewItemListDataSource; }()));
registerType('appdoo', (function () { function NewItemList() {} var __super = setSupertypeFromDomain(NewItemList, 'ListView', 'Core.UI');

	var sectionHeaderColor = 'hsl(0,0%,33%)';
	
	var numberOfSectionsBefore;
	
NewItemList.prototype.reloadDataLazy = function NewItemList_reloadDataLazy() {
		if (!_context.editor.editedScene) return;
	
		__super.prototype.reloadDataLazy.call(this);
		var defaultScrollTop = 0;
		
		var numberOfSections = this.dataSource.numberOfSections();
		
		if (document.activeElement === document.body && numberOfSections !== numberOfSectionsBefore) {
			this.DOMNode.scrollTop = defaultScrollTop;
			numberOfSectionsBefore = numberOfSections;
		}

		this.layoutSubviews();};
	


NewItemList.prototype.initFromData = function NewItemList_initFromData(data) {

		var self = __super.prototype.initFromData.call(this, data);

		self.draggable = true;
		self.selectable = false;
		self.separatorColor = 'transparent';
		
		this.style({
		  "backgroundColor" : "transparent"
		});
		
		self.sectionHeaderTemplate = {
					$type: 'View',
					$domain: "Core.UI",
					style: {
						boxSizing: 'border-box',
						backgroundColor: 'rgba(238,238,238,0.6)',
					},
					size: {
						width: 210,
						height: 22
					},
					subviews: [
					  {
						$type: "DisclosureLabel",
						$domain: "Core.UI",
						selected: true,
						colorStyle: 0,
						labelStyle: {
							fontSize: '12px',
							fontWeight: 'bold',
							color: sectionHeaderColor,
							textAlign: 'left',
							_textShadow: '0 1px 0 hsla(0,0%,100%,.6)'
						},
						position: { left: 10, top: 4 },
						size: { width: 200, height: 15 },
						autoresizingMask: 2,
						delegate: this
					  }
				    ]
				};

		self.delegate = data.delegate;
		self.dataSource = data.dataSource;
		self.searchField = data.dataSource.searchField; 
		self.dataSource.listView = self;
		self._listFooterEnabled = false;
		
		return self;};
	


// role DisclosureTriangleDelegate (Core.UI) 

NewItemList.prototype.disclosureTriangleDidChange = function NewItemList_disclosureTriangleDidChange(disclosureTriangle) {
			if (this.dataSource)
				this.dataSource.setSectionIsCollapsed(disclosureTriangle.tag, !disclosureTriangle.selected);};
		

	
	
NewItemList.prototype.decorateSectionHeaderAtIndexWithTitle = function NewItemList__decorateSectionHeaderAtIndexWithTitle(sectionHeaderView, sectionIndex, title) {

		if (this.dataSource.sectionShouldBeExcluded(sectionIndex)) {
			sectionHeaderView.style({overflow:'hidden'});
			sectionHeaderView.size.height = 0;
			return;
		}

		var icon;

		sectionHeaderView.subviews[0].tag = sectionIndex;
		sectionHeaderView.subviews[0].selected = !this.dataSource.sectionIsCollapsedAtIndex(sectionIndex);

		if (this.dataSource.sectionIsDataContextAtIndex(sectionIndex)) {
			icon = this.dataSource.iconForDataContextAtIndex(sectionIndex);
		}
		
		__super.prototype.decorateSectionHeaderAtIndexWithTitle.call(this, sectionHeaderView, sectionIndex, title);
		
		if (!icon) return;
		
		var displayIconLeft = true;

		var dx = 23+3;
		var label = sectionHeaderView.subviews[0].subviews[1];
		if (displayIconLeft)
			label.position.left += dx-3;
		else
			label.size.width -= dx;
		label.size.width -= 20;
		
		var iconLeft = displayIconLeft ? 23 : sectionHeaderView.size.width-dx;
		
		var iconButton = createComponentFromDomain("Button", "Core.UI", this.context, {
			size: { width: 22, height: 20 },
			position: { left: iconLeft, top: 1 },
			autoresizingMask: displayIconLeft?0:1,
			imageSrc: icon,
			action: function () {
				var dataContext = this.dataSource.dataContextAtIndex(sectionIndex);
				if (dataContext && dataContext.dataSource) {
					_context.editor.selectSingleObject(dataContext.dataSource);
				}
			}.bind(this)})
		;
		sectionHeaderView.addSubview(iconButton);
		
		
		var dataContext = this.dataSource.dataContextAtIndex(sectionIndex);
		if (dataContext.keyPath) {
		
			var stepUpButton = createComponentFromDomain("SpriteButton", "Core.UI", this.context, {
				size: { width: 16, height: 16 },
				position: { left: sectionHeaderView.size.width-dx+1, top: 3 },
				autoresizingMask: 1,
				sprite: 'Resources/DataContextGoBack.png',
				highlightOnMouseOver:true,
				toolTip: LocalizedString('Up One Level'),
				action: function () {
					var dataContext = this.dataSource.dataContextAtIndex(sectionIndex);
					dataContext.dropLastKeyPathComponent();
				}.bind(this)})
			;
			
			sectionHeaderView.addSubview(stepUpButton);
			
			var keyPath = dataContext.keyPath;
			if (dataContext.dataSource && dataContext.dataSource.rootDataKeyPath) {
				keyPath = keyPath.substr(dataContext.dataSource.rootDataKeyPath.length+1);
			}

			var keyPathLabel = createComponentFromDomain("Label", "Core.UI", this.context, {
				text: keyPath,
				style: { color: 'hsl(0,0%,48%)', pointerEvents: 'none', fontSize: '11px' },
				position: { left: 42+1-17, top: 20 }})
			;
			sectionHeaderView.addSubview(keyPathLabel);
			sectionHeaderView.size.height = 40;
			
			label.size.width -= 20;
		}};
	
	
NewItemList.prototype.clearFilter = function NewItemList_clearFilter() {
		this.dataSource.filterWithQuery(null);
		if(this.searchField !== undefined && this.searchField.value !== undefined) {
			this.searchField.value = "";
		}
		this.scrollTop = 0;
		this.reloadData();};
	
	
NewItemList.prototype.expectedTypeForProperty = function NewItemList_expectedTypeForProperty(key) {
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return NewItemList; }()));
registerType('appdoo', (function () { function DataPreviewCell() {} var __super = setSupertypeFromDomain(DataPreviewCell, 'View', 'Core.UI');

	Object.defineProperty(DataPreviewCell.prototype, "input", {
	outlet: true, get:function () { return this._input; }, set:function (v) {if (!Object.hasOwnProperty(this, "_input")) Object.defineProperty(this, "_input", { writable: true, configurable: true }); this._input = v; }});
	

	Object.defineProperty(DataPreviewCell.prototype, "dataType", {
	outlet: true, get:function () { return this._dataType; }, set:function (v) {if (!Object.hasOwnProperty(this, "_dataType")) Object.defineProperty(this, "_dataType", { writable: true, configurable: true }); this._dataType = v; }});
	

	Object.defineProperty(DataPreviewCell.prototype, "originalDataSource", {
	outlet: true, get:function () { return this._originalDataSource; }, set:function (v) {if (!Object.hasOwnProperty(this, "_originalDataSource")) Object.defineProperty(this, "_originalDataSource", { writable: true, configurable: true }); this._originalDataSource = v; }});
	

	Object.defineProperty(DataPreviewCell.prototype, "originalDataContext", {
	outlet: true, get:function () { return this._originalDataContext; }, set:function (v) {if (!Object.hasOwnProperty(this, "_originalDataContext")) Object.defineProperty(this, "_originalDataContext", { writable: true, configurable: true }); this._originalDataContext = v; }});
	

DataPreviewCell.prototype.init = function DataPreviewCell_init() {
		__super.prototype.init.call(this);
		this.prepare();
		return this;};
	
	
DataPreviewCell.prototype.styleDefault = function DataPreviewCell_styleDefault() {
		var c = this.input.isElement ? 'transparent' : 'transparent';
		this.style({
		backgroundColor: c,
		webkitFontSmoothing: 'antialiased' });};
	

	function isURL(str) {
	
		if (str.indexOf('http://') === 0) return true;
		if (str.indexOf('https://') === 0) return true;
		if (str.indexOf('file:') === 0) return true;
		var ext = (str.substr(str.length-4)).toLowerCase();
		if (ext === '.png' || ext === '.jpg' || ext === '.gif' || ext === 'jpeg') return true;

		return false;
	}

	function isImageURL(str) {
	
		var suffixes = [
			'.jpg',
			'.jpeg',
			'.gif',
			'.png',
		];

		for (var i = 0, c = suffixes.length; i < c; i++) {
			if (str.toLowerCase().indexOf(suffixes[i]) !== -1) return true;
		}
		
		return false;
	
	}

	function isVideoURL(str) {
	
		var suffixes = [
			'.mp4',
			'.m4v',
			'.mov',
			'.m3u8',
		];

		for (var i = 0, c = suffixes.length; i < c; i++) {
			if (str.toLowerCase().indexOf(suffixes[i]) !== -1) return true;
		}
		
		return false;
	
	}

	function isAudioURL(str) {
	
		var suffixes = [
			'.mp3',
			'.m4a',
			'.aac',
			'.wav',
			'.aif',
			'.aiff',
		];

		for (var i = 0, c = suffixes.length; i < c; i++) {
			if (str.toLowerCase().indexOf(suffixes[i]) !== -1) return true;
		}
		
		return false;
	
	}

	function isXML(str) {
		var numberOfLeftChevrons = str.split("<").length - 1;
		var numberOfRightChevrons = str.split(">").length - 1;
		
		if (numberOfLeftChevrons > 3 && !(Math.abs(numberOfLeftChevrons-numberOfRightChevrons) > 1)) {
			return true;
		}
		
		return false;
	}
	
	function mightBeHTML(str) {
		if (str.indexOf('<a href') !== -1) return true;
		if (str.indexOf('<img ') !== -1) return true;
		if (str.indexOf('<p>') !== -1) return true;
		if (str.indexOf('<b>') !== -1) return true;
		if (str.indexOf('<br>') !== -1) return true;
		return false;
	}
	
	function isReference(str) {
		return str.indexOf('***REF*') === 0;
	}

DataPreviewCell.prototype.detectTypeOfData = function DataPreviewCell__detectTypeOfData() {

		if (this.dataType || !this.input) return;

		var t;
		
		if (this.originalDataSource) {
			if (this.originalDataSource.suggestedDataTypeForKeyPath) {
				t = this.originalDataSource.suggestedDataTypeForKeyPath(this.input.keyPath, this.input.value);
			}
		}
		
		if (!t) {
			var value = this.input.value;
			
			if (typeof value === 'string') {
				if (this.input.key === 'title') {
					t = 'title';
				}
				else if (isXML(value)) {
					t = 'html';
				}
				else if (mightBeHTML(value)) {
					t = 'html';
				}
				else if (isURL(value)) {
					if (isImageURL(value)) {
						t = 'image-url';
					}
					else if (isVideoURL(value)) {
						t = 'video-url';
					}
					else if (isAudioURL(value)) {
						t = 'audio-url';
					}
					else {
						t = 'url';
					}
				}
				else if (isReference(value)) {
					t = 'reference';
				}
				else if (value.length > 25) {
					t = 'text';
				}
				
				if (!t) t = 'text';
			
			}
			else if (typeof value === 'number') {
				if (this.originalDataSource.mutable) t = 'number';
				else t = 'text';
			}
			else if (typeof value === 'boolean') {
				if (this.originalDataSource.mutable) t = 'boolean';
			}
			else if (typeof value === 'object') {
				if (Array.isArray(value)) {
					t = 'items';
				}
				else if (value && value.UTI) {
					t = null;
					
				}
				else if (value !== null) {
					t = 'object';
				}
			}
		}
		
		this.dataType = t;};
	
	
	function arrayValuesAreStrings(value) {
		for (var i = 0, c = value.length; i < c; i++) {
			if (typeof value[i] !== 'string') return false;
		}
		return true;
	}
	
	function processTextValueForPreview(value) {
		if (typeof value === 'string') return value.substr(0, 200);
		return value;
	}
	
DataPreviewCell.prototype.determineOutput = function DataPreviewCell__determineOutput() {
		if (!this.input) return;
		
		if ((this.input.key === '$id' || this.input.key === '$timestamp') && this.originalDataSource.mutable) {
			return;
		}
		
		var targetView = _context.editor.editedSubview;
		switch (this.dataType) {
			case 'text':
			case 'title':
			case 'text':
			case 'number':
			
				if (this.originalDataSource.mutable) {
					this.output = getType('appdoo.iOS.UITextField').prototype.createForSuperview(targetView);
					this.output.size.width = 210-20;
					this.output.text = this.input.value;
					if (this.input.key.toLowerCase() === 'password') this.output.secureTextEntry = true;
					this.output.name = this.input.key;
					this.output.placeholder = this.input.key;
					this.output.updateInputView();
					this.outputBindings = [{ sourceKeyPath: 'text' }];
				}
				else {
					this.output = getType('appdoo.iOS.UILabel').prototype.createForSuperview(targetView);
					this.output.size.width = 210;
					this.output.text = processTextValueForPreview(this.input.value);
					this.outputBindings = [{ sourceKeyPath: 'text' }];
					
					if (this.dataType === 'title') {
						this.output.fontName = '_DEFAULT_BOLD_';
						this.output.layoutMode = 'singleLine';
					}
					if (this.dataType === 'text') {
						this.output.fontSize = 15;
						this.output.layoutMode = 'autoFitHeight';
					}
				}
				
			
				
				break;
				
			case 'boolean':
				if (this.originalDataSource.mutable) {
					this.output = getType('appdoo.iOS.UISwitch').prototype.createForSuperview(targetView);
					this.output.on = this.input.value;
					this.output.name = this.input.key;
					this.outputBindings = [{ sourceKeyPath: 'on' }];
				}
				break;
			
			case 'options':
				if (this.originalDataSource.mutable) {
					this.output = getType('appdoo.iOS.UISegmentedControl').prototype.createForSuperview(targetView, {segments:this.input.value});
					this.output.size.width = 210-20;
					this.outputBindings = [{ sourceKeyPath: 'titleStrings' },{ sourceKeyPath: 'selectedSegmentIndex1', destinationKeyPath: 'titleStringsSelected' }];
				}
				break;

			case 'url':
				this.output = getType('info.appdoo-mac.Hyperlink').prototype.createForSuperview(targetView);
				this.output.size.width = 210;
				this.output.text = this.input.value;
				this.output.URL = this.input.value;
				this.outputBindings = [{ sourceKeyPath: 'text' }, { sourceKeyPath: 'URLString' }];
				break;
				
			case 'image-url':
				this.output = getType('appdoo.iOS.UIImageViewWithURL').prototype.createForSuperview(targetView);
				this.output.size = { width: 150, height: 75 };
				this.output.delegate = this;
				this.output.resourceContext = this.context.projectContext;
				this.output.imageURLString = this.input.value;
				this.outputBindings = [{ sourceKeyPath: 'imageURLString' }];
				break;

			case 'video-url':
				this.output = this.generateOutputViewForUTIs(['info.appdoo-mac.MoviePlayerView'], null, ['movieURLString']);
				break;

			case 'audio-url':
				this.output = this.generateOutputViewForUTIs(['info.appdoo-mac.SimpleAudioPlayer'], null, ['soundURLString']);
				break;
				
			case 'html':
				this.output = getType('info.appdoo-mac.SimpleHTMLView').prototype.createForSuperview(targetView);
				this.output.content = this.input.value;
				this.output.size = { width: 190+20, height: 190 };
				this.outputBindings = [{ sourceKeyPath: 'content' }];
				this.output.canScroll = false;
				this.output.autoresizingMask = 2;
				this.output.layoutSubviews();
				break;

			case 'items':

				var dataSourceId = this.originalDataSource.identify(),
					dataKeyPath = this.input.keyPath;
					
				if (this.originalDataSource.rootDataKeyPath)
					dataKeyPath = dataKeyPath.substr(this.originalDataSource.rootDataKeyPath.length+1);
				
				if (!this.originalDataSource.canBeKeyPathFiltered)
					dataKeyPath = undefined;
				
				var properties = {
								e_dataSourceID: dataSourceId,
								e_dataSourceDataKeyPath: dataKeyPath
							};

				this.output = this.generateOutputViewForUTIs(['appdoo.iOS.UITableView', 'appdoo.iOS.UICollectionView'], properties);
				
				break;

			case 'reference':

				this.output = this.generateOutputViewForUTIs(['info.appdoo-mac.ObjectProxy'], {
					originalObjectID: this.input.value.substr('***REF*'.length)
				}, ['originalObjectRef']);
				
				break;

			case 'object':
				this.output = this.context.decodeObjectTree({
					$type: 'Button', $domain: 'Core.UI',
					size: { height: 21-2-1+2-4+2, width: widthForTextWithAttributes(this.input.name, {fontSize: '11px'}) + 16 },
					buttonStyle: 'roundedFlat',
					text: this.input.name,
					action: function () {
						_context.editor.pushDataContextForDataContextWithDataKeyPath(this.originalDataContext, this.input.keyPath);
						_context.editor.newItemListDataSource.listView.scrollTo(0,0);
					}.bind(this)
				});
				this.output.label.style({fontSize:'11px'});
				if (this.input.value === null || !Object.keys(this.input.value).length) {
					this.output.disabled = true;
				}
				break;
				
			case 'view':
				if (targetView)
					this.output = targetView.context.decodeObjectTree(this.input.value);
				break;
		}};
	
	
DataPreviewCell.prototype.generateOutputViewForUTIs = function DataPreviewCell__generateOutputViewForUTIs(utis, properties, bindingSourceKeyPaths) {

		var output = this.context.decodeObjectTree({
			$type: 'View', $domain: 'Core.UI',
			size: { width: 100, height: 48 },
			style: { backgroundColor: ''},
			subviews: [
			]
		});
			
		var prototypes = [];
		var x = -3;
		if (Array.isArray(utis)) utis.every(function (uti) {
			
			var proto = getPrototype(uti);
			prototypes.push(proto);
			
			var iconURL;
			if (proto.iconURLForData)
				iconURL = proto.iconURLForData(properties);
			else iconURL = proto.iconURL;
			
			output.addSubview(this.context.decodeObjectTree({
						$type: 'ImageView', $domain: 'Core.UI',
						size: { width: 48, height: 48 },
						position: {left:x},
						imageSrc: iconURL
					  }));
			
			x += 3+48;
return true; }, this);
		
				
				
		var blueprintTransferData = [];
		var isViewAtIndex = [];
		
		var viewType = getType('Core.UI.View');
		for (var i = 0; i < utis.length; i++) {
		
			var isView = (prototypes[i] instanceof viewType);
			var p = clone(properties) || {};
			
			if (bindingSourceKeyPaths && bindingSourceKeyPaths[i]) {
				p.bindings = [
						  {
							sourceKeyPath: bindingSourceKeyPaths[i],
							destination: this.originalDataSource.identify(),
							destinationKeyPath: this.input.keyPath
						  }
						];
			}
		
			blueprintTransferData.push(JSON.stringify({
					UTI: utis[i],
					isView: isView,
					properties: p,
				}));
			isViewAtIndex[i] = isView;
		
			var subview = output.subviews[i];
			subview.tag = i;
			subview.DOMNode.className = 'canMove';
			subview.DOMNode.draggable = true;
			subview.DOMNode.ondblclick = function (e) {
				e.stopPropagation();
				var transferData = {};
				transferData[_context.objectBlueprintDataType] = blueprintTransferData[this.tag];
				_context.editor.handleDblClickInsertion(utis[this.tag], transferData, isViewAtIndex[this.tag]);
			}.bind(subview);
			subview.DOMNode.addEventListener('dragstart', function (e) {

				var dataTransferData = {};
				dataTransferData[_context.objectBlueprintDataType] = blueprintTransferData[this.tag];

				var dragItem = createComponentFromDomain("DragItem", "Core.UI", this.context, {
					sourceView: this,
					dataTransferData: dataTransferData,
					position: { left: -this.getRelativeX(0), top: -this.getRelativeY(-2) }})
				;
				
				dragItem.dragWithEvent(e);
				
				_context.showGrabCursor();
			}.bind(subview));
		}
		
		this.providesCustomObjects = true;
		
		return output;
					};
	
	
DataPreviewCell.prototype.prepare = function DataPreviewCell__prepare() {
		this.detectTypeOfData();
		this.determineOutput();
		this.createPreview();};
	
	
DataPreviewCell.prototype.createLabel = function DataPreviewCell__createLabel() {

		if (this.dataType === 'object') return;
		this.label = createComponentFromDomain("Label", "Core.UI", this.context, {
			text: this.input.name,
			position: { left: 26 }, 
			size: { height: this.input.name ? 15:0 },
			style: { fontSize: '11px', color: '#888', }})
		;

		this.label.position.top = this.input.name?this.output.position.bottom+4:this.output.position.bottom;
		this.addSubview(this.label);};
	
	
	
	
DataPreviewCell.prototype.createPreview = function DataPreviewCell__createPreview() {
		if (this.output) {
			this.output.position = { left: 26, top: 5 }; 
			this.addSubview(this.output);
			this.createLabel();
		}
		this.setHeight();};
	
	
DataPreviewCell.prototype.setHeight = function DataPreviewCell__setHeight() {

		if (!this.output) {
			this.size.height = 0;
			return;
		}

		if (!this.label) {
			this.size.height = this.output.position.bottom+5;
			return;
		}
		
		if (this.dataType !== 'view') {
			this.size.height = this.label.position.bottom+3;
		} else {
			this.size.height = this.label.position.top+10;
		}};
	
	
	
DataPreviewCell.prototype.imageViewDidLoadImage = function DataPreviewCell_imageViewDidLoadImage(imageView, img) {
	
		
		if (img.width < imageView.size.width && img.height < imageView.size.height) {

			var isHighRes = imageView.usesHighResolutionByDefault;
			imageView.contentMode = 'center';
			var scalar = isHighRes ? 2 : 1;
			imageView.size.width =	Math.max(img.width/scalar, 10);
			imageView.size.height =	Math.max(img.height/scalar, 10);
			
		} else {
			imageView.size.width = imageView.size.height/(img.height/img.width);
			imageView.contentMode = 'scaleAspectFill';
		}
};
	
	
	Object.defineProperty(DataPreviewCell.prototype, "isDraggable", {
		get: function () {
			return this.dataType !== 'object' && !this.providesCustomObjects;
		}});
	
DataPreviewCell.prototype.initPropertiesFromData = function DataPreviewCell_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("input")) this.input = data.input;
if (data.hasOwnProperty("dataType")) this.dataType = data.dataType;
if (data.hasOwnProperty("originalDataSource")) this.originalDataSource = data.originalDataSource;
if (data.hasOwnProperty("originalDataContext")) this.originalDataContext = data.originalDataContext;
};

DataPreviewCell.prototype.decodeData = function DataPreviewCell_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
if (data.hasOwnProperty("originalDataSource")) decoded.originalDataSource = this.context.decodeObjectTree(data.originalDataSource);
if (data.hasOwnProperty("originalDataContext")) decoded.originalDataContext = this.context.decodeObjectTree(data.originalDataContext);
return decoded; };

DataPreviewCell.prototype.encode = function DataPreviewCell_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

DataPreviewCell.prototype.encodeCloned = function DataPreviewCell_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

DataPreviewCell.prototype.expectedTypeForProperty = function DataPreviewCell_expectedTypeForProperty(key) {
	if (key === "input") return "Object";
	if (key === "dataType") return "String";
	if (key === "originalDataSource") return "BasicDataSource";
	if (key === "originalDataContext") return "BasicDataSource";
	if (key === "isDraggable") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return DataPreviewCell; }()));