
registerType('appdoo', (function () { function ObjectBindingController() {} var __super = setSupertypeFromDomain(ObjectBindingController, 'ObjectController', 'Core');

	var NULL_VALUE_FOR_BINDINGS = '^NULL^';

	Object.defineProperty(ObjectBindingController.prototype, "name", {
	outlet: true, get:function () { return this._name; }, set:function (v) {if (!Object.hasOwnProperty(this, "_name")) Object.defineProperty(this, "_name", { writable: true, configurable: true }); this._name = v; }});
	

	Object.defineProperty(ObjectBindingController.prototype, "owner", {
	outlet: true, get:function () { return this._owner; }, set:function (v) {if (!Object.hasOwnProperty(this, "_owner")) Object.defineProperty(this, "_owner", { writable: true, configurable: true }); this._owner = v; }});
	
	
	Object.defineProperty(ObjectBindingController.prototype, "inspectorView", {
	outlet: true, get:function () { return this._inspectorView; }, set:function (v) {if (!Object.hasOwnProperty(this, "_inspectorView")) Object.defineProperty(this, "_inspectorView", { writable: true, configurable: true }); this._inspectorView = v; }});
	

ObjectBindingController.prototype.init = function ObjectBindingController_init() {
		__super.prototype.init.call(this);

		
		Object.defineProperty(this.contents, 'name', { enumerable: false, writable: true });
		Object.defineProperty(this.contents, 'currentValue', { enumerable: false, writable: true });
		Object.defineProperty(this.contents, 'currentReadableValue', { enumerable: false, writable: true });
		Object.defineProperty(this.contents, 'availableKeyPathsForCurrentDestination', { get: this.getAvailableKeyPathsForCurrentDestination.bind(this) });
		Object.defineProperty(this.contents, 'sourceObject', { value: this.owner });
		Object.defineProperty(this.contents, 'dataContextID', { set: this.setDestinationFromDataContextID.bind(this), get: this.getCurrentDataContextID.bind(this) });
		Object.defineProperty(this.contents, 'destinationKeyPathUsingController', { set: this.setDestinationKeyPath.bind(this), get: this.getDestinationKeyPath.bind(this) });

		this.fetchName();
		this.fetchCurrentValue();

		this.observeObject(this.owner.dataController);
		this.observeObject(this.owner.bindingsController);
		
		return this;};
	

ObjectBindingController.prototype.observedObjectValueDidAppearForKey = function ObjectBindingController_observedObjectValueDidAppearForKey(obj, key, sender) {
		if (obj === this.owner.bindingsController) {
			this.inspectorView.update();
			if (this.owner.bindings.length === 1)
				this.owner.outlineAccessoryTypeDidChange();
		}};
	

ObjectBindingController.prototype.observedObjectValueDidDisappearForKey = function ObjectBindingController_observedObjectValueDidDisappearForKey(obj, value, key, sender) {
		if (obj === this.owner.bindingsController) {
			this.inspectorView.update();
			if (this.owner.bindings.length === 0)
				this.owner.outlineAccessoryTypeDidChange();
		}};
	

ObjectBindingController.prototype.observedObjectValueDidChangeForKeyPath = function ObjectBindingController_observedObjectValueDidChangeForKeyPath(obj, keyPath, sender) {
	
		if (keyPath.indexOf('bindings.') !== 0) return;
		var isUndoOrRedo = (sender === obj);
		if (isUndoOrRedo) {
		
			
			var components = keyPath.split('.');
			var lastPathComponent = components[components.length-1];

			if (lastPathComponent === 'destination') {
				
				this.context.broadcastValueChangeForKeyPathInObject('dataContextID', this, this);
				
				this.context.broadcastValueChangeForKeyPathInObject('availableKeyPathsForCurrentDestination', this, this);
				this.context.broadcastValueChangeForKeyPathInObject('destinationKeyPathUsingController', this, this);
				
				this.destinationKeyPathDidChange(true);
			}
			if (lastPathComponent === 'destinationKeyPath') {
				
				this.context.broadcastValueChangeForKeyPathInObject('destinationKeyPathUsingController', this, this);
				
				this.destinationKeyPathDidChange(true);
			}

		}};
	
	
ObjectBindingController.prototype.destinationKeyPathDidChange = function ObjectBindingController__destinationKeyPathDidChange(silent) {
	
		this.fetchCurrentValue();

		
		this.context.broadcastValueChangeForKeyPathInObject('currentValue', this, this);
		this.context.broadcastValueChangeForKeyPathInObject('currentReadableValue', this, this);

		
		
		if (this.contents.enumerableItemAccess) {
			this.owner.dataController.setValueForKeyPath(this.contents.currentValue, this.contents.sourceKeyPath);
		}};
	
	
ObjectBindingController.prototype.fetchCurrentData = function ObjectBindingController__fetchCurrentData() {
		this.fetchCurrentValue();};
	
	
ObjectBindingController.prototype.fetchName = function ObjectBindingController__fetchName() {
		this.contents.name = this.owner.readableNameForProperty(this.contents.sourceKeyPath);};
	
	
	function createReadableValue(value) {
		if (Array.isArray(value)) return '(' + LocalizedString('Multiple Values') + ')';
		
		if (typeof value === 'object' && value !== null && value.UTI)
			return '('+value.readableValue+')';
			
		if (typeof value === 'string' && value.indexOf('***REF*') === 0) {
			return '(' + LocalizedString('Internal Reference Value') + ')';
		}
		
		return value;
	}

ObjectBindingController.prototype.fetchCurrentValue = function ObjectBindingController__fetchCurrentValue() {
		var ctx = this.getCurrentDataContext();
		var value;
		
		if (!ctx) {
			value = '';
		}
		else {
			value = ctx.valueForKeyPath(this.contents.destinationKeyPath);
		}

		this.contents.currentValue = value;
		this.contents.currentReadableValue = createReadableValue(value);
		
		};
	

ObjectBindingController.prototype.getAvailableKeyPathsForCurrentDestination = function ObjectBindingController__getAvailableKeyPathsForCurrentDestination() {
		var ctx = this.getCurrentDataContext();

		if (!ctx)
			return [[NULL_VALUE_FOR_BINDINGS,LocalizedString('(No Selection)')]];

		var r = ctx.arrayWithNamedBindableKeyPaths;
		r.unshift([NULL_VALUE_FOR_BINDINGS,LocalizedString('(No Selection)')]);
		return r;};
	
	
ObjectBindingController.prototype.getCustomValueTransformer = function ObjectBindingController__getCustomValueTransformer() {
		return this.contents.customValueTransformer;};
	

ObjectBindingController.prototype.setCustomValueTransformer = function ObjectBindingController__setCustomValueTransformer(v) {
		this.contents.customValueTransformer = v;};
	
	
ObjectBindingController.prototype.getDestinationObject = function ObjectBindingController__getDestinationObject() {
	
		if (!this.contents.enumerableItemAccess)
			return this.contents.destinationObject;
		
		var destinationObjectDataSource = this.owner.context.connectableObjects[this.contents.destination];

		return destinationObjectDataSource;
};
	
	
ObjectBindingController.prototype.getCurrentDataContext = function ObjectBindingController__getCurrentDataContext() {
		return this.dataContextForDataSource(
			this.getDestinationObject(),
			this.contents.enumerableItemAccess
		);};
	

ObjectBindingController.prototype.dataContextForDataSource = function ObjectBindingController__dataContextForDataSource(dataSource, enumerableItemAccess) {
		return _context.editor.dataContextForDataSource(dataSource, enumerableItemAccess);};
	

ObjectBindingController.prototype.dataContextByID = function ObjectBindingController__dataContextByID(id) {
		return _context.editor.dataContextsController.valuePassingTest(function (x) {
			return x.$id === id;
		});};
	
	
ObjectBindingController.prototype.getCurrentDataContextID = function ObjectBindingController__getCurrentDataContextID() {
		var ctx = this.getCurrentDataContext();
		return ctx ? ctx.$id : '';};
	

ObjectBindingController.prototype.setDestinationFromDataContextID = function ObjectBindingController__setDestinationFromDataContextID(dataContextID) {
		var ctx = this.dataContextByID(dataContextID);

		if (!ctx) {
			this.setWithRootDataControllerValueForKey('', 'destination');
			this.setWithRootDataControllerValueForKey(NULL_VALUE_FOR_BINDINGS, 'destinationKeyPath');
			this.setWithRootDataControllerValueForKey(false, 'enumerableItemAccess');
			this.setWithRootDataControllerValueForKey(false, 'destinationIsMutable');
			this.contents.currentValue = '';
		}
		else {
			var keyPathBefore = this.contents.destinationKeyPath;

			this.setWithRootDataControllerValueForKey(ctx.dataSource.$id, 'destination');
			this.setWithRootDataControllerValueForKey(NULL_VALUE_FOR_BINDINGS, 'destinationKeyPath');
			this.setWithRootDataControllerValueForKey(!!ctx.indexPath, 'enumerableItemAccess');
			this.setWithRootDataControllerValueForKey(ctx.dataSource.mutable, 'destinationIsMutable');
			this.contents.currentValue = '';

			var bestKeyPathGuess = this.context.editor.bestKeyPathGuessForBinding(this.contents, keyPathBefore);

			if (bestKeyPathGuess) {
				this.setWithRootDataControllerValueForKey(bestKeyPathGuess, 'destinationKeyPath');
				this.destinationKeyPathDidChange();
			}
		}
		
		
		
		
		this.context.broadcastValueChangeForKeyPathInObject('availableKeyPathsForCurrentDestination', this, this);
		this.context.broadcastValueChangeForKeyPathInObject('destinationKeyPathUsingController', this, this);

		
		this.context.broadcastValueChangeForKeyPathInObject('currentValue', this, this);
		this.context.broadcastValueChangeForKeyPathInObject('currentReadableValue', this, this);
};
	
	
ObjectBindingController.prototype.setDestinationKeyPath = function ObjectBindingController__setDestinationKeyPath(value) {
		this.setWithRootDataControllerValueForKey(value, 'destinationKeyPath');
		this.destinationKeyPathDidChange();};
	

ObjectBindingController.prototype.getDestinationKeyPath = function ObjectBindingController__getDestinationKeyPath() {
		return this.contents.destinationKeyPath;};
	
	
	
	
	
ObjectBindingController.prototype.setWithRootDataControllerValueForKey = function ObjectBindingController__setWithRootDataControllerValueForKey(value, key) {
		var binding = this.contents,
			sourceObject = binding.sourceObject,
			index = sourceObject.bindings.indexOf(binding)
		
		
		
		sourceObject.dataController.setValueForKeyPath(value, 'bindings.'+index+'.'+key);};
	

ObjectBindingController.prototype.initPropertiesFromData = function ObjectBindingController_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("name")) this.name = data.name;
if (data.hasOwnProperty("owner")) this.owner = data.owner;
if (data.hasOwnProperty("inspectorView")) this.inspectorView = data.inspectorView;
};

ObjectBindingController.prototype.decodeData = function ObjectBindingController_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
if (data.hasOwnProperty("owner")) decoded.owner = this.context.decodeObjectTree(data.owner);
return decoded; };

ObjectBindingController.prototype.encode = function ObjectBindingController_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

ObjectBindingController.prototype.encodeCloned = function ObjectBindingController_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

ObjectBindingController.prototype.expectedTypeForProperty = function ObjectBindingController_expectedTypeForProperty(key) {
	if (key === "name") return "String";
	if (key === "owner") return "BasicObject";
	if (key === "inspectorView") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return ObjectBindingController; }()));