
registerType('appdoo.Editor', (function () { function OnScreenInfo() {} var __super = setSupertypeFromDomain(OnScreenInfo, 'View', 'Core.UI');

OnScreenInfo.prototype.initFromData = function OnScreenInfo_initFromData(data) {

		data.size = {
			width: 100+8,
			height: 46+4+2+1
		};
		
		if (!__super.prototype.initFromData.call(this, data))
			return null;
		
		this.style({
			backgroundColor: 'hsla(0,0%,0%,.5)',
			position: 'fixed',
			borderRadius: '150px',
			pointerEvents: 'none',
			zIndex: 1002,
			boxShadow: '0 2px 3px hsla(0,0%,0%,.25)',
		});

		this.label = createComponentFromDomain("Label", "Core.UI", this.context, {
			size: data.size,
			autoresizingMask: 18,
			text: 'text',
			position: { top: 7 },
			style: {
				color: 'hsl(0,0%,100%)',
				fontSize: '32px',
				textShadow: '0 2px 2px hsla(0,0%,0%,.1)',
				textAlign: 'center'
			}})
		;
		this.addSubview(this.label);
		
		this.duration = .5;
		this.releaseWhenFinished = data.releaseWhenFinished;
		
		return this;};
	
	
OnScreenInfo.prototype.showMessage = function OnScreenInfo_showMessage(msg) {
		this.label.text = msg;
		
		this.size.width = msg.length * 21 + 32 - 6 + 2 + 12;
		
		this.position = {
			left: window.innerWidth/2 - this.size.width/2,
			top: window.innerHeight/2 - this.size.height/2
		};

		if (this.hideTimeout)
			clearTimeout(this.hideTimeout);

		this.hideTimeout = setTimeout(function () {
		
			if (this.removeTimeout)
				clearTimeout(this.removeTimeout);

			this.removeTimeout = setTimeout(function () {
				delete this.removeTimeout;
				if (this.hideTimeout) return;
				this.removeFromSuperview(!this.releaseWhenFinished);
			}.bind(this), 1000);

			this.style({
				webkitTransition: 'opacity 0.5s ease-in-out',
				opacity: 0
			});
			
			delete this.hideTimeout;
			
		}.bind(this), this.duration*1000);

		this.style({
			webkitTransition: '',
			opacity: 1
		});
};
	

OnScreenInfo.prototype.expectedTypeForProperty = function OnScreenInfo_expectedTypeForProperty(key) {
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return OnScreenInfo; }()));