
registerType('appdoo.Editor', (function () { function OutlineDataSource() {} var __super = setSupertypeFromDomain(OutlineDataSource, 'BasicObject', 'Core');

	Object.defineProperty(OutlineDataSource.prototype, "id", {
	outlet: true, 
	synthesized: true, get:function () { return this._id; }, set:function (v) {if (!Object.hasOwnProperty(this, "_id")) Object.defineProperty(this, "_id", { writable: true, configurable: true }); this._id = v; }});
	

	Object.defineProperty(OutlineDataSource.prototype, "outlineView", {
	outlet: true, 
	synthesized: true, get:function () { return this._outlineView; }, set:function (v) {if (!Object.hasOwnProperty(this, "_outlineView")) Object.defineProperty(this, "_outlineView", { writable: true, configurable: true }); this._outlineView = v; }});
	

	Object.defineProperty(OutlineDataSource.prototype, "treeController", {
	outlet: true, 
	synthesized: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_treeController")) Object.defineProperty(this, "_treeController", { writable: true, configurable: true });
			this.observeObject(v);
			this._treeController = v;
		}, get:function () { return this._treeController; }});
	

	Object.defineProperty(OutlineDataSource.prototype, "editor", {
	outlet: true, 
	synthesized: true, get:function () { return this._editor; }, set:function (v) {if (!Object.hasOwnProperty(this, "_editor")) Object.defineProperty(this, "_editor", { writable: true, configurable: true }); this._editor = v; }});
	


	

OutlineDataSource.prototype.promisedNodesForDragEvent = function OutlineDataSource__promisedNodesForDragEvent(e) {
		var context = this.outlineView.context,
			promisedObjectIds = e.dataTransfer.getData('promised-objects'),
			nodes = promisedObjectIds ? promisedObjectIds.split("\n").map(function (id) { return context.globals[id]; }) : [];
		return nodes;};
	

	var numberOfViews, 
		numberOfSceneObjects,
		numberOfGlobalObjects,
		numberOfStaticCells;
		

// role OutlineViewDataSource (Core.UI) 
	
OutlineDataSource.prototype.numberOfChildrenOfItem = function OutlineDataSource_numberOfChildrenOfItem(item) {

			if (item === null) { 
				return this.treeController.rootNode.childNodes.length;
			}
			
			if (item.isLeaf) return 0;
			
			return item.childNodes.length;};
		

OutlineDataSource.prototype.childWithIndexOfItem = function OutlineDataSource_childWithIndexOfItem(index, item) {

			if (item === null) {
				return this.treeController.rootNode.childNodes[index];
			}

			return item.childNodes[index];};
		
		
OutlineDataSource.prototype.itemShouldDrawAsSeparator = function OutlineDataSource_itemShouldDrawAsSeparator(item) {
			return item && item.representedObject && item.representedObject.separator;};
		

OutlineDataSource.prototype.itemShouldDrawAsCaption = function OutlineDataSource_itemShouldDrawAsCaption(item) {
			return item && item.representedObject && item.representedObject.caption === true;};
		
		
OutlineDataSource.prototype.captionForItem = function OutlineDataSource_captionForItem(item) {
			return item.representedObject.text;};
		

OutlineDataSource.prototype.isItemExpandable = function OutlineDataSource_isItemExpandable(item) {
			return item && !item.isLeaf;};
		

OutlineDataSource.prototype.isItemCollapsable = function OutlineDataSource_isItemCollapsable(item) {
			if (item === _context.editor.appObjectsNode) return true;
			if (item === _context.editor.objectsNode) {
				return true;
			}
			if (_context.projectContext.usesNavigationOutlineNode)
				return true;
				
			return (item.parentNode !== this.treeController.rootNode);};
		
		
OutlineDataSource.prototype.isItemExpanded = function OutlineDataSource_isItemExpanded(item) {
			if (item && item.representedObject) {
				if (!this.isItemCollapsable(item)) return true;

				return item.representedObject.isExpandedInEditorOutline === true;
			}};
		
		
OutlineDataSource.prototype.isItemSelected = function OutlineDataSource_isItemSelected(item) {
			return this.treeController.nodeIsSelected(item);};
		
		
OutlineDataSource.prototype.parentItemForItem = function OutlineDataSource_parentItemForItem(item) {
			return item.parentNode;};
		


		
		
OutlineDataSource.prototype.setItemIsSelected = function OutlineDataSource_setItemIsSelected(item, isSelected) {
			if (isSelected === true)
				this.treeController.selectNode(item, this);
			else
				this.treeController.unselectNode(item, this);};
		

OutlineDataSource.prototype.beginChangingSelection = function OutlineDataSource_beginChangingSelection() {
			this.treeController.beginSelectionChange();};
		
		
OutlineDataSource.prototype.endChangingSelection = function OutlineDataSource_endChangingSelection(sender) {
			this.treeController.commitSelectionChange(sender);};
		
		
OutlineDataSource.prototype.setItemIsExpanded = function OutlineDataSource_setItemIsExpanded(item, isExpanded) {
			if (item.representedObject)
				item.representedObject.isExpandedInEditorOutline = isExpanded;};
		


		
		
OutlineDataSource.prototype.validateDragWithItems = function OutlineDataSource_validateDragWithItems(items) {
			return true;};
		
		
		
OutlineDataSource.prototype.validateDropInItemWithIndex = function OutlineDataSource_validateDropInItemWithIndex(e, item, index) {
			
			
			if (item === null) return false;
			
			
			if (!this.isItemExpandable(item)) return false;
			
			var nodes = this.promisedNodesForDragEvent(e);
			var shouldCopy = false;
			for (var i in nodes) {
				if (isNaN(i)) continue;

				
				if (nodes[i] === item) return false;
				if (item.hasAncestor(nodes[i])) return false;

				if (!nodes[i].representedObject || !item.representedObject.acceptsMemberWithUTI || item.representedObject.acceptsMemberWithUTI(nodes[i].representedObject.UTI, nodes[i].representedObject) === false) return false;

				if (item.representedObject.needsCopyOfMemberWithUTI &&
					item.representedObject.needsCopyOfMemberWithUTI(nodes[i].representedObject.UTI))
					shouldCopy = true;
				
			}
			if (nodes.length) return shouldCopy ? 2 : 3;


			
			
			if (this.isBlueprintDrag(e)) {
				var info = this.infoFromBlueprintDrag(e);

				if (!_context.editor.objectIsAllowedToHaveMembersOfUTI(item.representedObject, info.UTI, info.properties))
					return false;
				else
					return true;
			}
			
			
			if (this.viewObjectDrag(e)) {
				var data = JSON.parse(e.dataTransfer.getData(this.context.objectTreeDataType));
				var uti = utiFromData(data);
				if (item.representedObject.acceptsMemberWithUTI &&
					item.representedObject.acceptsMemberWithUTI(uti, data))
					return true;
				
				
				if (!this.isViewNodeThatAcceptsNewSubviews(item)) return false;
			}
			
			
			if (numberOfStaticCells) {
				return item.representedObject.acceptsMemberWithUTI ? item.representedObject.acceptsMemberWithUTI(nodes[0].representedObject.UTI, nodes[0].representedObject) : false;
			}
			
			if (e.dataTransfer && e.dataTransfer.files && e.dataTransfer.files.length) {
				return item === _context.editor.fileReferencesNode ? 2 : 0;
			}
			
			
			return 2;};
		
		
OutlineDataSource.prototype.validateUnspecificDrop = function OutlineDataSource_validateUnspecificDrop(e) {
			if (this.isBlueprintDrag(e)) {
				if (!this.isViewBlueprintDrag(e)) {
					return 2;
				}
			}

			if (e.dataTransfer && e.dataTransfer.files && e.dataTransfer.files.length) {
				return 2;
			}};
		
		
OutlineDataSource.prototype.handleDropInItemWithIndex = function OutlineDataSource_handleDropInItemWithIndex(e, item, index, dropEffect) {

			var nodes = this.promisedNodesForDragEvent(e);
			
			
			if (nodes.length)
				return this.handleNodesDropInItemWithIndex(nodes, e, item, index);
			
			
			if (this.isBlueprintDrag(e))
				return this.handleBlueprintDropInItemWithIndex(e, item, index);

			
			if (this.viewObjectDrag(e))
				return this.handleViewObjectDropInItemWithIndex(e, item, index);

			if (e.dataTransfer && e.dataTransfer.files && e.dataTransfer.files.length) {
				return this.handleFileDropInItemWithIndex(e, item, index);
			}
};
		
		
		
		
OutlineDataSource.prototype.menuForItems = function OutlineDataSource_menuForItems(nodes) {
			var items = [];
			if (Array.isArray(nodes)) nodes.every(function (node) {
				if (node && node.representedObject)
					items.push(node.representedObject);return true; }, this);
			
			return this.editor.contextMenuForItems(items);};
		
		

	
	
OutlineDataSource.prototype.isBlueprintDrag = function OutlineDataSource__isBlueprintDrag(e) {
		return e && e.dataTransfer && Array.isArray(e.dataTransfer.types) && e.dataTransfer.types.indexOf(this.context.objectBlueprintDataType) !== -1;};
	
	
OutlineDataSource.prototype.viewObjectDrag = function OutlineDataSource__viewObjectDrag(e) {
		return e && e.dataTransfer && Array.isArray(e.dataTransfer.types) && e.dataTransfer.types.indexOf(this.context.objectTreeDataType) !== -1;};
	

OutlineDataSource.prototype.isViewBlueprintDrag = function OutlineDataSource__isViewBlueprintDrag(e) {
		
		var dataJSON = e.dataTransfer.getData(this.context.objectBlueprintDataType),
			data = JSON.parse(dataJSON);
		return data.isView;
		};
	
	
OutlineDataSource.prototype.infoFromBlueprintDrag = function OutlineDataSource__infoFromBlueprintDrag(e) {

		var dataJSON = e.dataTransfer.getData(this.context.objectBlueprintDataType),
			data = JSON.parse(dataJSON);
		return data;
	};
	

OutlineDataSource.prototype.utiFromBlueprintDrag = function OutlineDataSource__utiFromBlueprintDrag(e) {

		return this.infoFromBlueprintDrag(e).UTI;
	};
	
	
OutlineDataSource.prototype.isViewNodeThatAcceptsNewSubviews = function OutlineDataSource__isViewNodeThatAcceptsNewSubviews(node) {
		return node.representedObject.encodesSubviews;};
	

OutlineDataSource.prototype.isObjectsNode = function OutlineDataSource__isObjectsNode(node) {
		return (node === this.editor.objectsNode ||
				node === this.editor.appObjectsNode);};
	

OutlineDataSource.prototype.handleNodesDropInItemWithIndex = function OutlineDataSource__handleNodesDropInItemWithIndex(nodes, e, item, index) {

		if (index === -2) return false; 

		var	nodesWereSelected = nodes.length && this.treeController.nodeIsSelected(nodes[0]);
		
		var shouldDuplicate = e.altKey;

		if (item.representedObject.needsCopyOfMemberWithUTI &&
			item.representedObject.needsCopyOfMemberWithUTI(nodes[0].representedObject.UTI))
			shouldDuplicate = true;
		
		if (shouldDuplicate) {
			var objectsToDuplicate = nodes.map(function (node) { return node.representedObject; });
			var newItems = _context.editor.duplicateItems(objectsToDuplicate, nodesWereSelected);
			nodes = newItems.map(function (item) { return item.node; });
		}
	

		if (!item) item = this.treeController.rootNode;
		
		if (nodesWereSelected)
			this.treeController.beginSelectionChange();
		
		if (Array.isArray(nodes)) nodes.every(function (node) {

			if (item === node.parentNode) {
				if (node.index < index) index--;
				item.moveChildNodeFromIndexToIndex(node.index, index, this);
				return true;
			}
		
			this.treeController.moveNodeToNodeAtIndex(node, item, index, this);
			index++;

			if (nodesWereSelected)
				this.treeController.selectNode(node, this);
return true; }, this);
		
		
		this.outlineView.reloadItem(null, true);

		if (nodesWereSelected)
			this.treeController.commitSelectionChange(this);

		return true;};
	
	
OutlineDataSource.prototype.handleBlueprintDropInItemWithIndex = function OutlineDataSource__handleBlueprintDropInItemWithIndex(e, item, index) {

		var dataTransfer = e.dataTransfer,
			dataJSON = dataTransfer.getData(this.context.objectBlueprintDataType),
			data = JSON.parse(dataJSON);
		
		var proto = getPrototype(data.UTI);
		if (!proto) {
			console.warn('Missing prototype!', data.UTI, data);
			this.context.beep();
			return;
		}
		
		var obj;
		var parentNode = item;
		
		if (data.isView) {
			obj = proto.createForSuperview(item.representedObject);
		}
		else {
			obj = proto.createForContext(_context.projectContext);
			if (index == -2) {
				parentNode = this.editor.preferredObjectNodeForItemWithUTI(utiFromData(obj), data.properties);
			}
		}
		
		if (obj) {
			_context.editor.registerInsertedItem(obj, true, parentNode, index, true);
			_context.editor.addUndoStepForInsertOperation(obj);
			for (var key in data.properties) {
				obj[key] = data.properties[key];
			}
		}
		

};
	

OutlineDataSource.prototype.handleViewObjectDropInItemWithIndex = function OutlineDataSource__handleViewObjectDropInItemWithIndex(e, item, index) {
		
		var data = JSON.parse(e.dataTransfer.getData(this.context.objectTreeDataType));
		
		var obj = this.context.projectContext.decodeObjectTree(data);
		_context.editor.registerInsertedItem(obj, true, item, index, true);
		_context.editor.addUndoStepForInsertOperation(obj);
		};
	
	
OutlineDataSource.prototype.handleFileDropInItemWithIndex = function OutlineDataSource__handleFileDropInItemWithIndex(e, item, index) {
		if (index === -2) index = undefined;
		_context.editor.dropFilesAtItemWithEventCompletion(e.dataTransfer.files, item, e, function complete() {}, index);};
	
	
	
// role ListViewDelegate 
		
OutlineDataSource.prototype.listViewWillUseDataTransferForDraggingItems = function OutlineDataSource_listViewWillUseDataTransferForDraggingItems(listView, dataTransfer, items) {
			
			
			
			
			if (!items.length) return;
			
			var itemsString = items.map(function (item) { return item.representedObject.$id; }).join(',');
			
			if (isKindOfType(items[0].representedObject, getType('appdoo.ResourceReference')) && items[0].representedObject.canCreateContainerViewForSuperview(_context.editor.editedSuperview)) {
				dataTransfer[this.context.resourceReferenceDataType] = itemsString;
			}
			
			dataTransfer[this.context.promisedRealObjectsDataType] = itemsString;
};
		
		
	
	
OutlineDataSource.prototype.resetOutlineView = function OutlineDataSource__resetOutlineView() {
		
		if (this.resetTimer) clearTimeout(this.resetTimer);
		this.resetTimer = setTimeout(function () {
			this.outlineView.reloadItem(null, true);
			delete this.resetTimer;
		}.bind(this), 1);};
	
	

	

// role Observer (Core) 

OutlineDataSource.prototype.observedObjectValueDidAppearForKey = function OutlineDataSource_observedObjectValueDidAppearForKey(obj, key, sender) {
			this.resetOutlineView();};
		
		
OutlineDataSource.prototype.observedObjectValueDidDisappearForKey = function OutlineDataSource_observedObjectValueDidDisappearForKey(obj, value, key, sender) {
			this.resetOutlineView();};
		

OutlineDataSource.prototype.observedObjectValueDidChangeKey = function OutlineDataSource_observedObjectValueDidChangeKey(obj, oldKey, newKey, keyPath, sender) {
			this.resetOutlineView();};
		

OutlineDataSource.prototype.observedObjectValuesDidReplace = function OutlineDataSource_observedObjectValuesDidReplace(obj, sender) {
			this.removeAllObservations();
			this.observeObject(this.treeController);
			this.resetOutlineView();};
		

OutlineDataSource.prototype.observedObjectValueDidChangeForKeyPath = function OutlineDataSource_observedObjectValueDidChangeForKeyPath(obj, keyPath, sender) {};
		
		
OutlineDataSource.prototype.observedObjectSelectionDidChange = function OutlineDataSource_observedObjectSelectionDidChange(obj, sender) {};
		

OutlineDataSource.prototype.observedObjectSelectionDidChangeForKeyPath = function OutlineDataSource_observedObjectSelectionDidChangeForKeyPath(obj, keyPath, isSelected, sender) {
		
			var node = obj.nodeForKeyPath(keyPath);

			if (!node) {
				 console.warn('NODE IS', node, obj, keyPath, isSelected, sender);
				return;
			}
			

			if (isSelected === true) {
			
				if (this.outlineView.expandToShowItem(node, sender)) {
					this.outlineView.selectItem(node, sender);
				}
			} else {
				this.outlineView.unselectItem(node, sender);
			}
};
		

	

OutlineDataSource.prototype.initPropertiesFromData = function OutlineDataSource_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("id")) this.id = data.id;
if (data.hasOwnProperty("outlineView")) this.outlineView = data.outlineView;
if (data.hasOwnProperty("treeController")) this.treeController = data.treeController;
if (data.hasOwnProperty("editor")) this.editor = data.editor;
};

OutlineDataSource.prototype.decodeData = function OutlineDataSource_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

OutlineDataSource.prototype.encode = function OutlineDataSource_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

OutlineDataSource.prototype.encodeCloned = function OutlineDataSource_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

OutlineDataSource.prototype.expectedTypeForProperty = function OutlineDataSource_expectedTypeForProperty(key) {
	if (key === "id") return "";
	if (key === "outlineView") return "";
	if (key === "treeController") return "";
	if (key === "editor") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return OutlineDataSource; }()));
registerType('appdoo', (function () { function OutlineRowAccessoryView() {} var __super = setSupertypeFromDomain(OutlineRowAccessoryView, 'View', 'Core.UI');

	Object.defineProperty(OutlineRowAccessoryView.prototype, "accessoryType", {
	outlet: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_accessoryType")) Object.defineProperty(this, "_accessoryType", { writable: true, configurable: true });
			this._accessoryType = v;
			this.updateView();
		}, get:function () { return this._accessoryType; }});
	
	
	Object.defineProperty(OutlineRowAccessoryView.prototype, "showsSpinningWheel", {
	synthesized: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_showsSpinningWheel")) Object.defineProperty(this, "_showsSpinningWheel", { writable: true, configurable: true });
			this._showsSpinningWheel = v;
			this.updateView();
		}, get:function () { return this._showsSpinningWheel; }});
	

	Object.defineProperty(OutlineRowAccessoryView.prototype, "target", {
	outlet: true, 
	referenced: true, get:function () { return this._target; }, set:function (v) {if (!Object.hasOwnProperty(this, "_target")) Object.defineProperty(this, "_target", { writable: true, configurable: true }); this._target = v; }});
	

	Object.defineProperty(OutlineRowAccessoryView.prototype, "targetMethod", {
	outlet: true, get:function () { return this._targetMethod; }, set:function (v) {if (!Object.hasOwnProperty(this, "_targetMethod")) Object.defineProperty(this, "_targetMethod", { writable: true, configurable: true }); this._targetMethod = v; }});
	

OutlineRowAccessoryView.prototype.viewDidLoad = function OutlineRowAccessoryView_viewDidLoad() {
		__super.prototype.viewDidLoad.call(this);
		this.updateView();};
	
	
	var defaultAccessoryItemWidth = 18;
	
	Object.defineProperty(OutlineRowAccessoryView.prototype, "spinningWheel", {
	synthesized: true, get:function () { return this._spinningWheel; }, set:function (v) {if (!Object.hasOwnProperty(this, "_spinningWheel")) Object.defineProperty(this, "_spinningWheel", { writable: true, configurable: true }); this._spinningWheel = v; }});
	
	
OutlineRowAccessoryView.prototype.updateView = function OutlineRowAccessoryView__updateView() {
		if (!this.DOMNode) return;
		
		this.removeAllSubviews();
		
		if (this.showsSpinningWheel) {

			var sv = createComponentFromDomain("View", "Core.UI", this.context, {
				size: this.size,
				style: { opacity: .7 }})
			;
			this.addSubview(sv);

			var opts = {
			  lines: 11, 
			  length: 3, 
			  width: 2, 
			  radius: 3, 
			  corners: 1, 
			  rotate: 45, 
			  direction: 1, 
			  color: '#000', 
			  speed: 3, 
			  trail: 54, 
			  shadow: false, 
			  hwaccel: false, 
			  className: 'spinner', 
			  zIndex: 0, 
			  top: 'auto', 
			  left: 'auto' 
			};
			var spinner = new Spinner(opts).spin(sv.DOMNode);
			this.spinningWheel = spinner;
		
			return;
		}
		
		if (this.spinningWheel) {
			this.spinningWheel.stop();
			delete this.spinningWheel;
		}
	
		if (typeof this.accessoryType === 'string') {
			var x = 0;
			if (Array.isArray(this.accessoryType.split(' '))) this.accessoryType.split(' ').every(function (s) {
				if (s === 'reload') {
					var sb = createComponentFromDomain("SpriteButton", "Core.UI", this.context, {
						sprite: "Resources/Reload.png",
						highlightOnMouseOver: true,
						size: {width:18,height:18},
						position: {left:x,top:1},
						style: {backgroundColor:'#ccc'},
						target: this,
						targetMethod: 'reloadButtonAction',
						toolTip: LocalizedString('Reload')})
					;
					this.addSubview(sb);
					x += defaultAccessoryItemWidth;
				}
				if (s === 'play') {
					var sb = createComponentFromDomain("SpriteButton", "Core.UI", this.context, {
						sprite: "Resources/Play.png",
						highlightOnMouseOver: true,
						size: {width:18,height:18},
						position: {left:x,top:1},
						style: {backgroundColor:'#ccc'},
						target: this,
						targetMethod: 'playButtonAction',
						toolTip: LocalizedString('play')})
					;
					this.addSubview(sb);
					x += defaultAccessoryItemWidth;
				}
				else if (s === 'bound') {
					var boundIcon = createComponentFromDomain("SpriteButton", "Core.UI", this.context, {
						sprite:'Resources/Bound.png',
						highlightOnMouseOver: true,
						size: {width:18,height:18},
						position: {left:x,top:1},
						target: this,
						targetMethod: 'boundButtonAction',
						toolTip: this.target ?this.target.readableBindings:''})
					;
					this.addSubview(boundIcon);
					x += defaultAccessoryItemWidth;
				}
				else if (s === 'locked') {
					var boundIcon = createComponentFromDomain("SpriteButton", "Core.UI", this.context, {
						sprite:'Resources/Locked.png',
						highlightOnMouseOver: true,
						size: {width:18,height:18},
						position: {left:x,top:1},
						target: this,
						targetMethod: 'lockedButtonAction',
						toolTip: LocalizedString('Unlock')})
					;
					this.addSubview(boundIcon);
					x += defaultAccessoryItemWidth;
				}return true; }, this);
			
			
			this.updateWidth();
		}
};
	
	
OutlineRowAccessoryView.prototype.updateWidth = function OutlineRowAccessoryView__updateWidth() {
		var widthBefore = this.size.width;
		var newWidth = defaultAccessoryItemWidth*this.subviews.length;
		this.size.width = newWidth;
		this.position.left -= (newWidth-widthBefore);};
	
	
OutlineRowAccessoryView.prototype.reloadButtonAction = function OutlineRowAccessoryView__reloadButtonAction(sender, e) {
		e.preventDefault();
		e.stopPropagation();

		this.showsSpinningWheel = true;
		
		var callbackCalled = false;
		var to;
		var callback = function () {
			if (callbackCalled) return;
			callbackCalled = true;
			this.showsSpinningWheel = false;
			clearTimeout(to);
		}.bind(this);
		
		to = setTimeout(callback, 10000);
		
		if (this.target.reload(callback) === false) callback();};
	
	
OutlineRowAccessoryView.prototype.playButtonAction = function OutlineRowAccessoryView__playButtonAction(sender, e) {
		e.preventDefault();
		e.stopPropagation();
		if (this.target.isPlaying) this.target.simulateAction('stop');
		else this.target.simulateAction('play');};
	

OutlineRowAccessoryView.prototype.boundButtonAction = function OutlineRowAccessoryView__boundButtonAction(sender, e) {
		e.preventDefault();
		e.stopPropagation();
	
		_context.editor.selectSingleObject(this.target);
		if (_context.editor.inspector) {
			_context.editor.inspector.selectedIndex = 2;
		}};
	

OutlineRowAccessoryView.prototype.lockedButtonAction = function OutlineRowAccessoryView__lockedButtonAction(sender, e) {
		e.preventDefault();
		e.stopPropagation();
		
		_context.editor.unlockObject(this.target);};
	
	
	Object.defineProperty(OutlineRowAccessoryView.prototype, "encodesSubviews", {
		value: false});
	

OutlineRowAccessoryView.prototype.initPropertiesFromData = function OutlineRowAccessoryView_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("accessoryType")) this.accessoryType = data.accessoryType;
if (data.hasOwnProperty("target")) this.target = data.target;
if (data.hasOwnProperty("targetMethod")) this.targetMethod = data.targetMethod;
};

OutlineRowAccessoryView.prototype.decodeData = function OutlineRowAccessoryView_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

OutlineRowAccessoryView.prototype.encode = function OutlineRowAccessoryView_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

OutlineRowAccessoryView.prototype.encodeCloned = function OutlineRowAccessoryView_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

OutlineRowAccessoryView.prototype.expectedTypeForProperty = function OutlineRowAccessoryView_expectedTypeForProperty(key) {
	if (key === "accessoryType") return "String";
	if (key === "showsSpinningWheel") return "boolean";
	if (key === "target") return "BasicObject";
	if (key === "targetMethod") return "String";
	if (key === "spinningWheel") return "";
	if (key === "encodesSubviews") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return OutlineRowAccessoryView; }()));