
registerType('appdoo.Editor', (function () { function SelectionController() {} var __super = setSupertypeFromDomain(SelectionController, 'ObjectController', 'Core');

	function unique(arr) {
	  return arr.reduce(function(accum, cur) { 
		if (accum.indexOf(cur) === -1) accum.push(cur); 
		return accum; 
	  }, [] );
	}


// role BasicObject (Core) 

SelectionController.prototype.initFromData = function SelectionController_initFromData(data) {
	
			if (!__super.prototype.initFromData.call(this, data))
				return;
	
			this.delegate = data.delegate;
	
			
			
	
			Object.defineProperty(this, "collectedData", {
			writable: true, 
				value: []});
			
	
			Object.defineProperty(this, "contents", {
			writable: true, 
				value: data.contents || []});
			
	
			Object.defineProperty(this, "collectedDataValues", {
			writable: true, 
				value: {}});
			
	
			Object.defineProperty(this, "itemBindings", {
			writable: true, 
				value: []});
			
			
			Object.defineProperty(this, "observedProperties", {
			writable: true, 
				value: []});
			
	
			return this;};
		

	

// role ObjectController (Core) 
	
		
	
SelectionController.prototype.get = function SelectionController_get(keyPath) {
			
			var values = [];

			if (Array.isArray(this.contents)) this.contents.every(function (component) {
				if (!component) return true;
				values.push(component.get(keyPath));return true; }, this);
			
		
			return values;};
		


		
	
SelectionController.prototype.set = function SelectionController_set(setObj, sender, silent) {

			if (this.contents.length === 0)
				return;

			for (var keyPath in setObj) {
			
				var value = setObj[keyPath];
		
				if (Array.isArray(this.contents)) this.contents.every(function (component) {
					component.dataController.setValueForKeyPath(value, keyPath, this);return true; }, this);
				
			}
		};
		

SelectionController.prototype.setValueForKeyPath = function SelectionController_setValueForKeyPath(value, keyPath, sender) {

			if (this.contents.length === 0)
				return;
	
			if (Array.isArray(this.contents)) this.contents.every(function (component) {
				component.dataController.setValueForKeyPath(value, keyPath, this);return true; }, this);
			
		};
		

	

// role BindingsCapableObject (Core) 

SelectionController.prototype.valueShouldChangeForKeyPath = function SelectionController_valueShouldChangeForKeyPath(value, keyPath, sender) {
			this.collectValueFromKeyPath(value, keyPath, sender);};
		
	
	


// role SelectionController 

		Object.defineProperty(SelectionController.prototype, "items", {
			set: function (v) {

				
				this.unregisterAllItemBindings();
				
				
				var values = [];
				if (Array.isArray(v)) v.every(function (item) {
					if (!v) return true;
					this.registerItemBindings(item);
					values.push(item);return true; }, this);
				

				this.replaceWithData(values, this);
			
			}, 
			get: function () { return this.contents; }});
		

	
	
// role InspectorInterface 

SelectionController.prototype.observeProperty = function SelectionController_observeProperty(keyPath) {
		
			if (Array.isArray(this.contents)) this.contents.every(function (item) {
	
				var binding = {
					sourceObject: this,
					sourceKeyPath: keyPath,
					destinationObject: item.dataController,
					destinationKeyPath: keyPath
				};
	
				this.context.registerBinding(binding);
				this.itemBindings.push(binding);
			return true; }, this);
			
			
			this.observedProperties.push(keyPath);
	};
		
		
SelectionController.prototype.unobserveProperty = function SelectionController_unobserveProperty(keyPath) {
		
			this.observedProperties.splice(this.observedProperties.indexOf(keyPath), 1);
	};
		
	
	


	
	
SelectionController.prototype.collectValueFromKeyPath = function SelectionController__collectValueFromKeyPath(value, keyPath, sender) {
	
		if (this.collectedData.indexOf(keyPath) === -1)
			this.collectedData.push(keyPath);
		
		if (this.collectedDataValues[keyPath] === undefined)
			this.collectedDataValues[keyPath] = [];
		
		this.collectedDataValues[keyPath].push(value);
		
		if (!this.collectedDataSender)
			this.collectedDataSender = sender;
	
		
		if (this.timer === undefined)
			this.timer = setTimeout(this.evaluateCollectedData.bind(this), 0);
};
	
	
SelectionController.prototype.evaluateCollectedData = function SelectionController__evaluateCollectedData() {

		delete this.timer;
		
		var sender = this.collectedDataSender,
			senderIsDataController = sender && (
				sender.contents !== undefined ||
				sender === this.delegate ||
				sender === this.context.undoManager ||
				sender.UTI === 'appdoo.Overview.ItemView'
			),
			senderIsInspector = !senderIsDataController && sender !== this.delegate.layoutResolver;

		delete this.collectedDataSender;
		

		
		if (senderIsDataController === true) {
		
		
			if (Array.isArray(this.collectedData)) this.collectedData.every(function (keyPath) {
				this.context.broadcastValueChangeForKeyPathInObject(keyPath, this);return true; }, this);
			
		}
		
		
		else if (senderIsInspector === true) {
		
			if (Array.isArray(this.collectedData)) this.collectedData.every(function (keyPath) {
				var setObj = {};
				setObj[keyPath] = this.collectedDataValues[keyPath][0];
				this.set(setObj);return true; }, this);
			
			
		}

		this.collectedData = [];
		this.collectedDataValues = {};
};
	

SelectionController.prototype.trackChanges = function SelectionController__trackChanges() {
	
		if(this.announcedChanges === undefined) return;
	
		this.valuesBefore = {};
		this.announcedChanges.every(function (keyPath) {
			this.valuesBefore[keyPath] = this.get(keyPath);
			return true;
		}.bind(this));
};
	
	
	
	var propertyKeyPaths = [
		'position.left',
		'position.top',
		'position.right',
		'position.bottom',
		'size.width',
		'size.height',
		'xIsEditable',
		'yIsEditable',
		'widthIsEditable',
		'heightIsEditable',
		'liveWidth',
		'liveHeight',
	];
	
SelectionController.prototype.registerItemBindings = function SelectionController__registerItemBindings(item) {
	
		if (!item) {
			return;
		}
		
		if (item.dataController === undefined) {
			console.warn('The object is missing a data controller. Bindings might not work.', item);
			return;
		}

		if (Array.isArray(propertyKeyPaths)) propertyKeyPaths.every(function (keyPath) {

			var binding = {
				sourceObject: this,
				sourceKeyPath: keyPath,
				destinationObject: item.dataController,
				destinationKeyPath: keyPath
			};

			this.context.registerBinding(binding);
			this.itemBindings.push(binding);
		return true; }, this);
		

		if (Array.isArray(this.observedProperties)) this.observedProperties.every(function (keyPath) {

			var binding = {
				sourceObject: this,
				sourceKeyPath: keyPath,
				destinationObject: item.dataController,
				destinationKeyPath: keyPath
			};

			this.context.registerBinding(binding);
			this.itemBindings.push(binding);
		return true; }, this);
		
	};
	

SelectionController.prototype.unregisterAllItemBindings = function SelectionController__unregisterAllItemBindings() {

		if (Array.isArray(this.itemBindings)) this.itemBindings.every(function (binding) {
			this.context.unregisterBinding(binding);return true; }, this);
		
		this.itemBindings = [];
	};
	
	
	Object.defineProperty(SelectionController.prototype, "itemsHaveEqualUTI", {
		get: function () {
			return this.getUnique('UTI').length === 1;
		}});
	
	
SelectionController.prototype.getUnique = function SelectionController_getUnique(keyPath) {
		return unique(this.get(keyPath));};
	

SelectionController.prototype.getSingle = function SelectionController_getSingle(keyPath) {
		var v = this.getUnique(keyPath);
		if (v.length === 1) return v[0];
		return;};
	
	
	Object.defineProperty(SelectionController.prototype, "itemsInOriginalOrder", {
		get: function () {
			var parentNode = this.getSingle('node.parentNode');
			if (!parentNode) return;
			var r = [];
			if (Array.isArray(parentNode.childNodes)) parentNode.childNodes.every(function (childNode) {
				if (this.contents.indexOf(childNode.representedObject) !== -1)
					r.push(childNode.representedObject);return true; }, this);
			
			return r;
		}});
	


	

SelectionController.prototype.alignSelectionHorizontally = function SelectionController_alignSelectionHorizontally() {
		return this.alignSelection('left',
		  function (a, b) { return a.size.width > b.size.width; },
		  function (a, b) { return a.position.left+a.size.width/2 - b.size.width/2; });};
	
	
SelectionController.prototype.alignSelectionVertically = function SelectionController_alignSelectionVertically() {
		return this.alignSelection('top',
		  function (a, b) { return a.size.height > b.size.height; },
		  function (a, b) { return a.position.top+a.size.height/2 - b.size.height/2; });};
	

SelectionController.prototype.alignSelectionLeft = function SelectionController_alignSelectionLeft() {
		return this.alignSelection('left',
		  function (a, b) { return a.position.left < b.position.left; },
		  function (a, b) { return a.position.left; });};
	

SelectionController.prototype.alignSelectionRight = function SelectionController_alignSelectionRight() {
		return this.alignSelection('left',
		  function (a, b) { return a.position.right > b.position.right; },
		  function (a, b) { return a.position.right-b.size.width; });};
	

SelectionController.prototype.alignSelectionTop = function SelectionController_alignSelectionTop() {
		return this.alignSelection('top',
		  function (a, b) { return a.position.top < b.position.top; },
		  function (a, b) { return a.position.top; });};
	

SelectionController.prototype.alignSelectionBottom = function SelectionController_alignSelectionBottom() {
		return this.alignSelection('top',
		  function (a, b) { return a.position.bottom > b.position.bottom; },
		  function (a, b) { return a.position.bottom-b.size.height; });};
	
	
SelectionController.prototype.alignSelection = function SelectionController__alignSelection(theProperty, findMaxCmp, getValue) {

		var selectedItems = this.contents;
	
		if (!selectedItems.length) return;
		
		
		var maxElement = selectedItems[0];
		for (var i = 1, c = selectedItems.length; i !== c; i++) {
			if (findMaxCmp(selectedItems[i], maxElement) === true) {
				maxElement = selectedItems[i];
			}
		}
	
		
		selectedItems.every(function (item) {

			if (item === maxElement)
				return true;
			
			var value = Math.round(getValue(maxElement, item));
			item.dataController.setValueForKeyPath(value, 'position.'+theProperty);

			return true;
		});
	};
	

SelectionController.prototype.expectedTypeForProperty = function SelectionController_expectedTypeForProperty(key) {
	if (key === "collectedData") return "";
	if (key === "contents") return "";
	if (key === "collectedDataValues") return "";
	if (key === "itemBindings") return "";
	if (key === "observedProperties") return "";
	if (key === "items") return "";
	if (key === "itemsHaveEqualUTI") return "";
	if (key === "itemsInOriginalOrder") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return SelectionController; }()));