
registerType('appdoo.Editor', (function () { function SizeModifierButtonsController() {} var __super = setSupertypeFromDomain(SizeModifierButtonsController, 'BasicObject', 'Core');

	Object.defineProperty(SizeModifierButtonsController.prototype, "item", {
	outlet: true, get:function () { return this._item; }, set:function (v) {if (!Object.hasOwnProperty(this, "_item")) Object.defineProperty(this, "_item", { writable: true, configurable: true }); this._item = v; }});
	

	Object.defineProperty(SizeModifierButtonsController.prototype, "sizeModifierButtons", {
	outlet: true, get:function () { return this._sizeModifierButtons; }, set:function (v) {if (!Object.hasOwnProperty(this, "_sizeModifierButtons")) Object.defineProperty(this, "_sizeModifierButtons", { writable: true, configurable: true }); this._sizeModifierButtons = v; }});
	

	Object.defineProperty(SizeModifierButtonsController.prototype, "borderView", {
	outlet: true, get:function () { return this._borderView; }, set:function (v) {if (!Object.hasOwnProperty(this, "_borderView")) Object.defineProperty(this, "_borderView", { writable: true, configurable: true }); this._borderView = v; }});
	

	Object.defineProperty(SizeModifierButtonsController.prototype, "manipulator", {
	outlet: true, get:function () { return this._manipulator; }, set:function (v) {if (!Object.hasOwnProperty(this, "_manipulator")) Object.defineProperty(this, "_manipulator", { writable: true, configurable: true }); this._manipulator = v; }});
	

	Object.defineProperty(SizeModifierButtonsController.prototype, "contentWrapper", {
	outlet: true, get:function () { return this._contentWrapper; }, set:function (v) {if (!Object.hasOwnProperty(this, "_contentWrapper")) Object.defineProperty(this, "_contentWrapper", { writable: true, configurable: true }); this._contentWrapper = v; }});
	

	Object.defineProperty(SizeModifierButtonsController.prototype, "coordinatesView", {
	outlet: true, get:function () { return this._coordinatesView; }, set:function (v) {if (!Object.hasOwnProperty(this, "_coordinatesView")) Object.defineProperty(this, "_coordinatesView", { writable: true, configurable: true }); this._coordinatesView = v; }});
	


SizeModifierButtonsController.prototype.destroy = function SizeModifierButtonsController_destroy() {

		if (Array.isArray(this.sizeModifierButtons)) this.sizeModifierButtons.every(function (button) {
			button.removeFromSuperview();return true; }, this);
		

		this.borderView.removeFromSuperview();

		delete this.item._sizeModifierButtonsController;
		__super.prototype.destroy.call(this);
};
	


// role Observer (Core) 

SizeModifierButtonsController.prototype.observedObjectValueDidChangeForKeyPath = function SizeModifierButtonsController_observedObjectValueDidChangeForKeyPath(obj, keyPath, sender) {

			if (keyPath.indexOf('position') === 0 ||
				keyPath.indexOf('size') === 0)
				this.positionButtons();	
			
			if (keyPath === 'heightIsEditable') {
				this.setHeightEditingButtonsHidden(!obj.get(keyPath));
			}

			if (keyPath === 'widthIsEditable') {
				this.setWidthEditingButtonsHidden(!obj.get(keyPath));
			}};
		

	
	
	var infoMode = 0;
	var infoLetters;
	
SizeModifierButtonsController.prototype.showCoordinatesDelayedInMode = function SizeModifierButtonsController_showCoordinatesDelayedInMode(mode) {

		infoMode = mode;
		if (infoLetters === undefined) {
			infoLetters = {
				X: LocalizedString('X_LETTER'),
				Y: LocalizedString('Y_LETTER'),
				W: LocalizedString('WIDTH_LETTER'),
				H: LocalizedString('HEIGHT_LETTER'),
			};
		}
		this.coordinatesView.hidden = false;
		this.coordinatesView.style({ opacity: 0 });
		this.coordinatesView.areVisible = true;
		setTimeout(function () {
			if (!this.coordinatesView.areVisible) return;
			this.updateCoordinates();
			this.coordinatesView.style({ opacity: 1 });
		}.bind(this), 200);
	};
	

SizeModifierButtonsController.prototype.updateCoordinates = function SizeModifierButtonsController_updateCoordinates() {
	
		if (infoMode === 0) {

			var x = this.item._position.left,
				y = this.item._position.top;
			this.coordinatesView.DOMNode.innerHTML = '<span style="color:#87850e">'+infoLetters.X+':</span>'+x+'  <span style="color:#87850e">'+infoLetters.Y+':</span>'+y;
		}
		if (infoMode === 1) {

			var w = this.item._size.width,
				h = this.item._size.height;
			this.coordinatesView.DOMNode.innerHTML = '<span style="color:#87850e">'+infoLetters.W+':</span>'+w+'  <span style="color:#87850e">'+infoLetters.H+':</span>'+h;
		}
	};
	

SizeModifierButtonsController.prototype.hideCoordinates = function SizeModifierButtonsController_hideCoordinates() {
		if (!this.coordinatesView) return;
		this.coordinatesView.beginAnimations();
		this.coordinatesView.animationDuration = 0.15;
		this.coordinatesView.style({ opacity:0 });


		
		this.coordinatesView.commitAnimations();
		this.coordinatesView.areVisible = false;};
	
	
SizeModifierButtonsController.prototype.positionButtons = function SizeModifierButtonsController_positionButtons() {
		if (!this.item || !this.item.DOMNode) return;
	
		try {
	
		var buttons = this.sizeModifierButtons,
			contentScale = this.manipulator.contentScale,
			item = this.item,
			contentWrapper = this.contentWrapper,
			borderView = this.borderView,
			coordinatesView = this.coordinatesView;
		
		var nullPosition = {
				left: (-item.getRelativeX(-item.DOMNode.scrollLeft, contentWrapper))
						* contentScale - 7,
				top: (-item.getRelativeY(-item.DOMNode.scrollTop, contentWrapper))
						* contentScale - 7
			},
			width =   item.size.width * contentScale,
			widthH =  parseInt(width/2)+1,
			height =  item.size.height * contentScale,
			heightH = parseInt(height/2)+1;
	
	
		for (var i = 0, c = 8; i !== c; i++) {
			buttons[i].position = {
				left: nullPosition.left,
				top: nullPosition.top
			};
		}

		buttons[1].position.left += widthH;
		buttons[2].position.left += width + 1;
		buttons[3].position.top  += heightH;
		buttons[4].position.top  += heightH;
		buttons[4].position.left += width + 1;
		buttons[5].position.top  += height + 1;
		buttons[6].position.top  += height + 1;
		buttons[7].position.top  += height + 1;
		buttons[6].position.left += widthH;
		buttons[7].position.left += width + 1;
		
		borderView.position = {
			left: nullPosition.left+7,
			top: nullPosition.top+7
		};
		
		coordinatesView.position = {
			left: borderView.position.left,
			top: borderView.position.top - 18+2-1
		};
		



		

		borderView.size = { width: width, height: height };
		
		if (item.heightIsEditable === false) {
			this.setHeightEditingButtonsHidden(true);
		}

		if (item.widthIsEditable === false) {
			this.setWidthEditingButtonsHidden(true);
		}

		if (item.yIsEditable === false) {
			this.setYEditingButtonsHidden(true);
		}
		
		} catch (err) {
			console.warn(err);
		}
				};
	
	
SizeModifierButtonsController.prototype.setHeightEditingButtonsHidden = function SizeModifierButtonsController__setHeightEditingButtonsHidden(v) {
		var buttons = this.sizeModifierButtons;
		buttons[0].hidden = v;
		buttons[1].hidden = v;
		buttons[2].hidden = v;
		buttons[5].hidden = v;
		buttons[6].hidden = v;
		buttons[7].hidden = v;};
	

SizeModifierButtonsController.prototype.setWidthEditingButtonsHidden = function SizeModifierButtonsController__setWidthEditingButtonsHidden(v) {
		var buttons = this.sizeModifierButtons;
		buttons[0].hidden = v;
		buttons[2].hidden = v;
		buttons[3].hidden = v;
		buttons[4].hidden = v;
		buttons[5].hidden = v;
		buttons[7].hidden = v;};
	

SizeModifierButtonsController.prototype.setYEditingButtonsHidden = function SizeModifierButtonsController__setYEditingButtonsHidden(v) {
		var buttons = this.sizeModifierButtons;
		buttons[0].hidden = v;
		buttons[1].hidden = v;
		buttons[2].hidden = v;};
	

SizeModifierButtonsController.prototype.initPropertiesFromData = function SizeModifierButtonsController_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("item")) this.item = data.item;
if (data.hasOwnProperty("sizeModifierButtons")) this.sizeModifierButtons = data.sizeModifierButtons;
if (data.hasOwnProperty("borderView")) this.borderView = data.borderView;
if (data.hasOwnProperty("manipulator")) this.manipulator = data.manipulator;
if (data.hasOwnProperty("contentWrapper")) this.contentWrapper = data.contentWrapper;
if (data.hasOwnProperty("coordinatesView")) this.coordinatesView = data.coordinatesView;
};

SizeModifierButtonsController.prototype.decodeData = function SizeModifierButtonsController_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

SizeModifierButtonsController.prototype.encode = function SizeModifierButtonsController_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

SizeModifierButtonsController.prototype.encodeCloned = function SizeModifierButtonsController_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

SizeModifierButtonsController.prototype.expectedTypeForProperty = function SizeModifierButtonsController_expectedTypeForProperty(key) {
	if (key === "item") return "";
	if (key === "sizeModifierButtons") return "";
	if (key === "borderView") return "";
	if (key === "manipulator") return "";
	if (key === "contentWrapper") return "";
	if (key === "coordinatesView") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return SizeModifierButtonsController; }()));