
registerType('appdoo.Editor', (function () { function iOSIconControl() {} var __super = setSupertypeFromDomain(iOSIconControl, 'EditableImageControl', 'appdoo');

iOSIconControl.prototype.initFromData = function iOSIconControl_initFromData(data) {

		if (!__super.prototype.initFromData.call(this, data))
			return null;
		
		this.iconType = data.iconType;
		
		return this;};
	


iOSIconControl.prototype.changeImageID = function iOSIconControl__changeImageID(v) {

		if (v) {

			var newID;
			
			if (this.iconType === 'TabBar')
				newID = this.context.nativeProxy.sendMessage('generateIOSTabBarIcons', v);
			else if (this.iconType === 'App')
				newID = this.context.nativeProxy.sendMessage('generateIOSAppIcons', v);
				
			if (!newID) {
				console.error('Conversion of the icon failed.');
				return false;
			}
			
			__super.prototype.changeImageID.call(this, newID);
			return true;
		
		}
		
		return __super.prototype.changeImageID.call(this, v);
		};
	

iOSIconControl.prototype.copy = function iOSIconControl_copy(e) {
		var imagePath;
		
		if (this.iconType === 'TabBar') {
			imagePath = this.context.pathForImageWithID(this.imageID, true);
		}
		if (this.iconType === 'App') {
			imagePath = this.context.pathForImageWithID(this.imageID+"-AppStore");
		}
		return this.context.nativeProxy.sendMessage('copyFileAsImage', imagePath);};
	

iOSIconControl.prototype.valueShouldChangeForKeyPath = function iOSIconControl_valueShouldChangeForKeyPath(value, keyPath) {
	
		if (['imageRef'].indexOf(keyPath) !== -1) {
			this[keyPath] = value;
			return true;
		}
		
		return false;
};
	

iOSIconControl.prototype.expectedTypeForProperty = function iOSIconControl_expectedTypeForProperty(key) {
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return iOSIconControl; }()));