
registerType('appdoo', (function () { function FileInfo() {} var __super = setSupertypeFromDomain(FileInfo, 'BasicObject', 'Core');

	Object.defineProperty(FileInfo.prototype, "absolutePath", {
	outlet: true, 
	enumerable: true, get:function () { return this._absolutePath; }, set:function (v) {if (!Object.hasOwnProperty(this, "_absolutePath")) Object.defineProperty(this, "_absolutePath", { writable: true, configurable: true }); this._absolutePath = v; }});
	

	Object.defineProperty(FileInfo.prototype, "relativePath", {
	outlet: true, 
	enumerable: true, get:function () { return this._relativePath; }, set:function (v) {if (!Object.hasOwnProperty(this, "_relativePath")) Object.defineProperty(this, "_relativePath", { writable: true, configurable: true }); this._relativePath = v; }});
	

	Object.defineProperty(FileInfo.prototype, "modificationTime", {
	outlet: true, 
	enumerable: true, get:function () { return this._modificationTime; }, set:function (v) {if (!Object.hasOwnProperty(this, "_modificationTime")) Object.defineProperty(this, "_modificationTime", { writable: true, configurable: true }); this._modificationTime = v; }});
	

FileInfo.prototype.initPropertiesFromData = function FileInfo_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("absolutePath")) this.absolutePath = data.absolutePath;
if (data.hasOwnProperty("relativePath")) this.relativePath = data.relativePath;
if (data.hasOwnProperty("modificationTime")) this.modificationTime = data.modificationTime;
};

FileInfo.prototype.decodeData = function FileInfo_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

FileInfo.prototype.encode = function FileInfo_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

FileInfo.prototype.encodeCloned = function FileInfo_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

FileInfo.prototype.expectedTypeForProperty = function FileInfo_expectedTypeForProperty(key) {
	if (key === "absolutePath") return "String";
	if (key === "relativePath") return "String";
	if (key === "modificationTime") return "Number";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return FileInfo; }()));
registerType('appdoo', (function () { function ImageReference() {} var __super = setSupertypeFromDomain(ImageReference, 'BasicObject', 'Core');

	Object.defineProperty(ImageReference.prototype, "imageID", {
	outlet: true, 
	enumerable: true, get:function () { return this._imageID; }, set:function (v) {if (!Object.hasOwnProperty(this, "_imageID")) Object.defineProperty(this, "_imageID", { writable: true, configurable: true }); this._imageID = v; }});
	

	Object.defineProperty(ImageReference.prototype, "contentType", {
	outlet: true, 
	enumerable: true, get:function () { return this._contentType; }, set:function (v) {if (!Object.hasOwnProperty(this, "_contentType")) Object.defineProperty(this, "_contentType", { writable: true, configurable: true }); this._contentType = v; }});
	

	Object.defineProperty(ImageReference.prototype, "originalFileInfo", {
	outlet: true, 
	enumerable: true, get:function () { return this._originalFileInfo; }, set:function (v) {if (!Object.hasOwnProperty(this, "_originalFileInfo")) Object.defineProperty(this, "_originalFileInfo", { writable: true, configurable: true }); this._originalFileInfo = v; }});
	

	Object.defineProperty(ImageReference.prototype, "fileReferenceID", {
	outlet: true, 
	enumerable: true, get:function () { return this._fileReferenceID; }, set:function (v) {if (!Object.hasOwnProperty(this, "_fileReferenceID")) Object.defineProperty(this, "_fileReferenceID", { writable: true, configurable: true }); this._fileReferenceID = v; }});
	

	Object.defineProperty(ImageReference.prototype, "temporaryFilePath", {
	outlet: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_temporaryFilePath")) Object.defineProperty(this, "_temporaryFilePath", { writable: true, configurable: true });
			var imageID = this.context.nativeProxy.sendMessage('importImage', v);
	
			if (!imageID) {
				console.warn('Importing the image failed. URL was: ', v);
				return;
			}

			this.imageID = imageID;
			this.context.registerImageWithID(imageID);
		}, get:function () { return this._temporaryFilePath; }});
	
	
ImageReference.prototype.encodeCloned = function ImageReference_encodeCloned() {
		var data = __super.prototype.encodeCloned.call(this);
		if (this.imageID) {
			data.temporaryFilePath = this.context.pathForImageWithID(data.imageID);
		}
		
		
		delete data.imageID;
		
		return data;};
	
	
ImageReference.prototype.deleteForEditor = function ImageReference_deleteForEditor(editor) {
		if (this.context)
			this.context.unregisterImageWithID(this.imageID);};
	

ImageReference.prototype.initPropertiesFromData = function ImageReference_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("imageID")) this.imageID = data.imageID;
if (data.hasOwnProperty("contentType")) this.contentType = data.contentType;
if (data.hasOwnProperty("originalFileInfo")) this.originalFileInfo = data.originalFileInfo;
if (data.hasOwnProperty("fileReferenceID")) this.fileReferenceID = data.fileReferenceID;
if (data.hasOwnProperty("temporaryFilePath")) this.temporaryFilePath = data.temporaryFilePath;
};

ImageReference.prototype.decodeData = function ImageReference_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
if (data.hasOwnProperty("originalFileInfo")) decoded.originalFileInfo = this.context.decodeObjectTree(data.originalFileInfo);
return decoded; };

ImageReference.prototype.encode = function ImageReference_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
if (this._originalFileInfo && this._originalFileInfo.encode) {encoded.originalFileInfo = this.originalFileInfo.encode();
}return encoded; };

ImageReference.prototype.expectedTypeForProperty = function ImageReference_expectedTypeForProperty(key) {
	if (key === "imageID") return "String";
	if (key === "contentType") return "String";
	if (key === "originalFileInfo") return "FileInfo";
	if (key === "fileReferenceID") return "String";
	if (key === "temporaryFilePath") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return ImageReference; }()));