
registerType('appdoo.Overview', (function () { function HeaderTitleView() {} var __super = setSupertypeFromDomain(HeaderTitleView, 'View', 'Core.UI');

	Object.defineProperty(HeaderTitleView.prototype, "iconSize", {
		value: 60});
	
	
	Object.defineProperty(HeaderTitleView.prototype, "iconControl", {
	synthesized: true, get:function () { return this._iconControl; }, set:function (v) {if (!Object.hasOwnProperty(this, "_iconControl")) Object.defineProperty(this, "_iconControl", { writable: true, configurable: true }); this._iconControl = v; }});
	

	Object.defineProperty(HeaderTitleView.prototype, "titleTextField", {
	synthesized: true, get:function () { return this._titleTextField; }, set:function (v) {if (!Object.hasOwnProperty(this, "_titleTextField")) Object.defineProperty(this, "_titleTextField", { writable: true, configurable: true }); this._titleTextField = v; }});
	
	
HeaderTitleView.prototype.fileReferencesDidUpdate = function HeaderTitleView_fileReferencesDidUpdate(refs) {
		if (this.iconControl.imageRef) {
			if (Array.isArray(refs)) refs.every(function (ref) {
				if (ref.$id === this.iconControl.imageRef.fileReferenceID) {
					this.iconControl.changeImageID(ref.resourceID, ref);
				}return true; }, this);
			
		}};
	

	

HeaderTitleView.prototype.initFromData = function HeaderTitleView_initFromData(data) {

		data.size = { width: 500, height: 76 };
		data.position = { top: 14 };
		
		if (!__super.prototype.initFromData.call(this, data))
			return;

		this.hidden = true;

		this.metadataController = this.context.projectMetadataController;
		this.observeObject(this.metadataController);
		this.createSubviews();

		return this;
};
	

HeaderTitleView.prototype.initPropertiesFromData = function HeaderTitleView__initPropertiesFromData() {
		
		};
	
	
HeaderTitleView.prototype.destroy = function HeaderTitleView_destroy() {
		__super.prototype.destroy.call(this);};
	
	
HeaderTitleView.prototype.viewDidLoad = function HeaderTitleView_viewDidLoad() {
		setTimeout(function(){
			this.hidden = false;
		}.bind(this),1);
		__super.prototype.viewDidLoad.call(this);};
	


	
	
	
HeaderTitleView.prototype.createSubviews = function HeaderTitleView__createSubviews() {
		
		this.createIconControl();
		this.createTitle();
};
	

HeaderTitleView.prototype.createIconControl = function HeaderTitleView__createIconControl() {

		var iconControl = createComponentFromDomain("AppIconControl", "appdoo", this.context, {
			size: {
				width: this.iconSize+2,
				height: this.iconSize+2
			},
			position: {
				top: -2
			},
			focusRing: this.context.pathForResource('AppIconFocusRing.png'),
			focusRingSize: 60+6,
			focusRingContentInset: [25,13,24,15],
			placeholderImageSrc: this.context.pathForResource('AppIconPlaceholder.png'),
			placeholderSize: {
				width: this.iconSize+2,
				height: this.iconSize+3,
			},
			drawsBackground: false,
			iconType: 'App',
			forceRetina: true,
			fileTypesForImport:['image/png'],
			incompatibilityWarning: LocalizedString('The app icon should be saved in PNG format with a size of at least 120x120 pixels (iPhone) or 152x152 pixels (iPad).'),})
		;
		iconControl.disabled = true;
		iconControl.ignoreStyleForDisabled = true;
		
		setTimeout(function () {
			iconControl.bindings = [{sourceKeyPath:'imageRef', destinationObject: this.metadataController, destinationKeyPath:'iconImage', bidirectional: true
			}];
			iconControl.applyBindings();
		}.bind(this), 100);
		
		iconControl.DOMNode.tabIndex = 1;

		iconControl.imageView.style({
			borderRadius: '12px'
		});

		this.addSubview(iconControl);
		this.iconControl = iconControl;
		
		this.observeObject(iconControl);
		};
	
	
HeaderTitleView.prototype.createTitle = function HeaderTitleView__createTitle() {

		var titleTextField = createComponentFromDomain("OverviewTitleTextField", "appdoo.Overview", this.context, {
			style: {
				border: 0,
				padding: 0,
				margin: 0,
				backgroundColor: 'transparent',
				fontSize: '25px',
				color: '#333',
				webkitFontSmoothing: 'antialiased',
				letterSpacing: '-1px',
				textShadow: '0 1px 0 hsla(0,0%,100%,.6)',
				display: 'inline',
				minWidth: '5px'
			},
			position: { left: this.iconSize+16, top: 13 },
			size: { width: 150 },
			delegate: this,
			bindings: [{sourceKeyPath:'value', destination:'projectMetadataController',
				destinationKeyPath: 'title', bidirectional: true
			}],
			disabled: true,
			style2: 'bar'})
		;
		
		titleTextField.inputNode.tabIndex = 2;
				
		this.addSubview(titleTextField);
		this.titleTextField = titleTextField;
};
	

	
	
	
HeaderTitleView.prototype.textFieldDidChangeWidth = function HeaderTitleView_textFieldDidChangeWidth(textField) {

		this.size.width = textField.size.width + textField.position.left;
		this.position.left = parseInt((window.innerWidth-this.size.width)/2);

		this.hidden = false;
};
	
	
HeaderTitleView.prototype.expectedTypeForProperty = function HeaderTitleView_expectedTypeForProperty(key) {
	if (key === "iconSize") return "";
	if (key === "iconControl") return "appdoo.AppIconControl";
	if (key === "titleTextField") return "appdoo.Overview.OverviewTitleTextField";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return HeaderTitleView; }()));