
registerType('appdoo', (function () { function Overview() {} var __super = setSupertypeFromDomain(Overview, 'ViewController', 'Core.UI');


// role BasicObject (Core) 

Overview.prototype.init = function Overview_init() {
			this.animationDuration = 0.25;
			__super.prototype.init.call(this);
			setTimeout(function () { this.overviewSegmentedControl.selectedIndex = kSegmentIndexScenes; }.bind(this), 1);};
		
		
Overview.prototype.destroy = function Overview_destroy() {
			var node = this.view.DOMNode;
			if (node.parentNode) {
				node.parentNode.removeChild(node);
			}
			this.removeWindowEvents();
			__super.prototype.destroy.call(this);};
		
	
	


	Object.defineProperty(Overview.prototype, "headerView", {
	outlet: true, get:function () { return this._headerView; }, set:function (v) {if (!Object.hasOwnProperty(this, "_headerView")) Object.defineProperty(this, "_headerView", { writable: true, configurable: true }); this._headerView = v; }});
	

	Object.defineProperty(Overview.prototype, "contentView", {
	outlet: true, get:function () { return this._contentView; }, set:function (v) {if (!Object.hasOwnProperty(this, "_contentView")) Object.defineProperty(this, "_contentView", { writable: true, configurable: true }); this._contentView = v; }});
	

	Object.defineProperty(Overview.prototype, "scenesView", {
	outlet: true, get:function () { return this._scenesView; }, set:function (v) {if (!Object.hasOwnProperty(this, "_scenesView")) Object.defineProperty(this, "_scenesView", { writable: true, configurable: true }); this._scenesView = v; }});
	

	Object.defineProperty(Overview.prototype, "overviewSegmentedControl", {
	outlet: true, get:function () { return this._overviewSegmentedControl; }, set:function (v) {if (!Object.hasOwnProperty(this, "_overviewSegmentedControl")) Object.defineProperty(this, "_overviewSegmentedControl", { writable: true, configurable: true }); this._overviewSegmentedControl = v; }});
	
	
	Object.defineProperty(Overview.prototype, "firstSettingsControl", {
	outlet: true, get:function () { return this._firstSettingsControl; }, set:function (v) {if (!Object.hasOwnProperty(this, "_firstSettingsControl")) Object.defineProperty(this, "_firstSettingsControl", { writable: true, configurable: true }); this._firstSettingsControl = v; }});
	


Overview.prototype.focus = function Overview_focus() {
	};
	
	
	
	
// role ViewDelegate (Core.UI) 
	
Overview.prototype.viewDidLoad = function Overview_viewDidLoad(view) {
			if (view !== this.view) return;
			__super.prototype.viewDidLoad.call(this, view);
			this.view.viewDidResize = this.resizeViewHandler.bind(this);
			this.createButtons();};
		
	
	var x;
	
Overview.prototype.viewDidAppear = function Overview_viewDidAppear() {
		
			if (x) return; x = true;

			this.context.prepareForUndoManagerWithID('overview');
			this.addWindowEvents();
			
			if (this.overviewSegmentedControl.selectedIndex === kSegmentIndexScenes) {
			
				this.scenesView.overviewDidAppear();
				this.scenesView.focus();
				
			}

			if (!this.context.isOffscreen)
				this.context.nativeProxy.sendMessage('contentScaleDidChange',0);
};
		
	
Overview.prototype.viewDidDisappear = function Overview_viewDidDisappear() {
			if (!x) return; x = false;
			this.removeWindowEvents();};
		
		

	
	
Overview.prototype.resizeViewHandler = function Overview__resizeViewHandler() {
		this.view.__proto__.viewDidResize.call(this.view);};
	


	
	
// role MainViewController (appdoo.appdooContext) 
		
Overview.prototype.performAfterLoading = function Overview_performAfterLoading(callback) {
			if (this.view === undefined) {
				this.loadView();
				this.view.hidden = true;
				document.body.appendChild(this.view.DOMNode);
			}
	
			callback();};
		
	
Overview.prototype.validateMenuItem = function Overview_validateMenuItem(tag) {
			return false;};
		
	


	

Overview.prototype.addWindowEvents = function Overview__addWindowEvents() {

		this.keydownEventHandlerBound =
			this.keydownEventHandler.bind(this);

		window.addEventListener('keydown',
								this.keydownEventHandlerBound);
		

		this._swipeEventHandlerBound = this.swipeEventHandler.bind(this);
		window.addEventListener('swipe', this._swipeEventHandlerBound);
};
	

Overview.prototype.removeWindowEvents = function Overview__removeWindowEvents() {
		window.removeEventListener('keydown',
								this.keydownEventHandlerBound);

		window.removeEventListener('swipe',
								this._swipeEventHandlerBound);};
	

Overview.prototype.keydownEventHandler = function Overview__keydownEventHandler(e) {
	
		if (this.overviewSegmentedControl.selectedIndex === kSegmentIndexAppInfo) {
			if (this.context.isCancelEvent(e)) { 
				this.overviewSegmentedControl.selectedIndex = kSegmentIndexScenes;
				e.preventDefault();
				return;
			}
		}
	

		if (e.metaKey === true && e.altKey !== true && e.shiftKey !== true) {
			var nSegments = 2;
				keyCode1 = 49;

			
			if (e.keyCode >= keyCode1 && e.keyCode <= keyCode1+nSegments-1) { 
				this.overviewSegmentedControl.selectedIndex = e.keyCode-keyCode1;
				e.preventDefault();
				return;
			}
		}

		
		if (e.keyCode === 187 && e.metaKey && e.altKey) {
			if (this.scenesView.zoomIn())
				e.preventDefault();
			return;
		}

		
		if (e.keyCode === 189 && e.metaKey && e.altKey) {
			if (this.scenesView.zoomOut())
				e.preventDefault();
			return;
		}
		
		if (e.target !== document.body) return;
};
	
	
Overview.prototype.swipeEventHandler = function Overview__swipeEventHandler(e) {

		if (e.detail === 1) {
			this.overviewSegmentedControl.selectedIndex = 0;
		}
		else if (e.detail === 2) {
			this.overviewSegmentedControl.selectedIndex = 1;
		}
};
	
	
Overview.prototype.createButtons = function Overview__createButtons() {
		
		if(this.context.disableInAppPreferences) {
			return;
		}
		var width = LocalizedNumber('PROJECT_SETTINGS_BUTTON_WIDTH')||143;
		width += 4;

		var b = this.context.makeForwardButton(LocalizedString('Project Settings'), width, 0,
			function () {
				this.overviewSegmentedControl.selectedIndex = kSegmentIndexAppInfo;
			}.bind(this));
		b.style({zIndex:2001});
		b.autoresizingMask = 1;
		b.position = { left: this.view.size.width-width-15, top: 30 };
		this.view.addSubview(b);
		this.goToSettingsButton = b;

		var b2 = this.context.makeBackButton(LocalizedString('Screens'), LocalizedNumber('BACK_TO_SCENES_BUTTON_WIDTH')+2, 0, function () {
				this.overviewSegmentedControl.selectedIndex = kSegmentIndexScenes;
			}.bind(this));
		b2.style({zIndex:2001});
		b2.position = { left: 15, top: 30 };
		b2.hidden = true;
		this.view.addSubview(b2);

		this.goToScenesButton = b2;
		};
	
	
Overview.prototype.segmentedViewControllerDidLoadSegmentAtIndex = function Overview_segmentedViewControllerDidLoadSegmentAtIndex(svc,i) {

		if (this.goToSettingsButton)
			this.goToSettingsButton.hidden = (i === kSegmentIndexAppInfo);

		if (this.goToScenesButton)
			this.goToScenesButton.hidden = (i === kSegmentIndexScenes);
};
	
	
	
Overview.prototype.getOverviewAppearance = function Overview_getOverviewAppearance() {
		return {
			contentScale: this.scenesView.contentScale
		};};
	

Overview.prototype.setOverviewAppearance = function Overview_setOverviewAppearance(obj) {
		if (!obj) return;};
	

Overview.prototype.createScene = function Overview_createScene() {
		return this.scenesView.sceneDispenserView.createSceneWithoutDrag();};
	
	

Overview.prototype.showPrototypeDevicesBar = function Overview_showPrototypeDevicesBar(bar) {
		var containerView = this.scenesView;
		containerView.addSubview(bar);
		containerView.size.height = window.innerHeight - bar.size.height - 45;};
	
	
Overview.prototype.fileReferencesDidUpdate = function Overview_fileReferencesDidUpdate(refs) {
		this.headerView.fileReferencesDidUpdate(refs);
		var infoEditor = getPrototype('appdoo.ProjectInfoEditor').sharedInstance;
		if (infoEditor) infoEditor.fileReferencesDidUpdate(refs); };
	
	
Overview.prototype.prototypeDevicesBarDidChangeHeight = function Overview_prototypeDevicesBarDidChangeHeight(bar) {
		if (!bar.superview) return;
		
		var siblingView = bar.superview.subviews[0];
		var newHeigt = window.innerHeight - bar.size.height;
		var difference = siblingView.size.height - newHeigt;
		siblingView.size.height = newHeigt;
		siblingView.style({ webkitTransform:'translateY('+difference/2+'px)' });
		bar.style({ webkitTransform:'translateY('+(difference)+'px)' });
		
		var animationTime = bar.size.height > 0 ? .75 : 0.5;
		setTimeout(function () {
			siblingView.beginAnimations();
			siblingView.animationDuration = animationTime;
			siblingView.style({ webkitTransform:'' });
			siblingView.commitAnimations();
			bar.beginAnimations();
			bar.animationDuration = animationTime;
			bar.style({ webkitTransform:'' });
			bar.commitAnimations();
		}, 1);
		};
	

Overview.prototype.initPropertiesFromData = function Overview_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("headerView")) this.headerView = data.headerView;
if (data.hasOwnProperty("contentView")) this.contentView = data.contentView;
if (data.hasOwnProperty("scenesView")) this.scenesView = data.scenesView;
if (data.hasOwnProperty("overviewSegmentedControl")) this.overviewSegmentedControl = data.overviewSegmentedControl;
if (data.hasOwnProperty("firstSettingsControl")) this.firstSettingsControl = data.firstSettingsControl;
};

Overview.prototype.decodeData = function Overview_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
if (data.hasOwnProperty("headerView")) decoded.headerView = this.context.decodeObjectTree(data.headerView);
if (data.hasOwnProperty("contentView")) decoded.contentView = this.context.decodeObjectTree(data.contentView);
if (data.hasOwnProperty("scenesView")) decoded.scenesView = this.context.decodeObjectTree(data.scenesView);
return decoded; };

Overview.prototype.encode = function Overview_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

Overview.prototype.encodeCloned = function Overview_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

Overview.prototype.expectedTypeForProperty = function Overview_expectedTypeForProperty(key) {
	if (key === "headerView") return "appdoo.Overview.HeaderTitleView";
	if (key === "contentView") return "Core.UI.View";
	if (key === "scenesView") return "appdoo.Overview.ScenesView";
	if (key === "overviewSegmentedControl") return "";
	if (key === "firstSettingsControl") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return Overview; }()));