
registerType('appdoo.Overview', (function () { function OverviewTitleTextField() {} var __super = setSupertypeFromDomain(OverviewTitleTextField, 'TextField', 'Core.UI');

OverviewTitleTextField.prototype.initFromData = function OverviewTitleTextField_initFromData(data) {

		var style = data.style || {};
		style.whiteSpace = 'pre';

		if (!__super.prototype.initFromData.call(this, data, true))
			return;


		this.defaultStyle = style;

		this.widthMeasurementLabel = createComponentFromDomain("Label", "Core.UI", this.context, {
			style: style,
			text: data.value,
			hidden: true})
		;
		
		this.applyBindings(true);
		
		this.delegate = data.delegate;

		this.inputNode.addEventListener('mousedown', function (e) {
			if (this.value === LocalizedString('Untitled')) {
				this.selectAll();
				e.preventDefault();
			}
		}.bind(this));

		this.inputNode.addEventListener('focus', function () {
			if (this.value === LocalizedString('Untitled'))
				this.selectAll();
			this.style({
				backgroundColor: "rgba(255,255,255,.2)",
				color: "#222",
				textShadow: ''
			});
		}.bind(this));
		
		this.inputNode.addEventListener('blur', function () {
			this.style({
				backgroundColor: this.defaultStyle.backgroundColor || '',
				color: this.defaultStyle.color || '',
				textShadow: this.defaultStyle.textShadow || ''
			});
		}.bind(this));

		this.DOMNode.addEventListener('input', function () {
			this.widthMeasurementLabel.text = this.inputNode.value;
			this.updateWidthFromLabel();
		}.bind(this));

		this.DOMNode.addEventListener('change', function () {
			this.updateWidthFromLabel();
			this.context.nativeProxy.sendMessage('setProjectName', this.value);

		}.bind(this));

		this.DOMNode.addEventListener('keydown', function (e) {
			if (e.keyCode === 13) {
				e.preventDefault();
				e.target.blur();
			}
		});
		
		this.observeObject(this.context.projectMetadataController);
		
		return this;};
	
	
OverviewTitleTextField.prototype.viewDidLoad = function OverviewTitleTextField_viewDidLoad() {
	
		this.superview.addSubview(this.widthMeasurementLabel);
		setTimeout(function(){
			this.updateWidthFromLabel();
		}.bind(this),1);
};
	

OverviewTitleTextField.prototype.viewDidResize = function OverviewTitleTextField_viewDidResize() {
		if (this.delegate !== undefined)
			this.delegate.textFieldDidChangeWidth(this);
		this.inputNode.style.width = this.size.width+'px';};
	

OverviewTitleTextField.prototype.updateWidthFromLabel = function OverviewTitleTextField_updateWidthFromLabel() {

		var width = this.widthMeasurementLabel.DOMNode.offsetWidth+2;
    	if (width < 50) width = 50;
    	this.size.width = width;
	};
		

	Object.defineProperty(OverviewTitleTextField.prototype, "value", {
	enumerable: true, 
		set: function (v) {
			this.inputNode.value = v;
			this.widthMeasurementLabel.text = v;
		}, 
		get: function () {
			return this.inputNode.value;
		}});
	
	
	Object.defineProperty(OverviewTitleTextField.prototype, "disabled", {
	synthesized: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_disabled")) Object.defineProperty(this, "_disabled", { writable: true, configurable: true });
			this._disabled = v;
			this.style({ pointerEvents: v ? 'none': '' });
		}, get:function () { return this._disabled; }});
	
	
OverviewTitleTextField.prototype.observedObjectValueDidChangeForKeyPath = function OverviewTitleTextField_observedObjectValueDidChangeForKeyPath(obj, keyPath, sender) {
		if (keyPath === 'title') {
			this.value = obj.get(keyPath);
			this.updateWidthFromLabel();
		}};
	


OverviewTitleTextField.prototype.expectedTypeForProperty = function OverviewTitleTextField_expectedTypeForProperty(key) {
	if (key === "value") return "";
	if (key === "disabled") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return OverviewTitleTextField; }()));