
registerType('appdoo', (function () { function ProjectInfoEditor() {} var __super = setSupertypeFromDomain(ProjectInfoEditor, 'View', 'Core.UI');

	var sharedInstance;
	Object.defineProperty(ProjectInfoEditor.prototype, "sharedInstance", {
		get: function () { return sharedInstance; }});
	

	Object.defineProperty(ProjectInfoEditor.prototype, "appCategories", {
		get: function () {
			var g = [
				["", ""],
				["public.app-category.business",			LocalizedString("Wirtschaft")],
				["public.app-category.developer-tools",		LocalizedString("Entwickler-Tools")],
				["public.app-category.education",			LocalizedString("Bildung")],
				["public.app-category.entertainment",		LocalizedString("Unterhaltung")],
				["public.app-category.finance",				LocalizedString("Finanzen")],
				["public.app-category.games",				LocalizedString("Spiele")],
				["public.app-category.graphics-design",		LocalizedString("Grafik und Design")],
				["public.app-category.healthcare-fitness",	LocalizedString("Gesundheit und Fitness")],
				["public.app-category.lifestyle",			LocalizedString("Lifestyle")],
				["public.app-category.medical",				LocalizedString("Medizin")],
				["public.app-category.music",				LocalizedString("Musik")],
				["public.app-category.news",				LocalizedString("Nachrichten")],
				["public.app-category.photography",			LocalizedString("Foto")],
				["public.app-category.productivity",		LocalizedString("Produktivität")],
				["public.app-category.reference",			LocalizedString("Referenz")],
				["public.app-category.social-networking",	LocalizedString("Soziale Netze")],
				["public.app-category.sports",				LocalizedString("Sport")],
				["public.app-category.travel",				LocalizedString("Reisen")],
				["public.app-category.utilities",			LocalizedString("Dienstprogramme")],
				["public.app-category.video",				LocalizedString("Video")],
				["public.app-category.weather",				LocalizedString("Wetter")]
			];

			categories.sort(function(a,b){
				if(a[1] < b[1]) return -1;
				if(a[1] > b[1]) return 1;
				return 0;
			})
			
			return categories;
		}});
	
	
	Object.defineProperty(ProjectInfoEditor.prototype, "listOfLanguages", {
		value: [
			['en','English (en)'],
			['fr','Français (fr)'],
			['es','Español (es)'],
			['pt','Português (pt)'],
			['it','Italiano (it)'],
			['de','Deutsch (de)'],
			['nl','Nederlands (nl)'],
			['vn','Tiếng Việt (vn)'],
			['ru','Русский (ru)'],
			['sv','Svenska (sv)'],
			['da','Dansk (da)'],
			['fi','Suomi (di)'],
			['nb','Norsk bokmål (nb)'],
			['tr','Türkçe (tr)'],
			['el','Ελληνικά (el)'],
			['id','Bahasa Indonesia (id)'],
			['ms','Melayu (ms)'],
			['hu','Magyar (hu)'],
			['pl','Polski (pl)'],
			['cs','Čeština (cs)'],
			['sk','Slovenský (sk)'],
			['uk','Українська (uk)'],
			['hr','Hrvatski (hr)'],
			['ca','Català (ca)'],
			['ro','Română (ro)'],
			['he','עברית (he)'],
			['ar','العربية (ar)'],
			['ja','日本語 (ja)'],
			['ko','한국어 (ko)'],
			['th','ไทย (th)'],
			['zh-Hans','简体字 (zh-Hans)'],
			['zh-Hant','正體字 (zh-Hant)'],
		]});
	

ProjectInfoEditor.prototype.init = function ProjectInfoEditor_init() {
		if (sharedInstance) return sharedInstance;
		sharedInstance = this;

		__super.prototype.init.call(this);
		this.style({
				  "backgroundImage": "-webkit-linear-gradient(hsla(0,0%,98%,.8),hsla(0,0%,98%,.1))",
				  "border": "1px solid rgba(0,0,0,.15)",
				  "borderRadius": "8px"
				});
		this.createSubviews();
		
		return this;};
	
	
ProjectInfoEditor.prototype.createSubviews = function ProjectInfoEditor__createSubviews() {
	
		var helpView = this.context.decodeObjectTree({
				$type: 'View',
				$domain: 'Core.UI',
				size: { width: 200, height: this.size.height },
				autoresizingMask: 16,
				position: { left: 400 },
				subviews: [
					{
						$type: 'Label',
						$domain: 'Core.UI',
						"text": "",
						position: { left: 20, top: 15 },
						size: { width: 200-40 },
						style: { fontSize: '12px', color: '#333', whiteSpace: 'pre-wrap' }
					}
				]
			});
		this.addSubview(helpView);
		this.helpView = helpView;
	
		var info = [
		
			{ type: 'select', name: LocalizedString('Language'), keyPath: 'defaultLanguage', items: this.listOfLanguages, help: LocalizedString('') },

			{ name: LocalizedString('Orientations'), type: 'interfaceOrientations', help: LocalizedString('Alle vom Layout dieser App unterstützten Geräte-Ausrichtungen.') },

			{ type: 'space' },
			{ type: 'space' },
			{ type: 'space' },

			{ name: LocalizedString('Launch Image'), type: 'launchImages', help: LocalizedString('This image is a placeholder for the app  launch.') },
			{ type: 'space' },

			{ type: 'boolean', keyPath: 'hidesStatusBarOnLaunch', name: LocalizedString('Hide status bar during application launch'), help: '' },
			
			{ type: 'text', name: LocalizedString('Bundle-ID-Präfix'), keyPath: 'appleAppBundlePrefix', placeholder: 'com.example' },
			
			{ type: 'text', name: LocalizedString('Version'), keyPath: 'version', width: 80, help: LocalizedString("The current version number of the app.") },
		
		];
		
		var y = 20;

		if (Array.isArray(info)) info.every(function (item) {
			var subview;
			switch (item.type) {
				case 'text':
					subview = this.createTextItem(item);
					break;
				case 'select':
					subview = this.createSelectItem(item);
					break;
				case 'color':
					y += 10;
					subview = this.createColorItem(item);
					break;
				case 'caption':
					subview = this.createCaptionItem(item);
					break;
				case 'interfaceOrientations':
					y += 20;
					subview = this.createInterfaceOrientationsItem(item);
					break;
				case 'space':
					subview = null;
					y += 10;
					break;
				case 'launchImages':
					subview = this.createLaunchImagesItem(item);
					y -= 10;
					y += 3;
					break;
				case 'boolean':
					subview = this.createBooleanItem(item);
					break;
			}
			if (subview) {
				subview.position.top = y;
				this.addSubview(subview);
				subview.DOMNode.onmouseover = function (item) {
					helpView.subviews[0].text = item.help;
					helpView.subviews[0].position.top = 15;
					if (this.superview.DOMNode.scrollTop > 20)
						helpView.subviews[0].position.top = this.superview.DOMNode.scrollTop-5;
				}.bind(this, item);
				subview.DOMNode.onmouseout = function (item) {
					helpView.subviews[0].text = '';
				}.bind(this, item);
				y += subview.size.height || 30;
			}
			return true; }, this);
		
		
		this.size.height = y+6;
		
		if (_context.overview) _context.overview.firstSettingsControl = this.subviews[1].subviews[1];
		};
	
	
	
ProjectInfoEditor.prototype.createTextItem = function ProjectInfoEditor__createTextItem(item) {

		return this.context.decodeObjectTree({
			$type: 'View',
			$domain: 'Core.UI',
			subviews: [{
				  	"$type": "Label",
				  	"$domain" : "Core.UI",
				  	"text": item.name,
				  	"position": {
				  	  "top": 0,
				  	  "left": 20
				  	},
					"size" : {
					  "width" : 130,
					  "height" : 30
					},
					"style": {
					  "textAlign": "right"
					}
				  }, {
				  	"$type": "TextField",
				  	"$domain" : "Core.UI",
				  	"position": {
				  	  "top": -5,
				  	  "left": 160
				  	},
					"size" : {
					  "width" : item.width || 220
					},
					"style": {
					  "fontSize": "13px"
					},
					"bindings": [
					  {
						"sourceKeyPath": "value",
						"destination": "projectMetadataController",
						"destinationKeyPath": item.keyPath,
						"bidirectional": true
					  }
					],
				  	placeholder: item.placeholder,
				  }
				]
			});
	};
	

ProjectInfoEditor.prototype.createBooleanItem = function ProjectInfoEditor__createBooleanItem(item) {

		return this.context.decodeObjectTree({
			$type: 'View',
			$domain: 'Core.UI',
			subviews: [
				  {
				  	"$type": "Checkbox",
				  	"$domain" : "Core.UI",
				  	"title": item.name,
				  	"position": {
				  	  "top": -5,
				  	  "left": 160
				  	},
					"size" : {
					  "width" : 210
					},
					"style": {
					  "fontSize": "12px"
					},
					"bindings": [
					  {
						"sourceKeyPath": "value",
						"destination": "projectMetadataController",
						"destinationKeyPath": item.keyPath,
						"bidirectional": true
					  }
					],
				  	placeholder: item.placeholder,
				  }						]
					});
	};
	

ProjectInfoEditor.prototype.createSelectItem = function ProjectInfoEditor__createSelectItem(item) {

		return this.context.decodeObjectTree({
			$type: 'View',
			$domain: 'Core.UI',
			subviews: [{
				  	"$type": "Label",
				  	"$domain" : "Core.UI",
				  	"text": item.name,
				  	"localizeText": true,
				  	"position": {
				  	  "top": 0,
				  	  "left": 20
				  	},
					"size" : {
					  "width" : 130,
					  "height" : 30
					},
					"style": {
					  "textAlign": "right",
					}
				  }, {
				  	"$type": "PopUpButton",
				  	"$domain" : "Core.UI",
				  	"position": {
				  	  "top": -4,
				  	  "left": 161
				  	},
					"size" : {
					  "width" : 225
					},
					"style": {
					  "fontSize": "16px"
					},
					items: item.items,
					"bindings": [
					  {
						"sourceKeyPath": "value",
						"destination": "projectMetadataController",
						"destinationKeyPath": item.keyPath,
						"bidirectional": true
					  }
					]

				  }						]
					});	};
	

ProjectInfoEditor.prototype.createColorItem = function ProjectInfoEditor__createColorItem(item) {

		return this.context.decodeObjectTree({
			$type: 'View',
			$domain: 'Core.UI',
			subviews: [{
				  	"$type": "Label",
				  	"$domain" : "Core.UI",
				  	"text": item.name,
				  	"localizeText": true,
				  	"position": {
				  	  "top": 0,
				  	  "left": 20
				  	},
					"size" : {
					  "width" : 130,
					  "height" : 30
					},
					"style": {
					  "textAlign": "right"
					}
				  }, {
				  	"$type": "ColorPicker",
				  	"$domain" : "Editor.Inspector",
				  	"position": {
				  	  "top": -3,
				  	  "left": 160
				  	},
					"size" : {
					  "width" : 50,
					  "height": 21
					},
					"style": {
					  "fontSize": "13px"
					},
					undefinedValue: system7DefaultTint,
					"bindings": [
					  {
						"sourceKeyPath": "value",
						"destination": "projectMetadataController",
						"destinationKeyPath": item.keyPath,
						"bidirectional": true
					  }
					]

				  }						]
					});	};
	
	
ProjectInfoEditor.prototype.createCaptionItem = function ProjectInfoEditor__createCaptionItem(item) {

		return this.context.decodeObjectTree({
				$type: 'View',
				$domain: 'Core.UI',
				subviews: [
				
				{
				  	"$type": "ImageView",
				  	"$domain" : "Core.UI",
				  	"imageSrc": "Resources/Ornament.png",
				  	"size": { width: 250, height: 11 },
				  	"position": { left: 76, top: 4 }
				},
				{
				  	"$type": "Label",
				  	"$domain" : "Core.UI",
				  	"text": item.name,
				  	"localizeText": true,
				  	"position": {
				  	  "top": 0,
				  	  "left": 20
				  	},
					"size" : {
					  "width" : 400-40,
					  "height" : 30
					},
					"style": {
					  "textAlign": "center",
					  "fontSize": "12px",
					  "color": "#666",
					  "textShadow": "0 1px 0 rgba(255,255,255,.3)"
					}
				  } ]
			});
	};
	
	
ProjectInfoEditor.prototype.createInterfaceOrientationsItem = function ProjectInfoEditor__createInterfaceOrientationsItem(item) {

		return this.context.decodeObjectTree({
			$type: 'View',
			$domain: 'Core.UI',
			subviews: [
			  {
				"$type": "Label",
				"$domain" : "Core.UI",
				"text": item.name,
				"localizeText": true,
				"position": {
				  "top": 0,
				  "left": 20
				},
				"size" : {
				  "width" : 130,
				  "height" : 30
				},
				"style": {
				  "textAlign": "right"
				}
			  },
			  {
				$type: 'InterfaceOrientationControl',
				$domain: 'appdoo',
				size: { width: 182, height: 50 },
				position: { left: 160, top: -16 },
				targetedDeviceFamily: this.context.projectContext.metadata.targetedDeviceFamily,
				bindings: [
					{
						sourceKeyPath: 'value',
						"destination": "projectMetadataController",
						destinationKeyPath: 'supportedInterfaceOrientations', 
						bidirectional: true,
					}
				]

			  } 
			]
		});	

	};
	
	
	var imageControls = [];

ProjectInfoEditor.prototype.createLaunchImagesItem = function ProjectInfoEditor__createLaunchImagesItem(item) {
	
		var subviews = [{
				"$type": "Label",
				"$domain" : "Core.UI",
				"text": item.name,
				"localizeText": true,
				"position": {
				  "top": 67,
				  "left": 20
				},
				"size" : {
				  "width" : 130,
				  "height" : 30
				},
				"style": {
				  "textAlign": "right"
				}
			  }];
			 
		var templates = [];
		
		if (this.context.projectContext.simulatedDeviceType === 'iPhone' || this.context.projectContext.targetIsIOSUniversal) {
			templates = templates.concat([
				{ caption: 'iPhone 4 (640 x 960)', controlWidth: 80, controlHeight: 120-8, keyPath: 'launchImages.phone35', offset: 20 },
				{ caption: 'iPhone 5 (640 x 1136)', controlWidth: 80, controlHeight: 120-8+16, keyPath: 'launchImages.phone40' },
				{ caption: 'iPhone 6/7 (750 × 1334)', controlWidth: 80, controlHeight: 120-8+16, keyPath: 'launchImages.phone72', offset: 20 },
				{ caption: 'iPhone 6/7 Plus (1242 x 2208)', controlWidth: 80, controlHeight: 120-8+16, keyPath: 'launchImages.phone71', offset: 20 },
			]);
		}
		if (this.context.projectContext.simulatedDeviceType === 'iPad' || this.context.projectContext.targetIsIOSUniversal) {
			templates = templates.concat([
				{ caption: 'iPad '+LocalizedString('Portrait')+' (1536 x 2048)', controlWidth: 80, controlHeight: 120-8, keyPath: 'launchImages.portrait' },
				{ caption: 'iPad '+LocalizedString('Landscape')+' (2048 x 1536)', controlWidth: 120-8, controlHeight: 80, keyPath: 'launchImages.landscape', offset: 20 }
			]);
		}
		
		var x = 160;
		var maxY = 142;
		
		if (Array.isArray(templates)) templates.every(function (template) {
			var controlY = (maxY-template.controlHeight)/2;
			var imageControl = {
				$type: 'EditableImageControl',
				$domain: 'appdoo',
				size: { width: template.controlWidth, height: template.controlHeight },
				position: { left: x,
					top: controlY
					},
				bindings: [
					{
						sourceKeyPath: 'imageRef',
						"destination": "projectMetadataController",
						destinationKeyPath: template.keyPath, 
						bidirectional: true,
					}
				],
				fileTypesForImport:['image/png']
			  };
			subviews.push(imageControl,
			  {
				"$type": "Label",
				"$domain" : "Core.UI",
				"text": template.caption,
				"localizeText": true,
				"position": {
				  "top": controlY+template.controlHeight+5,
				  "left": x
				},
				"size" : {
				  "width" : template.controlWidth,
				  "height" : 30
				},
				"style": {
				  "textAlign": "center",
				  "fontSize": "11px",
				  "color": "#777"
				}
			  });
			  
			  x += 80+10;return true; }, this);
		

		var view = this.context.decodeObjectTree({
			$type: 'View',
			$domain: 'Core.UI',
			size: { height: 175 },
			subviews: subviews
		});	
		
		if (Array.isArray(view.subviews)) view.subviews.every(function (subview) {
			if (subview.UTI === 'appdoo.EditableImageControl')
				imageControls.push(subview);
return true; }, this);
		
		
		return view;

	};
	
	
ProjectInfoEditor.prototype.fileReferencesDidUpdate = function ProjectInfoEditor_fileReferencesDidUpdate(refs) {
		if (Array.isArray(imageControls)) imageControls.every(function (ic) {
			if (!ic.imageRef) return true;
			if (Array.isArray(refs)) refs.every(function (ref) {
				if (ref.$id === ic.imageRef.fileReferenceID) {
					ic.changeImageID(ref.resourceID, ref);
				}return true; }, this);
			return true; }, this);
		};
	

ProjectInfoEditor.prototype.expectedTypeForProperty = function ProjectInfoEditor_expectedTypeForProperty(key) {
	if (key === "sharedInstance") return "";
	if (key === "appCategories") return "";
	if (key === "listOfLanguages") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return ProjectInfoEditor; }()));