
registerType('appdoo', (function () { function SceneDispenserView() {} var __super = setSupertypeFromDomain(SceneDispenserView, 'View', 'Core.UI');

	var itemOpacity = 0.9;

	Object.defineProperty(SceneDispenserView.prototype, "contentScale", {
		get: function () {
			var scale = 1/6;
			if (!this.context.projectContext.simulatedDeviceIsIPhone)
				scale /= 2;
			return scale;
		}});
	
	
	Object.defineProperty(SceneDispenserView.prototype, "sizeForItem", {
		get: function () {
			var contentScale = this.contentScale;
			var dimensions = this.context.projectContext.windowSizeForNewScenes,
				
				size = { width: 53, height: 94 }; 
			return size;
		}});
	
	
	Object.defineProperty(SceneDispenserView.prototype, "scenesView", {
	outlet: true, get:function () { return this._scenesView; }, set:function (v) {if (!Object.hasOwnProperty(this, "_scenesView")) Object.defineProperty(this, "_scenesView", { writable: true, configurable: true }); this._scenesView = v; }});
	
	
SceneDispenserView.prototype.init = function SceneDispenserView_init() {
		__super.prototype.init.call(this);

		var size = this.sizeForItem;
		
		this.backgroundView = createComponentFromDomain("View", "Core.UI", this.context, {
			size: { width:size.width, height:this.size.height },
			position: { left: -7 },
			autoresizingMask: 18,
			style: {
				backgroundImage: (window.devicePixelRatio > 1 ? 'url(Resources/Plus@2x.png)' : 'url(Resources/Plus.png)'),
				backgroundRepeat: 'no-repeat',
				backgroundSize: '20px 20px',
				backgroundPosition: '50%',
				opacity: 1.0
			}})
		;
		this.size.width = this.sizeForItem.width-7;
		this.addSubview(this.backgroundView);




		this.plusOverlayIcon = createComponentFromDomain("View", "Core.UI", this.context, {
			size: { width:this.sizeForItem.width, height:this.size.height },
			position: { left: -7 },
			autoresizingMask: 18,
			style: {
				backgroundImage: (window.devicePixelRatio > 1 ? 'url(Resources/Plus@2x.png)' : 'url(Resources/Plus.png)'),
				backgroundRepeat: 'no-repeat',
				backgroundSize: '20px 20px',
				backgroundPosition: '50%',
				opacity: 1.0,
				zIndex: 1000,
				pointerEvents: 'none'
			},})
		;

		this.addSubview(this.plusOverlayIcon);


		
		this.createItemAnimated(false);
		};
	
	
SceneDispenserView.prototype.createItemAnimated = function SceneDispenserView__createItemAnimated(animated) {

		var size = this.sizeForItem;

		var item = createComponentFromDomain("View", "Core.UI", this.context, {
			size: size,
			position: { top: this.size.height/2-size.height/2, left: animated ? -size.width-10 : -10 },
			style: {
				backgroundColor: '#fff',
				boxShadow: '0 2px 4px rgba(0,0,0,.3)',
				opacity: itemOpacity,
			},
			toolTip: LocalizedString('Click or drag to create a new screen')})
		;
		
		this.prepareItemForDrag(item);

		item.DOMNode.onclick = function (e) {
			this.createSceneWithoutDrag(e, false);
		}.bind(this);

		this.addSubview(item);
		this.draggableItemView = item;
		
		if (animated) {
		setTimeout(function () {
			item.beginAnimations();
			item.animationDuration = 0.4;
			item.position.left = -10;
			item.commitAnimations();
		});
		}
};
	
	
SceneDispenserView.prototype.prepareItemForDrag = function SceneDispenserView__prepareItemForDrag(item) {

		item.DOMNode.className = 'canMove';
		item.DOMNode.draggable = true;
		item.DOMNode.onmousedown = function () { this.context.showGrabCursor();document.activeElement.blur(); }.bind(this);
		item.DOMNode.ondragstart = function (e) {

			var dragItem = createComponentFromDomain("DragItem", "Core.UI", this.context, {
				sourceView: item,
				containerStyle: {
					opacity: 1
				},
				
				onBegin: function (_e) {
					this.beginDraggingNewSceneWithEvent(_e, item);

					if (_context.projectContext.testIfHasReachedLimit()) {
						dragItem.cancel(_e);
						return;
					}

				}.bind(this),
				
				onFinish: function (_e) {
					this.endDraggingNewSceneWithEvent(_e, item);
				}.bind(this),
				
				onCancel: function (_e) {
					item.hidden = false;
					return true;
				}.bind(this)})
			;
			dragItem.dragWithEvent(e);
			dragItem.updatesCursor = false;
			e.preventDefault(e);


		}.bind(this);
	};
	
	
	
SceneDispenserView.prototype.createSceneWithoutDrag = function SceneDispenserView_createSceneWithoutDrag(e, useMouseCoordinates) {
	
		if (_context.projectContext.testIfHasReachedLimit())
			return;

		var itemView = this.scenesView.createProvisorySceneView(this.scenesView.suggestPositionForNewScene(useMouseCoordinates?e:null));
		
		itemView.style({ opacity: 0 });
		
		this.scenesView.addItemView(itemView);
		this.scenesView.registerSceneView(itemView);
		this.scenesView.selectSceneView(itemView, true);
		this.scenesView.bringItemViewToFront(itemView);
		this.scenesView.saveItemViewPosition(itemView);

		this.context.projectScenesController.addValue(itemView.scene, this.scenesView);
		this.context.captureProjectItemImage(itemView.scene.viewController.$id);
		
		var draggableItemView = this.draggableItemView;
		
		var x = -draggableItemView.getRelativeX(0),
			y = -draggableItemView.getRelativeY(0);

		itemView.superview.addSubview(draggableItemView);
		draggableItemView.position.left = x + itemView.superview.getRelativeX(0);
		draggableItemView.position.top = y + this.scenesView.getRelativeY(0);
		draggableItemView.style({zIndex:1000});
		
		
		setTimeout(function () {
			var animationDuration = 0.4;
			if (e && e.altKey) animationDuration *= 4;
		
			draggableItemView.beginAnimations();
			draggableItemView.animationTimingFunction = 'ease-in-out';
			draggableItemView.animationDuration = animationDuration;
			var x = -itemView.getRelativeX(0) + itemView.superview.getRelativeX(0) + 34-7;
			var y = -itemView.getRelativeY(0) - 30-11;
			draggableItemView.position.left = x;
			draggableItemView.position.top = y;
			draggableItemView.style({opacity:1});
			draggableItemView.scaleX = (itemView.size.width/draggableItemView.size.width);
			draggableItemView.scaleY = (itemView.size.height/draggableItemView.size.height);
			draggableItemView.commitAnimations();

			setTimeout(function () {
				draggableItemView.removeFromSuperview();
				itemView.style({ opacity: 1 });
			}.bind(this), animationDuration*1000);
			
			setTimeout(function () {
				this.createItemAnimated(true);
			}.bind(this), 500);
			
		}.bind(this));

		this.scenesView.focus();
	
		return itemView.scene;};
	
	


	var itemView;
	
SceneDispenserView.prototype.beginDraggingNewSceneWithEvent = function SceneDispenserView__beginDraggingNewSceneWithEvent(e, item) {

		
		
		itemView = this.scenesView.createProvisorySceneView({left:-1000, top:-1000});
		itemView.style({ opacity: itemOpacity });

		e.dataTransfer.setData('promised-objects', itemView.scene.$id);
		e.dataTransfer.setData('provisory-item-type', 'appdoo.iOS.Scene');

		
		
		var upscaleFactor = this.scenesView.contentScale/this.contentScale;
		var deltaX = (itemView.size.width - e.dragItem.dragView.size.width)/2;
		var deltaY = (itemView.size.height - e.dragItem.dragView.size.height)/2;
		e.dataTransfer.setData('dragged-item-offset-x', Math.floor(-(e.dragItem.position.left-e.x)+deltaX));
		e.dataTransfer.setData('dragged-item-offset-y', Math.floor(-(e.dragItem.position.top-e.y)+deltaY));
		
		item.hidden = true;
		
		this.scenesView.itemViewWillStartDrag(itemView);
};
	
	
SceneDispenserView.prototype.endDraggingNewSceneWithEvent = function SceneDispenserView__endDraggingNewSceneWithEvent(e, item) {
	
		this.scenesView.sceneDispencerDidEndDragSceneView(itemView);
		if (!itemView) return;

	
		
	
		var dragDidWork = itemView.lastDragOperationWasValid;
		if (dragDidWork) {
			item.removeFromSuperview();
			this.createItemAnimated(true);

			setTimeout(function () {
				itemView.editTitle();
				
				if (itemView.DOMNode.style.opacity !== '1') {
					itemView.beginAnimations();
					itemView.style({opacity:1});
					itemView.commitAnimations();
				}
				itemView = null;
				newScene = null;
			}.bind(this), 200);
		}
		else {
			itemView.removeFromSuperview();
			itemView = null;
			newScene = null;
		}
		
	};
	
	
	function performAnimationStep(step, item, delay) {
	
		setTimeout(function () {

			item.beginAnimations();
			item.animationDuration = step.duration/1000;
			switch (step.type) {
				case 'moveRight':
					item.position.left += step.value;
					break;
				case 'moveLeft':
					item.position.left -= step.value;
					break;
			}
			item.commitAnimations();
			
		}, delay);
	
	}
	
	function playAnimation(animation, item) {
		var delay = 0;
		if (Array.isArray(animation)) animation.every(function (step) {
			delay += (step.start||0);
			performAnimationStep(step, item, delay);
			delay += (step.duration||0);return true; }, this);
		
	}
	
SceneDispenserView.prototype.shakeItem = function SceneDispenserView__shakeItem() {


		if (_context.editorIsVisible()) return;
		var item = this.draggableItemView;
		if (!item) return;
		var offset = 5, durationIn = 400, durationOut = durationIn/2.6667;

			playAnimation([
				{ type: 'moveRight', value: offset, duration: durationIn },
				{ type: 'moveRight', value: 0, duration: 100 },
				{ type: 'moveLeft', value: offset, duration: durationOut },
				{ type: 'moveRight', value: offset, duration: durationIn },
				{ type: 'moveRight', value: 0, duration: 100 },
				{ type: 'moveLeft', value: offset, duration: durationOut+100 },
			], item);
		};
	
	

SceneDispenserView.prototype.overviewDidAppear = function SceneDispenserView_overviewDidAppear() {
		this.size.width = this.sizeForItem.width-7;
		this.draggableItemView.removeFromSuperview();
		this.createItemAnimated(true);};
	

SceneDispenserView.prototype.initPropertiesFromData = function SceneDispenserView_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("scenesView")) this.scenesView = data.scenesView;
};

SceneDispenserView.prototype.decodeData = function SceneDispenserView_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

SceneDispenserView.prototype.encode = function SceneDispenserView_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

SceneDispenserView.prototype.encodeCloned = function SceneDispenserView_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

SceneDispenserView.prototype.expectedTypeForProperty = function SceneDispenserView_expectedTypeForProperty(key) {
	if (key === "contentScale") return "";
	if (key === "sizeForItem") return "";
	if (key === "scenesView") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return SceneDispenserView; }()));