
registerType('appdoo', (function () { function SceneView() {} var __super = setSupertypeFromDomain(SceneView, 'View', 'Core.UI');

	Object.defineProperty(SceneView.prototype, "scenesView", {
	synthesized: true, get:function () { return this._scenesView; }, set:function (v) {if (!Object.hasOwnProperty(this, "_scenesView")) Object.defineProperty(this, "_scenesView", { writable: true, configurable: true }); this._scenesView = v; }});
	

	Object.defineProperty(SceneView.prototype, "itemGroupView", {
	synthesized: true, get:function () { return this._itemGroupView; }, set:function (v) {if (!Object.hasOwnProperty(this, "_itemGroupView")) Object.defineProperty(this, "_itemGroupView", { writable: true, configurable: true }); this._itemGroupView = v; }});
	

	Object.defineProperty(SceneView.prototype, "sceneID", {
		get: function () {
			if (this.scene) return this.scene.$id;
		}});
	

	Object.defineProperty(SceneView.prototype, "scene", {
	synthesized: true, get:function () { return this._scene; }, set:function (v) {if (!Object.hasOwnProperty(this, "_scene")) Object.defineProperty(this, "_scene", { writable: true, configurable: true }); this._scene = v; }});
	

	Object.defineProperty(SceneView.prototype, "encodesSubviews", {
		value: false});
	

	Object.defineProperty(SceneView.prototype, "positionIsEditable", {
		value: true});
	


	

SceneView.prototype.initFromData = function SceneView_initFromData(data) {
	
		data.size = {
			width: data.itemSize.width,
			height: data.itemSize.height
		};

		if (!__super.prototype.initFromData.call(this, data))
			return;
		

		this.contentScale = data.contentScale;
		this.segueSource = data.segueSource;
		this.segueSourceItemView = data.segueSourceItemView;
		this.scenesView = data.scenesView;
		this.itemSize = data.itemSize;
		this.scene = data.scene;
		
		this.createSubviews();

		if (this.context.isDebugging)
			this.toolTip = data.sceneID;
		
		this.style({
				boxShadow: '0 2px 3px rgba(0,0,0,.25)',
				borderStyle: 'solid',
				borderColor: 'rgba(0,113,238,1.0)',
				borderWidth: '4px 0px 0px 0px',
		})
		this.updateView();

		return this;};
	

SceneView.prototype.createSubviews = function SceneView__createSubviews() {

		this.createImageView();
		this.createTitleLabel();

		this.imageView.DOMNode.className = 'canMove';
		this.imageView.DOMNode.onmousedown = function (e) {
			this.context.showGrabCursor();
		}.bind(this);
		
		
		this.imageView.DOMNode.onmouseup = function (e) {
            var isSelected = this.scenesView.sceneViewsController.selectedValues.indexOf(this) !== -1;
    		if (!isSelected) {
    		    this.scenesView.unselectAll();  
                this.scenesView.selectSceneView(this);
    		}
        }.bind(this);
};
	
	
	Object.defineProperty(SceneView.prototype, "temporaryPreviewImagePath", {
		get: function () {
			return this.imageView.imageSrc;
		}});
	
	
	function uniqueURL(v) {
		if (v) return v+'#'+Math.random(100000); return '';
		return v;
	}
	
SceneView.prototype.createImageView = function SceneView__createImageView() {
		
		if (!this.scene) {
			console.log(this, this.DOMNode);
			console.trace();
		}
		
		var imageSrc = (this.scene.temporaryPreviewImagePath || this.context.fileURLForPreviewWithID(this.scene.viewController.$id));
		
		imageSrc = uniqueURL(imageSrc);

		this.imageView = createComponentFromDomain("ImageView", "Core.UI", this.context, {
			autoresizingMask: 18,
				imageSrc: imageSrc,
				contentMode: 'scaleToFill',
				size: this.itemSize,
				style: {
					backgroundColor: 'hsl(0,0%,100%)'
				},
				changeWithTransition: true,
				tag: 100,

				bindings: [
				{ sourceKeyPath:'imageSrc', destination:'projectScenesByIDController', destinationKeyPath:this.scene.$id+'.temporaryPreviewImagePath', valueTransformer: uniqueURL, ignoreWhenInitializing: true
				}]})
			;
		
		
		this.imageView.DOMNode.addEventListener('dblclick', function (e) {
			this.open();
		}.bind(this));
		
		this.addSubview(this.imageView);
};
	
	
SceneView.prototype.createTitleLabel = function SceneView__createTitleLabel() {

		this.titleLabel = createComponentFromDomain("SceneViewTitleLabel", "appdoo", this.context, {
			scene: this.scene,
		
			style: {
				zIndex: 100,
			},
		
			autoresizingMask: 13,
			position: {
				left: -20,
				top: this.itemSize.height+10+4
			},
			size: {
				width: this.size.width+40,
				height: 12*3
			},
			bindings: [
				{ sourceKeyPath:'text', destination:'projectScenesByIDController', destinationKeyPath:this.scene.$id+'.e_title' }]})
		;
		
		this.titleLabel.DOMNode.onclick = function (e) {
			this.rename();
		}.bind(this);


		this.addSubview(this.titleLabel);
};
	
	
	
	
	
SceneView.prototype.prepareAsDragObject = function SceneView__prepareAsDragObject() {
		this.prepareAsDragObjectCustom();};
	
	
SceneView.prototype.prepareAsDragObjectHTML5 = function SceneView__prepareAsDragObjectHTML5() {
		this.DOMNode.draggable = true;
		this.DOMNode.addEventListener('dragstart', this.itemViewOnDragStart.bind(this));
		this.DOMNode.addEventListener('dragend', this.itemViewOnDragEnd.bind(this));};
	
	
SceneView.prototype.fixPosition = function SceneView__fixPosition(position) {};
	
	
SceneView.prototype.prepareAsDragObjectCustom = function SceneView__prepareAsDragObjectCustom() {
		return;

		this.DOMNode.draggable = true;
		
		this.DOMNode.addEventListener('mousedown', function (e) {
		
			if (e.detail > 1) return;
					
			var dragItemSourceView = this;

			var position = {
					left: e.x-this.getRelativeX(e.x) | 0,
					top: e.y-this.getRelativeY(e.y) | 0
				};
			
			this.fixPosition(position);

			var dragItem = createComponentFromDomain("DragItem", "Core.UI", this.context, {
				sourceView: dragItemSourceView,
				dragContext: this.context,
				position: position,
				containerStyle: {
					opacity: 1
				},
				minimumMovement: 1,
				onBegin: function (_e) {
					if (_e.altKey) {
						
						dragItemSourceView = this.cloneForDragOperation();
						dragItemSourceView.isDragAndDropClone = true;
						dragItem.isInCopyMode = true;
						dragItem.updatesCursor = true;
					}
					var offset = {
						left: -this.getRelativeX(e.x),
						top: -this.getRelativeY(e.y)
					};
					this.fixPosition(offset);
					_e.dataTransfer.setData('dragged-item-offset-x', -offset.left);
					_e.dataTransfer.setData('dragged-item-offset-y', -offset.top);
					dragItemSourceView.itemViewOnDragStart(_e);
				}.bind(this),
				
				onFinish: function (_e) {
					dragItemSourceView.itemViewOnDragEnd(_e, dragItem);
					this.scenesView.selectSceneView(dragItemSourceView);
				}.bind(this),
				
				onCancel: function (_e) {
					dragItemSourceView.itemViewOnCancel(_e);
				}.bind(this),})
			;
			dragItem.dragWithEvent(e);
			dragItem.updatesCursor = false;

		}.bind(this));
	};
	
	
	
	

SceneView.prototype.showTitleLabelAnimated = function SceneView_showTitleLabelAnimated(animated, duration) {
	
		if (!animated) {
			this.titleLabel.style({ opacity: 1 });
			return;
		}

		if (this.titleLabel.DOMNode.style.opacity === '0') {
			this.titleLabel.beginAnimations();
			this.titleLabel.style({ opacity: 1 });
			if (duration) this.titleLabel.animationDuration = duration;
			this.titleLabel.commitAnimations();
		}
	};
	

	
	
	
SceneView.prototype.editTitle = function SceneView_editTitle() {
	
		var style = { textAlign: 'center', fontSize: '12px' };
		
		var ftf = createComponentFromDomain("FloatingTextField", "Core.UI", this.context, {
			style: style,
			position: {
				left: this.size.width/2,
				top: this.titleLabel.position.top
			},
			text: this.titleLabel.label.text,
			delegate: this})
		;
		this.addSubview(ftf);
};
	


// role FloatingTextFieldDelegate (Core.UI) 

SceneView.prototype.textFieldDidBeginEditing = function SceneView_textFieldDidBeginEditing(textField) {
			this.titleLabel.hidden = true;};
		

SceneView.prototype.textFieldDidEndEditing = function SceneView_textFieldDidEndEditing(textField) {
			var v = textField.value;
			if (v !== this.scene.viewController.title && v.length > 0) {
				this.context.projectScenesByIDController.setValueForKeyPath(v, this.sceneID+'.e_title', this);
			}
			this.scenesView.selectSceneView(this);
			this.titleLabel.hidden = false;
			this.scenesView.focus();};
		

	
	
	
	

SceneView.prototype.drawConnection = function SceneView__drawConnection() {
		return;
	
		this.arrow = createComponentFromDomain("ImageView", "Core.UI", this.context, {
			size: { width: 22, height: 40 },
			position: { left: this._size.width/2-11, top: -53+5+3-1 },
			imageSrc: this.context.pathForResource('ArrowDown.png')})
		;
		
		this.addSubview(this.arrow);
};
	
	
	
	
	
	Object.defineProperty(SceneView.prototype, "isMemberOfRootGroup", {
		get: function () {
			return this.itemGroupView && 
			this.itemGroupView.UTI === 'appdoo.Overview.ItemGroupView';
		}});
	

SceneView.prototype.itemViewOnDragStart = function SceneView__itemViewOnDragStart(e) {

		this.scenesView.itemViewWillStartDrag(this);
		
		e.dataTransfer.setData('promised-objects', this.scene.$id);

		if (this.isMemberOfRootGroup) {
			this.itemViewIndexBeforeDrag = this.superview.itemViews.indexOf(this);
		}
		else {
			this.itemViewPositionBeforeDrag = clone(this.position);
		}

		setTimeout(function () {
			this.hidden = true;
		}.bind(this) ,1);
};
	

SceneView.prototype.itemViewOnDragEnd = function SceneView__itemViewOnDragEnd(e, dragItem) {

		if (this.isDragAndDropClone) {
			delete this.isDragAndDropClone;
			if (!this.lastDragOperationWasValid) {
				this.scenesView.unregisterItemView(this);
				this.removeFromSuperview();
				return;
			}
			else {
				this.scenesView.finishInsertion(this.scene);
			}
		}
		
		if (e.didCancel) {
			if (this.isMemberOfRootGroup) {
				this.itemGroupView.insertItemViewAtIndex(this, this.itemViewIndexBeforeDrag);
				this.itemGroupView.sizeToFitAnimated(true, true);
				this.itemGroupView.arrangeItemViewsAnimated(true, false, true);
			}
			else {
				if (this.itemGroupView)
					this.itemGroupView.addSubview(this);
			}
			this.hidden = true;
			dragItem.dragView.style({opacity:1});
		}
		else {
			this.hidden = false;
			this.itemGroupView = this.superview;
			this.scenesView.itemViewDidEndDrag(this);
		}
		
		};
	
	
SceneView.prototype.itemViewOnCancel = function SceneView__itemViewOnCancel(e) {

		this.scenesView.itemViewDidEndDrag(this);
		
		if (this.itemViewPositionBeforeDrag) {
			this.position = this.itemViewPositionBeforeDrag;
		}
		};
	

SceneView.prototype.updateView = function SceneView_updateView() {
		var isInitial = this.context.projectContext.isInitialScene(this.scene.viewController.$id);
		if(isInitial) {
			this.DOMNode.style.borderColor = 'rgba(0,113,238,1.0)';
		} else {
			this.DOMNode.style.borderColor = 'rgba(0,113,238,0.0)';
		}
		this.addContextMenu();};
	
	
	
	
SceneView.prototype.addContextMenu = function SceneView__addContextMenu() {
		var isInitial = this.context.projectContext.isInitialScene(this.scene.viewController.$id);
		this.contextMenu = this.context.decodeObjectTree({
			"$type": "Menu",
			"$domain": "Core.UI",
			"items": [
				{
				"$type": "MenuItem",
				"$domain": "Core.UI",
				"title": LocalizedString("Edit"),
				"target": this,
				"targetMethod": "open"
				},
				{
				"$type": "MenuItem",
				"$domain": "Core.UI",
				"title": (this.scene.e_showsInTabBar ? LocalizedString("Initial Screen (Tab View)") : LocalizedString("Initial Screen")),
				"target": this,
				"state": isInitial,
				"enabled": true, 
				"targetMethod": "makeinitial"
				},
				{
				"$type" : "MenuItem",
				"$domain" : "Core.UI",
				"separator" : true
				},
				{
				"$type": "MenuItem",
				"$domain": "Core.UI",
				"title": LocalizedString("Copy"),
				"target": this,
				"targetMethod": "copy"
				},
				{
				"$type": "MenuItem",
				"$domain": "Core.UI",
				"title": LocalizedString("Paste"),
				"target": this,
				"targetMethod": "delete"
				},
				{
				"$type": "MenuItem",
				"$domain": "Core.UI",
				"title": LocalizedString("Duplicate"),
				"target": this,
				"targetMethod": "duplicate"
				},
				{
				"$type" : "MenuItem",
				"$domain" : "Core.UI",
				"separator" : true
				},
				{
				"$type": "MenuItem",
				"$domain": "Core.UI",
				"title": LocalizedString("Delete"),
				"target": this,
				"targetMethod": "cut"
				},
			]
		});
	};
	
	
SceneView.prototype.cut = function SceneView_cut(sender, menuItem) {
		if (menuItem) {
			return this.scenesView.cut();
		}
		this.scenesView.cut();};
	

SceneView.prototype.copy = function SceneView_copy(sender) {
		if (menuItem) {
			return this.scenesView.copy();
		}
		this.scenesView.copy();};
	

SceneView.prototype.paste = function SceneView_paste(sender) {
		this.scenesView.paste();};
	

SceneView.prototype.duplicate = function SceneView_duplicate(sender, menuItem) {
		if (menuItem) {
			return this.scenesView.duplicateSelection();
		}
		var duplicateView = this.scenesView.duplicateSceneView(this, true);
		this.scenesView.selectSceneView(duplicateView, true);};
	

SceneView.prototype.makeinitial = function SceneView_makeinitial(sender, menuItem) {
		if(this.scene.v_showsInTabBar) {
			
			this.context.projectMetadataController.removeObjectForKey('initialViewController',sender);
		} else {
			this.context.projectMetadataController.setValueForKeyPath(this.scene.viewController.$id, 'initialViewController');
		}
		this.context.overview.scenesView.updateSceneContextualMenus();};
	

SceneView.prototype.delete = function SceneView_delete(sender, menuItem) {
		if (menuItem) {
			return this.scenesView.deleteSelection();
		}
		this.scenesView.deleteScene(this.scene, false);};
	
	
SceneView.prototype.open = function SceneView_open(sender) {
		this.context.showEditorWithOptions({
			itemId: this.sceneID
		});};
	
	
SceneView.prototype.rename = function SceneView_rename(sender) {
		this.editTitle();};
	
	
	
SceneView.prototype.cloneForDragOperation = function SceneView__cloneForDragOperation(e) {
		var itemView = this.scenesView.duplicateItemView(this, false);
		itemView.position = { left: -1000, top: -1000 };
		itemView.style({opacity:1});
		return itemView;};
	


	

SceneView.prototype.selectForEditor = function SceneView_selectForEditor(editor) {
	
		if (!this.focusRing) {
			this.focusRing = createComponentFromDomain("SmartScalingImage", "Core.UI", this.context, {
					size: {
						width: this.size.width + 10,
						height: this.size.height + 10
					},
					imageSrc: 'Resources/SquaredFocusRing.png',
					contentInset: [11,11,11,11],
					style: { pointerEvents: 'none' },
					position: {
						left: -5,
						top: -5
					},
					autoresizingMask: 18})
				;

			this.addSubview(this.focusRing);
		}
		this.focusRing.hidden = false;
		
		this.titleLabel.selectForEditor(editor);
};
	

SceneView.prototype.unselectForEditor = function SceneView_unselectForEditor(editor) {

		if (this.focusRing)
			this.focusRing.hidden = true;

		this.titleLabel.unselectForEditor(editor);};
	
	
	Object.defineProperty(SceneView.prototype, "previewSize", {
		set: function (v) {

			var scaledSize = {
				width: this.scenesView.contentScale * v.width,
				height: this.scenesView.contentScale * v.height,
			};
			var dx = scaledSize.width-this.size.width,
				dy = scaledSize.height-this.size.height;

			this.position.left -= dx/2;
			this.position.top -= dy/2;
			
			this.size = scaledSize;
			
		}});
	
	
SceneView.prototype.expectedTypeForProperty = function SceneView_expectedTypeForProperty(key) {
	if (key === "scenesView") return "";
	if (key === "itemGroupView") return "";
	if (key === "sceneID") return "";
	if (key === "scene") return "";
	if (key === "encodesSubviews") return "";
	if (key === "positionIsEditable") return "";
	if (key === "temporaryPreviewImagePath") return "";
	if (key === "isMemberOfRootGroup") return "";
	if (key === "previewSize") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return SceneView; }()));
registerType('appdoo', (function () { function SceneViewTitleLabel() {} var __super = setSupertypeFromDomain(SceneViewTitleLabel, 'View', 'Core.UI');

	Object.defineProperty(SceneViewTitleLabel.prototype, "scene", {
	outlet: true, get:function () { return this._scene; }, set:function (v) {if (!Object.hasOwnProperty(this, "_scene")) Object.defineProperty(this, "_scene", { writable: true, configurable: true }); this._scene = v; }});
	

SceneViewTitleLabel.prototype.init = function SceneViewTitleLabel_init() {
		__super.prototype.init.call(this);
		
		var fontSize = 12;

		var xPadding = 10;
		this.backgroundView = createComponentFromDomain("CanvasView", "Core.UI", this.context, {
			size: {
				width: this.size.width+xPadding*2,
				height: this.size.height+10,
			},
			position: { left: -xPadding, top: -5+2 },
			style: { pointerEvents:'none' }})
		;
		this.addSubview(this.backgroundView);


		this.backgroundView.draw = function (width, height) {

			var ctx = this.backgroundView.DOMNode.getContext('2d');

			ctx.fillStyle = this.isSelected ? 'hsl(209,100%,47%)' : 'hsla(0,0%,95%,.0)';
			
			var textWidth = Math.min(this.label.widthToFit, this.label.size.width)+1;
			var textHeight = this.label.heightToFitWidth(textWidth);
			this.size.height = textHeight;
			
			var isSingleLine = textHeight <= 15;
			
			textWidth += xPadding;
			textHeight += 11-2-4;
			if (isSingleLine) textWidth += 14;
			
			ctx.save();
			ctx.scale(this.backgroundView.contentScale,this.backgroundView.contentScale);
			ctx.roundRect(width/2-textWidth/2,0+1,textWidth,textHeight,isSingleLine ? 40 : 10);
			ctx.fill();
			ctx.restore();

		}.bind(this);

		this.label = createComponentFromDomain("UILabel", "appdoo.iOS", this.context, {
			size: this.sizeCopy,
			textAlignment: 'center',
			fontSize: 12,
			numberOfLines: 2,
			style: {
				pointerEvents:'none',
				color: 'var(--overview-text-color)',
				overflow: 'hidden',
				cursor: 'default',
			},})
		;
		this.label._containerNode.style.verticalAlign = 'top';
		this.addSubview(this.label);

		this.backgroundView.layoutSubviews();
		
		
		
		return this;};
	

SceneViewTitleLabel.prototype.selectForEditor = function SceneViewTitleLabel_selectForEditor(editor) {
		this.isSelected = true;
		this.label.CSSTextColor = 'var(--overview-text-color-selected)';
		this.backgroundView.layoutSubviews();};
	

SceneViewTitleLabel.prototype.unselectForEditor = function SceneViewTitleLabel_unselectForEditor(editor) {
		this.isSelected = false;
		this.label.CSSTextColor = 'var(--overview-text-color)';
		this.backgroundView.layoutSubviews();};
	
	
	Object.defineProperty(SceneViewTitleLabel.prototype, "text", {
	outlet: true, 
		set: function (text) {if (!Object.hasOwnProperty(this, "_text")) Object.defineProperty(this, "_text", { writable: true, configurable: true });
			if (!text) text = this.scene.e_title;
			if (!text) text = LocalizedString("Untitled");
			this.label.text = text;
			if (this.backgroundView) this.backgroundView.layoutSubviews();
		}, get:function () { return this._text; }});
	

SceneViewTitleLabel.prototype.initPropertiesFromData = function SceneViewTitleLabel_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("scene")) this.scene = data.scene;
if (data.hasOwnProperty("text")) this.text = data.text;
};

SceneViewTitleLabel.prototype.decodeData = function SceneViewTitleLabel_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
if (data.hasOwnProperty("scene")) decoded.scene = this.context.decodeObjectTree(data.scene);
return decoded; };

SceneViewTitleLabel.prototype.encode = function SceneViewTitleLabel_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

SceneViewTitleLabel.prototype.encodeCloned = function SceneViewTitleLabel_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

SceneViewTitleLabel.prototype.expectedTypeForProperty = function SceneViewTitleLabel_expectedTypeForProperty(key) {
	if (key === "scene") return "Scene";
	if (key === "text") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return SceneViewTitleLabel; }()));