
registerType('appdoo.Overview', (function () { function ScenesView() {} var __super = setSupertypeFromDomain(ScenesView, 'View', 'Core.UI');

	var defaultContentScale = 0.33,
		zoomMin = 0.125,
		zoomMax = 1.0,
		zoomStep = 0.125;

	Object.defineProperty(ScenesView.prototype, "overview", {
	outlet: true, 
	synthesized: true, get:function () { return this._overview; }, set:function (v) {if (!Object.hasOwnProperty(this, "_overview")) Object.defineProperty(this, "_overview", { writable: true, configurable: true }); this._overview = v; }});
	

	Object.defineProperty(ScenesView.prototype, "sceneDispenserView", {
	outlet: true, 
	synthesized: true, get:function () { return this._sceneDispenserView; }, set:function (v) {if (!Object.hasOwnProperty(this, "_sceneDispenserView")) Object.defineProperty(this, "_sceneDispenserView", { writable: true, configurable: true }); this._sceneDispenserView = v; }});
	

	Object.defineProperty(ScenesView.prototype, "contentScale", {
	outlet: true, 
	synthesized: true, get:function () { return this._contentScale; }, set:function (v) {if (!Object.hasOwnProperty(this, "_contentScale")) Object.defineProperty(this, "_contentScale", { writable: true, configurable: true }); this._contentScale = v; }});
	

	Object.defineProperty(ScenesView.prototype, "contentScaleY", {
		get: function () {
			return this.contentScale;
		}});
	

ScenesView.prototype.init = function ScenesView_init() {

		__super.prototype.init.call(this);
		
		this.style({ outline: "none", overflow: "auto" });
		
		this.DOMNode.addEventListener('keydown', this.keyDown.bind(this));

		this.DOMNode.onfocus = function (e) {
			this.context.registerFocus(this);
		}.bind(this);

		this.DOMNode.onblur = function (e) {
			this.context.unregisterFocus(this);
			this.manipulator.unselectAll();
		}.bind(this);

		this.observeObject(this.context.projectScenesController);
		this.observeObject(this.context.projectScenesByIDController);

		var cs;
		try {
			cs = this.context.projectContext.project.metadata.overviewAppearance.contentScale;
		} catch (err) {}
		if (!isNaN(cs)) {
			this.contentScale = cs;
		}
		else {
			if (this.context.projectContext.screenSizeInPoints.width > 320)
				defaultContentScale = 0.16;
			this.contentScale = defaultContentScale;
		}

		this.reset();

		this.addContextMenu();
		};
	

ScenesView.prototype.reset = function ScenesView__reset() {
		this.itemViewForId = {};
		this.itemGroupForId = {};
		this.removeAllSubviews();
		delete this.focusRing;
		if (this.manipulator) {
			this.manipulator.destroy();
			this.manipulator = null;
		}};
	

ScenesView.prototype.overviewDidAppear = function ScenesView_overviewDidAppear() {
		this.updateSegues();
		this.updateSceneTitles();
		if (this.context.editor) {
			var sceneView = this.itemViewForId[this.context.editor.lastEditedSceneID];
			if (sceneView) {
				setTimeout(function () {
					this.focus();
					this.manipulator.unselectAll();
					this.manipulator.select(sceneView, this.manipulator);
				}.bind(this), 1);
			}
		}
		this.sceneDispenserView.overviewDidAppear();};
	
	
ScenesView.prototype.updateSceneTitles = function ScenesView__updateSceneTitles() {
	
		if (Array.isArray(this.sceneViewsController.contents)) this.sceneViewsController.contents.every(function (sceneView) {
			sceneView.titleLabel.text = sceneView.scene.e_title;return true; }, this);
		
};
	

ScenesView.prototype.updateSceneContextualMenus = function ScenesView__updateSceneContextualMenus() {
		if (Array.isArray(this.sceneViewsController.contents)) this.sceneViewsController.contents.every(function (sceneView) {
			sceneView.updateView();return true; }, this);
		
};
	


ScenesView.prototype.createSubviews = function ScenesView__createSubviews() {
	
		this.createSceneDispenser();
	
		
		this.createContentView();
		
		
		this.createManipulator();
};
	
	
ScenesView.prototype.createSceneDispenser = function ScenesView__createSceneDispenser() {

        this.sceneDispenserView = this.context.decodeObjectTree({
				"$type": "SceneDispenserView",
				"$domain": "appdoo",
				"$id": "sceneDispenserView",
				"size": { "width": 80, "height": 200 },
				"position": { "top": this.size.height/2-100 },
				"autoresizingMask": 40,
				"style": { "zIndex": "2000" },
				"connections":[ { "key" : "scenesView", "destination" : "scenesView" } ]
              });
		
		
	};
	
	
ScenesView.prototype.createManipulator = function ScenesView__createManipulator() {
	
		var overlayView = createComponentFromDomain("View", "Core.UI", this.context, {
			style: {
				zIndex: 1000, pointerEvents: 'none' },
			size: { width: this.superview.size.width, height: this.superview.size.height },
			position: { left: 0, top: 0 },
			hidden:true})
		;
		
		this.superview.superview.superview.superview.addSubview(overlayView);

		
		this.manipulator = createComponentFromDomain("Manipulator", "appdoo", this.context, {
			delegate: this,
			frameView: this,
			contentWrapper: this,
			overlayView: overlayView,
			contentScale: 1,
			editedView: this.contentView,
			observableItemsController: this.sceneViewsController,
			showGuidelines: true,
			delegateIsOverview: true})
		;

		this.DOMNode.onscroll = function (e) {
			this.manipulator.updateSizeModifierButtons();
		}.bind(this);

	};
	

ScenesView.prototype.editedViewsForManipulator = function ScenesView_editedViewsForManipulator() {
		return this.sceneViewsController.contents;};
	
	
ScenesView.prototype.createContentView = function ScenesView__createContentView() {

		this.contentView = createComponentFromDomain("View", "Core.UI", this.context, {
			size: { width: 200, height: 200 },
			position: { top: 0, left: 0 },})
		;
		this.insertSubviewAtIndex(this.contentView, 0);

		this.prepareAsDropTarget();
		
		this.createSceneViews();
		this.createSegueViews();
		
		this.layoutContentView();
};
	
	
ScenesView.prototype.createSceneViews = function ScenesView__createSceneViews() {
	
		this.sceneViewsController = createComponentFromDomain("ArrayController", "Core", this.context, {
			contents: []})
		;

		if (Array.isArray(this.context.projectContext.scenes)) this.context.projectContext.scenes.every(function (scene) {
			this.addViewForScene(scene);return true; }, this);
		
	
		
		if (Array.isArray(this.sceneViewsController.contents)) this.sceneViewsController.contents.every(function (sceneView) {
			this.positionSceneView(sceneView);return true; }, this);
		
};
	
	
ScenesView.prototype.positionSceneView = function ScenesView__positionSceneView(sceneView) {
		sceneView.position = this.scaledPositionForScene(sceneView.scene);};
	
	
ScenesView.prototype.createSegueViews = function ScenesView__createSegueViews() {

		this.segueViewsController = createComponentFromDomain("ArrayController", "Core", this.context, {
			contents: []})
		;
		
		if (Array.isArray(this.context.projectContext.scenes)) this.context.projectContext.scenes.every(function (scene) {
			if (Array.isArray(scene.segues)) scene.segues.every(function (segue) {
				this.addViewForSegue(segue, scene);return true; }, this);
			return true; }, this);
		
	};
	
	
ScenesView.prototype.updateSegues = function ScenesView__updateSegues() {

		if (Array.isArray(this.segueViewsController.contents)) this.segueViewsController.contents.every(function (segueView) {
			segueView.removeFromSuperview();return true; }, this);
		
		
		this.createSegueViews();
		};
	
	
ScenesView.prototype.addViewForSegue = function ScenesView__addViewForSegue(segue, sourceScene) {

		var targetScene = this.context.projectContext.sceneWithID(segue.destinationSceneID);
		
		if (!sourceScene || !targetScene) {
			console.warn('sourceScene or targetScene is undefined.', sourceScene, targetScene);
			return;
		}

		var segueView = createComponentFromDomain("SegueView", "appdoo", this.context, {
			size: { width: 100, height: 100 },
			style: { zIndex: 0 },
			sourceScene: sourceScene,
			targetScene: targetScene,
			sourceSceneView: this.viewForScene(sourceScene),
			targetSceneView: this.viewForScene(targetScene),})
		;
		
		
		this.layoutSegue(segueView);
		this.contentView.insertSubviewAtIndex(segueView, 0);

		
		this.context.addDataControllerToObject(segue, this);
		this.segueViewsController.addValue(segueView, this);
};
	
	
ScenesView.prototype.layoutSegue = function ScenesView__layoutSegue(segueView) {
	
		var scene1View = segueView.sourceSceneView;
		var scene2View = segueView.targetSceneView;

		var points = this.connectionPointsForSceneViews(scene1View, scene2View),
			p1 = points[0], p2 = points[1];
		
		segueView.direction = this.directionFromPoints(points);
		segueView.angle = this.angleFromPoints(points);
		
		var margin = 8;
		
		var frame = {
			position: {
				left: Math.min(p1.left, p2.left)-margin,
				top: Math.min(p1.top, p2.top)-margin,
			},
			size: {
				width: Math.abs(p1.left-p2.left)+margin*2,
				height: Math.abs(p1.top-p2.top)+margin*2,
			}
		};
		
		segueView.position = frame.position;
		segueView.size = frame.size;
		
};
	


	
ScenesView.prototype.relayoutSegueViews = function ScenesView__relayoutSegueViews(changedItemViews) {
		
		var segueViewsToRelayout = [];
		
		if (Array.isArray(this.segueViewsController.contents)) this.segueViewsController.contents.every(function (segueView) {
			if (changedItemViews.indexOf(segueView.sourceSceneView) !== -1 ||
				changedItemViews.indexOf(segueView.targetSceneView) !== -1) {
				segueViewsToRelayout.push(segueView);
			}return true; }, this);
		
		
		if (Array.isArray(segueViewsToRelayout)) segueViewsToRelayout.every(function (segueView) {
			this.layoutSegue(segueView);return true; }, this);
		
};
	
	

ScenesView.prototype.layoutSubviews = function ScenesView__layoutSubviews() {
		this.layoutContentView();};
	

ScenesView.prototype.layoutContentView = function ScenesView__layoutContentView() {
		
		if (!this.contentView) return;
		this.sizeContentViewToFit();
		this.contentView.position.left = Math.max(
			this.size.width/2,
			-this.contentViewLowestX+20
		);
		};
	
	
ScenesView.prototype.sizeContentViewToFit = function ScenesView__sizeContentViewToFit() {
	
		var maxX = 0;
		var maxY = 0;
		
		if (Array.isArray(this.contentView.subviews)) this.contentView.subviews.every(function (sceneView) {
			maxX = Math.max(maxX, sceneView.position.left+sceneView.size.width);
			maxY = Math.max(maxY, sceneView.position.top+sceneView.size.height);return true; }, this);
		

		this.contentView.size = { width: maxX, height: maxY };
	};
	
	
	Object.defineProperty(ScenesView.prototype, "contentViewLowestX", {
		get: function () {
			var minX = 0;
			if (Array.isArray(this.contentView.subviews)) this.contentView.subviews.every(function (sceneView) {
				minX = Math.min(minX, sceneView.position.left);return true; }, this);
			
			return minX;
		}});
	
	
	
	
	
	
	var _isLocked;
	Object.defineProperty(ScenesView.prototype, "isLocked", {
		set: function (v) {
			_isLocked = v;
			if (!v && queuedKeyEvents.length) {
				if (Array.isArray(queuedKeyEvents)) queuedKeyEvents.every(function (e) {
					this.keyDown(e);
					queuedKeyEvents.splice(queuedKeyEvents.indexOf(e), 1);return true; }, this);
				
			}
		}, 
		get: function () { return _isLocked; }});
	

	var queuedKeyEvents = [];
	
ScenesView.prototype.keyDown = function ScenesView__keyDown(e) {

		if (this.isLocked) {
			queuedKeyEvents.push(e);
			e.preventDefault();
			return;
		}

		if (e.target.tagName === 'INPUT') return;

		 
		if (e.keyCode >= 37 && e.keyCode <= 40) {
			
			var result = this.moveSelection(e.keyCode-37);

			e.preventDefault();
			e.stopPropagation();

		}
		
		 
		else if (e.keyCode === 13) {
		
			var selectedItemView = this.sceneViewsController.selectedValues[0];
			if (selectedItemView) {
				selectedItemView.editTitle();
				e.preventDefault();
			}
		
		}
		
		
		else if (e.keyCode === 8 || e.keyCode === 46) {
			if (this.deleteSelection() === true)
				e.preventDefault();
		}

		
		else if (e.keyCode === 32) {
			var selectedItemView = this.sceneViewsController.selectedValues[0];
			if (selectedItemView) selectedItemView.open();

			e.preventDefault();
			e.stopPropagation();
		}
		};
	
	
	
	

ScenesView.prototype.canCopy = function ScenesView_canCopy() {
		return this.sceneViewsController.selectedValues.length > 0;};
	

ScenesView.prototype.canCut = function ScenesView_canCut() {
		return true;};
	

ScenesView.prototype.canPaste = function ScenesView_canPaste() {
		return this.context.nativeProxy.sendMessage("pasteboardContainsType", this.context.scenesDataType);};
	

ScenesView.prototype.canDuplicate = function ScenesView_canDuplicate() {
		return this.canCopy();};
	

ScenesView.prototype.copy = function ScenesView_copy() {

		var copies = [];
		if (Array.isArray(this.sceneViewsController.selectedValues)) this.sceneViewsController.selectedValues.every(function (sceneView) {
			copies.push(sceneView.scene.encodeCloned());return true; }, this);
		
		
		var dataType = this.context.scenesDataType;
		this.context.pasteboardDelegate.clearData();
		this.context.pasteboardDelegate.setData(dataType, JSON.stringify(copies));
		
		return true;
		};
	

ScenesView.prototype.cut = function ScenesView_cut() {
		if (this.copy()) {
			this.deleteSelection();
			return true;
		}};
	

ScenesView.prototype.paste = function ScenesView_paste() {

		var itemsData;
		try {
			itemsData = JSON.parse(this.context.pasteboardDelegate.getData(this.context.scenesDataType));
		} catch (err) {
			alert(LocalizedString('An error has occured while inserting.'));
			return false;
		}
		
		this.unselectAll();
		if (Array.isArray(itemsData)) itemsData.every(function (data) {
			var sceneView = this.insertSceneFromData(data);
			this.selectSceneView(sceneView, false);return true; }, this);
		
		
		return true;
};
	
	
	

ScenesView.prototype.duplicateSelection = function ScenesView_duplicateSelection(sender) {

		
		
		var addOffset = !!sender;
	
		if (Array.isArray(clone(this.sceneViewsController.selectedValues))) clone(this.sceneViewsController.selectedValues).every(function (sceneView) {
			var duplicateView = this.duplicateSceneView(sceneView, addOffset);
			this.selectSceneView(duplicateView, true);return true; }, this);
		
};
	
	
ScenesView.prototype.duplicateSceneView = function ScenesView_duplicateSceneView(sceneView, addOffset) {
		var scene = sceneView.scene;
		var data = scene.encodeCloned();
		if (addOffset && data.positionOnOverview) {
			data.positionOnOverview.left += 20;
			data.positionOnOverview.top += 20;
		}
		return this.insertSceneFromData(data, sceneView);};
	
	
ScenesView.prototype.insertSceneFromData = function ScenesView__insertSceneFromData(data, sceneView) {
		var duplicate = this.context.projectContext.decodeObjectTree(data);
		duplicate.identify();
		this.context.projectScenesController.addValue(duplicate, this);

		if (sceneView) duplicate.temporaryPreviewImagePath = sceneView.temporaryPreviewImagePath;

		var duplicateView = this.addViewForScene(duplicate);
		this.context.captureProjectItemImage(duplicate.viewController.$id);
		this.positionSceneView(duplicateView);
		this.bringItemViewToFront(duplicateView);
		this.updateSegues();
		return duplicateView;};
	
	

	

	
	
ScenesView.prototype.prepareAsDropTarget = function ScenesView__prepareAsDropTarget() {
	
		var draggedView, self = this;

		this.dropHandler = {

			didEnterWithEvent: function (e) {
			
				if (e.dataTransfer.types.indexOf('provisory-item-type') !== -1) {
					var upscaleFactor = this.contentScale/this.sceneDispenserView.contentScale*1;
					e.dragItem.setScaleAnimated(upscaleFactor, true);
				}

				draggedView = self.itemViewForId[e.dataTransfer.getData('promised-objects')];
				if (draggedView) {
					draggedView.lastDragOperationWasValid = true;
					this.addItemView(draggedView);
				}
				
			}.bind(this),

			didLeaveWithEvent: function (e) {

				if (e.dragItem)
					e.dragItem.setScaleAnimated(1, true);
				
				if (draggedView)
					draggedView.lastDragOperationWasValid = false;

			}.bind(this),
			
			dropEffectForEvent: function (e) {
				return 'move';
			}.bind(this),
			
			didDropWithEvent: function (e) {
			
				if (!draggedView) return;

				draggedView.position = {
					left: this.contentView.getRelativeX(e.x)-e.dataTransfer.getData('dragged-item-offset-x'),
					top: this.contentView.getRelativeY(e.y)-e.dataTransfer.getData('dragged-item-offset-y')
				};
				
				this.bringItemViewToFront(draggedView);

				if (e.dataTransfer.types.indexOf('provisory-item-type') !== -1) {
					this.context.projectScenesController.addValue(draggedView.scene, this);
					this.registerSceneView(draggedView);
					this.context.captureProjectItemImage(draggedView.scene.viewController.$id);
					this.selectSceneView(draggedView, true);
				}

				this.saveItemViewPosition(draggedView, null);
				
				draggedView.position = this.scaledPositionForScene(draggedView.scene);
				
				this.focus();
				
				e.preventDefault();
				return true;
			}.bind(this)
		}; 
	};
	
	
ScenesView.prototype.addItemView = function ScenesView__addItemView(itemView, animated) {

		if (!itemView)
			return;
		
		this.contentView.addSubview(itemView);
		};
	
	
ScenesView.prototype.unregisterItemView = function ScenesView_unregisterItemView(itemView) {
		delete this.itemViewForId[itemView.scene.$id];};
	
	
ScenesView.prototype.bringItemViewToFront = function ScenesView__bringItemViewToFront(itemView) {
		var i = 0;
		if (Array.isArray(this.contentView.subviews)) this.contentView.subviews.every(function (_itemView) {
			_itemView.DOMNode.style.zIndex = (_itemView == itemView) ? this.contentView.subviews.length : i;
			i++;return true; }, this);
		};
	


	var announcedDragOperationType,
		announcedDragOperationSender,
		announcedDragOperationArguments;

ScenesView.prototype.announceDragOperation = function ScenesView_announceDragOperation(operationType, sender, arg1, arg2) {
		announcedDragOperationType = operationType;
		announcedDragOperationSender = sender;
		announcedDragOperationArguments = [arg1, arg2];};
	
	


	

ScenesView.prototype.previewSizeForInstance = function ScenesView_previewSizeForInstance(instance) {
		return instance.previewSize || this.context.projectContext.windowSizeInPoints;};
	

ScenesView.prototype.addViewForScene = function ScenesView__addViewForScene(scene) {

		var itemView = this.createItemView(scene);
		this.contentView.addSubview(itemView);
		
		this.registerSceneView(itemView);
		
		return itemView;
		};
	
	
ScenesView.prototype.registerSceneView = function ScenesView__registerSceneView(itemView) {

		
		this.sceneViewsController.addValue(itemView, this);

		
		this.context.addDataControllerToObject(itemView.scene, this);

		this.context.addDataControllerToObject(itemView, this);
		itemView.dataController.canUndo = false;
	};
	
	
ScenesView.prototype.viewForScene = function ScenesView__viewForScene(scene) {
		return this.sceneViewsController.valuePassingTest(function (sceneView) {
			return sceneView.scene === scene;
		});};
	

ScenesView.prototype.generatePlaceholderViewControllers = function ScenesView__generatePlaceholderViewControllers(viewControllerIDs) {

		var viewControllers = [],
			projectContext = this.context.projectContext;

		if (Array.isArray(viewControllerIDs)) viewControllerIDs.every(function (viewControllerId) {
			var id = viewControllerId;
			var vcData = projectContext.viewControllerWithID(id);
			if (!vcData) {
				console.warn(viewControllerId, 'not available.');
				return true;
			}
		
			viewControllers.push(
				{
					title: vcData.title,
					tabBarItem: vcData.tabBarItem,
					$id: vcData.$id
				}
			);
			
			if (!vcData.tabBarItem.title) vcData.tabBarItem.title = vcData.title;return true; }, this);
		
		return viewControllers;
		};
	
	
ScenesView.prototype.addViewForTabBarController = function ScenesView__addViewForTabBarController(tabBarController) {

		var placeholderViewControllers = this.generatePlaceholderViewControllers(tabBarController.viewControllerIDs);
			
		var containerView = createComponentFromDomain("View", "Core.UI", this.context, {
			size: { width: 320, height: 49 }})
		;

		containerView.instance = tabBarController;
	
		this.contentView.addSubview(containerView);
		console.log(containerView.DOMNode);
};
	
	
ScenesView.prototype.createProvisorySceneView = function ScenesView_createProvisorySceneView(position) {
		var scene = this.context.projectContext.createNewScene();
		return this.createItemView(scene, position);};
	
	
ScenesView.prototype.createItemView = function ScenesView__createItemView(scene, position, segueSource, segueSourceItemView) {

		if (!scene) {
			console.log("createItemView", arguments);
			console.trace();
			return;
		}

		var unscaledSize = this.previewSizeForInstance(scene),
			size = {
				width: unscaledSize.width * this.contentScale,
				height: unscaledSize.height * this.contentScale
			};

		var itemView = createComponentFromDomain("SceneView", "appdoo", this.context, {
				scene: scene,
				position: position,
				itemSize: size,
				contentScale: this.contentScale,
				segueSource: segueSource,
				segueSourceItemView: segueSourceItemView,
				overview: this.overview,
				instancesView: this,
				scenesView: this,
				bindings: [
					{ sourceKeyPath: 'previewSize', destination: 'projectScenesByIDController', destinationKeyPath: scene.$id+'.previewSize', ignoreWhenInitializing: true }]})
			;
		
		this.itemViewForId[scene.$id] = itemView;

		return itemView;};
	
	
	
	
ScenesView.prototype.saveItemViewPosition = function ScenesView__saveItemViewPosition(itemView, p) {
	
		var pBefore = clone(itemView.scene.positionOnOverview);

		if (!p) p = this.unscaledInstancePositionForItemView(itemView);

		if (pBefore && pBefore.left === p.left && pBefore.top === p.top)
			return;

		this.context.projectScenesByIDController.setValueForKeyPath(p, itemView.scene.$id+'.positionOnOverview', this);
	};
	


	

ScenesView.prototype.deleteScene = function ScenesView_deleteScene(scene,confirmed) {
		var ctx = this.context;







		
		if (confirmed == true) {
			ctx.projectScenesController.removeValue(scene);
			if(ctx.projectMetadataController.get("initialViewController")) {
				if(ctx.projectContext.initialScene == ctx.projectMetadataController.get("initialViewController")) {
					ctx.projectMetadataController.removeObjectForKey('initialViewController',sender);
				}
			}
			return;
		}
		var result = this.context.nativeProxy.sendMessage('confirmWithOptions', JSON.stringify({
			message: LocalizedString('Delete Screen'),
			details: LocalizedString('Do you really want do delete this screen?'),
			button1: LocalizedString('Delete'),
			button2: LocalizedString('Cancel'),
			button3: '',
			
		}));
		if (result === true) {
			if(ctx.projectMetadataController.get("initialViewController")) {
				if(ctx.projectContext.initialScene == ctx.projectMetadataController.get("initialViewController")) {
					ctx.projectMetadataController.removeObjectForKey('initialViewController',null);
				}
			}
			ctx.projectScenesController.removeValue(scene);
			var change = {
				type: 'delete',
				object: scene,
			};
			
			ctx.prototypeDevicesBar.publishChange(change);
		}};
	



	
	
ScenesView.prototype.selectAnyItem = function ScenesView__selectAnyItem() {

		this.focus();
		
		var firstSceneView = this.sceneViewsController.contents[0];
		if (firstSceneView) this.selectSceneView(firstSceneView);
		};
	

ScenesView.prototype.selectAll = function ScenesView_selectAll() {
		this.manipulator.selectAll();};
	

ScenesView.prototype.canSelectAll = function ScenesView_canSelectAll() {
		return true;};
	

ScenesView.prototype.canUnselectAll = function ScenesView_canUnselectAll() {
		return this.sceneViewsController.selectedValues.length > 0;};
	

ScenesView.prototype.unselectAll = function ScenesView_unselectAll() {
		this.manipulator.unselectAll();};
	
	
ScenesView.prototype.selectSceneView = function ScenesView_selectSceneView(sceneView, exclusive) {

		if (exclusive) this.manipulator.unselectAll(this.manipulator);
		this.manipulator.select(sceneView, this.manipulator);};
	
	

ScenesView.prototype.moveSelection = function ScenesView__moveSelection(direction) {
	
		if (this.sceneViewsController.selectedValues.length !== 1) {
			return;
		}

		var itemViewsForId = this.itemViewForId,
			itemViewSelected = this.sceneViewsController.selectedValues[0],
			x = itemViewSelected.position.left,
			itemViewToSelect,
			comparator,
			score = 0;

		switch (direction) {
		case 0: 
			comparator = function (original, compared) {
				if (compared.position.left >= original.position.left) return 0;
				return 10000 - (original.position.left - compared.position.left) -
					Math.abs(original.position.top - compared.position.top);
			};
			break;
		case 1: 
			comparator = function (original, compared) {
				if (compared.position.top >= original.position.top) return 0;
				return 10000 - (original.position.top - compared.position.top) -
					Math.abs(original.position.left - compared.position.left);
			};
			break;
		case 2: 
			comparator = function (original, compared) {
				if (compared.position.left <= original.position.left) return 0;
				return 10000 - (compared.position.left - original.position.left) -
					Math.abs(original.position.top - compared.position.top);
			};
			break;
		case 3: 
			comparator = function (original, compared) {
				if (compared.position.top <= original.position.top) return 0;
				return 10000 - (compared.position.top - original.position.top) -
					Math.abs(original.position.left - compared.position.left);
			};
			break;
		}


		for (id in itemViewsForId) {
			if (id === itemViewSelected.scene.$id) continue;
			var itemView = itemViewsForId[id],
				_score = comparator(itemViewSelected, itemView);
			if (_score > score) {
				itemViewToSelect = itemView;
				score = _score;
			}
		}

		if (itemViewToSelect === undefined) {
			return false;
		}

		this.selectSceneView(itemViewToSelect, true);
		this.scrollToShowView(itemViewToSelect, 30);
		return true;};
	


// role Observer (Core) 

ScenesView.prototype.observedObjectValueDidAppearForKey = function ScenesView_observedObjectValueDidAppearForKey(obj, key, sender) {

			if (!this.context.undoManager.isUndoingOrRedoing) return;
			
			var value = obj.get(key);
			
			if (value.UTI === 'appdoo.iOS.Scene') {
				var sceneView = this.addViewForScene(value);
				this.positionSceneView(sceneView);
				this.updateSegues();
				this.bringItemViewToFront(sceneView);
			}
};
		
		
ScenesView.prototype.observedObjectValueDidDisappearForKey = function ScenesView_observedObjectValueDidDisappearForKey(obj, value, key, sender) {

			if (value.UTI === 'appdoo.iOS.Scene') {
				var itemView = this.itemViewForId[value.$id];
				if (itemView) {
					this.sceneViewsController.removeValue(itemView);
					itemView.removeFromSuperview();
					this.updateSegues();
				}
			}
};
		

ScenesView.prototype.observedObjectValueDidChangeKey = function ScenesView_observedObjectValueDidChangeKey(obj, oldKey, newKey, keyPath, sender) {
};
		
		
ScenesView.prototype.observedObjectValueDidChangeForKeyPath = function ScenesView_observedObjectValueDidChangeForKeyPath(obj, keyPath) {
			
			if (obj === this.context.projectScenesByIDController) {
				var components = keyPath.split('.');
				var sceneID = components.shift();
				keyPath = components.join('.');
				
				if (keyPath === 'positionOnOverview') {
					var itemView = this.itemViewForId[sceneID];
					if (itemView) {
						this.positionSceneView(itemView);
						this.updateSegues();
					}
				}
			}};
		


	

ScenesView.prototype.canDelete = function ScenesView_canDelete() {
		return this.sceneViewsController.selectedValues.length > 0;};
	

ScenesView.prototype.deleteSelection = function ScenesView_deleteSelection() {
		if(this.sceneViewsController.selectedValues.length > 1) {
			var selectedScenes = clone(this.sceneViewsController.selectedValues);
			var ctx = this;
			
			var result = this.context.nativeProxy.sendMessage('confirmWithOptions', JSON.stringify({
				message: LocalizedString('Delete Screens'),
				details: LocalizedString('Do you really want do delete all selected screens?'),
				button1: LocalizedString('Delete'),
				button2: LocalizedString('Cancel'),
				button3: '',
				
			}));
			if (result === true) {
				if (Array.isArray(selectedScenes)) selectedScenes.every(function (sceneView) {
					ctx.deleteScene(sceneView.scene,true);
					this.context.updateAllSceneViews();return true; }, this);
				
			}
			return;
		}

		if (Array.isArray(clone(this.sceneViewsController.selectedValues))) clone(this.sceneViewsController.selectedValues).every(function (sceneView) {
			this.deleteScene(sceneView.scene, false);
			this.context.updateAllSceneViews();return true; }, this);
		
		
		return true;
};
	
	
	
	

ScenesView.prototype.manipulatorWillMoveItems = function ScenesView_manipulatorWillMoveItems(manipulator, items) {
		if (Array.isArray(items)) items.every(function (item) {
			this.bringItemViewToFront(item);return true; }, this);
		};
	
	
ScenesView.prototype.manipulatorDidMoveItems = function ScenesView_manipulatorDidMoveItems(manipulator, items) {

		this.relayoutSegueViews(items);
		
		if (Array.isArray(items)) items.every(function (item) {
			this.saveItemViewPosition(item);return true; }, this);
		
		
		this.layoutContentView()};
	

ScenesView.prototype.manipulatorIsMovingItems = function ScenesView_manipulatorIsMovingItems(manipulator, items) {
		this.relayoutSegueViews(items);};
	
	
ScenesView.prototype.sceneDispencerDidEndDragSceneView = function ScenesView_sceneDispencerDidEndDragSceneView(sceneView) {
		return;
		this.dragInProgress = false;

		if (this.overview.headerView)
			this.overview.headerView.titleTextField.disabled = false;

		for (id in this.itemViewForId) {
			this.itemViewForId[id].style({ pointerEvents: '' });
		}
};
	
	
	

		Object.defineProperty(ScenesView.prototype, "editedSubviewRect", {
			get: function () {
				var rect = {};
				rect.size = this.contentView.size;
				rect.position = {
					left: this.contentView.position.left,
					top: this.contentView.position.top +
						this.position.top
				};
				return rect;
			}});
		

	
ScenesView.prototype.contextMenuForItems = function ScenesView_contextMenuForItems() {};
	
	
ScenesView.prototype.groupViewDidChangeSize = function ScenesView_groupViewDidChangeSize(groupView) {};
	
	
ScenesView.prototype.itemViewWillStartDrag = function ScenesView_itemViewWillStartDrag(itemView) {
	
		this.dragInProgress = true;

		if (this.overview.headerView)
			this.overview.headerView.titleTextField.disabled = true;

		for (id in this.itemViewForId) {
			if (itemView.sceneId === id) continue;
			this.itemViewForId[id].style({ pointerEvents: 'none' });
		}
		
		if (this.connectionLayer) {
			this.connectionLayer.style({ opacity: 0.0 });
		}};
	


	

ScenesView.prototype.scaledPositionForScene = function ScenesView__scaledPositionForScene(scene) {

		var middleX = 0,
			offsetY = 0;

		var position = scene.positionOnOverview ? clone(scene.positionOnOverview) : { left: 0, top: 150 };
		var size = this.previewSizeForInstance(scene);
		
		position = {
			left:position.left-size.width/2,
			top:position.top
		};
		
		position.left *= this.contentScale;
		position.top *= this.contentScaleY;
		
		position.left += middleX;
		position.top += offsetY;
		
		return position;
	};
	
	
ScenesView.prototype.unscaledInstancePositionForItemView = function ScenesView__unscaledInstancePositionForItemView(itemView) {

		var middleX = 0,
			offsetY = 0;
		
		var position = itemView.positionCopy;
		var size = this.previewSizeForInstance(itemView.scene);

		position.left -= middleX;
		position.top -= offsetY;
		
		position.left /= this.contentScale;
		position.top /= this.contentScaleY;
		position.left += size.width/2;
		
		position.top = position.top | 0;
		position.left = position.left | 0;
		
		return position;
	};
	

ScenesView.prototype.scaledConnectionStartPositionForSceneView = function ScenesView_scaledConnectionStartPositionForSceneView(itemView) {
		if (!itemView) return {};
		return this.scaledCenterForInstance(instance);};
	

ScenesView.prototype.scaledConnectionEndPositionForSceneView = function ScenesView_scaledConnectionEndPositionForSceneView(itemView) {
		return {};};
	

ScenesView.prototype.scaledCenterForInstance = function ScenesView_scaledCenterForInstance(instance) {
		var pos = this.scaledPositionForScene(instance);
		pos.left += this.itemViewForId[instance.$id].size.width/2;
		pos.top += (this.itemViewForId[instance.$id].size.height-40)/2;
		return pos;};
	
	
ScenesView.prototype.snapPositionForSceneView = function ScenesView_snapPositionForSceneView(itemView, orientation) {

		if (!itemView) return {};

		var position = itemView.positionCopy;
		position.orientation = orientation;
		
		switch (orientation) {
			case 'north':
				position.left += itemView.size.width/2;
				break;
			case 'north-east':
				position.left += itemView.size.width;
				break;
			case 'north-west':
				break;
			case 'east':
				position.left += itemView.size.width;
				position.top += itemView.size.height/2;
				break;
			case 'west':
				position.top += itemView.size.height/2;
				break;
			case 'south':
				position.left += itemView.size.width/2;
				position.top += itemView.size.height;
				break;
			case 'south-east':
				position.left += itemView.size.width;
				position.top += itemView.size.height;
				break;
			case 'south-west':
				position.top += itemView.size.height;
				break;
		}

		return position;};
	

ScenesView.prototype.connectionPointsForSceneViews = function ScenesView__connectionPointsForSceneViews(v1, v2) {
		
		var p1, p2,
			orientation1, orientation2;
		
		if (v1.position.bottom < v2.position.top) {
			orientation1 = 'south';
			orientation2 = 'north';
		}
		else if (v2.position.bottom < v1.position.top) {
			orientation1 = 'north';
			orientation2 = 'south';
		}
		else if (v1.position.right < v2.position.left) {
			orientation1 = 'east';
			orientation2 = 'west';
		}
		else if (v2.position.right < v1.position.left) {
			orientation1 = 'west';
			orientation2 = 'east';
		}
		
		p1 = this.snapPositionForSceneView(v1, orientation1);
		p2 = this.snapPositionForSceneView(v2, orientation2);

		return [p1, p2];};
	
	
ScenesView.prototype.directionFromPoints = function ScenesView__directionFromPoints(points) {
		var p1 = points[0], p2 = points[1];
		return p1.orientation+'-to-'+p2.orientation;};
	
	
ScenesView.prototype.angleFromPoints = function ScenesView__angleFromPoints(points) {
	
		var dy = points[1].top-points[0].top,
			dx = points[1].left-points[0].left,
			steigung = dx ? dy/dx : 1,
			deg = (2-(2/(Math.abs(steigung)+1)))*45;
			
		if (steigung === 1) {
			if (dy > 0) deg = 180;
			else deg = 315;
		}
		else {
			if (steigung < 0) deg *= -1;
			if (dx < 0) deg += 180;
			deg += 90;
		}
		
		return deg;
	};
	


ScenesView.prototype.addContextMenu = function ScenesView__addContextMenu() {
		
		this.contextMenu = this.context.decodeObjectTree({
			"$type": "Menu",
			"$domain": "Core.UI",
			delegate: this,
			"items": [
			  {
				"$type": "MenuItem",
				"$domain": "Core.UI",
				"title": LocalizedString("Paste"),
				"target": this,
				"targetMethod": "paste"
			  },
			  {
				"$type": "MenuItem",
				"$domain": "Core.UI",
				"title": LocalizedString("New Screen"),
				"target": this,
				"targetMethod": "createNewSceneFromMenu"
			  },
			  {
				"$type": "MenuItem",
				"$domain": "Core.UI",
				"title": LocalizedString("Clean Up"),
				"target": this,
				"targetMethod": "arrangeScenes"
			  },
			]
		});
		};
	

ScenesView.prototype.menuNeedsUpdate = function ScenesView_menuNeedsUpdate(menu) {
		menu.menuItemByTargetMethod('paste').hidden = this.canPaste() !== true;};
	
	
ScenesView.prototype.arrangeScenes = function ScenesView_arrangeScenes(sender, animated) {
		this.context.arrangeScenesForOverview(this.context.projectContext.project);

		
		if (Array.isArray(this.sceneViewsController.contents)) this.sceneViewsController.contents.every(function (sceneView) {
			if (animated !== false) {
				sceneView.beginAnimations();
				sceneView.animationDuration = 0.5;
			}
			sceneView.position = this.scaledPositionForScene(sceneView.scene);
			if (animated !== false) {
				sceneView.commitAnimations();
			}return true; }, this);
		
		
		this.updateSegues();};
	
	
ScenesView.prototype.createNewSceneFromMenu = function ScenesView_createNewSceneFromMenu(obj, sender, e) {
		this.sceneDispenserView.createSceneWithoutDrag(e, true);};
	
	

	var xForPositionSuggestions = -60,
		yForPositionSuggestions = 120;

ScenesView.prototype.suggestPositionForNewScene = function ScenesView_suggestPositionForNewScene(e) {
	
		if (e) return {
			left: e.clientX+this.contentView.getRelativeX(0) - 60 + 30,
			top: e.clientY+this.contentView.getRelativeY(0) - 125 + 15,
		};
		
		var r = { left:xForPositionSuggestions, top:yForPositionSuggestions };	
		xForPositionSuggestions += 20;
		yForPositionSuggestions += 20;
		
		return r;
		};
	
	
ScenesView.prototype.initPropertiesFromData = function ScenesView_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("overview")) this.overview = data.overview;
if (data.hasOwnProperty("sceneDispenserView")) this.sceneDispenserView = data.sceneDispenserView;
if (data.hasOwnProperty("contentScale")) this.contentScale = data.contentScale;
};

ScenesView.prototype.decodeData = function ScenesView_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

ScenesView.prototype.encode = function ScenesView_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

ScenesView.prototype.encodeCloned = function ScenesView_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

ScenesView.prototype.expectedTypeForProperty = function ScenesView_expectedTypeForProperty(key) {
	if (key === "overview") return "";
	if (key === "sceneDispenserView") return "";
	if (key === "contentScale") return "";
	if (key === "contentScaleY") return "";
	if (key === "contentViewLowestX") return "";
	if (key === "isLocked") return "";
	if (key === "editedSubviewRect") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return ScenesView; }()));
registerType('appdoo', (function () { function SegueView() {} var __super = setSupertypeFromDomain(SegueView, 'View', 'Core.UI');

	Object.defineProperty(SegueView.prototype, "sourceScene", {
	outlet: true, get:function () { return this._sourceScene; }, set:function (v) {if (!Object.hasOwnProperty(this, "_sourceScene")) Object.defineProperty(this, "_sourceScene", { writable: true, configurable: true }); this._sourceScene = v; }});
	

	Object.defineProperty(SegueView.prototype, "targetScene", {
	outlet: true, get:function () { return this._targetScene; }, set:function (v) {if (!Object.hasOwnProperty(this, "_targetScene")) Object.defineProperty(this, "_targetScene", { writable: true, configurable: true }); this._targetScene = v; }});
	

	Object.defineProperty(SegueView.prototype, "sourceSceneView", {
	outlet: true, get:function () { return this._sourceSceneView; }, set:function (v) {if (!Object.hasOwnProperty(this, "_sourceSceneView")) Object.defineProperty(this, "_sourceSceneView", { writable: true, configurable: true }); this._sourceSceneView = v; }});
	

	Object.defineProperty(SegueView.prototype, "targetSceneView", {
	outlet: true, get:function () { return this._targetSceneView; }, set:function (v) {if (!Object.hasOwnProperty(this, "_targetSceneView")) Object.defineProperty(this, "_targetSceneView", { writable: true, configurable: true }); this._targetSceneView = v; }});
	
	
	Object.defineProperty(SegueView.prototype, "direction", {
	outlet: true, get:function () { return this._direction; }, set:function (v) {if (!Object.hasOwnProperty(this, "_direction")) Object.defineProperty(this, "_direction", { writable: true, configurable: true }); this._direction = v; }});
	

	Object.defineProperty(SegueView.prototype, "angle", {
	outlet: true, get:function () { return this._angle; }, set:function (v) {if (!Object.hasOwnProperty(this, "_angle")) Object.defineProperty(this, "_angle", { writable: true, configurable: true }); this._angle = v; }});
	

SegueView.prototype.layoutSubviews = function SegueView_layoutSubviews() {
		this.redraw();};
	

SegueView.prototype.createCanvasIfNecessary = function SegueView__createCanvasIfNecessary() {
		if (!this.canvas) {
			this.canvas = document.createElement('canvas');
			this.DOMNode.appendChild(this.canvas);
		}};
	
	
	
	function drawPoints(ctx, p) {
		var colors = ['red','red','blue','green'];
		for (var i = 0, c = points.length; i < c; i+=2) {
			ctx.fillStyle = colors[i/2];
			ctx.fillRect(p[i]-3, p[i+1]-3, 7, 7);
		}
	}
	
	function drawLineWithArrow(ctx, width, height, scale) {

		var margin = 8,
			d = 0;
		
		height -= 10;
		
		
		
		
		var points = [
			-0.5+margin,margin,
			width-0.5-margin,height-margin,
			margin-0.5,height-d-margin,
			width-margin-0.5,margin+d
		];
		
		
		points[3] -= 1*scale;
		
		for (var i = 0, c = points.length; i < c; i++) {
			points[i]*=scale;
		}
		
		var lineWidth = 3*scale;


		

		ctx.lineWidth = lineWidth-2*scale;
		ctx.strokeStyle = "hsl(0,0%,100%)";
		ctx.stroke();
		ctx.beginPath();
		ctx.moveTo(points[2]-7*scale,points[3]+0.5);
		ctx.lineTo(points[2]+7*scale,points[3]+0.5);
		ctx.lineTo(points[2],points[3]+10*scale);
		ctx.lineTo(points[2]-7*scale,points[3]);
		ctx.fillStyle = "hsl(0,0%,100%)";
		ctx.save();
		ctx.shadowColor = "rgba(0,0,0, .15)";
		ctx.shadowOffsetX = 0; 
		ctx.shadowOffsetY = 3*scale;
		ctx.shadowBlur = 3*scale;
		ctx.fill();
		ctx.restore();
		ctx.strokeStyle = "rgba(0,0,0, .35)";
		ctx.lineWidth = 1;
		ctx.stroke();
		
		
		ctx.fillRect((width-10)*scale, points[3]-0.5,
					(lineWidth-3)*scale, 3*scale);


		

		ctx.beginPath();
		ctx.moveTo(points[0],points[1]);
		ctx.bezierCurveTo(
			points[4],points[5],
			points[6],points[7],
			points[2],points[3]);
		

		ctx.save();
		ctx.shadowColor = "rgba(0,0,0, .15)";
		ctx.shadowOffsetX = 0; 
		ctx.shadowOffsetY = 3*scale;
		ctx.shadowBlur = 3*scale;
		ctx.lineWidth = lineWidth+2;
		ctx.strokeStyle = "rgba(0,0,0, .35)";
		ctx.stroke();
		ctx.restore();

		ctx.lineWidth = lineWidth;
		ctx.strokeStyle = "hsl(0,0%,98%)";
		ctx.stroke();

	}
	
	function flipHorizontal(ctx,w,h) {
		ctx.translate(w*2, 0);
		ctx.scale(-1, 1);
	}

	function flipVertical(ctx,w,h) {
		ctx.translate(0, h*2);
		ctx.scale(1, -1);
	}
	
SegueView.prototype.redraw = function SegueView__redraw() {

		this.createCanvasIfNecessary();
		

		var width = this.size.width,
			height = this.size.height;

		var scale = 2;

		
		this.canvas.width = width*scale;
		this.canvas.height = height*scale;
		this.canvas.style.width = width+'px';
		this.canvas.style.height = height+'px';

		var ctx = this.canvas.getContext('2d');
		ctx.clearRect(0,0, width,height);
		
		switch (this.direction) {

			case 'north-to-south':
				flipVertical(ctx,width,height);
			case 'south-to-north':
				if (this.angle > 180)
					flipHorizontal(ctx,width,height);
				break;

			case 'east-to-west':
				flipHorizontal(ctx,width,height);
			case 'west-to-east':

				if (this.angle > 270 ||
					this.angle < 90)
					flipVertical(ctx,width,height);

				
				ctx.translate(width*2, 0);
				ctx.rotate(90*Math.PI/180);

				
				width = this.size.height;
				height = this.size.width;



				break;
			default:
				
				return;
		}
		
		if (height < 36) return;
		
		drawLineWithArrow(ctx, width, height, scale);
		
};
	

SegueView.prototype.initPropertiesFromData = function SegueView_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("sourceScene")) this.sourceScene = data.sourceScene;
if (data.hasOwnProperty("targetScene")) this.targetScene = data.targetScene;
if (data.hasOwnProperty("sourceSceneView")) this.sourceSceneView = data.sourceSceneView;
if (data.hasOwnProperty("targetSceneView")) this.targetSceneView = data.targetSceneView;
if (data.hasOwnProperty("direction")) this.direction = data.direction;
if (data.hasOwnProperty("angle")) this.angle = data.angle;
};

SegueView.prototype.decodeData = function SegueView_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

SegueView.prototype.encode = function SegueView_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

SegueView.prototype.encodeCloned = function SegueView_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

SegueView.prototype.expectedTypeForProperty = function SegueView_expectedTypeForProperty(key) {
	if (key === "sourceScene") return "";
	if (key === "targetScene") return "";
	if (key === "sourceSceneView") return "";
	if (key === "targetSceneView") return "";
	if (key === "direction") return "";
	if (key === "angle") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return SegueView; }()));