
registerType('appdoo', (function () { function Project() {} var __super = setSupertypeFromDomain(Project, 'BasicObject', 'Core');

Project.prototype.init = function Project_init() {
		__super.prototype.init.call(this);
		if (!this.objects) this.objects = [];
		return this;};
	

	Object.defineProperty(Project.prototype, "metadata", {
	outlet: true, 
	enumerable: true, get:function () { return this._metadata; }, set:function (v) {if (!Object.hasOwnProperty(this, "_metadata")) Object.defineProperty(this, "_metadata", { writable: true, configurable: true }); this._metadata = v; }});
	

	Object.defineProperty(Project.prototype, "objects", {
	outlet: true, 
	enumerable: true, get:function () { return this._objects; }, set:function (v) {if (!Object.hasOwnProperty(this, "_objects")) Object.defineProperty(this, "_objects", { writable: true, configurable: true }); this._objects = v; }});
	

	Object.defineProperty(Project.prototype, "fileReferences", {
	outlet: true, 
	enumerable: true, get:function () { return this._fileReferences; }, set:function (v) {if (!Object.hasOwnProperty(this, "_fileReferences")) Object.defineProperty(this, "_fileReferences", { writable: true, configurable: true }); this._fileReferences = v; }});
	

	Object.defineProperty(Project.prototype, "tabBarController", {
	outlet: true, 
	enumerable: true, get:function () { return this._tabBarController; }, set:function (v) {if (!Object.hasOwnProperty(this, "_tabBarController")) Object.defineProperty(this, "_tabBarController", { writable: true, configurable: true }); this._tabBarController = v; }});
	

	Object.defineProperty(Project.prototype, "scenes", {
	outlet: true, 
	enumerable: true, get:function () { return this._scenes; }, set:function (v) {if (!Object.hasOwnProperty(this, "_scenes")) Object.defineProperty(this, "_scenes", { writable: true, configurable: true }); this._scenes = v; }});
	

	
Project.prototype.encodeForAppdooPreview = function Project_encodeForAppdooPreview(deviceInfo) {

		window.nextViewTagForAppdooPreview = 101;
		var transformer = createComponentFromDomain('appdooPreviewTransformer', 'appdoo', _context, {
			deviceInfo: deviceInfo
		});

		var result = {
			$type: this.constructor.name,
			$domain: this.__domain,
			formatVersion: 2,
			scenes: [],
			fileReferences: [],
			metadata: this.metadata,
			objects: [],
		};
		

		if (Array.isArray(this.scenes)) this.scenes.every(function (scene) {
			result.scenes.push(scene.encodeForAppdooPreview(deviceInfo));return true; }, this);
		

		transformer.currentObjects = [];
		if (Array.isArray(this.objects)) this.objects.every(function (object) {
			if (!object.transformData) return true;
			if (!transformer.checkCompatibility(object, object)) return true;
			result.objects.push(object.transformData(object.encode(), transformer));return true; }, this);
		
		if (Array.isArray(transformer.currentObjects)) transformer.currentObjects.every(function (objectInfo) {
			result.objects.unshift(objectInfo);return true; }, this);
		

		if (Array.isArray(this.fileReferences)) this.fileReferences.every(function (fileReference) {
			result.fileReferences.push(fileReference.encode());return true; }, this);
		
		
		result.tabBarController = this.tabBarController.transformData(this.tabBarController.encode(), transformer);
		
		result.bindingsInfo = {};
		if (Array.isArray(this.objects)) this.objects.every(function (obj) {
			collectBindingsForObject(obj, result.bindingsInfo, this);return true; }, this);
		
		

		return result;};
	
	
Project.prototype.bindingIsValid = function Project_bindingIsValid(binding) {
		return true;};
	

Project.prototype.applyValueTransformerFromBindingToValue = function Project_applyValueTransformerFromBindingToValue(binding, _value) {
		_value = __super.prototype.applyValueTransformerFromBindingToValue.call(this, binding, _value);
		if (binding.valueTransformerIsBooleanInverter === true) {
			_value = !_value;
		}
		if (binding.valueTransformerIsBooleanInverter === true) {
			_value = !_value;
		}
		return _value;};
	
	
	Object.defineProperty(Project.prototype, "navigationBarFont", {
	outlet: true, 
	enumerable: true, get:function () { return this._navigationBarFont; }, set:function (v) {if (!Object.hasOwnProperty(this, "_navigationBarFont")) Object.defineProperty(this, "_navigationBarFont", { writable: true, configurable: true }); this._navigationBarFont = v; }});
	
	
	Object.defineProperty(Project.prototype, "navigationBarLabelColor", {
	outlet: true, 
	enumerable: true, get:function () { return this._navigationBarLabelColor; }, set:function (v) {if (!Object.hasOwnProperty(this, "_navigationBarLabelColor")) Object.defineProperty(this, "_navigationBarLabelColor", { writable: true, configurable: true }); this._navigationBarLabelColor = v; }});
	

	Object.defineProperty(Project.prototype, "usesCustomNavigationBarFont", {
	outlet: true, 
	enumerable: true, get:function () { return this._usesCustomNavigationBarFont; }, set:function (v) {if (!Object.hasOwnProperty(this, "_usesCustomNavigationBarFont")) Object.defineProperty(this, "_usesCustomNavigationBarFont", { writable: true, configurable: true }); this._usesCustomNavigationBarFont = v; }});
	

	Object.defineProperty(Project.prototype, "barButtonItemFont", {
	outlet: true, 
	enumerable: true, get:function () { return this._barButtonItemFont; }, set:function (v) {if (!Object.hasOwnProperty(this, "_barButtonItemFont")) Object.defineProperty(this, "_barButtonItemFont", { writable: true, configurable: true }); this._barButtonItemFont = v; }});
	

	Object.defineProperty(Project.prototype, "usesCustomBarButtonItemFont", {
	outlet: true, 
	enumerable: true, get:function () { return this._usesCustomBarButtonItemFont; }, set:function (v) {if (!Object.hasOwnProperty(this, "_usesCustomBarButtonItemFont")) Object.defineProperty(this, "_usesCustomBarButtonItemFont", { writable: true, configurable: true }); this._usesCustomBarButtonItemFont = v; }});
	

	Object.defineProperty(Project.prototype, "tabBarItemFont", {
	outlet: true, 
	enumerable: true, get:function () { return this._tabBarItemFont; }, set:function (v) {if (!Object.hasOwnProperty(this, "_tabBarItemFont")) Object.defineProperty(this, "_tabBarItemFont", { writable: true, configurable: true }); this._tabBarItemFont = v; }});
	

	Object.defineProperty(Project.prototype, "usesCustomTabBarItemFont", {
	outlet: true, 
	enumerable: true, get:function () { return this._usesCustomTabBarItemFont; }, set:function (v) {if (!Object.hasOwnProperty(this, "_usesCustomTabBarItemFont")) Object.defineProperty(this, "_usesCustomTabBarItemFont", { writable: true, configurable: true }); this._usesCustomTabBarItemFont = v; }});
	

Project.prototype.initPropertiesFromData = function Project_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("metadata")) this.metadata = data.metadata;
if (data.hasOwnProperty("objects")) this.objects = data.objects;
if (data.hasOwnProperty("fileReferences")) this.fileReferences = data.fileReferences;
if (data.hasOwnProperty("tabBarController")) this.tabBarController = data.tabBarController;
if (data.hasOwnProperty("scenes")) this.scenes = data.scenes;
if (data.hasOwnProperty("navigationBarFont")) this.navigationBarFont = data.navigationBarFont;
if (data.hasOwnProperty("navigationBarLabelColor")) this.navigationBarLabelColor = data.navigationBarLabelColor;
if (data.hasOwnProperty("usesCustomNavigationBarFont")) this.usesCustomNavigationBarFont = data.usesCustomNavigationBarFont;
if (data.hasOwnProperty("barButtonItemFont")) this.barButtonItemFont = data.barButtonItemFont;
if (data.hasOwnProperty("usesCustomBarButtonItemFont")) this.usesCustomBarButtonItemFont = data.usesCustomBarButtonItemFont;
if (data.hasOwnProperty("tabBarItemFont")) this.tabBarItemFont = data.tabBarItemFont;
if (data.hasOwnProperty("usesCustomTabBarItemFont")) this.usesCustomTabBarItemFont = data.usesCustomTabBarItemFont;
};

Project.prototype.decodeData = function Project_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
if (data.hasOwnProperty("objects")) decoded.objects = []; if (Array.isArray(data.objects)) { data.objects.forEach(function (o) { decoded.objects.push(this.context.decodeObjectTree(o)); }.bind(this)); }
if (data.hasOwnProperty("fileReferences")) decoded.fileReferences = []; if (Array.isArray(data.fileReferences)) { data.fileReferences.forEach(function (o) { decoded.fileReferences.push(this.context.decodeObjectTree(o)); }.bind(this)); }
if (data.hasOwnProperty("tabBarController")) decoded.tabBarController = this.context.decodeObjectTree(data.tabBarController);
if (data.hasOwnProperty("scenes")) decoded.scenes = []; if (Array.isArray(data.scenes)) { data.scenes.forEach(function (o) { decoded.scenes.push(this.context.decodeObjectTree(o)); }.bind(this)); }
if (data.hasOwnProperty("navigationBarFont")) decoded.navigationBarFont = this.context.decodeObjectTree(data.navigationBarFont);
if (data.hasOwnProperty("barButtonItemFont")) decoded.barButtonItemFont = this.context.decodeObjectTree(data.barButtonItemFont);
if (data.hasOwnProperty("tabBarItemFont")) decoded.tabBarItemFont = this.context.decodeObjectTree(data.tabBarItemFont);
return decoded; };

Project.prototype.encode = function Project_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
if (this._objects && this._objects.encode) {encoded.objects = []; this._objects.forEach(function (o) { encoded.objects.push(o.encode()); });
}if (this._fileReferences && this._fileReferences.encode) {encoded.fileReferences = []; this._fileReferences.forEach(function (o) { encoded.fileReferences.push(o.encode()); });
}if (this._tabBarController && this._tabBarController.encode) {encoded.tabBarController = this.tabBarController.encode();
}if (this._scenes && this._scenes.encode) {encoded.scenes = []; this._scenes.forEach(function (o) { encoded.scenes.push(o.encode()); });
}if (this._navigationBarFont && this._navigationBarFont.encode) {encoded.navigationBarFont = this.navigationBarFont.encode();
}if (this._barButtonItemFont && this._barButtonItemFont.encode) {encoded.barButtonItemFont = this.barButtonItemFont.encode();
}if (this._tabBarItemFont && this._tabBarItemFont.encode) {encoded.tabBarItemFont = this.tabBarItemFont.encode();
}return encoded; };

Project.prototype.encodeCloned = function Project_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
if (this._objects && this._objects.encode) {encoded.objects = []; this._objects.forEach(function (o) { encoded.objects.push(o.encodeCloned()); });
}if (this._fileReferences && this._fileReferences.encode) {encoded.fileReferences = []; this._fileReferences.forEach(function (o) { encoded.fileReferences.push(o.encodeCloned()); });
}if (this._tabBarController && this._tabBarController.encode) {encoded.tabBarController = this.tabBarController.encodeCloned();
}if (this._scenes && this._scenes.encode) {encoded.scenes = []; this._scenes.forEach(function (o) { encoded.scenes.push(o.encodeCloned()); });
}if (this._navigationBarFont && this._navigationBarFont.encode) {encoded.navigationBarFont = this.navigationBarFont.encodeCloned();
}if (this._barButtonItemFont && this._barButtonItemFont.encode) {encoded.barButtonItemFont = this.barButtonItemFont.encodeCloned();
}if (this._tabBarItemFont && this._tabBarItemFont.encode) {encoded.tabBarItemFont = this.tabBarItemFont.encodeCloned();
}return encoded; };

Project.prototype.expectedTypeForProperty = function Project_expectedTypeForProperty(key) {
	if (key === "metadata") return "Object";
	if (key === "objects") return "BasicObject[]";
	if (key === "fileReferences") return "BasicObject[]";
	if (key === "tabBarController") return "UITabBarController";
	if (key === "scenes") return "Scene[]";
	if (key === "navigationBarFont") return "UIFont";
	if (key === "navigationBarLabelColor") return "String";
	if (key === "usesCustomNavigationBarFont") return "Boolean";
	if (key === "barButtonItemFont") return "UIFont";
	if (key === "usesCustomBarButtonItemFont") return "Boolean";
	if (key === "tabBarItemFont") return "UIFont";
	if (key === "usesCustomTabBarItemFont") return "Boolean";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return Project; }()));
registerType('appdoo', (function () { function appdooPreviewTransformer() {} var __super = null;

	Object.defineProperty(appdooPreviewTransformer.prototype, "isPreviewTransformer", {
		value: true});
	

appdooPreviewTransformer.prototype.initFromData = function appdooPreviewTransformer_initFromData(data) {
		this.specialBindingsObject = { bindings:[] };
		this.uidLookupTable = {};
		this.deviceInfo = data.deviceInfo;
		return this;};
	

appdooPreviewTransformer.prototype.createObject = function appdooPreviewTransformer_createObject(data) {
		var result = {
			$type: data.$type,
			$domain: data.$domain,
			$id: data.$id,
			$extra: {  },
			$categories: [],
			$connections: [],
			$initialMethodCalls: [],
			$propertyPriorities: {}
		};
		return result;};
	
	
appdooPreviewTransformer.prototype.demandPlugin = function appdooPreviewTransformer_demandPlugin(uti) {};
	
	
	Object.defineProperty(appdooPreviewTransformer.prototype, "previewAppVersion", {
		get: function () {
			return this.deviceInfo.ServerVersion*1;
		}});
	

appdooPreviewTransformer.prototype.transformCSSColor = function appdooPreviewTransformer_transformCSSColor(cssColor) {
		if (!cssColor || typeof cssColor !== 'string') return undefined;
		
		var colorInfo = _context.colorInfoFromCSSColor(cssColor);
		if (colorInfo.colorSpace === 'calibratedRGB') {
			return {
				$type: 'UIColor',
				$domain: 'com.apple',
				$constructor: {
					name: 'colorWithRed:green:blue:alpha:',
					arguments: [ colorInfo.red, colorInfo.green, colorInfo.blue, colorInfo.alpha ]
				}
			};
		}
		};
	

appdooPreviewTransformer.prototype.transformFont = function appdooPreviewTransformer_transformFont(fontOrFontName, fontSize, fontFamily) {

		var fontName;
		if (typeof fontOrFontName === 'object') {
			fontName = fontOrFontName.fontName;
			fontSize = fontOrFontName.pointSize;
			fontFamily = fontOrFontName.fontFamily;
		}
		else fontName = fontOrFontName;

		var font = {
			$type: 'UIFont',
			$domain: 'com.apple',
		};
		
		if (fontName === '_DEFAULT_') {
			font.$constructor = {
				name: 'systemFontOfSize:',
				arguments: [ fontSize ]
			};
		}
		else if (fontName === '_DEFAULT_BOLD_') {
			font.$constructor = {
				name: 'boldSystemFontOfSize:',
				arguments: [ fontSize ]
			};
		}
		else if (fontName === '_DEFAULT_ITALIC_') {
			font.$constructor = {
				name: 'italicSystemFontOfSize:',
				arguments: [ fontSize ]
			};
		}
		else {
			font.$constructor = {
				name: 'fontWithName:size:',
				arguments: [ fontName, fontSize ]
			};
		}
		
		return font;	};
	

appdooPreviewTransformer.prototype.transformCGSize = function appdooPreviewTransformer_transformCGSize(width, height) {
		return {
			$type: 'CGSize',
			$domain: 'com.apple',
			width: Math.max(width||0,0),
			height: Math.max(height||0,0)
		};
};
	
	
appdooPreviewTransformer.prototype.transformCGRect = function appdooPreviewTransformer_transformCGRect(x, y, width, height) {
		return {
			$type: 'CGRect',
			$domain: 'com.apple',
			origin: { x: x||0, y: y||0 },
			size: { width: Math.max(width||0,0), height: Math.max(height||0,1) }
		};};
	

	var UITextAlignmentLeft = 0,
		UITextAlignmentCenter = 1,
		UITextAlignmentRight = 2,
		UITextAlignmentJustify = 3;

appdooPreviewTransformer.prototype.transformTextAlignment = function appdooPreviewTransformer_transformTextAlignment(textAlignment) {

		switch (textAlignment) {
			case 'left':
				return UITextAlignmentLeft;
				break;
			case 'center':
				return UITextAlignmentCenter;
				break;
			case 'right':
				return UITextAlignmentRight;
				break;
			case 'justify':
				return UITextAlignmentJustify;
				break;
		}
		
		return UITextAlignmentLeft;};
	
	
	var UIControlContentHorizontalAlignmentCenter = 0,
		UIControlContentHorizontalAlignmentLeft = 1,
		UIControlContentHorizontalAlignmentRight = 2,
		UIControlContentHorizontalAlignmentFill = 3;
		
	
appdooPreviewTransformer.prototype.transformContentHorizontalAlignment = function appdooPreviewTransformer_transformContentHorizontalAlignment(alignment) {

		switch (alignment) {
			case 'left':
				return UIControlContentHorizontalAlignmentLeft;
				break;
			case 'center':
				return UIControlContentHorizontalAlignmentCenter;
				break;
			case 'right':
				return UIControlContentHorizontalAlignmentRight;
				break;
			case 'fill':
				return UIControlContentHorizontalAlignmentFill;
				break;
		}
		
		return UIControlContentHorizontalAlignmentCenter;
	};
	
	
appdooPreviewTransformer.prototype.transformString = function appdooPreviewTransformer_transformString(value) {
		if (typeof value === 'string') return value;
		return '';};
	
	
appdooPreviewTransformer.prototype.transformInteger = function appdooPreviewTransformer_transformInteger(value) {
		if (typeof value === 'number') return value|0;
		return 0;};
	

appdooPreviewTransformer.prototype.transformFloat = function appdooPreviewTransformer_transformFloat(value) {
		if (typeof value === 'number') return value;
		return parseFloatLocal(value);};
	
	
appdooPreviewTransformer.prototype.transformBoolean = function appdooPreviewTransformer_transformBoolean(value) {
		return value ? true : false;};
	
	
appdooPreviewTransformer.prototype.transformLocalFileToURL = function appdooPreviewTransformer_transformLocalFileToURL(name, id) {
		return 'file:'+name;};
	
	
appdooPreviewTransformer.prototype.transformReferencedImage = function appdooPreviewTransformer_transformReferencedImage(imageRef) {
		if (!imageRef || !imageRef.imageID) return;
		var img = {
			$type: 'UIImage',
			$domain: 'com.apple',
			$constructor: { name: 'imageWithResourceID:', arguments: [imageRef.imageID] }
		};
		
		return img;};
	
	
appdooPreviewTransformer.prototype.transformImageURL = function appdooPreviewTransformer_transformImageURL(info) {
		return _context.transformImageURL(info);};
	

appdooPreviewTransformer.prototype.transformFileReference = function appdooPreviewTransformer_transformFileReference(idString) {
		return _context.transformFileReference(idString);};
	
	
appdooPreviewTransformer.prototype.transformEdgeInsets = function appdooPreviewTransformer_transformEdgeInsets(top, left, bottom, right) {
		return {
			$type: 'UIEdgeInsets',
			$domain: 'com.apple',
			top: top,
			left: left,
			bottom: bottom,
			right: right
		};};
	

	var tagForCID = {};
appdooPreviewTransformer.prototype.tagForViewWithCID = function appdooPreviewTransformer_tagForViewWithCID(cid) {
		if (!tagForCID[cid])
		tagForCID[cid] = (nextViewTagForAppdooPreview++);
		return tagForCID[cid];};
	
	
	var UIModalTransitionStyleCoverVertical = 0,
		UIModalTransitionStyleFlipHorizontal = 1,
		UIModalTransitionStyleCrossDissolve = 2,
		UIModalTransitionStylePartialCurl = 3;
	
	var modalTransitionStyleByString = { 'UIModalTransitionStyleCoverVertical': UIModalTransitionStyleCoverVertical, 'UIModalTransitionStyleFlipHorizontal': UIModalTransitionStyleFlipHorizontal, 'UIModalTransitionStyleCrossDissolve': UIModalTransitionStyleCrossDissolve };
	
appdooPreviewTransformer.prototype.transformModalTransitionStyle = function appdooPreviewTransformer_transformModalTransitionStyle(str) {
		var r = modalTransitionStyleByString[str];
		if (isNaN(r)) return -1;
		return r;};
	
	
appdooPreviewTransformer.prototype.transformActionInfo = function appdooPreviewTransformer_transformActionInfo(actionInfo, t) {
		if (!actionInfo) return { type: t };
		var actionType = actionInfo.actionType;
		actionInfo = clone(actionInfo);
		actionInfo.type = actionType;

		if (actionInfo.modalTransitionStyle) {
			actionInfo.modalTransitionStyle = this.transformModalTransitionStyle(actionInfo.modalTransitionStyle);
		}

		return actionInfo;};
	
	
appdooPreviewTransformer.prototype.generateActionObject = function appdooPreviewTransformer_generateActionObject(actionTypeDeprecated, actionInfo) {
		if (!actionInfo) return {};
		actionType = actionInfo.actionType;
		
		var result = {
			$type: 'ActionObject',
    		$domain: 'info.appdoo-mac',
    		$id: _context.createUID('ActionObject', this.uidLookupTable),
    		$needsContextReference: true,
    		$needsViewControllerReference: true,
    		$needsReferenceInSceneObjects: true
    	};

    	result.actionInfo = this.transformActionInfo(actionInfo, actionType);
    	
    	this.currentObjects.push(result);
    	return { $type: '$Reference', destination: result.$id };
		};
	
	
appdooPreviewTransformer.prototype.transformObjectArray = function appdooPreviewTransformer_transformObjectArray(array) {
	
		var result = {
			$type: 'NSArray',
			$domain: 'com.apple',
			$categories: ['NSArray+EncodedObjectArray'],
			$constructor: {
				name: 'arrayWithEncodedObjectArray:context:',
				arguments: [[],{ $type: '$Context' }]
			},
		};
		
		if (Array.isArray(array)) array.every(function (info) {
			result.$constructor.arguments[0].push(info);return true; }, this);
		
		
		return result;
};
	
	
appdooPreviewTransformer.prototype.addConnection = function appdooPreviewTransformer_addConnection(connection) {
	
		this.currentViewController.$connections.push(connection);
		};
	
	
appdooPreviewTransformer.prototype.registerSpecialBinding = function appdooPreviewTransformer_registerSpecialBinding(binding) {
		this.specialBindingsObject.bindings.push(binding);};
	


	var UIControlEventTouchDown		   = 1 <<  0,
		UIControlEventTouchDownRepeat		= 1 <<	1,
		UIControlEventTouchDragInside		= 1 <<	2,
		UIControlEventTouchDragOutside	= 1 <<	3,
		UIControlEventTouchDragEnter		= 1 <<	4,
		UIControlEventTouchDragExit		= 1 <<	5,
		UIControlEventTouchUpInside		= 1 <<	6,
		UIControlEventTouchUpOutside		= 1 <<	7,
		UIControlEventTouchCancel			= 1 <<	8,
		UIControlEventValueChanged		= 1 << 12,
		UIControlEventEditingDidBegin		= 1 << 16,
		UIControlEventEditingChanged		= 1 << 17,
		UIControlEventEditingDidEnd		= 1 << 18,
		UIControlEventEditingDidEndOnExit = 1 << 19,
		UIControlEventAllTouchEvents		= 0x00000FFF,
		UIControlEventAllEditingEvents	= 0x000F0000,
		UIControlEventApplicationReserved = 0x0F000000,
		UIControlEventSystemReserved		= 0xF0000000,
		UIControlEventAllEvents			= 0xFFFFFFFF;

appdooPreviewTransformer.prototype.addActionFromDataToResult = function appdooPreviewTransformer_addActionFromDataToResult(data, result) {
		if (!data.actionInfo) return;
		
		var actionType = data.actionInfo.actionType;

		if (actionType) {
		
			if (actionType === 'objectAction' && (data.actionInfo && (data.actionInfo.objectActionID === 'seekBackward' || data.actionInfo.objectActionID === 'seekForward'))) {
			
				var actionInfo1 = clone(data.actionInfo); actionInfo1.objectActionID = (data.actionInfo.objectActionID === 'seekForward') ? 'beginSeekingForward' : 'beginSeekingBackward';
				var actionInfo2 = clone(data.actionInfo); actionInfo2.objectActionID = 'endSeeking';
			
				result.$initialMethodCalls.push({
					name: 'addTarget:action:forControlEvents:',
					arguments: [
						this.generateActionObject('objectAction', actionInfo1),
						{ $type: 'SEL', name: 'action:' },
						UIControlEventTouchDown
					]
				});
				result.$initialMethodCalls.push({
					name: 'addTarget:action:forControlEvents:',
					arguments: [
						this.generateActionObject('objectAction', actionInfo2),
						{ $type: 'SEL', name: 'action:' },
						UIControlEventTouchUpInside | UIControlEventTouchUpOutside
					]
				});
			}
			else {
				result.$initialMethodCalls.push({
					name: 'addTarget:action:forControlEvents:',
					arguments: [
						this.generateActionObject(actionType, data.actionInfo),
						{ $type: 'SEL', name: 'action:' },
						UIControlEventTouchUpInside
					]
				});
			}
		}};
	
	
appdooPreviewTransformer.prototype.transformChange = function appdooPreviewTransformer_transformChange(change) {

		var result = { $type: 'Change' };
		
		if(_context.editor.editedScene !== undefined) {
			result.sceneID = _context.editor.editedScene.$id;
		} else if(change.object !== undefined) {
			result.sceneID = change.object.$id;
		}
		if (!change.object) {
			if (!change.controllerId) return;
			
			var controller = _context.controllerForPersistantID(change.controllerId);
			if (!controller || !controller.contents) return;
			
			var object = controller.contents;
		}
		else {
			var object = change.object;
		}
		result.objectID = object.$id;
		
		if (!object || !object.transformChangeForAppdooPreview) return;
		
		if (!object.transformChangeForAppdooPreview(change, this, result)) {
			return;
		}
		
		return result;
	};
	
	
appdooPreviewTransformer.prototype.setStringProperty = function appdooPreviewTransformer_setStringProperty(result, key, value) {
		result[key] = this.transformString(value);};
	

appdooPreviewTransformer.prototype.setFloatProperty = function appdooPreviewTransformer_setFloatProperty(result, key, value) {
		result[key] = this.transformFloat(value);};
	

appdooPreviewTransformer.prototype.setIntegerProperty = function appdooPreviewTransformer_setIntegerProperty(result, key, value) {
		result[key] = this.transformInteger(value);};
	

appdooPreviewTransformer.prototype.setBooleanProperty = function appdooPreviewTransformer_setBooleanProperty(result, key, value) {
		result[key] = this.transformBoolean(value);};
	

appdooPreviewTransformer.prototype.setColorProperty = function appdooPreviewTransformer_setColorProperty(result, key, value) {
		result[key] = this.transformCSSColor(value);};
	
	
appdooPreviewTransformer.prototype.setReferenceProperty = function appdooPreviewTransformer_setReferenceProperty(result, key, sourceCID, destinationCID) {
		this.addConnection({
			source: sourceCID,
			destination: destinationCID,
			type: 'outlet',
			key: key
		});};
	

appdooPreviewTransformer.prototype.setFontProperty = function appdooPreviewTransformer_setFontProperty(result, fontName, fontSize, fontFamily) {
		var key = 'font';
		result[key] = this.transformFont(fontName, fontSize, fontFamily);};
	
	
appdooPreviewTransformer.prototype.setType = function appdooPreviewTransformer_setType(result, typeName) {
		result.$type = typeName;};
	

appdooPreviewTransformer.prototype.registerInverseBinding = function appdooPreviewTransformer_registerInverseBinding(result, data, key, destinationKeyPathPrefix, dataProviderID, dataProvider) {
		return _context.registerInverseBindingForTransformer(this, result, data, key, destinationKeyPathPrefix, dataProviderID, dataProvider);};
	

appdooPreviewTransformer.prototype.addDataProviderToObject = function appdooPreviewTransformer_addDataProviderToObject(result, data) {
		if (!data.dataProvider) return;
		if (data.dataProvider.UTI)
			result.dataProvider = data.dataProvider.transformData(data.dataProvider.encode(), this);
		else
			result.dataProvider = getPrototype(utiFromData(data.dataProvider)).transformData(data.dataProvider, this);

		result.$propertyPriorities['dataProvider'] = -1;
		
		this.setReferenceProperty(data, 'dataProvider', data.$id, data.dataProvider.$id);};
	

appdooPreviewTransformer.prototype.forEachSubview = function appdooPreviewTransformer_forEachSubview(result, callback) {
		if (result.$extra)
		if (Array.isArray(result.$extra.subviews)) result.$extra.subviews.every(function (subview) {
			callback(subview);return true; }, this);
		};
	

appdooPreviewTransformer.prototype.getInputDataSourceForCurrentScene = function appdooPreviewTransformer_getInputDataSourceForCurrentScene() {
		var result;
		if (Array.isArray(this.currentObjects)) this.currentObjects.every(function (obj) {
			if (utiFromData(obj) === 'appdoo.SceneInputDataSource') {
				result = obj;
				return false;
			}return true; }, this);
		
		return result;};
	
	
	function readableNameForPreviewBuildVersion(v) {
		if (v === 6) return '1.0.1';
		if (v === 7) return '1.0.2';
		if (v === 8) return '1.0.3';
		if (v === 9) return '1.0.3';
		if (v === 10) return '1.0.4';
		if (v === 11) return '1.0.4';
		if (v === 12) return '1.0.5';
		return '(Build '+v+')';
	}
	
	var didShowCompatibilityWarning;
appdooPreviewTransformer.prototype.checkCompatibility = function appdooPreviewTransformer_checkCompatibility(proto, data) {
		var v = Infinity;
		if (proto.dataRequiresPreviewBuildVersion) v = proto.dataRequiresPreviewBuildVersion(data);
		else if (proto.requiresPreviewBuildVersion) v = proto.requiresPreviewBuildVersion;
		else return true;
		
		var isCompatible = v <= this.deviceInfo.ServerVersion*1;

		if (!isCompatible && v !== Infinity) {
			if (!didShowCompatibilityWarning) {
				var name = proto.readableTypeForData ? proto.readableTypeForData(data) : proto.readableType;
				var icon = this.context.nativeProxy.sendMessage('bundlePath')+'/Resources/PreviewAppPhone.png';
				
				this.context.nativeProxy.sendMessage('confirmWithOptions', JSON.stringify({
					message: LocalizedString2("The component „%1“ requires a newer version of the Preview app.", name),
					details: LocalizedString3("You are using version %1, %2 requires version %3. Please update to the latest version.", readableNameForPreviewBuildVersion(this.deviceInfo.ServerVersion*1), name, readableNameForPreviewBuildVersion(v)),
					button1: 'OK',
					icon: icon
				}));
				didShowCompatibilityWarning = true;
			}
		}

		return isCompatible;};
	
	
appdooPreviewTransformer.prototype.registerAppDelegateCode = function appdooPreviewTransformer_registerAppDelegateCode(signature, code) {};
	
	
appdooPreviewTransformer.prototype.registerObjectProxy = function appdooPreviewTransformer_registerObjectProxy(data) {

		var result = this.createObject(data);
		result.$type = 'ObjectProxy';
		result.$domain = 'info.appdoo-mac.Preview';
		result.$needsContextReference = true;
		return result;
	};
	

appdooPreviewTransformer.prototype.expectedTypeForProperty = function appdooPreviewTransformer_expectedTypeForProperty(key) {
	if (key === "isPreviewTransformer") return "";
	if (key === "previewAppVersion") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return appdooPreviewTransformer; }()));
registerType('appdoo', (function () { function ProjectContext() {} var __super = setSupertypeFromDomain(ProjectContext, 'ApplicationContext', 'Core');

	Object.defineProperty(ProjectContext.prototype, "shouldIncludeAppdooPreviewData", {
		get: function () {
			return false;
			return window._context && _context.isDebugging;
		}});
	

	Object.defineProperty(ProjectContext.prototype, "nativeProxy", {
	outlet: true, get:function () { return this._nativeProxy; }, set:function (v) {if (!Object.hasOwnProperty(this, "_nativeProxy")) Object.defineProperty(this, "_nativeProxy", { writable: true, configurable: true }); this._nativeProxy = v; }});
	

	Object.defineProperty(ProjectContext.prototype, "undoManager", {
	outlet: true, get:function () { return this._undoManager; }, set:function (v) {if (!Object.hasOwnProperty(this, "_undoManager")) Object.defineProperty(this, "_undoManager", { writable: true, configurable: true }); this._undoManager = v; }});
	

	Object.defineProperty(ProjectContext.prototype, "isOffscreen", {
	outlet: true, get:function () { return this._isOffscreen; }, set:function (v) {if (!Object.hasOwnProperty(this, "_isOffscreen")) Object.defineProperty(this, "_isOffscreen", { writable: true, configurable: true }); this._isOffscreen = v; }});
	

	Object.defineProperty(ProjectContext.prototype, "highResolutionEnabled", {
	outlet: true, get:function () { return this._highResolutionEnabled; }, set:function (v) {if (!Object.hasOwnProperty(this, "_highResolutionEnabled")) Object.defineProperty(this, "_highResolutionEnabled", { writable: true, configurable: true }); this._highResolutionEnabled = v; }});
	
	
	Object.defineProperty(ProjectContext.prototype, "projectDataDirectory", {
	outlet: true, get:function () { return this._projectDataDirectory; }, set:function (v) {if (!Object.hasOwnProperty(this, "_projectDataDirectory")) Object.defineProperty(this, "_projectDataDirectory", { writable: true, configurable: true }); this._projectDataDirectory = v; }});
	

	Object.defineProperty(ProjectContext.prototype, "temporaryDataDirectory", {
	outlet: true, get:function () { return this._temporaryDataDirectory; }, set:function (v) {if (!Object.hasOwnProperty(this, "_temporaryDataDirectory")) Object.defineProperty(this, "_temporaryDataDirectory", { writable: true, configurable: true }); this._temporaryDataDirectory = v; }});
	
	
	Object.defineProperty(ProjectContext.prototype, "usesNavigationOutlineNode", {
		value: true});
	

	Object.defineProperty(ProjectContext.prototype, "temporaryImagesDirectory", {
		get: function () {
			return this.temporaryDataDirectory + '/Images';
		}});
	

	Object.defineProperty(ProjectContext.prototype, "projectImagesDirectory", {
		get: function () {
			return this.projectDataDirectory + '/Images';
		}});
	

	Object.defineProperty(ProjectContext.prototype, "project", {
	synthesized: true, get:function () { return this._project; }, set:function (v) {if (!Object.hasOwnProperty(this, "_project")) Object.defineProperty(this, "_project", { writable: true, configurable: true }); this._project = v; }});
	

	Object.defineProperty(ProjectContext.prototype, "tabBarController", {
		get: function () { return this.project.tabBarController; }});
	

	Object.defineProperty(ProjectContext.prototype, "metadata", {
		get: function () { return this.project ? this.project.metadata : {}; }});
	

	Object.defineProperty(ProjectContext.prototype, "objects", {
		get: function () { return this.project ? this.project.objects : []; }});
	

	Object.defineProperty(ProjectContext.prototype, "scenes", {
		get: function () { return this.project ? this.project.scenes : []; }});
	

	Object.defineProperty(ProjectContext.prototype, "fileReferences", {
		get: function () {
			if (this.project && !this.project.fileReferences) this.project.fileReferences = [];
			return this.project ? this.project.fileReferences : [];
		}});
	

ProjectContext.prototype.init = function ProjectContext_init() {
		var self = __super.prototype.init.call(this);
		if (self) { self.cleanUpRegistrations(); }
		return self;};
	

ProjectContext.prototype.applicationContextIsReady = function ProjectContext__applicationContextIsReady() {
		};
	
	
	
ProjectContext.prototype.loadProjectData = function ProjectContext__loadProjectData(projectData) {
	
		this.simulatedSystemVersion = projectData.metadata.simulatedSystemVersion;
		getType('appdoo.iOS.UINavigationBar').prototype.setGlobalSettingsWithContext(projectData.metadata.navigationBarGlobals || {}, this);
	
		
		cachedProjectData = projectData;
	
		this.project = this.decodeObjectTree(projectData);

		
		if (!this.metadata.title) {
			this.metadata.title = LocalizedString('Untitled');
			var i = 1;
			if (Array.isArray(this.scenes)) this.scenes.every(function (scene) {
				var sceneTitle = LocalizedString('Screen')+' '+i;
				scene.viewController.title = sceneTitle;
				scene.viewController.tabBarItem.title = sceneTitle;
				scene.navigationBar.title = sceneTitle;
				i++;return true; }, this);
			
			this.metadata.defaultLanguage = window.language;
			this.metadata.projectID = this.nativeProxy.sendMessage('generateClientUID');
			
			this.isEditingNewProject = true;
			
		}
		
		else if (this.metadata.title === LocalizedString('Untitled')) {

			var pn = this.nativeProxy.sendMessage('getProjectName');
			if (pn) this.metadata.title = pn;
			
		}
		
		
		this.nativeProxy.sendMessage('setProjectName', this.metadata.title);
};
	
	
	var cachedProjectData; 

ProjectContext.prototype.collectProjectData = function ProjectContext_collectProjectData(forCapturing) {
	
		if (forCapturing === true && cachedProjectData !== undefined) return cachedProjectData;

		var data = this.projectData;

		if (this.shouldIncludeAppdooPreviewData) {
			data.appdooPreviewData = this.project.encodeForAppdooPreview();
		}

		cachedProjectData = data;
		return data;
};
	
	
	Object.defineProperty(ProjectContext.prototype, "projectData", {
		get: function () {
			return this.project.encode();;
		}});
	


	

	Object.defineProperty(ProjectContext.prototype, "changedRegistrationStates", {
	writable: true});
	

	Object.defineProperty(ProjectContext.prototype, "changedMediaItems", {
	writable: true});
	
	
ProjectContext.prototype.itemIsRegistered = function ProjectContext_itemIsRegistered(itemType, id) {
		return this.changedRegistrationStates[itemType]
			&& this.changedRegistrationStates[itemType][id] === 1;};
	

ProjectContext.prototype.itemIsDeregistered = function ProjectContext_itemIsDeregistered(itemType, id) {
		return this.changedRegistrationStates[itemType]
			&& this.changedRegistrationStates[itemType][id] === -1;};
	

ProjectContext.prototype.registerItem = function ProjectContext_registerItem(itemType, id) {
		this.changeItemRegistrationState(itemType, id, 1);};
	

ProjectContext.prototype.deregisterItem = function ProjectContext_deregisterItem(itemType, id) {
		this.changeItemRegistrationState(itemType, id, -1);};
	
	

	

	
ProjectContext.prototype.registerResourceWithID = function ProjectContext_registerResourceWithID(ID) {
		this.registerItem('resource', ID);};
	

ProjectContext.prototype.unregisterResourceWithID = function ProjectContext_unregisterResourceWithID(ID, ignoreFileReferences) {
		if (!ignoreFileReferences && this.fileReferenceWithResourceID(ID)) return;
		this.deregisterItem('resource', ID);};
	

ProjectContext.prototype.registerImageWithID = function ProjectContext_registerImageWithID(ID) {
		this.registerItem('image', ID);};
	
	
ProjectContext.prototype.unregisterImageWithID = function ProjectContext_unregisterImageWithID(ID) {
		this.unregisterResourceWithID(ID);};
	

ProjectContext.prototype.registerDatabaseWithID = function ProjectContext_registerDatabaseWithID(ID) {
		this.registerItem('database', ID);};
	

ProjectContext.prototype.unregisterDatabaseWithID = function ProjectContext_unregisterDatabaseWithID(ID) {
		this.deregisterItem('database', ID);};
	

ProjectContext.prototype.registerViewControllerWithID = function ProjectContext_registerViewControllerWithID(ID) {
		this.registerItem('viewController', ID);};
	

ProjectContext.prototype.unregisterViewControllerWithID = function ProjectContext_unregisterViewControllerWithID(ID) {
		this.deregisterItem('viewController', ID);};
	

ProjectContext.prototype.registerMediaItem = function ProjectContext_registerMediaItem(item) {
		this.registerItem('mediaItem', item.$id);
		this.changedMediaItems[item.$id] = item;};
	

ProjectContext.prototype.unregisterMediaItem = function ProjectContext_unregisterMediaItem(item) {
		this.deregisterItem('mediaItem', item.$id);
		this.changedMediaItems[item.$id] = item;};
	

ProjectContext.prototype.changeItemRegistrationState = function ProjectContext__changeItemRegistrationState(itemType, id, state) {
		
		if (!this.changedRegistrationStates[itemType])
			this.changedRegistrationStates[itemType] = {};
		
		this.changedRegistrationStates[itemType][id] = state;
};
	
	
ProjectContext.prototype.cleanUpRegistrations = function ProjectContext__cleanUpRegistrations() {
		this.changedRegistrationStates = {};
		this.changedMediaItems = {};};
	
	
ProjectContext.prototype.performCallbackOnResourceIDsInScene = function ProjectContext__performCallbackOnResourceIDsInScene(scene, callback) {
		updateSubviewsWithCallback(scene.viewController.viewData, function (view) {
			
			if (view.imageRef) {
				callback(view.imageRef.imageID);
			}
		}.bind(this));
		if (scene.navigationBar) {
			if (scene.navigationBar.v_backgroundImage)	callback(scene.navigationBar.v_backgroundImage.imageID);
			if (scene.navigationBar.v_titleViewImage)	callback(scene.navigationBar.v_titleViewImage.imageID);
		}
		if (scene.viewController.tabBarItem) {
			if (scene.viewController.tabBarItem.image)	callback(scene.viewController.tabBarItem.image.imageID);
			if (scene.viewController.tabBarItem.unselectedImage)	callback(scene.viewController.tabBarItem.unselectedImage.imageID);
		}};
	
	
ProjectContext.prototype.unregisterReferencesInScene = function ProjectContext_unregisterReferencesInScene(scene) {
		this.performCallbackOnResourceIDsInScene(scene, function (resourceID) {
			this.unregisterResourceWithID(resourceID);
		}.bind(this));};
	

ProjectContext.prototype.registerReferencesInScene = function ProjectContext_registerReferencesInScene(scene) {
		this.performCallbackOnResourceIDsInScene(scene, function (resourceID) {
			this.registerResourceWithID(resourceID);
		}.bind(this));};
	
	
	
	
ProjectContext.prototype.getDataSourceById = function ProjectContext_getDataSourceById(id) {
		return this.instancesData[id];};
	

	Object.defineProperty(ProjectContext.prototype, "anyDataSource", {
		get: function () {
			var result;
			var dsType = getType('appdoo.BasicDataSource');
			if (Array.isArray(_context.editor.editedScene.objects)) _context.editor.editedScene.objects.every(function (obj) {
				if (isKindOfType(obj, dsType)) {
					result = obj; return false;
				}return true; }, this);
			
			if (result) return result;
			if (Array.isArray(this.project.objects)) this.project.objects.every(function (obj) {
				if (isKindOfType(obj, dsType)) {
					result = obj; return false;
				}return true; }, this);
			
			return result;
		}});
	

ProjectContext.prototype.objectWithID = function ProjectContext_objectWithID(id) {
		var result;
		if (Array.isArray(this.project.objects)) this.project.objects.every(function (obj) {
			if (obj.$id === id) {
				result = obj;
				return false;
			}return true; }, this);
		
		if (result) return result;

		if (!_context.editor || !_context.editor.editedScene) return;
		if (Array.isArray(_context.editor.editedScene.objects)) _context.editor.editedScene.objects.every(function (obj) {
			if (obj.$id === id) {
				result = obj;
				return false;
			}return true; }, this);
		
		return result;};
	
	
ProjectContext.prototype.getLivingDataSourceWithId = function ProjectContext_getLivingDataSourceWithId(id) {
		return this.objectWithID(id);};
	
	
ProjectContext.prototype.sceneWithID = function ProjectContext_sceneWithID(sceneID) {
		var result;
		if (Array.isArray(this.scenes)) this.scenes.every(function (scene) {
			if (scene.$id === sceneID) {
				result = scene;
				return false;
			}return true; }, this);
		
		return result;};
	
	
ProjectContext.prototype.sceneContainingViewController = function ProjectContext_sceneContainingViewController(viewControllerID) {
		var result;
		if (Array.isArray(this.scenes)) this.scenes.every(function (scene) {
			if (scene.viewController &&
				scene.viewController.$id === viewControllerID) {
				result = scene;
				return false;
			}return true; }, this);
		
		return result;};
	

ProjectContext.prototype.viewControllerWithID = function ProjectContext_viewControllerWithID(viewControllerID) {
		var scene = this.sceneContainingViewController(viewControllerID);
		if (scene) return scene.viewController;};
	


	
	
	

	Object.defineProperty(ProjectContext.prototype, "screenSizeInPoints", {
		get: function () {
			switch (this.metadata.deviceProfile) {
				
				case 'iPhone-Widescreen':
				case 'iPhone-5':
					return { width: 320, height: 568 };

				case 'iPhone-6':
					return { width: 375, height: 667 };

				case 'iPhone-6-Plus':
					return { width: 414, height: 736 };

				case 'iPhone-X':
					return { width: 375, height: 812 };

				case 'iPhone-XR':
					return { width: 414, height: 896 };

				case 'iPhone-XS-Max':
					return { width: 414, height: 896 };

				case 'iPad7.9': 
				case 'iPad9.7': 
				case 'iPad10.5': 
				case 'iPad-original': 
					return { width: 768, height: 1024 };
				
				case 'iPad11.0': 
					return { width: 954, height: 1366 };
					
				case 'iPad12.9': 
					return { width: 1024, height: 1366 };

				default:
					return { width: 320, height: 640 };
			}
		}});
	
	
	Object.defineProperty(ProjectContext.prototype, "simulatedDeviceIsIPhone", {
		get: function () {
			var metadata = cachedProjectData.metadata;
			if (!metadata.deviceProfile) return;
			return metadata.deviceProfile.indexOf('iPhone') === 0;
		}});
	
	
	Object.defineProperty(ProjectContext.prototype, "simulatedDeviceType", {
		get: function () {
			var metadata = cachedProjectData.metadata;
			if (!metadata.deviceProfile) return;
			if (metadata.deviceProfile.indexOf('iPhone') === 0) return 'iPhone';
			if (metadata.deviceProfile.indexOf('iPad') === 0) return 'iPad';
		}});
	

	Object.defineProperty(ProjectContext.prototype, "targetIsIOSUniversal", {
		get: function () {
			return this.metadata.targetedDeviceFamily == 'iOS-Universal';
		}});
	

	Object.defineProperty(ProjectContext.prototype, "windowSizeInPoints", {
		get: function () {
			var size = this.screenSizeInPoints;
			if (this.simulatedSystemVersion < 7)
				size.height -= 20;
			return size;
		}});
	

	Object.defineProperty(ProjectContext.prototype, "landscapeWindowSizeInPoints", {
		get: function () {
			var size = this.screenSizeInPoints;
			size = { width: size.height, height: size.width };
			if (this.simulatedSystemVersion < 7)
				size.height -= 20;
			return size;
		}});
	
	
	Object.defineProperty(ProjectContext.prototype, "windowSizeForNewScenes", {
		get: function () {
			if (this.metadata.simulatedInterfaceOrientation === 'landscape') {
				return this.landscapeWindowSizeInPoints;
			}
			return this.windowSizeInPoints;
		}});
	

	Object.defineProperty(ProjectContext.prototype, "initialScene", {
		get: function () {
			if(_context.projectMetadataController.get("initialViewController")) {
				return _context.projectMetadataController.get("initialViewController");
			}
			if (this.tabBarController) {
				if (this.tabBarController.viewControllerIDs &&
					this.tabBarController.viewControllerIDs.length)
					return this.sceneContainingViewController(this.tabBarController.viewControllerIDs[0]);
			}
			return this.scenes[0];
		}});
	

ProjectContext.prototype.isInitialScene = function ProjectContext_isInitialScene(vcID) {
		var isInitial = false;
		if(vcID) {
			if(this.initialScene == this.sceneContainingViewController(vcID)) {
				isInitial = true;
			}
			if(this.initialScene == vcID) {
				isInitial = true;
			}
			if(!_context.projectMetadataController.get("initialViewController")) {
				if (Array.isArray(this.scenes)) this.scenes.every(function (scene) {
					if(scene.viewController.$id == vcID && scene.e_showsInTabBar) {
						
							isInitial = true;
						
					}return true; }, this);
				
			}
		}
		return isInitial;};
	

ProjectContext.prototype.resourceNamed = function ProjectContext_resourceNamed(resourceName) {
		var result;
		if (Array.isArray(this.fileReferences)) this.fileReferences.every(function (obj) {

			if (obj.resourceID && obj.name === resourceName) {
				result = obj;
				return false;
			}
return true; }, this);
		
		return result;};
	

ProjectContext.prototype.fileReferenceWithID = function ProjectContext_fileReferenceWithID(refID) {
		var result;
		if (Array.isArray(this.fileReferences)) this.fileReferences.every(function (obj) {

			if (obj.$id === refID) {
				result = obj;
				return false;
			}
return true; }, this);
		
		return result;};
	

ProjectContext.prototype.fileReferenceWithResourceID = function ProjectContext_fileReferenceWithResourceID(resourceID) {
		var result;
		if (Array.isArray(this.fileReferences)) this.fileReferences.every(function (obj) {

			if (obj.resourceID === resourceID) {
				result = obj;
				return false;
			}
return true; }, this);
		
		return result;};
	

ProjectContext.prototype.pathForResourceNamed = function ProjectContext_pathForResourceNamed(resourceName) {
		var resource = this.resourceNamed(resourceName);
		if (resource) return this.pathForResourceWithID(resource.resourceID);};
	
	
ProjectContext.prototype.pathForResourceWithID = function ProjectContext_pathForResourceWithID(resourceID) {
		return this.nativeProxy.sendMessage('pathForResourceWithID', resourceID);};
	

ProjectContext.prototype.urlForResourceWithID = function ProjectContext_urlForResourceWithID(resourceID) {
		return this.nativeProxy.sendMessage('urlForResourceWithID', resourceID);};
	
	
	
	
	
ProjectContext.prototype.nextNameForNewScene = function ProjectContext_nextNameForNewScene() {
		return LocalizedString('Screen')+' '+(this.scenes.length+1);};
	

ProjectContext.prototype.createNewScene = function ProjectContext__createNewScene(addImmediately, sender) {
	
		var t = this.nextNameForNewScene();
		
		var size = this.windowSizeInPoints;

		var s = this.decodeObjectTree({
			$type: 'Scene',
			$domain: 'appdoo.iOS',
			viewController: {
				$type: 'UIViewController',
				$domain: 'appdoo.iOS',
				title: t,
				viewData: {
					$type: 'SceneRootView',
					$domain: 'appdoo.iOS',
					size: size,
					backgroundColor: 'rgb(255, 255, 255)'
				},
				tabBarItem: {
					$type: 'UITabBarItem',
					$domain: 'appdoo.iOS',
					title: t,
				}
			},
			simulatedInterfaceOrientation: this.metadata.simulatedInterfaceOrientation,
			hasCustomInterfaceOrientations: false
		});

		
		s.identify();
		s.viewController.identify();
		s.e_showsNavigationBar = true;
		
		if (addImmediately) {
			_context.projectScenesController.addValue(s, sender);
		}
		
		return s;
	};
	
	
ProjectContext.prototype.identify = function ProjectContext_identify(obj, prefix) {
		if (!obj) return;
		if (!obj.$id) {
			obj.$id = _context.createAppdooObjectID(prefix || (obj.constructor ? obj.constructor.name : null));
		}
		this.globals[obj.$id] = obj;
		this.connectableObjects[obj.$id] = obj;
		return obj.$id;};
	

	Object.defineProperty(ProjectContext.prototype, "simulatedSystemVersion", {
	synthesized: true, get:function () { return this._simulatedSystemVersion; }, set:function (v) {if (!Object.hasOwnProperty(this, "_simulatedSystemVersion")) Object.defineProperty(this, "_simulatedSystemVersion", { writable: true, configurable: true }); this._simulatedSystemVersion = v; }});
	
	
	
	
	
ProjectContext.prototype.addObject = function ProjectContext_addObject(obj) {
		this.objects.push(obj);};
	
	
	
ProjectContext.prototype.addFileReference = function ProjectContext_addFileReference(obj) {
		this.fileReferences.push(obj);};
	
	
	Object.defineProperty(ProjectContext.prototype, "defaultOrSystemTintColor", {
		get: function () {
			if (this.metadata.globalTintColor) {
				return this.metadata.globalTintColor;
			}
			return system7DefaultTint;
		}});
	
	
	
	
	
ProjectContext.prototype.nameForNewFormControl = function ProjectContext_nameForNewFormControl(controlType) {
		var name = controlType.readableType;

		var dict = namesForFormElements(_context.editor.editedView);

		var i = 1;
		while (name in dict) {
			i++;
			name = controlType.readableType+' '+i;
		}
		
		return name;};
	
	
	
ProjectContext.prototype.testIfHasReachedLimit = function ProjectContext_testIfHasReachedLimit() {
		return false;














		};
	

ProjectContext.prototype.handleUnknownData = function ProjectContext__handleUnknownData(data) {
		if (this.isOffscreen) return;
		return getTypeFromDomain('PlaceholderObject','appdoo');};
	
	
ProjectContext.prototype.initPropertiesFromData = function ProjectContext_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("nativeProxy")) this.nativeProxy = data.nativeProxy;
if (data.hasOwnProperty("undoManager")) this.undoManager = data.undoManager;
if (data.hasOwnProperty("isOffscreen")) this.isOffscreen = data.isOffscreen;
if (data.hasOwnProperty("highResolutionEnabled")) this.highResolutionEnabled = data.highResolutionEnabled;
if (data.hasOwnProperty("projectDataDirectory")) this.projectDataDirectory = data.projectDataDirectory;
if (data.hasOwnProperty("temporaryDataDirectory")) this.temporaryDataDirectory = data.temporaryDataDirectory;
};

ProjectContext.prototype.decodeData = function ProjectContext_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

ProjectContext.prototype.encode = function ProjectContext_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

ProjectContext.prototype.encodeCloned = function ProjectContext_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

ProjectContext.prototype.expectedTypeForProperty = function ProjectContext_expectedTypeForProperty(key) {
	if (key === "shouldIncludeAppdooPreviewData") return "";
	if (key === "nativeProxy") return "";
	if (key === "undoManager") return "";
	if (key === "isOffscreen") return "";
	if (key === "highResolutionEnabled") return "";
	if (key === "projectDataDirectory") return "";
	if (key === "temporaryDataDirectory") return "";
	if (key === "usesNavigationOutlineNode") return "";
	if (key === "temporaryImagesDirectory") return "";
	if (key === "projectImagesDirectory") return "";
	if (key === "project") return "Project";
	if (key === "tabBarController") return "UITabBarController";
	if (key === "metadata") return "Object";
	if (key === "objects") return "BasicObject[]";
	if (key === "scenes") return "Scene[]";
	if (key === "fileReferences") return "BasicObject[]";
	if (key === "projectData") return "";
	if (key === "changedRegistrationStates") return "";
	if (key === "changedMediaItems") return "";
	if (key === "anyDataSource") return "";
	if (key === "screenSizeInPoints") return "";
	if (key === "simulatedDeviceIsIPhone") return "";
	if (key === "simulatedDeviceType") return "";
	if (key === "targetIsIOSUniversal") return "";
	if (key === "windowSizeInPoints") return "";
	if (key === "landscapeWindowSizeInPoints") return "";
	if (key === "windowSizeForNewScenes") return "";
	if (key === "initialScene") return "";
	if (key === "simulatedSystemVersion") return "";
	if (key === "defaultOrSystemTintColor") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return ProjectContext; }()));
registerType('appdoo', (function () { function PlaceholderObject() {} var __super = setSupertypeFromDomain(PlaceholderObject, 'BasicObject', 'Core');

	Object.defineProperty(PlaceholderObject.prototype, "data", {
	synthesized: true, get:function () { return this._data; }, set:function (v) {if (!Object.hasOwnProperty(this, "_data")) Object.defineProperty(this, "_data", { writable: true, configurable: true }); this._data = v; }});
	
	
PlaceholderObject.prototype.decodeData = function PlaceholderObject_decodeData(data) {
		this.data = data;
		return {};};
	
	
PlaceholderObject.prototype.encode = function PlaceholderObject_encode() {
		return this.data;};
	
	
	Object.defineProperty(PlaceholderObject.prototype, "readableValue", {
		get: function () {
			if (this.data) return this.data.$type;
			return LocalizedString('Unknown Object Type');
		}});
	
	
	Object.defineProperty(PlaceholderObject.prototype, "outlineIconURL", {
		value: 'Resources/MissingPlugIn.png'});
	
	
	Object.defineProperty(PlaceholderObject.prototype, "inspectorProperties", {
		get: function () {
			return [{
				type: 'group',
				title: this.readableValue,
				id: this.constructor.name,
				items: [
					{
						type: 'info',
						html: LocalizedString('This object was created with a newer version of appdoo.'),
						showIcon: true,
						positionLeft: true,
						height: 100
					}
				]
			}]
		}});
	

PlaceholderObject.prototype.expectedTypeForProperty = function PlaceholderObject_expectedTypeForProperty(key) {
	if (key === "data") return "";
	if (key === "readableValue") return "";
	if (key === "outlineIconURL") return "";
	if (key === "inspectorProperties") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return PlaceholderObject; }()));