
registerType('appdoo', (function () { function PrototypeDevicesBar() {} var __super = setSupertypeFromDomain(PrototypeDevicesBar, 'View', 'Core.UI');

	var defaultBarHeight = 41-3;


PrototypeDevicesBar.prototype.init = function PrototypeDevicesBar_init() {
		__super.prototype.init.call(this);
		this.style({
			boxSizing: 'border-box',
			backgroundColor: 'var(--editor-backgroundcolor)',
			borderTop: '1px solid var(--editor-separator-color)',
			overflow: 'visible',
			position: 'fixed',
			width: '100%'
		});
		this.autoresizingMask = (1 << 1);
		this.connectedDevices = [];
		
		return this;};
	

PrototypeDevicesBar.prototype.updateDevicesList = function PrototypeDevicesBar_updateDevicesList(devices) {
		if (!devices) devices = [];
		
		this.minimumSystemVersion = Infinity;
		this.minimumBuildVersion = Infinity;
	
		
		if (Array.isArray(clone(devices))) clone(devices).every(function (device) {
			if (!this.deviceShouldPreviewCurrentProject(device)) {
				devices.splice(devices.indexOf(device), 1);
				return true;
			}
			
			this.minimumSystemVersion = Math.min(this.minimumSystemVersion, device.SystemVersion*1);
			this.minimumBuildVersion = Math.min(this.minimumBuildVersion, device.ServerVersion*1);return true; }, this);
		

		this.devices = devices;

		var heightBefore = this.size.height;
		if (!devices || !devices.length) {
			this.size.height = 0;
		}
		else {
			this.size.height = defaultBarHeight;
		}
		
		if (this.superview && heightBefore !== this.size.height) {
			
			_context.overview.prototypeDevicesBarDidChangeHeight(this);
		}
		
		if (!devices.length) {
			if (Array.isArray(this.subviews)) this.subviews.every(function (subview) {
				subview.selected = false;return true; }, this);
			
			setTimeout(function () {
				if (!this.devices || !this.devices.length)
					this.removeAllSubviews();
			}.bind(this), 1500);
			return;
		}
		
		this.removeAllSubviews();

		var x = 10; 
		
		
		if(devices.length > 0) {
			var titleText = LocalizedString('Preview Devices:');
			var titleTextWidth = widthForTextWithAttributes(titleText, {fontSize: '12px'});
			
			var titleLabel = createComponentFromDomain("Label", "Core.UI", this.context, {
				size: { width: titleTextWidth+4, height: 20 },
				text: titleText,
				style: { fontSize: '12px' }})
			;
			titleLabel.position = { left: x, top: Math.round(this.size.height/2-titleLabel.size.height/2)+2 };
			this.addSubview(titleLabel);
			x += titleLabel.size.width;
		}
		
		if (Array.isArray(devices)) devices.every(function (device) {
			var deviceView = createComponentFromDomain("DeviceView", "appdoo", this.context, {
				deviceInfo: device})
			;
			deviceView.position = { left: x, top: Math.round(this.size.height/2-deviceView.size.height/2)-1 };
			this.addSubview(deviceView);
			x += deviceView.size.width + 10;return true; }, this);
		
		
		setTimeout(function () {
			this.publishToIdleDevices();
		}.bind(this), 100);
		};
	
	
PrototypeDevicesBar.prototype.deviceShouldPreviewCurrentProject = function PrototypeDevicesBar__deviceShouldPreviewCurrentProject(device) {

		var _context = this.context;
		
		if (device.ServerVersion >= 12 && this.context.projectContext.targetIsIOSUniversal) {
			return true;
		}
		return !(device.SimulatedDeviceType === 'iPad' && _context.projectContext.simulatedDeviceIsIPhone) && !(device.SimulatedDeviceType === 'iPhone' && !_context.projectContext.simulatedDeviceIsIPhone);
};
	
	
PrototypeDevicesBar.prototype.publishToIdleDevices = function PrototypeDevicesBar__publishToIdleDevices() {
	
		if (this.devices.length > 1) return;
		
		if (Array.isArray(this.devices)) this.devices.every(function (device) {
			if (device.IsIdle && this.deviceShouldPreviewCurrentProject(device)) {
				this.selectDevice(device);
			}return true; }, this);
		};
	
	
PrototypeDevicesBar.prototype.deviceBySessionID = function PrototypeDevicesBar__deviceBySessionID(sessionID) {
		var result;
		if (Array.isArray(this.devices)) this.devices.every(function (device) {
			if (device.SessionID === sessionID) {
				result = device;
				return false;
			}return true; }, this);
		
		return result;};
	

PrototypeDevicesBar.prototype.deviceByID = function PrototypeDevicesBar__deviceByID(deviceID) {
		var result;
		if (Array.isArray(this.devices)) this.devices.every(function (device) {
			if (device.DeviceID === deviceID) {
				result = device;
				return false;
			}return true; }, this);
		
		return result;};
	

PrototypeDevicesBar.prototype.connectedDeviceBySessionID = function PrototypeDevicesBar__connectedDeviceBySessionID(sessionID) {
		var result;
		if (Array.isArray(this.connectedDevices)) this.connectedDevices.every(function (device) {
			if (device.SessionID === sessionID) {
				result = device;
				return false;
			}return true; }, this);
		
		return result;};
	
	
PrototypeDevicesBar.prototype.selectDevice = function PrototypeDevicesBar_selectDevice(deviceInfo) {
	
		if (!this.deviceShouldPreviewCurrentProject(deviceInfo)) {
			return;
		}

		if (deviceInfo) this.beginPublishingForDevice(deviceInfo);
	
		if (Array.isArray(this.subviews)) this.subviews.every(function (subview) {
			if (subview.deviceInfo === deviceInfo) {
				subview.selected = true;
			}return true; }, this);
		
		};
	


PrototypeDevicesBar.prototype.unselectDevice = function PrototypeDevicesBar_unselectDevice(deviceInfo) {
		delete this.connectedDeviceBySessionID[deviceInfo.SessionID];
		this.connectedDevices.splice(this.connectedDevices.indexOf(deviceInfo), 1);};
	

	
PrototypeDevicesBar.prototype.beginPublishingForDevice = function PrototypeDevicesBar__beginPublishingForDevice(deviceInfo) {
		if (!this.deviceShouldPreviewCurrentProject(deviceInfo)) {
			return;
		}
	
		if (!this.connectedDeviceBySessionID(deviceInfo.SessionID)) {
			this.connectedDevices.push(deviceInfo);
		}
		this.publishForDevice(deviceInfo, false);};
	
	
PrototypeDevicesBar.prototype.endPublishingForConnectedDevices = function PrototypeDevicesBar__endPublishingForConnectedDevices() {
		this.connectedDevices = [];};
	
	
PrototypeDevicesBar.prototype.publishForConnectedDevices = function PrototypeDevicesBar__publishForConnectedDevices() {
		if (!this.context.editor) return;
		if (Array.isArray(this.connectedDevices)) this.connectedDevices.every(function (device) {
			this.publishForDevice(device);return true; }, this);
		};
	
	
	var updateTimer = null, updateCallback = null, changes = [];
PrototypeDevicesBar.prototype.publishChange = function PrototypeDevicesBar_publishChange(newChange) {
		if (!this.connectedDevices.length) return;
		changes.push(newChange);
		
		if (updateTimer) clearTimeout(updateTimer);
		else if (!updateCallback) updateCallback = function () {
			this.publishChangesDelayed(changes);
			changes = [];
		}.bind(this);
		updateTimer = setTimeout(updateCallback, 1);
	};
	

PrototypeDevicesBar.prototype.publishChangesDelayed = function PrototypeDevicesBar__publishChangesDelayed(changes) {
		if (Array.isArray(this.connectedDevices)) this.connectedDevices.every(function (device) {
		
			if (device.ServerVersion*1 < 2) {
				setTimeout(function () {
					this.publishForDevice(device);
				}.bind(this), 1);
				return true;
			}

			else if (device.ServerVersion*1 < 5) {
				this.publishChangeDelayedForDevice(changes[changes.length-1], device);
			}
			
			else {
				this.publishChangesDelayedForDevice(changes, device);
			}return true; }, this);
		};
	
	
PrototypeDevicesBar.prototype.publishChangeDelayedForDevice = function PrototypeDevicesBar__publishChangeDelayedForDevice(change, device) {
		
		var transformedChange = this.transformChange(change);
		if (!transformedChange) {
			this.handleChangeTransformationFailed(change, device);
			return;
		}
		this.context.nativeProxy.sendMessage('sendPreviewDataChangeToPrototypeDeviceWithSessionID', JSON.stringify(transformedChange), device.SessionID);};
	
	
PrototypeDevicesBar.prototype.publishChangesDelayedForDevice = function PrototypeDevicesBar__publishChangesDelayedForDevice(changes, device) {

		var transformedChanges = [], didFail = false;
		if (Array.isArray(changes)) changes.every(function (change) {
			var t = this.transformChange(change);
			if (!t) {
				didFail = true;
				this.handleChangeTransformationFailed(change, device);
				return false;
			}
			if (t.idle) return true;
			transformedChanges.push(t);return true; }, this);
		
		if (didFail) return;

		if (!transformedChanges.length) return;
		
		this.context.nativeProxy.sendMessage('sendPreviewDataChangeToPrototypeDeviceWithSessionID', JSON.stringify(transformedChanges), device.SessionID);};
	
	
PrototypeDevicesBar.prototype.handleChangeTransformationFailed = function PrototypeDevicesBar__handleChangeTransformationFailed(change, device) {
		 alertd('Change could not be transformed.', change.keyPath);
		setTimeout(function () {
			this.publishForDevice(device);
		}.bind(this), 1);};
	
	
PrototypeDevicesBar.prototype.transformChange = function PrototypeDevicesBar__transformChange(change) {
		var transformedChange = getPrototype('appdoo.appdooPreviewTransformer').transformChange(change);
		return transformedChange;};
	
	
PrototypeDevicesBar.prototype.publishForDeviceWithSessionID = function PrototypeDevicesBar__publishForDeviceWithSessionID(sessionID) {
		var device = this.deviceBySessionID(sessionID);
		if (!device) return;
		this.publishForDevice(device);};
	
	
PrototypeDevicesBar.prototype.publishForDevice = function PrototypeDevicesBar__publishForDevice(device, skipSave) {

		if (!device) return;
		if (!skipSave && this.context.editor) this.context.editor.saveItem();

		try {
			var encoded = this.context.projectContext.project.encodeForAppdooPreview(device);
		} catch (err) {
		}
		try {
			var json = JSON.stringify(encoded);
			this.context.nativeProxy.sendMessage('sendPreviewDataToPrototypeDeviceWithSessionID', json, device.SessionID);
		} catch (err) {
			console.warn('Could not generate JSON from', encoded, 'Error:', err);
		}};
	
	
PrototypeDevicesBar.prototype.deviceDidChangeCurrentProject = function PrototypeDevicesBar_deviceDidChangeCurrentProject(info) {

		var deviceID = info.deviceID,
			projectID = info.projectID,
			device = this.deviceByID(deviceID);

		if (!device) return;
		
		device.CurrentProjectID = projectID;
		
		var thisProjectWasSelected = (projectID === _context.projectContext.metadata.projectID);

		if (Array.isArray(this.subviews)) this.subviews.every(function (subview) {
			if (subview.deviceInfo.DeviceID === deviceID) {
				subview.selected = thisProjectWasSelected;
				if (!thisProjectWasSelected) this.unselectDevice(device);
				return false;
			}return true; }, this);
		
		};
	


PrototypeDevicesBar.prototype.expectedTypeForProperty = function PrototypeDevicesBar_expectedTypeForProperty(key) {
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return PrototypeDevicesBar; }()));
registerType('appdoo', (function () { function DeviceView() {} var __super = setSupertypeFromDomain(DeviceView, 'View', 'Core.UI');


	Object.defineProperty(DeviceView.prototype, "deviceInfo", {
	outlet: true, get:function () { return this._deviceInfo; }, set:function (v) {if (!Object.hasOwnProperty(this, "_deviceInfo")) Object.defineProperty(this, "_deviceInfo", { writable: true, configurable: true }); this._deviceInfo = v; }});
	

	Object.defineProperty(DeviceView.prototype, "selected", {
	synthesized: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_selected")) Object.defineProperty(this, "_selected", { writable: true, configurable: true });
			this._selected = v;
			if (v) this.styleSelected();
			else this.styleDefault();
		}, get:function () { return this._selected; }});
	

DeviceView.prototype.init = function DeviceView_init() {
		__super.prototype.init.call(this);

		var text = this.deviceInfo.Name,
			width = widthForTextWithAttributes(text, {fontSize: '12px'});

		this.size = { width: width+26+8, height: 28 };

		var iconName;
		switch (this.deviceInfo.DeviceModel) {
			case 'iPhone':
			case 'iPhone Simulator':
				iconName = 'iPhone16';
				break;
			case 'iPad':
			case 'iPad Simulator':
				iconName = 'iPad16';
				break;
			default:
				alertd(this.deviceInfo.DeviceModel);
		}
		
		
		this.style({
			border: '1px solid transparent',
			borderRadius: '4px',
			boxSizing: 'border-box',
			webkitTransitionProperty: 'backgroundColor,color',
			webkitTransitionDuration: '0.15s',
			webkitTransitionTimingFunction: 'ease-in-out',
		});

		this.icon = createComponentFromDomain("ImageView", "Core.UI", this.context, {
			size: { width: 16, height: 16 },
			position: { left: 4, top: 4+1 },
			imageSrc: 'Resources/'+iconName+'.png',})
		;
		this.addSubview(this.icon);

		this.label = createComponentFromDomain("Label", "Core.UI", this.context, {
			size: { width: this.size.width-26, height: 20 },
			position: { left: 25-1, top: 4+1+1 },
			text: text,
			style: { fontSize: '12px' }})
		;
		this.addSubview(this.label);

		this.DOMNode.onclick = function () {
			if (!this.superview.deviceShouldPreviewCurrentProject(this.deviceInfo)) {
				return;
			}
			this.selected = !this.selected;
			if (this.selected) {
				this.superview.selectDevice(this.deviceInfo);
			}
			else {
				this.superview.unselectDevice(this.deviceInfo);
				_context.editor.saveItem();
				_context.projectContext.collectProjectData();
			}
		}.bind(this);
		
		this.selected = false;
		
		return this;};
	
	
DeviceView.prototype.styleSelected = function DeviceView_styleSelected() {
		this.style({
			color: 'rgb(0,124,255)'
		});};
	

DeviceView.prototype.styleDefault = function DeviceView_styleDefault() {
		this.style({
			backgroundColor: '',
			webkitBoxShadow: '',
			border: '1px solid transparent',
			color: '#555',
		});};
	
	
DeviceView.prototype.initPropertiesFromData = function DeviceView_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("deviceInfo")) this.deviceInfo = data.deviceInfo;
};

DeviceView.prototype.decodeData = function DeviceView_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

DeviceView.prototype.encode = function DeviceView_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

DeviceView.prototype.encodeCloned = function DeviceView_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

DeviceView.prototype.expectedTypeForProperty = function DeviceView_expectedTypeForProperty(key) {
	if (key === "deviceInfo") return "";
	if (key === "selected") return "Boolean";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return DeviceView; }()));