
registerType('appdoo', (function () { function ResourceReference() {} var __super = setSupertypeFromDomain(ResourceReference, 'BasicEditableObject', 'appdoo');

ResourceReference.prototype.updateContentsByImportingFileFromPath = function ResourceReference_updateContentsByImportingFileFromPath(path) {
	
		var resourceID = this.context.nativeProxy.sendMessage('importBinaryFileFromPath', path);
		if (!resourceID) return;
		
		this.context.registerResourceWithID(resourceID);
		this.context.unregisterResourceWithID(this.resourceID, true);
		this.resourceID = resourceID;
		if (!this.originalFileInfo) this.originalFileInfo = createComponentFromDomain("FileInfo", "appdoo", this.context, {})
		;
		this.originalFileInfo.absolutePath = path;
		this.originalFileInfo.relativePath = this.context.nativeProxy.sendMessage('getRelativeFilePath', path);
		
		this.size = undefined;
		this.imageSize = undefined;
		
		this.outlineIconURLDidChange();
		if (_context.editorIsVisible()) _context.editor.refreshInspector();};
	
	
ResourceReference.prototype.showInFinder = function ResourceReference_showInFinder() {
		if (!this.originalFileInfo) return this.context.beep();
		this.context.nativeProxy.sendMessage('showFileInFinder', this.originalFileInfo.absolutePath, this.originalFileInfo.relativePath);};
	
	
ResourceReference.prototype.openWithDefaultApplication = function ResourceReference_openWithDefaultApplication() {
		if (!this.originalFileInfo) return this.context.beep();
		this.context.nativeProxy.sendMessage('openWithDefaultApplication', this.originalFileInfo.absolutePath, this.originalFileInfo.relativePath);};
	
	
ResourceReference.prototype.addFileItemsToMenu = function ResourceReference_addFileItemsToMenu(menu) {

		var ref = this;
		if (this.isSynchronized) {

			var appNamesByURL = this.context.nativeProxy.sendMessage('availableApplicationsForFile', ref.originalFileInfo.absolutePath, ref.originalFileInfo.relativePath);
			var fileInfoJSON = JSON.stringify(ref.originalFileInfo.encode());

			if (appNamesByURL) {
				appNamesByURL = JSON.parse(appNamesByURL);

				menu.items.unshift(this.context.decodeObjectTree({
					"$type": "MenuItem",
					"$domain": "Core.UI",
					"title": LocalizedString("Show In Finder"),
					"target": ref,
					"targetMethod": "showInFinder",
				 }),
				 this.context.decodeObjectTree({ "$type" : "MenuItem", "$domain" : "Core.UI", "separator" : true })
				);

				var openWithMenu = this.context.decodeObjectTree({
				  "$type" : "Menu",
				  "$domain" : "Core.UI",
				  "items" : [
				  ]
				});
				
				for (var url in appNamesByURL) {
					var name = appNamesByURL[url];
					openWithMenu.items.push(this.context.decodeObjectTree({
						"$type": "MenuItem",
						"$domain": "Core.UI",
						"title": name,
						"action": function (url) {
							this.context.nativeProxy.sendMessage('openFileWithApplication', fileInfoJSON, url);
						}.bind(this, url),
						icon: url
					 }));
				}

				var defaultAppName = this.context.nativeProxy.sendMessage('defaultApplicationNameForFile',ref.originalFileInfo.absolutePath,ref.originalFileInfo.relativePath);
				var defaultAppURL;

				openWithMenu.items.sort(function (a, b) {
					if (a.title === defaultAppName) defaultAppURL = a.icon;
					return a.title.localeCompare(b.title);
				});

				if (defaultAppURL)
					openWithMenu.items.unshift(
					 this.context.decodeObjectTree({
						"$type": "MenuItem",
						"$domain": "Core.UI",
						"title": LocalizedString1("%1 (Default)", defaultAppName),
						icon: defaultAppURL,
						"target": ref,
						"targetMethod": "openWithDefaultApplication",
					 }),
					 this.context.decodeObjectTree({
						"$type": "MenuItem",
						"$domain": "Core.UI",
						separator: true
					 }));
				
				var openWithMenuItem = this.context.decodeObjectTree({
						"$type": "MenuItem",
						"$domain": "Core.UI",
						"title": LocalizedString("Open With"),
					 });
				openWithMenuItem.submenu = openWithMenu;
				menu.items.unshift(openWithMenuItem);

				if (defaultAppName) {
					menu.items.unshift(
					 this.context.decodeObjectTree({
						"$type": "MenuItem",
						"$domain": "Core.UI",
						"title": LocalizedString('Open'),
						"target": ref,
						"targetMethod": "openWithDefaultApplication",
					 }));
				}
			
			}
		}
	};
	
	
ResourceReference.prototype.chooseFileToSync = function ResourceReference_chooseFileToSync() {
		this.chooseFile();};
	
ResourceReference.prototype.supportedOfficeMimeTypes = function ResourceReference_supportedOfficeMimeTypes() {
		return [
			'application/pdf',
			'text/rtf',
			'application/msword',
			'application/vnd.openxmlformats-officedocument.wordprocessingml.document',
			'application/vnd.ms-excel',
			'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
			'application/x-iwork-numbers-sffnumbers',
			'application/x-iwork-pages-sffpages',
			'application/x-iwork-keynote-sffkeynote'
		];};
	
	
ResourceReference.prototype.chooseFile = function ResourceReference_chooseFile() {
		var fileInfoJSON = this.context.nativeProxy.sendMessage('chooseFileForImport', JSON.stringify({
			title: LocalizedString('Import'),
			prompt: LocalizedString("Import File"),
			message: ""
		}));
		if (!fileInfoJSON) return;

		var fileInfo = JSON.parse(fileInfoJSON);
		var path = fileInfo.path;
		
		if (path) {
			if (fileInfo.type !== this.contentType) {
				_context.showIncompatibilityErrorForFile({}, false, [this.contentType]);
				return;
			}
		
			this.contentType = fileInfo.type;
			this.updateContentsByImportingFileFromPath(path);
			_context.checkIfFilesWereUpdated();
		}
		};
	
	
ResourceReference.prototype.addRetinaSuffixToName = function ResourceReference_addRetinaSuffixToName() {
		if (this.name.indexOf('@2x') !== -1) return;
		var split = this.name.split('.');
		var extension = split.pop();
		this.e_name = split.join('.')+'@2x.'+extension;};
	
	

	Object.defineProperty(ResourceReference.prototype, "resourceID", {
	outlet: true, 
	enumerable: true, get:function () { return this._resourceID; }, set:function (v) {if (!Object.hasOwnProperty(this, "_resourceID")) Object.defineProperty(this, "_resourceID", { writable: true, configurable: true }); this._resourceID = v; }});
	

	Object.defineProperty(ResourceReference.prototype, "contentType", {
	outlet: true, 
	enumerable: true, get:function () { return this._contentType; }, set:function (v) {if (!Object.hasOwnProperty(this, "_contentType")) Object.defineProperty(this, "_contentType", { writable: true, configurable: true }); this._contentType = v; }});
	

	Object.defineProperty(ResourceReference.prototype, "size", {
	outlet: true, 
	enumerable: true, get:function () { return this._size; }, set:function (v) {if (!Object.hasOwnProperty(this, "_size")) Object.defineProperty(this, "_size", { writable: true, configurable: true }); this._size = v; }});
	

	Object.defineProperty(ResourceReference.prototype, "lastModified", {
	outlet: true, 
	enumerable: true, get:function () { return this._lastModified; }, set:function (v) {if (!Object.hasOwnProperty(this, "_lastModified")) Object.defineProperty(this, "_lastModified", { writable: true, configurable: true }); this._lastModified = v; }});
	

	Object.defineProperty(ResourceReference.prototype, "originalFileInfo", {
	outlet: true, 
	enumerable: true, 
		get: function () {
			return this._originalFileInfo || {};
		}, set:function (v) {if (!Object.hasOwnProperty(this, "_originalFileInfo")) Object.defineProperty(this, "_originalFileInfo", { writable: true, configurable: true }); this._originalFileInfo = v; }});
	

	Object.defineProperty(ResourceReference.prototype, "name", {
	outlet: true, 
	enumerable: true, get:function () { return this._name; }, set:function (v) {if (!Object.hasOwnProperty(this, "_name")) Object.defineProperty(this, "_name", { writable: true, configurable: true }); this._name = v; }});
	

	Object.defineProperty(ResourceReference.prototype, "e_name", {
		set: function (v) {
			this.name = v;
			this.readableValueDidChange(v);
		}, 
		get: function ( ) { return this.name; }});
	

	Object.defineProperty(ResourceReference.prototype, "nameIsEditable", {
		get: function () {
			return true;
		}});
	


	Object.defineProperty(ResourceReference.prototype, "temporaryFilePath", {
	outlet: true, 
	enumerable: true, 
		set: function (v) {if (!Object.hasOwnProperty(this, "_temporaryFilePath")) Object.defineProperty(this, "_temporaryFilePath", { writable: true, configurable: true });
			var id = this.context.nativeProxy.sendMessage('importResourceFromFile', v);
	
			if (!id) {
				console.warn('Importing the file failed. Path was: ', v);
				return;
			}

			this.resourceID = id;
			this.context.registerResourceWithID(id);
		}, get:function () { return this._temporaryFilePath; }});
	

	Object.defineProperty(ResourceReference.prototype, "readableValue", {
		get: function () { return this.name || LocalizedString1('Untitled %1', this.readableType); }});
	
	
	Object.defineProperty(ResourceReference.prototype, "readableType", {
		get: function () {
			if (this.contentType) {
				if (this.isImage) return LocalizedString('Image File');
				if (this.isAudio) return LocalizedString('Audio File');
				if (this.isVideo) return LocalizedString('Movie File');
			}
			return LocalizedString('File');
		}});
	
	
	Object.defineProperty(ResourceReference.prototype, "isVideo", {
		get: function () { return this.contentType.indexOf('video/') === 0; }});
	

	Object.defineProperty(ResourceReference.prototype, "isAudio", {
		get: function () { return this.dataIsAudio(this); }});
	

	Object.defineProperty(ResourceReference.prototype, "isFont", {
		get: function () { return this.dataIsFont(this); }});
	
	
ResourceReference.prototype.dataIsAudio = function ResourceReference__dataIsAudio(data) {
		return data.contentType.indexOf('audio/') === 0;};
	

ResourceReference.prototype.dataIsFont = function ResourceReference__dataIsFont(data) {
		return data.contentType && data.contentType.indexOf('font') !== -1;};
	

	Object.defineProperty(ResourceReference.prototype, "isImage", {
		get: function () { return this.contentType.indexOf('image/') === 0 || this.contentType === 'application/x-photoshop'; }});
	
	
	Object.defineProperty(ResourceReference.prototype, "isPDF", {
		get: function () { return this.contentType === 'application/pdf'; }});
	
	
	Object.defineProperty(ResourceReference.prototype, "isOfficeDocument", {
		get: function () {
			var split = this.name.split('.');
			var extension = split.pop();
			if (extension === 'pages' || extension === 'numbers' || extension === 'keynote' || extension === 'key') {
				return true;
			}
			var mimeTypes = this.supportedOfficeMimeTypes();
			return (mimeTypes.indexOf(this.contentType) !== -1);
		}});
	

ResourceReference.prototype.determineSize = function ResourceReference__determineSize() {
			if (isNaN(this.size)) {
				this.size = this.context.nativeProxy.sendMessage('sizeInBytesForResourceWithID', this.resourceID);
			}};
	

	Object.defineProperty(ResourceReference.prototype, "readableSize", {
		get: function () {
			this.determineSize();
			
			var bytes = this.size;

			var kb = parseInt(bytes/1024);
			if (kb < 1000) {
				if (kb === 0) kb = 1;
				return LocalizedString1('%1 KB', this.context.nativeProxy.sendMessage('formatNumber', kb));
			}
			var mb = parseInt(kb/102.4)/10;
			return LocalizedString1('%1 MB', this.context.nativeProxy.sendMessage('formatNumber', mb));
		}});
	
	

	Object.defineProperty(ResourceReference.prototype, "readableFileType", {
	synthesized: true, 
		get: function () {
			
			if (!this._readableFileType) {
				this.readableFileType = this.context.nativeProxy.sendMessage('readableTypeForResourceWithID', this.resourceID);
			}
			return this._readableFileType || LocalizedString('Unknown');
		}, set:function (v) {if (!Object.hasOwnProperty(this, "_readableFileType")) Object.defineProperty(this, "_readableFileType", { writable: true, configurable: true }); this._readableFileType = v; }});
	
	
	Object.defineProperty(ResourceReference.prototype, "isEmbedded", {
		get: function () {
			return true;
		}});
	
	
	Object.defineProperty(ResourceReference.prototype, "shouldSync", {
	outlet: true, 
	enumerable: true, get:function () { return this._shouldSync; }, set:function (v) {if (!Object.hasOwnProperty(this, "_shouldSync")) Object.defineProperty(this, "_shouldSync", { writable: true, configurable: true }); this._shouldSync = v; }});
	

	Object.defineProperty(ResourceReference.prototype, "isSynchronized", {
		get: function () {
			var p = this.context.nativeProxy.sendMessage('getAbsolutePath', this.originalFileInfo.absolutePath, this.originalFileInfo.relativePath);
			return this.shouldSync && this.originalFileInfo && p;
		}});
	
	
	Object.defineProperty(ResourceReference.prototype, "syncInfo", {
		get: function () {
			var isSynchronized = this.isSynchronized;
			
			var str = '<div style="color:#555;position:relative;top:-5px;padding-right:10px">';
			if (isSynchronized)
				str += LocalizedString('This file is synchronized on this device.');
			else
				str += LocalizedString('This file is not synchronized on this device.');
			
			str += '</div>';
			return str;
		}});
	

	Object.defineProperty(ResourceReference.prototype, "pathInfo", {
		get: function () {
			if (!this.originalFileInfo) return '';
			return this.originalFileInfo.absolutePath;
		}});
	
	
	Object.defineProperty(ResourceReference.prototype, "inspectorProperties", {
		get: function () {
			var isSynced = this.isSynchronized;
			var chooseButtonTitle = isSynced ? LocalizedString('Replace…') : LocalizedString('Choose…'),
				chooseButtonLeft = isSynced ? 110 : 45;
			var groups = [
				{
					type: 'group',
					title: this.readableType,
					id: this.constructor.name,
					items: [
						{ name: LocalizedString('Name'), keyPath: 'e_name', type: 'textarea', textFieldHeight: 30 },
						{ name: LocalizedString('Type'), type: 'info', html: this.getInfo(), htmlForMultiple: '', height: 50, positionLeft: true, dynamic: true },

						{ type: 'space' },
						{ type: 'space' },
						
						{ name: LocalizedString('Synchronize'), type: 'boolean', positionLeft: 1, keyPath: 'shouldSync', conditionalProperties: [

							{ type: 'info', showIcon:1, html: this.syncInfo, dynamic: true,  left:45-20, height:30-10-5, marginTop: 8, hidden: isSynced },
							
							{ type: 'button', caption: LocalizedString('Show File'), buttonWidth:80, align: 'left', noLinebreak:true, left: 45, actionKeyPath: 'showInFinder', hidden: !isSynced, left: 25, offsetY: 5 },
							
							{ type: 'button', caption: chooseButtonTitle, buttonWidth:80, align: 'left', left: chooseButtonLeft, actionKeyPath: 'chooseFileToSync', offsetY: 5 },

						] },
					]
				},
			];
			
			if (this.originalFileInfo && this.originalFileInfo.absolutePath) {
			}
			
			return groups;
		}});
	
	
	Object.defineProperty(ResourceReference.prototype, "readableDimensions", {
		get: function () {
			var s = this.imageSize;
			if (!s || !s.width || !s.height) return '?';
			return s.width+' × '+s.height+' '+LocalizedString('Pixel');
		}});
	
	
ResourceReference.prototype.getInfo = function ResourceReference__getInfo() {
		var str = '';
		var dict = {
				'readableFileType':LocalizedString('Kind'),
				'readableSize':LocalizedString('Size'),
			};
		if (this.isImage)
			dict.readableDimensions = LocalizedString('Dimens.');
			
		for (var key in dict) {
			str += '<tr><td align=right>'+dict[key]+':</td><td>'+this[key]+'</td></tr>';
		}
		
		return '<table>'+str+'</table>';
};
	
	
	Object.defineProperty(ResourceReference.prototype, "cocoaType", {
		value: 'NSObject'});
	

	Object.defineProperty(ResourceReference.prototype, "cocoaCustomType", {
		value: 'NSObject'});
	

	Object.defineProperty(ResourceReference.prototype, "outlineIconURL", {
		get: function () {
			if (this.isImage) {
				this.determineSize();
				if (this.size > 500000) return 'Resources/File.png';
				return this.filePath;
			}
			if (this.isAudio) return 'Resources/Sound.png';
			if (this.isVideo) return 'Resources/Movie.png';
			if (this.isPDF) return 'Resources/FilePDF.png';
			return 'Resources/File.png';
		}});
	
	
ResourceReference.prototype.editorDidInsertThis = function ResourceReference_editorDidInsertThis(editor) {
		this.context.registerResourceWithID(this.resourceID);};
	
	
ResourceReference.prototype.prepareForEditor = function ResourceReference_prepareForEditor(editor) {
		if (this.isFont) {
			editor.loadFont(this);
		}};
	
	
	Object.defineProperty(ResourceReference.prototype, "fontInfo", {
	synthesized: true, 
	enumerable: true, 
		get: function () {
			if (!this._fontInfo) {
				try {
					var json = this.context.nativeProxy.sendMessage('infoForFontAtPath', this.filePath);
					this.fontInfo = JSON.parse(json);
				} catch (err) {}
			
			}
			return this._fontInfo;
		}, set:function (v) {if (!Object.hasOwnProperty(this, "_fontInfo")) Object.defineProperty(this, "_fontInfo", { writable: true, configurable: true }); this._fontInfo = v; }});
	

ResourceReference.prototype.deleteForEditor = function ResourceReference_deleteForEditor(editor) {

		this.dataController.setValueForKey('','resourceID');
		this.context.unregisterResourceWithID(this.resourceID, true);
		
		editor.fileReferencesDidUpdate([this]);
		
		editor.unloadFont(this);
};
	
	
ResourceReference.prototype.createContainerViewForSuperview = function ResourceReference_createContainerViewForSuperview(view) {

		if (this.isImage) {
			var uiImageWithUrlProto = getPrototype('appdoo.iOS.UIImageViewWithURL');
			var obj = uiImageWithUrlProto.createForSuperview(view);
			obj.sourceType = 'local';
			obj.e_localImageObjectID = this.$id;
			
			var scalar = this.name.indexOf('@2x') === -1 ? 1 : 2;
			
			_context.whenImageIsReady(this.filePath, function (img) {
				obj.size = { width: (img.width/scalar)|0, height: (img.height/scalar)|0 };
			});
			
			return obj;
		}
		if (this.isVideo) {
			var mpv = getPrototype('info.appdoo-mac.MoviePlayerView').createForSuperview(view);
			mpv.sourceType = 'local';
			mpv.localMovieObjectID = this.identify();
			return mpv;
		}
		if (this.isAudio) {
			var ssp = getPrototype('info.appdoo-mac.SimpleAudioPlayer').createForContext(view.context);
			ssp.soundFileReferenceID = this.identify();
			_context.editor.registerInsertedItem(ssp);
			_context.editor.addUndoStepForInsertOperation(ssp);
			
			var label = getPrototype('appdoo.iOS.UILabel').createForSuperview(view);
			label.text = LocalizedString('play');
			label.textAlignment = 'center';
			_context.editor.registerInsertedItem(label);
			_context.undoManager.disableRegistration();
			var button =
				_context.editor.convertItemsToButton([label], false);
			_context.undoManager.enableRegistration();
			button.e_actionObjectID = ssp.identify();
			button.actionInfo.objectActionID = 'playOrPause';
			return button;
		}

		if (this.isPDF || this.isOfficeDocument) {





			
		}
};
	
	
ResourceReference.prototype.canCreateContainerViewForSuperview = function ResourceReference_canCreateContainerViewForSuperview(view) {
		if (this.isImage) return true;
		if (this.isVideo) return true;
		if (this.isAudio) return true;
		if (this.isPDF) return true;
		if (this.isOfficeDocument) return true;};
	
	
	Object.defineProperty(ResourceReference.prototype, "filePath", {
		get: function () { return this.context.pathForResourceWithID(this.resourceID); }});
	

	Object.defineProperty(ResourceReference.prototype, "fileURL", {
		get: function () { return this.context.urlForResourceWithID(this.resourceID); }});
	
	
	
ResourceReference.prototype.encodeCloned = function ResourceReference_encodeCloned() {
		var result = this.encode();
		if (result.resourceID) { result.temporaryFilePath = this.filePath; delete result.resourceID; }
		return result;};
	


ResourceReference.prototype.clone = function ResourceReference_clone() {
		return this.context.decodeObjectTree(this.encodeCloned());};
	
	
	
	Object.defineProperty(ResourceReference.prototype, "needsNoObjCOutlet", {
		value: true});
	

ResourceReference.prototype.specialDataToCopyWithEditor = function ResourceReference_specialDataToCopyWithEditor(editor) {
		var data = {};
		if (this.fileURL) data['public.file-url'] = 'file:///'+this.filePath;
		return data;};
	
	
	Object.defineProperty(ResourceReference.prototype, "imageSize", {
	outlet: true, 
		get: function () {
			if (!this._imageSize) {

				if (this.isSynchronized) {
					this.imageSize = JSON.parse(		this.context.nativeProxy.sendMessage('getImageSize', this.originalFileInfo.absolutePath, this.originalFileInfo.relativePath));

				}
				else {
					this.imageSize = JSON.parse(		this.context.nativeProxy.sendMessage('getImageSize', this.filePath));
				}
			}
			return this._imageSize;
		}, set:function (v) {if (!Object.hasOwnProperty(this, "_imageSize")) Object.defineProperty(this, "_imageSize", { writable: true, configurable: true }); this._imageSize = v; }});
	

ResourceReference.prototype.initPropertiesFromData = function ResourceReference_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("resourceID")) this.resourceID = data.resourceID;
if (data.hasOwnProperty("contentType")) this.contentType = data.contentType;
if (data.hasOwnProperty("size")) this.size = data.size;
if (data.hasOwnProperty("lastModified")) this.lastModified = data.lastModified;
if (data.hasOwnProperty("originalFileInfo")) this.originalFileInfo = data.originalFileInfo;
if (data.hasOwnProperty("name")) this.name = data.name;
if (data.hasOwnProperty("temporaryFilePath")) this.temporaryFilePath = data.temporaryFilePath;
if (data.hasOwnProperty("shouldSync")) this.shouldSync = data.shouldSync;
if (data.hasOwnProperty("imageSize")) this.imageSize = data.imageSize;
};

ResourceReference.prototype.decodeData = function ResourceReference_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
if (data.hasOwnProperty("originalFileInfo")) decoded.originalFileInfo = this.context.decodeObjectTree(data.originalFileInfo);
return decoded; };

ResourceReference.prototype.encode = function ResourceReference_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
if (this._originalFileInfo && this._originalFileInfo.encode) {encoded.originalFileInfo = this.originalFileInfo.encode();
}return encoded; };

ResourceReference.prototype.expectedTypeForProperty = function ResourceReference_expectedTypeForProperty(key) {
	if (key === "resourceID") return "String";
	if (key === "contentType") return "String";
	if (key === "size") return "Number";
	if (key === "lastModified") return "Number";
	if (key === "originalFileInfo") return "FileInfo";
	if (key === "name") return "";
	if (key === "e_name") return "String";
	if (key === "nameIsEditable") return "";
	if (key === "temporaryFilePath") return "";
	if (key === "readableValue") return "";
	if (key === "readableType") return "";
	if (key === "isVideo") return "";
	if (key === "isAudio") return "";
	if (key === "isFont") return "";
	if (key === "isImage") return "";
	if (key === "isPDF") return "";
	if (key === "isOfficeDocument") return "";
	if (key === "readableSize") return "";
	if (key === "readableFileType") return "";
	if (key === "isEmbedded") return "Boolean";
	if (key === "shouldSync") return "Boolean";
	if (key === "isSynchronized") return "Boolean";
	if (key === "syncInfo") return "String";
	if (key === "pathInfo") return "String";
	if (key === "inspectorProperties") return "";
	if (key === "readableDimensions") return "";
	if (key === "cocoaType") return "";
	if (key === "cocoaCustomType") return "";
	if (key === "outlineIconURL") return "";
	if (key === "fontInfo") return "";
	if (key === "filePath") return "";
	if (key === "fileURL") return "";
	if (key === "needsNoObjCOutlet") return "";
	if (key === "imageSize") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return ResourceReference; }()));
registerType('appdoo', (function () { function ObjCHeaderResourceReference() {} var __super = setSupertypeFromDomain(ObjCHeaderResourceReference, 'ResourceReference', 'appdoo');

	var interfacesByClass = {};

ObjCHeaderResourceReference.prototype.init = function ObjCHeaderResourceReference_init() {
		__super.prototype.init.call(this);
		this.parseHeader();
		if (this.headerInfo) {
			if (Array.isArray(this.headerInfo.interfaces)) this.headerInfo.interfaces.every(function (interface) {
				interfacesByClass[interface.name] = interface;
				interface.headerFile = this.name;return true; }, this);
			
		}
		return this;};
	
	
	Object.defineProperty(ObjCHeaderResourceReference.prototype, "headerInfo", {
	outlet: true, 
	enumerable: true, get:function () { return this._headerInfo; }, set:function (v) {if (!Object.hasOwnProperty(this, "_headerInfo")) Object.defineProperty(this, "_headerInfo", { writable: true, configurable: true }); this._headerInfo = v; }});
	
	
ObjCHeaderResourceReference.prototype.parseHeader = function ObjCHeaderResourceReference__parseHeader() {
	
		if (this.headerInfo) return;
	
		var code = this.context.nativeProxy.sendMessage('stringFromFile', this.filePath);
		if (!code) return;
		
		this.headerInfo = {
			interfaces: []
		};
		
		var currentLine = '',
			currentLineModes = 0,
			currentBlocks = 0,
			blockDepth = 0;

		var PREPROCESSOR_LINE_MODE 		= 1 << 0,
			COMMENT_LINE_MODE			= 1 << 1;
			INTERFACE_BLOCK				= 1 << 2,
			IMPLEMENTATION_BLOCK		= 1 << 3,
			PROTOCOL_BLOCK				= 1 << 4,
			CURLY_BLOCK					= 1 << 5;
		
		var currentBlock;
		
		for (var i = 0, c = code.length; i < c; i++) {
			var ch = code[i];
			if (ch === '\n') {
				currentLine = currentLine.trim();
				if (currentLine.indexOf('@interface') === 0) {
					currentBlocks |= INTERFACE_BLOCK;
					parseInterfaceLine(currentLine);
				}
				else if (currentLine.indexOf('@protocol') === 0) {
					currentBlocks |= PROTOCOL_BLOCK;
				}
				else if (currentLine.indexOf('@implementation') === 0) {
					currentBlocks |= IMPLEMENTATION_BLOCK;
				}
				else if (currentLine === '@end') {
					currentBlocks = 0;
					if (currentBlock) {
						if (currentBlock.type === 'ObjectiveCInterfaceDeclaration') {
							this.headerInfo.interfaces.push(currentBlock);
						}
						currentBlock = null;
					}
				}
				else if (currentLine.indexOf('@property') === 0) {
					parsePropertyLine(currentLine);
				}
				else if (currentLine.indexOf('-') === 0 || currentLine.indexOf('+') === 0) {
					parseMethodLine(currentLine);
				}
				currentLine = '';
				currentLineModes = 0;
			}
			
			currentLine += ch;
			if (currentLineModes) continue;
			
			switch (ch) {
				case '{':
					blockDepth++;
					currentBlocks |= CURLY_BLOCK;
					break;
				case '{':
					blockDepth--;
					if (blockDepth === 0 && (currentBlocks & CURLY_BLOCK))
						currentBlocks ^= CURLY_BLOCK;
					break;
				case '#':
					currentLineModes |= PREPROCESSOR_LINE_MODE;
					break;
				case '/':
					if (code[i+1] === '/') currentLineModes |= COMMENT_LINE_MODE;
					break;
			}

		}
		
		function parseInterfaceLine(line) {
			line = line.substr('@interface'.length).trim();
			var split = line.split(':');
			var name = split[0].trim();
			var superclass = split[1] ? split[1].trim() : '';
			currentBlock = { type: 'ObjectiveCInterfaceDeclaration', name: name, superclass: superclass, properties: [], methods: [] };
		}
		
		function parsePropertyLine(line) {
			if (!currentBlock || currentBlock.type !== 'ObjectiveCInterfaceDeclaration') return;
			line = line.substr('@property'.length).trim();
			var propertyInfo = {
				attribtues: ''
			};
			if (line[0] === '(') {
				var pos = line.indexOf(')');
				propertyInfo.attribtues = line.substr(1, pos-1).trim();
				line = line.substr(pos+1).trim();
			}
			if (line.indexOf('IBOutlet') === 0) {
				propertyInfo.isIBOutlet = true;
				line = line.substr('IBOutlet'.length).trim();
			}

			
			line = line.substr(0, line.length-1).trim();
			
			var pos = Math.max(line.lastIndexOf(' '), line.lastIndexOf('	'));
			if (pos < 1) return;
			
			propertyInfo.name = line.substr(pos).trim();
			propertyInfo.type = line.substr(0, pos).trim();
			currentBlock.properties.push(propertyInfo);
			alert(JSON.stringify(propertyInfo));
		}
		
		function parseMethodLine(line) {
			if (!currentBlock || currentBlock.type !== 'ObjectiveCInterfaceDeclaration') return;
			
			var methodSignature = {
				isClassMethod: (line[0] === '+'),
				parameters: []
			};

			line = line.substr(1).trim();
			if (line[0] === '(') {
				var pos = line.indexOf(')');
				methodSignature.returnType = line.substr(1, pos-1).trim();
				line = line.substr(pos+1).trim();
			}

			
			line = line.substr(0, line.length-1).trim();
			
			
			var beforeColon = true, requiredCharsBeforeNextParameter = '';
			function isRequiredChar(ch) {
				var is = false;
				if		(ch === requiredCharsBeforeNextParameter[0]) is = true;
				else if (ch === '	' && requiredCharsBeforeNextParameter[0] == ' ') is = true;
				else if (requiredCharsBeforeNextParameter[0] == 'a') {
					if (ch === ' ' || ch === '	') return true;
					is = true;
				}

				if (is === true)
					requiredCharsBeforeNextParameter = requiredCharsBeforeNextParameter.substr(1);
				
				return is;
			}
			var selectorName = '', parameter = '';
			for (var i = 0, c = line.length; i < c; i++) {
				var ch = line[i];
				if (beforeColon && ch !== ' ' && ch !== '	') selectorName += ch;
				if (ch === ':') { beforeColon = false; requiredCharsBeforeNextParameter = '()a '; }
				if (!beforeColon) {
					if (ch !== ':') parameter += ch;
					if (isRequiredChar(ch)) {
						if (!requiredCharsBeforeNextParameter.length) {
							beforeColon = true;
							methodSignature.parameters.push(parameter.trim());
							parameter = '';
						}
					}
				}
			}
			parameter = parameter.trim(); if (parameter) methodSignature.parameters.push(parameter);
			methodSignature.selectorName = selectorName;
			currentBlock.methods.push(methodSignature);

		}
		
		if (window.isDebugging) {
			alertd('Header: '+JSON.stringify(this.headerInfo));
		}
		};
	

ObjCHeaderResourceReference.prototype.canCreateContainerViewForSuperview = function ObjCHeaderResourceReference_canCreateContainerViewForSuperview(view) {
		return this.headerInfo && this.headerInfo.interfaces.length === 1;};
	
	
ObjCHeaderResourceReference.prototype.createContainerViewForSuperview = function ObjCHeaderResourceReference_createContainerViewForSuperview(view) {
		var interface = this.headerInfo.interfaces[0];
	
		var shell = getPrototype('info.appdoo-mac.NativeObjectPlaceholder').createForContext(view.context);
		shell.className = interface.name;
		shell.interface = interface;
		_context.editor.registerInsertedItem(shell);
		_context.editor.addUndoStepForInsertOperation(shell);
		_context.editor.selectSingleObject(shell);};
	
	
ObjCHeaderResourceReference.prototype.interfaceForClass = function ObjCHeaderResourceReference_interfaceForClass(className) {
		return interfacesByClass[className];};
	
	
ObjCHeaderResourceReference.prototype.initPropertiesFromData = function ObjCHeaderResourceReference_initPropertiesFromData(data) {
try { __super.prototype.initPropertiesFromData.call(this, data); } catch (err) {}
if (data.hasOwnProperty("headerInfo")) this.headerInfo = data.headerInfo;
};

ObjCHeaderResourceReference.prototype.decodeData = function ObjCHeaderResourceReference_decodeData(data) { var decoded;
try { decoded = __super.prototype.decodeData.call(this, data); } catch (err) { console.warn(err); decoded = clone(data); }
return decoded; };

ObjCHeaderResourceReference.prototype.encode = function ObjCHeaderResourceReference_encode() { var encoded;
try { encoded = __super.prototype.encode.call(this); } catch (err) { console.warn(err); encoded = this.context.encodeObject(this); }
return encoded; };

ObjCHeaderResourceReference.prototype.encodeCloned = function ObjCHeaderResourceReference_encodeCloned() { var encoded;
try { encoded = __super.prototype.encodeCloned.call(this); } catch (err) { console.warn(err); encoded = {}; }
return encoded; };

ObjCHeaderResourceReference.prototype.expectedTypeForProperty = function ObjCHeaderResourceReference_expectedTypeForProperty(key) {
	if (key === "headerInfo") return "";
	if (__super) return __super.prototype.expectedTypeForProperty(key);
};

return ObjCHeaderResourceReference; }()));